/* ESTADO DE LOS PEDIDOS
a = aperturado/abierto/activo/
b = preparacion
c = en camino
d = despachado/entregado/cerrado
z = anulado
*/

var moneda = $("#moneda").val();
$(function() {
    moment.locale('es');
    
    //esto es para que se actualice cada 30 sec el listado de mesas y la cantidad de comensales.
    if ($("#actu_automatica_mesa").val() == '1') {
        mesa_list(1); // Primera carga
        if (typeof contadorComensal === 'function') { contadorComensal(); }
        setInterval(function() {
            mesa_list(1); // Actualización cada 30 segundos
            if (typeof contadorComensal === 'function') { contadorComensal(); }
        }, 30000);
    } else {
        mesa_list(1); // Solo una vez si no hay actualizaci?n autom?tica
    }
    
    tiempo_mesa();
    setInterval(tiempo_mesa, 1000);
    tiempo_pedido();
    setInterval(tiempo_pedido, 1000);
    tiempo_preparacion();
    setInterval(tiempo_preparacion, 1000);
    countNuevoPedidoDelivery();
    setInterval(countNuevoPedidoDelivery, 10000);
    countNuevoPedidoMostrador();
    setInterval(countNuevoPedidoMostrador, 10000);
    alert_pedidos_programados();
    setInterval(alert_pedidos_programados, 50000);
    validarApertura();
    
    //esto es para mostrar / ocultar mesa, llevar y delivery.
    var existeTab01 = document.querySelector('.tab01');
    var existeTab02 = document.querySelector('.tab02');
    var existeTab03 = document.querySelector('.tab03');
    if (existeTab02 && !existeTab01){
        mostrador();
        tab02();
    }
    if (existeTab03 && !existeTab02 && !existeTab01){
        delivery();
        tab03();
    }
    if (!existeTab03 && !existeTab02 && !existeTab01){
        $('.cont01-1').css('display','none');
    }
    
    
    var parametro = getUrlParameter('cod');
    if(parametro !== undefined){
        if(getUrlParameter('tip') == 3){
            $('#codtipoped').val(3);
            listarPedidosDetalle(3,parametro,0);
            activaTab('tabp-3');
            $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc3');
            if(getUrlParameter('est') == 'a'){
                $('#codpestdelivery').val(1);
                activaTab('delivery01');
                delivery_list_a();
                editar_pedido(parametro); 
            } else if (getUrlParameter('est') == 'b'){
                activaTab('delivery02');
                delivery_list_b();
            } else if (getUrlParameter('est') == 'c'){
                activaTab('delivery03');
                delivery_list_c();
            } else if (getUrlParameter('est') == 'd'){
                activaTab('delivery04');
                delivery_list_d();
            }
            $('.display-estado-mesa').css('display','none');
            $('.cont01-1').css('display','none');
            $('.cont01-2').css('display','block');
        } else if(getUrlParameter('tip') == 2){
            activaTab('tabp-2');
            if(getUrlParameter('est') == 'a'){
                $('#codtipoped').val(2);
                activaTab('mostrador01');
                mostrador_list_a();
                //listarPedidosDetalle(2,parametro,0);
            }
            $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc2');
            $('.display-estado-mesa').css('display','none');
            $('.cont01-1').css('display','none');
            $('.cont01-2').css('display','block');
        } 
               
    }
    $('#form-nuevo-pedido').formValidation({
    framework: 'bootstrap',
    excluded: ':disabled',
        fields: {}
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        
        if($('#codtipoped').val() == 3 && $('#cliente_id').val() == ''){
            Swal.fire({   
                title:'Advertencia',   
                text: 'Ingrese un cliente al pedido',
                icon: "warning", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            return false;
        }
        
        // Validar que id_mesa está presente antes de enviar
        var id_mesa = $('#id_mesa').val();
        console.log('[PEDIDO] Validando formulario - id_mesa:', id_mesa);
        
        if(!id_mesa || id_mesa == '' || id_mesa == '0'){
            console.error('[PEDIDO] Error: id_mesa no válido');
            Swal.fire({
                title: 'Error',
                text: 'Debe seleccionar una mesa antes de continuar',
                icon: 'error',
                confirmButtonText: 'Aceptar'
            });
            return false;
        }
        
        // Enviar formulario via AJAX para mejor control de errores
        console.log('[PEDIDO] Formulario v�lido, enviando via AJAX...');
        var $form = $(e.target);
        
        // Asegurar que los campos requeridos tengan valores antes de serializar
        var id_mesa_val = $('#id_mesa').val();
        var nomb_cliente_val = $('#nomb_cliente').val();
        var nro_personas_val = $('#nro_personas').val();
        var id_mozo_val = $('#id_mozo').val();
        
        // Valores por defecto si no est�n presentes
        if(!nomb_cliente_val || nomb_cliente_val == '') {
            nomb_cliente_val = 'Mesa: ' + id_mesa_val;
            $('#nomb_cliente').val(nomb_cliente_val);
        }
        if(!nro_personas_val || nro_personas_val == '') {
            nro_personas_val = '1';
            $('#nro_personas').val(nro_personas_val);
        }
        if(!id_mozo_val || id_mozo_val == '') {
            // Si no hay mozo seleccionado y el rol no es 5, usar el primero disponible
            if($('#rol_usr').val() != 5) {
                var firstMozo = $('#id_mozo option:first').val();
                if(firstMozo) {
                    id_mozo_val = firstMozo;
                    $('#id_mozo').selectpicker('val', firstMozo);
                }
            }
        }
        
        console.log('[PEDIDO] Datos a enviar:');
        console.log('  id_mesa:', id_mesa_val);
        console.log('  nomb_cliente:', nomb_cliente_val);
        console.log('  nro_personas:', nro_personas_val);
        console.log('  id_mozo:', id_mozo_val);
        
        var formData = $form.serialize();
        var formAction = $form.attr('action');
        
        // Construir URL correctamente (formAction ya contiene la URL completa)
        var urlFinal = formAction;
        if(formAction.indexOf('http') !== 0) {
            // Si es una ruta relativa, agregar la URL base
            urlFinal = $('#url').val() + formAction.replace(/^\//, '');
        }
        
        console.log('[PEDIDO] URL final:', urlFinal);
        console.log('[PEDIDO] formAction original:', formAction);
        console.log('[PEDIDO] formData serializado:', formData);
        
        // Mostrar loading (compatible con SweetAlert2)
        Swal.fire({
            html: '<h4>Creando pedido...</h4><p>Por favor espere</p>',
            timer: 30000,
            allowOutsideClick: false,
            showCancelButton: false,
            showConfirmButton: false,
            allowEscapeKey: false,
            onBeforeOpen: function() {
                Swal.showLoading();
            }
        });
        
        $.ajax({
            url: urlFinal,
            type: 'POST',
            data: formData,
            success: function(response) {
                console.log('[PEDIDO] Respuesta del servidor recibida');
                console.log('[PEDIDO] Response type:', typeof response);
                console.log('[PEDIDO] Response content:', response);
                
                Swal.close();
                
                // Intentar parsear como JSON
                var jsonResponse = null;
                try {
                    jsonResponse = typeof response === 'string' ? JSON.parse(response) : response;
                    console.log('[PEDIDO] JSON parseado:', jsonResponse);
                } catch(e) {
                    console.log('[PEDIDO] No es JSON, es HTML o texto');
                    // Si no es JSON, puede ser que el servidor hizo una redirecci?n HTTP
                    // Verificar si hay redirecci?n en los headers o en la respuesta
                    if(response && typeof response === 'string' && response.indexOf('venta/orden') !== -1) {
                        var match = response.match(/venta\/orden\/(\d+)/);
                        if(match && match[1]) {
                            console.log('[PEDIDO] Redirecci?n detectada en HTML, yendo a orden:', match[1]);
                            window.location.href = $('#url').val() + 'venta/orden/' + match[1];
                            return;
                        }
                    }
                }
                
                // Si es JSON y tiene los datos correctos
                if(jsonResponse && jsonResponse.fil == 1 && jsonResponse.id_pedido){
                    console.log('[PEDIDO] Redirigiendo a orden:', jsonResponse.id_pedido);
                    window.location.href = $('#url').val() + 'venta/orden/' + jsonResponse.id_pedido;
                } else if(jsonResponse) {
                    console.error('[PEDIDO] Error en respuesta JSON:', jsonResponse);
                    Swal.fire({
                        title: 'Error',
                        text: jsonResponse.message || jsonResponse.error || 'No se pudo crear el pedido. Por favor, intente nuevamente.',
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                } else {
                    // Si no es JSON y no hay redirecci?n, puede ser que el servidor hizo redirect HTTP
                    // En ese caso, el navegador deber?a haber seguido la redirecci?n autom?ticamente
                    console.log('[PEDIDO] Respuesta no es JSON, puede ser redirecci?n HTTP');
                }
            },
            error: function(xhr, status, error) {
                console.error('[PEDIDO] Error AJAX:', error);
                console.error('[PEDIDO] Status:', status);
                console.error('[PEDIDO] Response:', xhr.responseText);
                console.error('[PEDIDO] Status Code:', xhr.status);
                
                Swal.close();
                
                // Si el error es 302 (redirecci?n), seguir la redirecci?n
                if(xhr.status == 302 || xhr.status == 301) {
                    var redirectUrl = xhr.getResponseHeader('Location');
                    if(redirectUrl) {
                        console.log('[PEDIDO] Redirecci?n detectada en headers:', redirectUrl);
                        window.location.href = redirectUrl;
                        return;
                    }
                }
                
                Swal.fire({
                    title: 'Error',
                    text: 'Error al crear el pedido: ' + (error || 'Error desconocido'),
                    type: 'error',
                    confirmButtonText: 'Aceptar'
                });
            }
        });
    });
    $('#form-cambiar-mesa').formValidation({
    framework: 'bootstrap',
    excluded: ':disabled',
        fields: {}
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');
        fv.defaultSubmit();
    });

    $('#form-mover-pedidos').formValidation({
    framework: 'bootstrap',
    excluded: ':disabled',
        fields: {}
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');
        fv.defaultSubmit();
    });

    $('#form-editar-pedido')
    .formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {

    e.preventDefault();
    var $form = $(e.target),
    fv = $form.data('formValidation');
    
    var id_repartidor = ($('#id_repartidor_edit').val() == null) ? '9999' : $('#id_repartidor_edit').val();

    id_pedido = $('#id_pedido').val();
    hora_entrega = $('#hora_entrega_edit').val();
    id_repartidor = id_repartidor;
    amortizacion = $('#amortizacion').val();
    tipo_pago = $('#id_tipo_pago').val();
    paga_con = $('#paga_con').val();
    comision_delivery = $('#comision_delivery').val();

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/pedido_crud',
        data: {
            id_pedido: id_pedido,
            id_repartidor: id_repartidor,
            hora_entrega: hora_entrega,
            amortizacion: amortizacion,
            tipo_pago: tipo_pago,
            paga_con: paga_con,
            comision_delivery: comision_delivery
        },
        success: function (cod) {
            $('#modal-editar-pedido').modal('hide');
            Swal.fire({   
                title:'Proceso Terminado',   
                text: 'Datos actualizados correctamente',
                icon: "success", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            delivery_list_a();
            delivery_list_b();
            listarPedidosDetalle(3,$('#id_pedido').val(),0);          
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }    
    });
        return false;
    });

    $('#form-editar-venta-pago')
    .formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {

    e.preventDefault();
    var $form = $(e.target),
    fv = $form.data('formValidation');
    
    id_venta = $('#id_venta').val();
    pago_tipo = $("input[name='pago_tipo[]']").map(function(){return $(this).val();}).get();
    pago_monto = $("input[name='pago[]']").map(function(){return $(this).val();}).get();

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/venta_edit_pago',
        data: {
            id_venta: id_venta,
            pago_tipo: pago_tipo,
            pago_monto: pago_monto
        },
        success: function (cod) {
            $('#modal-editar-venta-pago').modal('hide');
            Swal.fire({   
                title:'Proceso Terminado',   
                text: 'Datos actualizados correctamente',
                icon: "success", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            delivery_list();
            listarPedidosDetalle(3,$('#id_pedido').val(),id_venta);        
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }    
    });
        return false;
    });


    $('#form-repartidor-selecionar').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {
    
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
    
        var id_repartidor = ($('#id_selecionar_repartidor').val() == null) ? '1' : $('#id_selecionar_repartidor').val();
    
        id_pedido = $('#id_pedido_r').val();
        id_repartidor = id_repartidor;
    
    
        $.ajax({
            dataType: 'JSON',
            type: 'POST',
            url: $('#url').val()+'venta/repartidor_crud',
            data: {
                id_pedido: id_pedido,
                id_repartidor: id_repartidor,
            },
            success: function (cod) {
                $('#modal-select-repartidor').modal('hide');
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos actualizados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                delivery_list_a();
                delivery_list_b();
                delivery_list_c();
                // listarPedidosDetalle(3,$('#id_pedido').val(),0);          
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(errorThrown + ' ' + textStatus);
            }    
        });
            return false;
    });



    $("#telefono_cliente").autocomplete({
        delay: 1,
        autoFocus: true,
        source: function (request, response) {
            $.ajax({
                url: $('#url').val()+'venta/buscar_cliente_telefono',
                type: "post",
                dataType: "json",
                data: {
                    cadena: request.term
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        tipo_cli = (item.tipo_cliente == 1) ? $("#diAcr").val() : $("#tribAcr").val();
                        return {
                            id_cliente: item.id_cliente,
                            nombre: item.nombre,
                            telefono: item.telefono,
                            direccion: item.direccion,
                            referencia: item.referencia,
                            //label: tipo_cli+': '+item.dni+''+item.ruc,
                            value: item.telefono
                        }
                    }))
                }
            })
        },
        select: function (e, ui) {
            //$("#documento_cliente").val('');
            $("#cliente_id").val(ui.item.id_cliente);
            /////////////////////////////////////////////
            $('.display-nombre').css('display','block');
            //$('.display-telefono-cliente').css('display','block');
            $("#nomb_cliente").removeAttr('disabled');
            //$("#telefono_cliente").removeAttr('disabled');
            /////////////////////////////////////////
            if($('input:radio[name=tipo_entrega]:checked').val() == 1){
                $('.display-direccion-cliente').css('display','block');
                $('.display-referencia-cliente').css('display','block');
                $('.display-repartidor').css('display','block');
                $("#direccion_cliente").removeAttr('disabled');
                $("#referencia_cliente").removeAttr('disabled');
                $("#id_repartidor").removeAttr('disabled');
            } else {
                $('.display-direccion-cliente').css('display','none');
                $('.display-referencia-cliente').css('display','none');
                $('.display-repartidor').css('display','none');
                $("#direccion_cliente").attr('disabled','true');
                $("#referencia_cliente").attr('disabled','true');
                $("#id_repartidor").attr('disabled','true');
            }
            ////////////////////////////////////////////
            $("#telefono_cliente").val(ui.item.telefono);
            $("#nomb_cliente").val(ui.item.nombre);
            $("#direccion_cliente").val(ui.item.direccion);
            $("#referencia_cliente").val(ui.item.referencia);
            $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
            //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-info" onclick="editar_cliente('+ui.item.id_cliente+');" type="button"><i class="fa fa-user"></i></button>');
        },
        change: function(e, ui) {
            $("#documento_cliente").val('');
        }
    })
    .autocomplete( "instance" )._renderItem = function( ul, item ) {
        return $( "<li class='ui-menu-item'></li>" )
            .data( "item.autocomplete", item )
            .append( "<div class='ui-menu-item-wrapper'>" + item.nombre+"<br>Telefono/Celular: "+item.telefono+"</div>" )
            .appendTo( ul );
    };

    $("#nomb_cliente").autocomplete({
        delay: 1,
        autoFocus: true,
        source: function (request, response) {
            $.ajax({
                url: $('#url').val()+'venta/buscar_cliente',
                type: "post",
                dataType: "json",
                data: {
                    cadena: request.term
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        tipo_cli = (item.tipo_cliente == 1) ? $("#diAcr").val() : $("#tribAcr").val();
                        return {
                            id_cliente: item.id_cliente,
                            nombre: item.nombre,
                            telefono: item.telefono,
                            direccion: item.direccion,
                            referencia: item.referencia,
                            //label: tipo_cli+': '+item.dni+''+item.ruc,
                            value: item.nombre
                        }
                    }))
                }
            })
        },
        select: function (e, ui) {
            //$("#documento_cliente").val('');
            $("#cliente_id").val(ui.item.id_cliente);
            /////////////////////////////////////////////
            $('.display-nombre').css('display','block');
            //$('.display-telefono-cliente').css('display','block');
            // $("#nomb_cliente").removeAttr('disabled');
            //$("#telefono_cliente").removeAttr('disabled');
            /////////////////////////////////////////
            if($('input:radio[name=tipo_entrega]:checked').val() == 1){
                $('.display-direccion-cliente').css('display','block');
                $('.display-referencia-cliente').css('display','block');
                $('.display-repartidor').css('display','block');
                $("#direccion_cliente").removeAttr('disabled');
                $("#referencia_cliente").removeAttr('disabled');
                $("#id_repartidor").removeAttr('disabled');
            } else {
                $('.display-direccion-cliente').css('display','none');
                $('.display-referencia-cliente').css('display','none');
                $('.display-repartidor').css('display','none');
                $("#direccion_cliente").attr('disabled','true');
                $("#referencia_cliente").attr('disabled','true');
                $("#id_repartidor").attr('disabled','true');
            }
            ////////////////////////////////////////////
            $("#telefono_cliente").val(ui.item.telefono);
            $("#nomb_cliente").val(ui.item.nombre);
            $("#direccion_cliente").val(ui.item.direccion);
            $("#referencia_cliente").val(ui.item.referencia);
            $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
            $('.btn-opc-nuevo-cliente').html('<button class="btn btn-info" onclick="editar_cliente('+ui.item.id_cliente+');" type="button"><i class="fa fa-user"></i></button>');
        },
        change: function(e, ui) {
            $("#documento_cliente").val('');
        }
    })
    .autocomplete( "instance" )._renderItem = function( ul, item ) {
        return $( "<li class='ui-menu-item'></li>" )
            .data( "item.autocomplete", item )
            .append( "<div class='ui-menu-item-wrapper'>" + item.nombre+"<br>Telefono/Celular: "+item.telefono+"</div>" )
            .appendTo( ul );
    };    

    $('#form-mozo-cambiar-selecionar').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {
    
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
    
        id_pedido = $('#id_pedido_r').val();
        id_mozo = $('#id_mozo22').val();
    
        $.ajax({
            dataType: 'JSON',
            type: 'POST',
            url: $('#url').val()+'venta/mozo_edit',
            data: {
                id_pedido: id_pedido,
                id_mozo: id_mozo,
            },
            success: function (cod) {
                $('#modal-select-id_mozo').modal('hide');
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos actualizados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                location.reload();       
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(errorThrown + ' ' + textStatus);
            }    
        });
            return false;
    });    
});

var mesa_list = function(cod){
    $('.list-mesas').empty();
    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/mesa_list',
        success: function (item) {
            var count = 0,
                count_disponibles = 0,
                count_ocupadas = 0,
                count_pagos = 0;

            var contador = {};

            $.each(item['mesa'], function(i, mesa) {
                var idSalon = mesa.id_salon;
                var estado = mesa.estado;

                // Normalizar estado: 'o' (ocupada legacy) se trata como 'i' para que la mesa se muestre
                var estadoMesa = (mesa.estado === 'o') ? 'i' : mesa.estado;
                x = (estadoMesa == 'a') ? count_disponibles++ : 'NINGUNO';
                y = (estadoMesa == 'p') ? count_pagos++ : 'NINGUNO';
                z = (estadoMesa == 'i') ? count_ocupadas++ : 'NINGUNO';

                forma = (mesa.forma == 1) ? '' : 'rounded-circle';

                if (estadoMesa === 'i' || estadoMesa === 'p') {
                    if (contador[idSalon]) {
                      contador[idSalon]++;
                    } else {
                      contador[idSalon] = 1;
                    }  
                }

                // ?? ROL 5 = Mozo
                if($('#rol_usr').val() == 5){

                    if(mesa.id_salon == cod && estadoMesa == 'a'){
                        // Mesa disponible ? abrir Swal
                        $('.list-mesas')
                        .append($(
                            '<button class="btn btn-green dim '+forma+' btn-large-dim custom-btn-green" ' +
                                'onclick="registrarMesa('+mesa.id_mesa+', \''+mesa.nro_mesa+'\', \''+mesa.desc_salon+'\')">' +
                                '<div class="top-mesas">' +
                                    '<span>'+mesa.nro_mesa+'</span>' +
                                '</div>' +
                                '<div class="bottom-mesas">' +
                                    '<span class="cstm-disp">Disponible</span>' +
                                '</div>' +
                                '<input type="radio" autocomplete="off">' +
                            '</button>'
                        ));
                    } else if(mesa.id_salon == cod && estadoMesa == 'p'){
                        // Mesa en pago
                        $('.list-mesas')
                        .append($(
                            '<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>' +
                            '<button class="btn btn-blue dim  '+forma+'  btn-large-dim custom-btn-blue"'+
                                'onclick="orden('+mesa.id_pedido+')">' +
                                '<div class="top-mesas">' +
                                    '<span>'+mesa.nro_mesa+'</span>' +
                                '</div>' +
                                '<div class="bottom-mesas">' +
                                    '<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span>' +
                                    '<span class="span-a"><i class="fas fa-user"></i> '+mesa.Mozo.nombre_mozo+'</span>' +
                                    '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span>' +
                                    '<span class="span-a"><strong>' + moneda +' '+ (mesa.PedidoTotal.total !== null ? mesa.PedidoTotal.total : 0) + '</strong></span>' +
                                '</div>'+
                                '<div class="icon-right" style="position: absolute; bottom: 0; right: 0; padding: 10px;">'+
                                    '<img src="../public/images/dolar.png" alt="Icon" style="width: 20px; height: 20px;"/>'+
                                '</div>'+
                                '<input type="radio" autocomplete="off">' +
                            '</button>'
                        ));
                    } else if(mesa.id_salon == cod && estadoMesa == 'i'){
                        // Mesa ocupada
                        $('.list-mesas')
                        .append($(
                            '<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>' +
                            '<button title="Vendedor: '+mesa.Mozo.nombre_mozo+'" class="btn btn-reed dim '+forma+' btn-large-dim custom-btn-reed"' +
                                'onclick="orden('+mesa.id_pedido+')">' +
                                '<div class="top-mesas">' +
                                    '<span>'+mesa.nro_mesa+'</span>' +
                                '</div>' +
                                '<div class="bottom-mesas">' +
                                    '<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span>' +
                                    '<span class="span-a"><i class="fas fa-user"></i> '+mesa.Mozo.nombre_mozo+'</span>' +
                                    '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span>' +
                                    '<span class="span-a"><strong>' + moneda +' '+ (mesa.PedidoTotal.total !== null ? mesa.PedidoTotal.total : 0) + '</strong></span>' +
                                '</div>' +
                                '<input type="radio" autocomplete="off">' +
                            '</button>'
                        ));
                    }

                } else {
                    // ?? Otros roles = Admin
                    if(mesa.id_salon == cod && estadoMesa == 'a'){
                        $('.list-mesas')
                        .append($(
                            '<button class="btn btn-green dim '+forma+' btn-large-dim custom-btn-green" ' +
                                'onclick="nuevoPedidoMesa('+mesa.id_mesa+', \''+mesa.nro_mesa+'\', \''+mesa.desc_salon+'\')">' +
                                '<div class="top-mesas">' +
                                    '<span>'+mesa.nro_mesa+'</span>' +
                                '</div>' +
                                '<div class="bottom-mesas">' +
                                    '<span class="cstm-disp">Disponible</span>' +
                                '</div>' +
                                '<input type="radio" autocomplete="off">' +
                            '</button>'
                        ));
                    } else if(mesa.id_salon == cod && estadoMesa == 'p'){
                        $('.list-mesas')
                        .append($(
                           '<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>' +
                            '<button class="btn btn-blue dim  '+forma+'  btn-large-dim custom-btn-blue"'+
                                'onclick="orden('+mesa.id_pedido+')">' +
                                '<div class="top-mesas">' +
                                    '<span>'+mesa.nro_mesa+'</span>' +
                                '</div>' +
                                '<div class="bottom-mesas">' +
                                    '<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span>' +
                                    '<span class="span-a"><i class="fas fa-user"></i> '+mesa.Mozo.nombre_mozo+'</span>' +
                                    '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span>' +
                                    '<span class="span-a"><strong>' + moneda +' '+ (mesa.PedidoTotal.total !== null ? mesa.PedidoTotal.total : 0) + '</strong></span>' +
                                '</div>'+
                                '<div class="icon-right" style="position: absolute; bottom: 0; right: 0; padding: 10px;">'+
                                    '<img src="../public/images/dolar.png" alt="Icon" style="width: 20px; height: 20px;"/>'+
                                '</div>'+
                                '<input type="radio" autocomplete="off">' +
                            '</button>'
                        ));
                    } else if(mesa.id_salon == cod && estadoMesa == 'i'){
                        $('.list-mesas')
                        .append($(
                            '<input type="hidden" name="tiempo_mesa[]" value="'+mesa.fecha_pedido+'"/>' +
                            '<button title="Vendedor: '+mesa.Mozo.nombre_mozo+'" class="btn btn-reed dim '+forma+' btn-large-dim custom-btn-reed"' +
                                'onclick="listarPedidos('+mesa.id_salon+','+mesa.id_mesa+',1,'+mesa.id_pedido+',\''+mesa.nro_mesa+'\',\''+mesa.desc_salon+'\')">' +
                                '<div class="top-mesas">' +
                                    '<span>'+mesa.nro_mesa+'</span>' +
                                '</div>' +
                                '<div class="bottom-mesas">' +
                                    '<span class="span-a"><i class="far fa-user"></i> '+mesa.nro_personas+'</span>' +
                                    '<span class="span-a"><i class="fas fa-user"></i> '+mesa.Mozo.nombre_mozo+'</span>' +
                                    '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa'+count+++'">'+moment(mesa.fecha_pedido).fromNow(true)+'</span></span>' +
                                    '<span class="span-a"><strong>' + moneda +' '+ (mesa.PedidoTotal.total !== null ? mesa.PedidoTotal.total : 0) + '</strong></span>' +
                                '</div>' +
                                '<input type="radio" autocomplete="off">' +
                            '</button>'
                        ));
                    }
                }

            });

            $('.mesas-disponibles').attr('data-original-title',count_disponibles+' mesas disponibles');
            $('.mesas-disponibles').text(count_disponibles);
            $('.mesas-pago').attr('data-original-title',count_pagos+' mesas en proceso de pago');
            $('.mesas-pago').text(count_pagos);

            $('.mesas-ocupadas').text(count_ocupadas);
            $('.pedidos-mesas-total-1').text(count_ocupadas);

        }
    });
}

var tiempo_mesa = function(){
    moment.locale('es');
    $('input[name^="tiempo_mesa"]').each(function(i) {
        var fechaConvertida = moment($(this).val()).fromNow(true);
        $(".hora-mesa"+i).text(fechaConvertida);
    });
}

var mostrador = function(){
    activaTab('mostrador01');
    mostrador_list_a();
    $('.pedido-mozo').hide();
}

var count_pedido_mostrador = 0;
var countNuevoPedidoMostrador = function(){
    $.ajax({     
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/mostrador_list',
        data: {
            estado : 'a'
        },
        success: function (data){
            $.each(data, function(i, item) {
                if(parseInt(item.length) !== count_pedido_mostrador){
                    count_pedido_mostrador = 0;
                    if($('#codpestdelivery').val() == 1){
                        delivery_list_a();
                    }
                    var sound = new buzz.sound($('#url').val()+"public/sound/ding_ding", {
                        formats: [ "ogg", "mp3", "aac" ]
                    });
                    ($('#sonido_de_ll').val() == 0) ? '': sound.play();
                    // sound.play();
                    count_pedido_mostrador = item.length + count_pedido_mostrador;
                    $('.pedidos-llevar-total-1').text(count_pedido_mostrador);
                }
            });
        }
    })
}




var mostrador_list_a = function(){
    
    function filterGlobal () {
        $('#list-mostrador-confirmacion').DataTable().search( 
            $('#search_filter_e').val()
        ).draw();
    }
    
    var count = 0;
    var table = $('#list-mostrador-confirmacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/mostrador_list",
            "data": {
                estado: 'a'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                    return '<a href="javascript:void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
                }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_pedido_mostrador[]" value="'+data.fecha_pedido+'"/><i class="ti-timer"></i> <span class="tiempo-pedido-mostrador'+count+++'">'+moment(data.fecha_pedido).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-user"></i> '+data.nomb_cliente;
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.Total.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-mostrador-total').text(total);
            //  $('.pedidos-llevar-total-1').text(total);
        }
    });
    
    $('input.search_filter_e').on( 'keyup click', function () {
        filterGlobal();
    });
}

var mostrador_list_b = function(){
    
    function filterGlobal () {
        $('#list-mostrador-preparacion').DataTable().search( 
            $('#search_filter_f').val()
        ).draw();
    }
    
    var count = 0;
    var table = $('#list-mostrador-preparacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/mostrador_list_c",
            "data": {
                estado: 'b'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                    return '<a href="javascript:void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,'+data.id_pedido+','+data.id_venta+');">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_preparacion_mostrador[]" value="'+data.fecha_pedido+'"/><i class="ti-timer"></i> <span class="tiempo-preparacion-mostrador'+count+++'">'+moment(data.fecha_pedido).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-user"></i> '+data.nomb_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                    var blkstr = []; 
                    $.each(data['Tipopago'], function(i,dato) { 
                        var str = "<span class='label label-success' style='background: "+dato.color+"'>" + dato.nombre + "</span>"; 
                        blkstr.push(str); 
                    });
                    return blkstr;
                }
            },
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-mostrador-total').text(total);
        }
    });
    
    $('input.search_filter_f').on( 'keyup click', function () {
        filterGlobal();
    });
}

var mostrador_list_c = function(){

    function filterGlobal () {
        $('#list-mostrador-entregados').DataTable().search( 
            $('#search_filter_g').val()
        ).draw();
    }
    
    var table = $('#list-mostrador-entregados')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/mostrador_list_c",
            "data": {
                estado: 'd'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                    return '<a href="javascript:void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,'+data.id_pedido+','+data.id_venta+');">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                var fecha1 = moment(data.fecha_entrega);
                var fecha2 = moment(data.fecha_pedido);
                var duration = moment.duration(fecha2 - fecha1).humanize();
                return '<i class="ti-arrow-up text-warning"></i> '+moment(data.fecha_pedido).format('h:mm A')
                    +'<br><i class="ti-arrow-down text-success"></i> '+moment(data.fecha_entrega).format('h:mm A')
                    +'<br><i class="ti-timer"></i> '+duration;
            }},
            
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-user"></i> '+data.nomb_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                    var blkstr = []; 
                    $.each(data['Tipopago'], function(i,dato) { 
                        var str = "<span class='label label-success' style='background: "+dato.color+"'>" + dato.nombre + "</span>"; 
                        blkstr.push(str); 
                    });
                    return blkstr;
                }
            },
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-mostrador-total').text(total);
        }
    });
    
    $('input.search_filter_g').on( 'keyup click', function () {
        filterGlobal();
    });
}

var delivery = function(){
    activaTab('delivery01');
    delivery_list_a();
    $('.pedido-mozo').hide();
}

var count_pedido_delivery = 0;
var countNuevoPedidoDelivery = function(){
    $.ajax({     
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/delivery_list',
        data: {
            estado : 'a'
        },
        success: function (data){
            $.each(data, function(i, item) {
                if(parseInt(item.length) !== count_pedido_delivery){
                    count_pedido_delivery = 0;
                    if($('#codpestdelivery').val() == 1){
                        delivery_list_a();
                    }
                    var sound = new buzz.sound($('#url').val()+"public/sound/ding_ding", {
                        formats: [ "ogg", "mp3", "aac" ]
                    });
                    // sound.play();
                    ($('#sonido_de_ll').val() == 0) ? '': sound.play();
                    count_pedido_delivery = item.length + count_pedido_delivery;
                    $('.pedidos-total-1').text(count_pedido_delivery);
                }
            });
        }
    })
}

var delivery_list_a = function(){
    
    function filterGlobal () {
        $('#list-delivery-confirmacion').DataTable().search( 
            $('#search_filter_a').val()
        ).draw();
    }
    $('.tb-st').empty();
    var count = 0;
    var table = $('#list-delivery-confirmacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list",
            "data": {
                estado: 'a'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                if(data.pedido_programado == 1){
                    return '<a href="javascript::void(0)"><span class="round round-primary" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
                } else {
                    return '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
                }
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_pedido_delivery[]" value="'+data.fecha_pedido+'"/><i class="ti-timer"></i> <span class="tiempo-pedido-delivery'+count+++'">'+moment(data.fecha_pedido).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.tipo_pago == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                var sumatoria = Number(data.Total.total) + Number(data.comision_delivery);
                return moneda+' '+ sumatoria;
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
            $('.pedidos-total-1').text(total);
        }
    });
    
    $('input.search_filter_a').on( 'keyup click', function () {
        filterGlobal();
    });
}

var delivery_list_b = function(){

    function filterGlobal () {
        $('#list-delivery-preparacion').DataTable().search( 
            $('#search_filter_b').val()
        ).draw();
    }
    $('.tb-st').empty();
    var count = 0;
    var table = $('#list-delivery-preparacion')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list",
            "data": {
                estado: 'b'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                    return '<a href="javascript:void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<input type="hidden" name="tiempo_preparacion_delivery[]" value="'+data.fecha_preparacion+'"/><i class="ti-timer"></i> <span class="tiempo-preparacion-delivery'+count+++'">'+moment(data.fecha_preparacion).fromNow(true)+'</span>'
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
                if(data.tipo_pago == 1){
                    return '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 2){
                    return '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 3){
                    return '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 4){
                    return '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago >= 5){
                    return '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }
            }},
            {"data": null,
            "render": function(data, type, row){
                if(data.id_repartidor == '9999'){
                    return '<button  onclick="list_repartidor('+data.id_pedido+');" type="button" class="btn btn-primary btn-sm">Seleccionar</button>';
                }else{
                    return '<a href="#" class="text-muted " onclick="list_repartidor('+data.id_pedido+');"> <i class="ti-user"></i> '+data.NombreRepartidor.desc_repartidor +'</a>'; 
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                var sumatoria = Number(data.Total.total) + Number(data.comision_delivery);
                return moneda+' '+ sumatoria;
                // return moneda+' '+formatNumber(data.Total.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
        }
    });
    
    $('input.search_filter_b').on( 'keyup click', function () {
        filterGlobal();
    });
}

var delivery_list_c = function(){

    function filterGlobal () {
        $('#list-delivery-enviados').DataTable().search( 
            $('#search_filter_c').val()
        ).draw();
    }
    $('.tb-st').empty();
    var table = $('#list-delivery-enviados')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list_c",
            "data": {
                estado: 'c'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                    return '<a href="javascript:void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+','+data.id_venta+');">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                var fecha1 = moment(data.fecha_envio);
                var fecha2 = moment(data.fecha_pedido);
                var duration = moment.duration(fecha2 - fecha1).humanize();
                return '<i class="ti-arrow-up text-warning"></i> '+moment(data.fecha_pedido).format('h:mm A')
                    +'<br><i class="ti-arrow-down text-info"></i> '+moment(data.fecha_envio).format('h:mm A')
                    +'<br><i class="ti-timer"></i> '+duration;
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                    var blkstr = []; 
                    $.each(data['Tipopago'], function(i,dato) { 
                        var str = "<span class='label label-success' style='background: "+dato.color+"'>" + dato.nombre + "</span>"; 
                        blkstr.push(str); 
                    });
                    return blkstr;
                }
            },
            {"data": null,
            "render": function(data, type, row){
                if(data.id_repartidor == '9999'){
                    return '<button  onclick="list_repartidor('+data.id_pedido+');" type="button" class="btn btn-primary btn-sm">Seleccionar</button>';
                }else{
                    return '<a href="#" class="text-muted " onclick="list_repartidor('+data.id_pedido+');"> <i class="ti-user"></i> '+data.NombreRepartidor.desc_repartidor +'</a>'; 
                }
            }},
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
            //$('#idventa').val(idventa);
        }
    });
    
    $('input.search_filter_c').on( 'keyup click', function () {
        filterGlobal();
    });
}

var delivery_list_d = function(){

    function filterGlobal () {
        $('#list-delivery-entregados').DataTable().search( 
            $('#search_filter_d').val()
        ).draw();
    }
    $('.tb-st').empty();
    var table = $('#list-delivery-entregados')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/delivery_list_c",
            "data": {
                estado: 'd'
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                    return '<a href="javascript:void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,'+data.id_pedido+',0);">'+data.nro_pedido+'</span></a>';
            }},
            {"data": null,
                "render": function(data, type, row){
                var fecha1 = moment(data.fecha_entrega);
                var fecha2 = moment(data.fecha_envio);
                var fecha3 = moment(data.fecha_preparacion);
                if(data.fecha_envio == '0000-00-00 00:00:00'){
                    var fecha_i = fecha3;
                } else {
                    var fecha_i = fecha2;
                }
                var duration = moment.duration(fecha_i - fecha1).humanize();
                return '<i class="ti-arrow-up text-info"></i> '+fecha_i.format('h:mm A')
                    +'<br><i class="ti-arrow-down text-success"></i> '+moment(data.fecha_entrega).format('h:mm A')
                    +'<br><i class="ti-timer"></i> '+duration;
            }},
            {"data": null,
                "render": function(data, type, row){
                return '<i class="ti-mobile"></i> '+data.telefono_cliente+'<br><i class="ti-user"></i> '+data.nombre_cliente;
            }},
            {"data": null,
                "render": function(data, type, row){
                var tipo_entrega = (data.tipo_entrega == 1) ? '<span class="label label-primary">A DOMICILIO</span>' : '<span class="label label-inverse">POR RECOGER</span>';
                return tipo_entrega;
            }},
            {"data": null,
                "render": function(data, type, row){
                    var blkstr = []; 
                    $.each(data['Tipopago'], function(i,dato) { 
                        var str = "<span class='label label-success' style='background: "+dato.color+"'>" + dato.nombre + "</span>"; 
                        blkstr.push(str); 
                    });
                    return blkstr;
                }
            },
            {"data": null,
                "className": "text-right",
                "render": function(data, type, row){
                return moneda+' '+formatNumber(data.total);
            }},
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.pedidos-total').text(total);
        }
    });
    
    $('input.search_filter_d').on( 'keyup click', function () {
        filterGlobal();
    });
}

var tiempo_pedido = function(){
    moment.locale('es');
    $('input[name^="tiempo_pedido_mostrador"]').each(function(i) {
        var fechaConvertida_mostrador_a = moment($(this).val()).fromNow(true);
        $(".tiempo-pedido-mostrador"+i).text(fechaConvertida_mostrador_a);
    });
    $('input[name^="tiempo_pedido_delivery"]').each(function(i) {
        var fechaConvertida_delivery_a = moment($(this).val()).fromNow(true);
        $(".tiempo-pedido-delivery"+i).text(fechaConvertida_delivery_a);
    });
}

var tiempo_preparacion = function(){
    moment.locale('es');
    $('input[name^="tiempo_preparacion_mostrador"]').each(function(i) {
        var fechaConvertida_mostrador_b = moment($(this).val()).fromNow(true);
        $(".tiempo-preparacion-mostrador"+i).text(fechaConvertida_mostrador_b);
    });
    $('input[name^="tiempo_preparacion_delivery"]').each(function(i) {
        var fechaConvertida_delivery_b = moment($(this).val()).fromNow(true);
        $(".tiempo-preparacion-delivery"+i).text(fechaConvertida_delivery_b);
    });
}

/* Imprimir Pre Cuenta*/
var impPreCuenta = function(id_pedido, id_mesa, estado, s = false) {
    if (s) {
        $.ajax({
            url: $("#url").val() + 'venta/pedido_estado_update',
            type: "post",
            dataType: "json",
            data: {
                id_mesa: id_mesa,
                estado: 'p' // Solo cambiamos a "p" al hacer Precuenta
            },
            success: function (r) {
                // Cambiamos visualmente la mesa sin eliminarla
                var botonMesa = $('#mesa-' + id_mesa);
                if (botonMesa.length) {
                    botonMesa
                        .removeClass('custom-btn-green custom-btn-reed') // Quita verde o rojo
                        .addClass('custom-btn-blue') // Azul para mesas en proceso
                        .find('.bottom-mesas .cstm-disp').html('En Proceso'); // Cambia texto
                }
            }
        }).done(function() {
            // Abrir la Precuenta en ventana nueva
            window.open($("#url").val() + 'venta/impresion_precuenta/' + id_pedido + '?pr=pc1', '_blank');
        });
    } else {
        window.open($("#url").val() + 'venta/impresion_precuenta/' + id_pedido + '?pr=pc2', '_blank');
    }
}


var listarPedidos = function(cod_salon, cod_mesa, id_tipo_pedido, id_pedido, mesa, salon) {
    $('#codsalonorigen').val(cod_salon);
    $('#codmesaorigen').val(cod_mesa);
    reset_default();
    $('.card_height').css('background','#fffde3');
    $('.card-body-right').css('display','block');
    $('.display-opciones-pedido').hide();

    if(id_tipo_pedido == 1){
        $('.pedido-numero-icono').html('');
        $('.pedido-numero').html(salon+' - Mesa: '+mesa);
    }

    $('.cont03').css('display','block');
    $('#list-pedidos').empty();

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/listarPedidos',
        data: {
            id_pedido: id_pedido,
            codpagina: $('#codpagina').val()
        },
        success: function (data) {
            var totPed = 0,
                total = 0,
                estado_mesa = null; // ?? guardamos el estado de la mesa

            if (data.length != 0) {
                $.each(data, function(i, item) {
                    // capturo el estado de la mesa (viene en el JSON del pedido)
                    estado_mesa = item.estado_mesa;

                    $('#nombre_mozo').val(item.nombre_mozo);
                    $('.pedido-mozo').show();
                    $('.pedido-mozo').attr('data-original-title','Vendedor: '+item.nombre_mozo);

                    totPed = (item.cantidad * item.precio);

                    $('#list-pedidos').append(
                        $('<div class="d-flex flex-row comment-row comment-list" onclick="subPedido(1,'+item.id_pedido+','+item.id_pres+',\''+item.precio+'\');"/>')
                        .append('<div class="comment-text w-100 p-0 m-b-10n"><span style="display: inline-block;">'
                        +'<h6 class="m-b-5">'+item.Producto.pro_nom+' <span class="label label-warning">'+item.Producto.pro_pre+'</span></h6>'
                        +'<p class="m-b-0 font-13">'+item.cantidad+' Unidad(es) en '+moneda+' '+formatNumber(item.precio)+' | Unidad</p></span>' 
                        +'<span class="price">'+moneda+' '+formatNumber(totPed)+'</span></div>')
                    );

                    total = totPed + total;    
                });

                $('.totalPagar').html('<div class="text"><span>'+moneda+' '+formatNumber(total)+'</span>');
            } else {
                $('#list-pedidos').html(
                    '<div class="justify-center" style="height: 100%;">'+
                        '<div class="text-center">'+
                            '<h2><i class="fas fa-shopping-basket display-4" style="color: #d3d3d3;"></i></h2>'+
                            '<h4 style="color: #d3d3d3;">Agregue productos</h4>'+
                            '<h6 style="color: #d3d3d3;">No se encontraron productos</h6>'+
                        '</div>'+
                    '</div>'
                );

                $('.totalPagar').html('<div class="text"><span>'+moneda+' '+formatNumber(total)+'</span>');
            }

            // ?? Configuramos siempre el bot?n "Precuenta"
            $('.opc-precuenta-pedido').show();
            $('.opc-precuenta-pedido').attr(
                'onclick',
                'impPreCuenta('+id_pedido+','+cod_mesa+', "'+estado_mesa+'", 1);'
            );
        }
    });

    $('.card-footer-right').css('display','block');
    $('.display-opciones-pedido').show();
    $('.opc-whatsapp-pedido').hide();
    $('.opc-anular-pedido').hide();

    $('.opc-mozo-pedido').show();
    $('.opc-mozo-pedido').attr('onclick','mozo_pedido('+id_pedido+');');
    
    if ($('#anular_pedido_mesa').val() == 1) {
        $('.opc-anular-pedido').show();
        $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');        
    }

    $('.btn-submit-nuevo-pedido').html('<a class="btn btn-orange" href="'+$('#url').val()+'venta/orden/'+id_pedido+'">Continuar <i class="fas fa-arrow-right"></i></a>');
}


var mozo_pedido = function(id_pedido){
    $('#modal-select-id_mozo').modal('show');
    $('#id_pedido_r').val(id_pedido);
}

var listarPedidosDetalle = function(cod_atencion,id_pedido,id_venta){
    reset_default();
    $('.display-delivery').hide();
    $('.card_height').css('background','#fffde3');
    $('.card-body-right').css('display','block');
    $('.pedido-numero-icono').html('<i class="ti-arrow-circle-right"></i> ');
    $('.cont04').css('display','block');
    $('#list-pedidos-detalle').empty();
    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/listarPedidosDetalle',
        data: {
            cod_atencion: cod_atencion,
            id_pedido: id_pedido
        },
        success: function (data) {

            $('.pedido-numero').html(data.nro_pedido);
            $('.opc-mozo-pedido').attr('onclick','mozo_pedido('+id_pedido+');');

            var totPed = 0,
                total = 0;
            
            $('.pedido-cliente').text(data.nombre_cliente); 
            $('.pedido-mozo').show();
            $('.pedido-mozo').css('font-size','20px');
            $('.pedido-mozo').attr('data-original-title',data.User.nombre);
            $('.pedido-mozo').attr('data-placement','left');

            // data-placement="top"

            if(cod_atencion == 3){
                $('.display-delivery').show();                
                if(data.tipo_entrega == 1){
                    var tipo_entrega = '<span class="label label-primary">A DOMICILIO</span>';
                    $('.display-pedido-direccion').show();
                    $('.display-pedido-referencia').show();
                    $('.display-pedido-repartidor').show();
                    $('.display-pedido-paga-con').show();                    
                    if(data.tipo_pago == 4){
                        $('.display-pedido-email').show();
                    } else {
                        $('.display-pedido-email').hide();
                    }
                }else{
                    var tipo_entrega = '<span class="label label-inverse">POR RECOGER</span>';
                    $('.display-pedido-email').hide();
                    $('.display-pedido-direccion').hide();
                    $('.display-pedido-referencia').hide();
                    $('.display-pedido-repartidor').hide();
                }
                $('.pedido-telefono').text(data.telefono_cliente);
                $('.pedido-email').text(data.email_cliente);
                $('.pedido-direccion').text(data.direccion_cliente);
                $('.pedido-referencia').text(data.referencia_cliente);
                $('.pedido-tipo-entrega').html(tipo_entrega);
                $('.pedido-repartidor').text(data.desc_repartidor);
                $('.pedido-paga-con').text(moneda+' '+formatNumber(data.paga_con));

                if(data.tipo_pago == 1){
                    var Tipo_pago = '<span class="label label-success">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 2){
                    var Tipo_pago = '<span class="label label-info">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 3){
                    var Tipo_pago = '<span class="label label-warning">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago == 4){
                    var Tipo_pago = '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">'+data.Tipopago.nombre+'</span>';
                } else if(data.tipo_pago >= 5){
                    var Tipo_pago = '<span class="label label-light-primary">'+data.Tipopago.nombre+'</span>';
                }

                $('.pedido-pago').html(Tipo_pago);



                if(data.pedido_programado == 1){
                    var hora_entrega = moment(data.hora_entrega, 'HH:mm:ss');
                    $('.pedido-hora-entrega').text(moment(hora_entrega).format('hh:mm A'));
                    $('.pedido-total-amortizado').text(moneda+' '+formatNumber(data.amortizacion));
                } else {
                    $('.display-hora-entrega').hide();
                    $('.display-pedido-total-amortizado').hide();
                }

            } else {
                $('.display-delivery').hide();
            }
            if (data.Detalle.length != 0) {
                $.each(data.Detalle, function(i, item) {
                    totPed = (item.cant * item.precio);
                    $('#list-pedidos-detalle')
                    .append(
                        $('<div class="d-flex flex-row comment-row tr-left-3" onclick="subPedido(2,'+item.id_pedido+','+item.id_pres+',\''+item.precio+'\');"/>')
                        .append('<div class="comment-text w-100 p-0 m-b-10n"><span style="display: inline-block;">'
                        +'<h6 class="m-b-5">'+item.Producto.pro_nom+' <span class="label label-warning">'+item.Producto.pro_pre+'</span></h6>'
                        +'<p class="m-b-0 font-13">'+item.cant+' Unidad(es) en '+moneda+' '+formatNumber(item.precio)+' | Unidad</p></span>'
                        +'<span class="price">'+moneda+' '+formatNumber(totPed)+'</span></div>'));
                    total = totPed + total;    
                });
                $('.pedido-total').text(moneda+' '+formatNumber(parseFloat(total)+parseFloat(data.comision_delivery)));
                if(data.estado_pedido == 'a'){
                    if($('#codtipoped').val() == 3){
                        $('.display-opciones-pedido').show();
                        $('.opc-mozo-pedido').show();
                        $('.opc-print-pedido').hide();
                        $('.opc-whatsapp-pedido').show();
                        $('.opc-anular-pedido').hide();
                        $('.opc-whatsapp-pedido').attr('onclick','enviar_whatsapp_pago(\''+data.nro_pedido+'\',\''+total+'\',\''+data.nombre_cliente+'\',\''+data.telefono_cliente+'\');');
                        $('.opc-facturar-pedido').html('<a class="dropdown-item" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="fas fa-plus"></i> Agregar productos</a>');
                        $('.opc-anular-pedido').hide();
                        //ESTO ES PARA CONDICIONAR EL BOTON DE ANULAR PEDIDO CUANDO ES PARA DELIVERY EN ESTADO "a"
                        if ($('#anular_pedido_delivery').val() == 1) {
                            $('.opc-anular-pedido').show();
                            $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');        
                        }
                        //$('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');">CONFIRMAR</a>');
                        $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="confirmar_pedido('+id_pedido+',\''+data.estado_pedido+'\');">CONFIRMAR</a>');
                        
                        if(data.tipo_entrega == 1){ //A DOMICILIO
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').show();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO;
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                            }
                        } else { //RECOGER
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').hide();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                                $('.opc-editar-pedido').hide();
                            }
                        }

                    } else {
                        $('.display-opciones-pedido').show();
                        $('.opc-mozo-pedido').show();
                        $('.opc-print-pedido').hide();
                        $('.opc-whatsapp-pedido').hide();
                        $('.opc-facturar-pedido').hide();
                        $('.opc-editar-pedido').hide();
                        $('.opc-anular-pedido').hide();
                        //ESTO ES PARA CONDICIONAR EL BOTON DE ANULAR PEDIDO CUANDO ES PARA LLEVAR
                        if ($('#anular_pedido_llevar').val() == 1) {
                            $('.opc-anular-pedido').show();
                            $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');        
                        }
                        if($('#rol_usr').val() != 5){
                            $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="mdi mdi-receipt"></i> COBRAR</a>');
                        } else {
                            $('.btn-submit-nuevo-pedido').html('');
                        }
                    }                    
                    $('.card-footer-right').css('display','block');
                    $('.display-pedido-monto').show();
                } else if(data.estado_pedido == 'b'){
                    $('.display-opciones-pedido').show();
                    $('.opc-mozo-pedido').show();
                    $('.opc-print-pedido').hide();
                    $('.opc-whatsapp-pedido').hide();
                    $('.opc-facturar-pedido').hide();
                    if($('#codtipoped').val() == 3){

                        if(data.tipo_entrega == 1){ //A DOMICILIO
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').show();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO;
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                            }
                        } else { //RECOGER
                            $('.opc-editar-pedido').show();
                            $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pedido('+id_pedido+');"><i class="fas fa-edit"></i> Editar pedido</a>');
                            $('.display-pedido-repartidor-edit').hide();
                            if(data.pedido_programado == 1){ // PEDIDO PROGRAMADO
                                $('.display-entrega-programada').show();
                            } else {
                                $('.display-entrega-programada').hide();
                                $('.opc-editar-pedido').hide();
                            }
                        }
                        $('.opc-anular-pedido').hide();
                        
                        //ESTO ES PARA CONDICIONAR EL BOTON DE ANULAR PEDIDO CUANDO ES PARA DELIVERY EN ESTADO "b"
                        if ($('#anular_pedido_delivery').val() == 1) {
                            $('.opc-anular-pedido').show();
                            $('.opc-anular-pedido').attr('onclick','anular_pedido('+id_pedido+');');        
                        }
                    
                    } else {
                        $('.opc-mozo-pedido').show();
                        $('.opc-editar-pedido').hide();
                        $('.opc-print-pedido').show();
                        $('.opc-print-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="impresion_ticket('+id_pedido+');"><i class="fas fa-print"></i> Ticket cliente</a>');
                        $('.opc-anular-pedido').show();
                        $('.opc-anular-pedido').attr('onclick','anular_venta('+id_pedido+',\''+data.nro_pedido+'\','+id_venta+');');
                    }

                    if(cod_atencion == 2){
                        $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="pedidoAccion(3,\'b\','+data.id_pedido+');">ENTREGADO</a>');
                    }else{
                        if($('#rol_usr').val() != 5){
                            $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="mdi mdi-receipt"></i> COBRAR</a>');       
                        } else {
                            $('.btn-submit-nuevo-pedido').html('');
                        }
                    }
                    $('.card-footer-right').css('display','block');
                    $('.display-pedido-monto').hide();
                } else if(data.estado_pedido == 'c'){
                    $('.display-opciones-pedido').show();
                    $('.opc-mozo-pedido').show();
                    $('.opc-whatsapp-pedido').hide();
                    $('.opc-editar-pedido').show();
                    $('.opc-editar-pedido').html('<a class="dropdown-item" href="javascript:void(0);" onclick="editar_venta_pago('+id_venta+');"><i class="fas fa-edit"></i> Editar venta</a>');
                        $('.display-entrega-programada').hide();
                        $('.display-pedido-repartidor-edit').hide();
                        $('.display-paga-con').hide();
                        $('.display-comision-delivery').hide();
                    $('.opc-anular-pedido').show();
                    $('.opc-anular-pedido').attr('onclick','anular_venta('+id_pedido+',\''+data.nro_pedido+'\','+id_venta+');');
                    $('.opc-print-pedido').show();
                    $('.opc-print-pedido').html('<a class="dropdown-item" href="'+$("#url").val()+'venta/impresion_reparto/'+id_venta+'" target="_blank"><i class="fas fa-print"></i> Ticket reparto</a>');
                    $('.opc-facturar-pedido').html('');
                    $('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" href="javascript:void(0);" onclick="pedidoAccion(2,\'c\','+data.id_pedido+');">ENTREGADO</a>');
                    //$('.btn-submit-nuevo-pedido').html('<a class="btn btn-success" target="_self" href="'+$("#url").val()+'venta/orden/'+id_pedido+'"><i class="mdi mdi-receipt"></i> FACTURAR</a>');
                    $('.card-footer-right').css('display','block');
                    $('.display-pedido-pago').hide();
                    $('.display-pedido-monto').hide();
                    $('.display-pedido-total-amortizado').hide();
                } else if(data.estado_pedido == 'd'){
                    $('.display-opciones-pedido').hide();
                    $('.btn-submit-nuevo-pedido').html('');
                    $('.card-footer-right').css('display','none');
                    $('.display-pedido-pago').hide();
                    $('.display-pedido-monto').hide();
                    $('.display-pedido-total-amortizado').hide();
                }
            } else {
                $('.pedido-total').text(moneda+' 0.00');
                $('.card-footer-right').css('display','none');
                $('.display-opciones-pedido').hide();
                $('.totalPagar').html('');
                $('.btn-submit-nuevo-pedido').html('');
                $('#list-pedidos-detalle').html('<div class="justify-center m-t-40" style="height: 100%;"><div class="text-center"><h2><i class="fas fa-shopping-basket display-4" style="color: #d3d3d3;"></i></h2><h4 style="color: #d3d3d3;"><a href="'+$("#url").val()+'venta/orden/'+id_pedido+'" class="link">Agregue productos</a></h4><h6 style="color: #d3d3d3;">No se encontraron productos</h6></div></div>');    
            }
        }
    });
}

var pedidoAccion = function(cod_accion,estado_pedido,id_pedido){
    /* cod_accion
        1 = enviar delivery, 2 = entregado delivery, 3 = entregado mostrador
    */
    if(cod_accion == 1){
        var accion = 'PREPARADO';
    }else if(cod_accion == 2 || cod_accion == 3){
        var accion = 'ENTREGADO';
    }
    var html_confirm = '<div><br>\
        <div style="width: 100% !important; float: none !important;">\
            <table class="table m-b-0">\
                <tr><td class="text-left">Pedido: </td><td class="text-right">'+$('.pedido-numero').text()+'</td></tr>\
            </table>\
        </div><br>\
        Ingrese código de vaucher</div>\
        <form><input class="form-control text-center w-100" type="text" id="codigo_vaucher" autocomplete="off"/></form><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Sí, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'venta/pedidoAccion',
                    type: 'POST',
                    data: {
                        cod_accion : cod_accion,
                        id_pedido : id_pedido,
                        codigo_operacion : $("#codigo_vaucher").val()
                    },
                    dataType: 'json'
                })
                .done(function(response){
                    Swal.fire({
                        title: 'Proceso Terminado',
                        text: 'El pedido ha sido '+accion,
                        icon: 'success',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                    reset_default();
                    $('.cont01').css('display','flex');
                    if(cod_accion == 1 || cod_accion == 2){
                        if(estado_pedido == 'b'){
                            delivery_list_b();
                        }else if(estado_pedido == 'c'){
                            delivery_list_c();
                        }
                    } else if(cod_accion == 3){
                        mostrador();
                    }
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexi?n a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
}

var registrarMesa = function(id_mesa,nro_mesa,salon){
    var html_confirm = '<div>Se procedera aperturar la siguiente mesa:</div><br>\
    <table class="table m-b-0">\
    <tr><td class="text-left">Zona: </td><td class="text-right">'+salon+'</td></tr>\
    <tr><td class="text-left">Mesa: </td><td class="text-right">'+nro_mesa+'</td></tr>\
    </table>\
    <label>Nro personas</label>\
    <input class="form-control numero-personas text-center" type="text" value="1" id="nro_personas"/><br>\
    <div><span class="text-success" style="font-size: 17px;">Esta Usted de Acuerdo?</span></div>';
    
    Swal.fire({
        title: 'Necesitamos de tu Confirmaci?n',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'venta/pedido_create/pc1',
                    type: 'POST',
                    data: {
                        id_mesa: id_mesa,
                        nomb_cliente: 'Mesa '+nro_mesa,
                        nro_personas: $("#nro_personas").val()
                    },
                    dataType: 'json',
                    success: function (data) {
                        if(data['fil'] == 1){
                            window.open($("#url").val()+'venta/orden/'+data['id_pedido'],'_self');
                        }else{
                            window.open($("#url").val()+'venta','_self');
                        }
                    }
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexi?n a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
    $('.numero-personas').TouchSpin({
        buttondown_class: "btn btn-secondary",
        buttonup_class: "btn btn-secondary",
        min: 1,
        mousewheel: false
    });
}

var orden = function(id_pedido){
    window.open($("#url").val()+'venta/orden/'+id_pedido,'_self');
}

var list_categorias_menu = function(){
    $('.categoriamenu').css('display','block');
    $('#categoriamenu').css('display','none');
    $('#modal-lista-menu').modal('show');
    $('.list_categorias_menu').empty();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/menu_categoria_list",
        dataType: "json",
        success: function(item){
            if(item.data.length > 0){
                $.each(item.data, function(i, item) {
                    var categoria_nombre = (item.descripcion).substr(0,1).toUpperCase()+(item.descripcion).substr(1).toLowerCase();
                    $('.list_categorias_menu')
                        .append(
                        $('<li class="nav-item m-t-10"/>')
                            .html('<a class="nav-link bg-header" data-toggle="tab" href="#categoriamenu" onclick="list_platos_menu('+item.id_catg+');" role="tab">'
                                +'<span class="hidden-sm-up">'+categoria_nombre+'</span>'
                                +'<span class="hidden-xs-down font-14">'+categoria_nombre+'</span> </a>')
                        )
                });
            }else{
                $('.list_categorias_menu').html("");
            }
        }
    });
}
var list_repartidor = function(id){
    // $('.categoriamenu').css('display','block');
    // $('#categoriamenu').css('display','none');
    $('#modal-select-repartidor').modal('show');
    $('#id_pedido_r').val(id);
    // $('.list_categorias_menu').empty();
    // $.ajax({
    //     type: "POST",
    //     url: $('#url').val()+"venta/menu_categoria_list",
    //     dataType: "json",
    //     success: function(item){
    //         if(item.data.length > 0){
    //             $.each(item.data, function(i, item) {
    //                 var categoria_nombre = (item.descripcion).substr(0,1).toUpperCase()+(item.descripcion).substr(1).toLowerCase();
    //                 $('.list_categorias_menu')
    //                     .append(
    //                     $('<li class="nav-item m-t-10"/>')
    //                         .html('<a class="nav-link bg-header" data-toggle="tab" href="#categoriamenu" onclick="list_platos_menu('+item.id_catg+');" role="tab">'
    //                             +'<span class="hidden-sm-up">'+categoria_nombre+'</span>'
    //                             +'<span class="hidden-xs-down font-14">'+categoria_nombre+'</span> </a>')
    //                     )
    //             });
    //         }else{
    //             $('.list_categorias_menu').html("");
    //         }
    //     }
    // });
}
var list_platos_menu = function(id_catg){

    $('.categoriamenu').css('display','none');
    $('#categoriamenu').css('display','block');
    
    function filterGlobal () {
        $('#list_platos_menu').DataTable().search( 
            $('#search_filter_menu').val()
        ).draw();
    }
    
    var count = 0;
    var table = $('#list_platos_menu')
    .DataTable({
        "destroy": true,
        "dom": "tp",
        "bSort": false,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"venta/menu_plato_list",
            "data": {
                id_catg: id_catg
            }
        },        
        "columns":[
            {"data":null,
                "render": function ( data, type, row) {
                var pro_nom = (data.pro_nom).substr(0,1).toUpperCase()+(data.pro_nom).substr(1).toLowerCase();
                var pro_pre = (data.pro_pre).substr(0,1).toUpperCase()+(data.pro_pre).substr(1).toLowerCase();
                return pro_nom+' | '+pro_pre+' | '+$('#moneda').val()+' '+data.pro_cos;
            }},
            {"data": null,
                "render": function(data, type, row){
                var checked = (data.est_c == 'a') ? 'checked' : '';
                return '<div class="switch text-right" onclick="estado_plato_menu('+data.id_catg+','+data.id_pres+',\''+data.est_c+'\');"><label class="m-b-0"><input type="checkbox" '+checked+'><span class="lever switch-col-light-green"></span></label></div>';
            }}
        ]
    });
    
    $('input.search_filter_menu').on( 'keyup click', function () {
        filterGlobal();
    });
}

var estado_plato_menu = function(id_catg,id_pres,estado){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/menu_plato_estado",
        dataType: "json",
        data: {
            id_pres : id_pres,
            estado : estado
        },
        success: function(request){
            list_platos_menu(id_catg);
        }
    });
}

var nuevoPedidoMesa = function(id_mesa,mesa,salon){
    $('#codsalonorigen').val('0');
    $('#codmesaorigen').val('0');
    $('.id-mesa').val(id_mesa);
    //////////////////////////////////////
    reset_default();
    $('.display-mozo').css('display','block');
    $("#id_mozo").removeAttr('disabled');
    $('#id_mozo').selectpicker('refresh');
    $('#id_mozo').selectpicker('val', '');
    $("#nomb_cliente").removeAttr('disabled');
    $('.pedido-mozo').hide();
    $('.display-personas').css('display','block');
    $('.numero-personas').TouchSpin({
        buttondown_class: "btn btn-link text-success",
        buttonup_class: "btn btn-link text-success",
        min: 1,
        mousewheel: false
    });
    ///////////////////////////////////////////   
    // $('.card_height').css('background','#fffde3');
    $('.card_height').css('background','#ffffff');
    $('.card-body-right').css('display','block');
    $('.cont02').css('display','block');
    $('.pedido-numero-icono').html('');
    $('.pedido-numero').html(salon+' - Mesa: '+mesa);
    $('.card-footer-right').css('display','block');
    $('.display-opciones-pedido').hide();
    /////////////////////////////////////////////
    $('#form-nuevo-pedido').data('formValidation').resetForm($('#form-nuevo-pedido'));
    $("#nomb_cliente").val('Mesa: '+mesa);
    $('.btn-submit-nuevo-pedido').html('<button type="submit" class="btn btn-orange btn-submit-nuevo-pedido">Continuar <i class="fas fa-arrow-right"></i></button>');
    id_usuario_default();
}

var tab01 = function(){
    $('.topbar').css('width','100%');
    $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc1');
    $('.display-estado-mesa').css('display','block');
    $('input[name^="codtipoped"]').val(1);
    /////////////////////
    reset_default();
    $('.cont01').css('display','flex');
    $('.cont01-1').css('display','block');
    $('.cont01-2').css('display','none');
    $('.nomPed').html('una mesa');
    $('.dim').removeClass('active');
    $('#codpestdelivery').val(0);
}

var tab02 =  function(){
    $('.topbar').css('width','100%');
    $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc2');
    $('.display-estado-mesa').css('display','none');
    $('input[name^="codtipoped"]').val(2);
    /////////////////////////////
    reset_default();
    $('.cont01').css('display','flex');
    $('.cont01-1').css('display','none');
    $('.cont01-2').css('display','block');
    $('.nomPed').html('un pedido');
    $('#codpestdelivery').val(0);
}

var tab03 = function(){
    $('.topbar').css('width','100%');
    $('#form-nuevo-pedido').attr('action','venta/pedido_create/pc3');
    $('.display-estado-mesa').css('display','none');
    $('input[name^="codtipoped"]').val(3);
    ///////////////////////
    reset_default();
    $('.cont01').css('display','flex');
    $('.cont01-1').css('display','none');
    $('.cont01-2').css('display','block');
    $('.nomPed').html('un pedido');
    $('#codpestdelivery').val(1);
    //$('#cliente_id').val('');
}

$('.tab01,.list-salones').click( function() {
    tab01();
});

$('.tab02').click( function() {
    tab02();
});

$('.tab03').click( function() {
    tab03();
});

$('.btn-nuevo-pedido').click( function() {
    reset_default();
    $('.card_height').css('background','#fffde3');
    //$('.card_height').css('background','#FFFFF0');
    $('.card-body-right').css('display','block');
    $('.pedido-numero-icono').html('');
    $('.pedido-numero').html('Nuevo pedido:');
    $('.cont02').css('display','block');
    $('#form-nuevo-pedido').data('formValidation').resetForm($('#form-nuevo-pedido'));
    if($('#codtipoped').val() == 2){
        $('.display-nombre').css('display','block');
        $('.btn-opc-nuevo-cliente').css('display','none');
        $("#nomb_cliente").removeAttr('disabled');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
    } else if($('#codtipoped').val() == 3){
        //$('#cliente_id').val('');
        $('.display-pedido-programado').css('display','block');
        $('#tipo_entrega_1').prop('checked', true);
        $('#tipo_entrega_2').prop('checked', false);
        $('.display-tipo-entrega').css('display','block');
        $('.btn-tipo-entrega-1').addClass('active');
        $('.btn-tipo-entrega-2').removeClass('active');
        $('.display-telefono-cliente').css('display','block');
        $("#telefono_cliente").removeAttr('disabled');
        $('.display-nombre').css('display','block');
        $("#nomb_cliente").removeAttr('disabled');
        $('.display-direccion-cliente').css('display','block');
        $("#direccion_cliente").removeAttr('disabled');
        $('.display-referencia-cliente').css('display','block');
        $("#referencia_cliente").removeAttr('disabled');
        $('.display-repartidor').css('display','block');
        $("#id_repartidor").removeAttr('disabled');
        $('#id_repartidor').selectpicker('refresh');
        $('#id_repartidor').selectpicker('val', '');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'id_repartidor');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
        $('.btn-opc-nuevo-cliente').css('display','block');
        $('.btn-opc-nuevo-cliente').html('<button class="btn btn-secondary" onclick="nuevo_cliente();" type="button"><i class="fa fa-user-plus"></i></button>');
    }
    $('.card-footer-right').css('display','block');
    $('.btn-submit-nuevo-pedido').html('<button type="submit" class="btn btn-orange btn-submit-nuevo-pedido">Continuar <i class="fas fa-arrow-right"></i></button>');
    $('.display-opciones-pedido').hide();
});

$('.btn-cancelar-pedido').click( function(){
    if($('#codtipoped').val() == 1){
        tab01();
    } else if($('#codtipoped').val() == 2){
        tab02();
    } else if($('#codtipoped').val() == 3){
        tab03();
    }
    /*
    $('#form-nuevo-pedido').data('formValidation').resetForm($('#form-nuevo-pedido'));
    */
});

$('.btn-tipo-entrega-1').on('click', function(event){
    $('.display-nombre').css('display','block');
    $("#nomb_cliente").prop('disabled', false);
    $('.display-direccion-cliente').css('display','block');
    $("#direccion_cliente").prop('disabled', false);
    $('.display-referencia-cliente').css('display','block');
    $("#referencia_cliente").prop('disabled', false);
    $('.display-repartidor').css('display','block');
    $("#id_repartidor").prop('disabled', false);
    $('#id_repartidor').selectpicker('refresh');
    $('#id_repartidor').selectpicker('val', '');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'id_repartidor');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
});

$('.btn-tipo-entrega-2').on('click', function(event){
    $('.display-nombre').css('display','block');
    $("#nomb_cliente").prop('disabled', false);
    $('.display-direccion-cliente').css('display','none');
    $("#direccion_cliente").prop('disabled', true);
    $('.display-referencia-cliente').css('display','none');
    $("#referencia_cliente").prop('disabled', true);
    $('.display-repartidor').css('display','none');
    $("#id_repartidor").prop('disabled', true);
    $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
    $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
});

/* INICIO - OPCION DE MESAS */
/* 1.- OPCION CAMBIAR MESA  */
/* Combo mesa origen */
var comboMesaOrigenOpc01 = function(cod_salon_origen_opc01){
    $('#cod_mesa_origen_opc01').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaOri",
        data: {
            cod_salon_origen: cod_salon_origen_opc01
        },
        success: function (response) {
            $('#cod_mesa_origen_opc01').html(response);
            $('#cod_mesa_origen_opc01').selectpicker();
            $('#cod_mesa_origen_opc01').selectpicker('refresh');
            $('#cod_mesa_origen_opc01').val($('#codmesaorigen').val()).selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_origen_opc01').html('There was an error!');
        }
    });
}

/* Combo mesa destino */
var comboMesaDestinoOpc01 = function(cod_salon_destino_opc01){
    $('#cod_mesa_destino_opc01').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaDes",
        data: {
            cod_salon_destino: cod_salon_destino_opc01,
            estado: 'a'
        },
        success: function (response) {
            $('#cod_mesa_destino_opc01').html(response);
            $('#cod_mesa_destino_opc01').selectpicker();
            $('#cod_mesa_destino_opc01').selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_destino_opc01').html('There was an error!');
        }
    });
}

/* Combo salon origen */
$('#cod_salon_origen_opc01').change( function() {
    var cod_salon_origen_opc01 = $('#cod_salon_origen_opc01').val();
    comboMesaOrigenOpc01(cod_salon_origen_opc01);
    $('#form-cambiar-mesa').formValidation('revalidateField', 'cod_mesa_origen_opc01');
});

/* Combo salon destino */
$('#cod_salon_destino_opc01').change( function() {
    var cod_salon_destino_opc01 = $('#cod_salon_destino_opc01').val();
    comboMesaDestinoOpc01(cod_salon_destino_opc01);
});

/* Boton cambiar mesa */
$('.opc-cambiar-mesa').click( function() {
    $('#cod_salon_origen_opc01').val($('#codsalonorigen').val()).selectpicker('refresh');
    var cod_salon_destino_opc01 = $('#cod_salon_destino_opc01').val();
    comboMesaOrigenOpc01($('#codsalonorigen').val());
    comboMesaDestinoOpc01(cod_salon_destino_opc01);
});

$('#modal-cambiar-mesa').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form-cambiar-mesa').formValidation('resetForm', true);
    $('#cod_salon_origen_opc01').val('').selectpicker('refresh');
    $('#cod_salon_destino_opc01').val('').selectpicker('refresh');
});
/* OPCION CAMBIAR MESA  */

/* 2.- OPCION MOVER PEDIDOS  */
/* Combo mesa origen */
var comboMesaOrigenOpc02 = function(cod_salon_origen_opc02){
    $('#cod_mesa_origen_opc02').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaOri",
        data: {
            cod_salon_origen: cod_salon_origen_opc02
        },
        success: function (response) {
            $('#cod_mesa_origen_opc02').html(response);
            $('#cod_mesa_origen_opc02').selectpicker();
            $('#cod_mesa_origen_opc02').selectpicker('refresh');
            $('#cod_mesa_origen_opc02').val($('#codmesaorigen').val()).selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_origen_opc02').html('There was an error!');
        }
    });
}

/* Combo mesa destino */
var comboMesaDestinoOpc02 = function(cod_salon_destino_opc02){
    $('#cod_mesa_destino_opc02').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"venta/ComboMesaDes",
        data: {
            cod_salon_destino: cod_salon_destino_opc02,
            estado: 'i'
        },
        success: function (response) {
            $('#cod_mesa_destino_opc02').html(response);
            $('#cod_mesa_destino_opc02').selectpicker();
            $('#cod_mesa_destino_opc02').selectpicker('refresh');
        },
        error: function () {
            $('#cod_mesa_destino_opc02').html('There was an error!');
        }
    });
}

/* Combo salon origen */
$('#cod_salon_origen_opc02').change( function() {
    var cod_salon_origen_opc02 = $('#cod_salon_origen_opc02').val();
    comboMesaOrigenOpc02(cod_salon_origen_opc02);
    $('#form-mover-pedidos').formValidation('revalidateField', 'cod_mesa_origen_opc02');
});

/* Combo salon destino */
$('#cod_salon_destino_opc02').change( function() {
    var cod_salon_destino_opc02 = $('#cod_salon_destino_opc02').val();
    comboMesaDestinoOpc02(cod_salon_destino_opc02);
});

/* Boton cambiar mesa */
$('.opc-mover-pedidos').click( function() {
    $('#cod_salon_origen_opc02').val($('#codsalonorigen').val()).selectpicker('refresh');
    var cod_salon_destino_opc02 = $('#cod_salon_destino_opc02').val();
    comboMesaOrigenOpc02($('#codsalonorigen').val());
    comboMesaDestinoOpc02(cod_salon_destino_opc02);
});

$('#modal-mover-pedidos').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form-mover-pedidos').formValidation('resetForm', true);
    $('#cod_salon_origen_opc02').val('').selectpicker('refresh');
    $('#cod_salon_destino_opc02').val('').selectpicker('refresh');
});
/* OPCION MOVER PEDIDOS  */

/* FIN OPCION DE MESAS */

/************  */

var reset_default = function(){
    $('.cont01').css('display','none');
    $('.cont02').css('display','none');
    $('.cont03').css('display','none');
    $('.cont04').css('display','none');
    $('.card-body-right').css('display','none');
    $('.card-footer-right').css('display','none');
    $('.card_height').css('background','#747474');
    $('.totalPagar').html('');
    $('.pedido-numero-icono').html('');
    $('.pedido-numero').html('Detalle:');
    $('.opc-mozo-pedido').hide();
    // NONE DISPLAY
    $('.display-pedido-programado').css('display','none');
    $('.pedido_programado').prop('checked', false);
    $('.pedido_programado').val('0');
    $('.display-tipo-entrega').css('display','none');
    $('.display-hora-entrega').css('display','none');
    $('.display-pedido-total-amortizado').css('display','none');
    $('.display-busqueda-cliente').css('display','none');
    $('.display-nombre').css('display','none');
    $('.display-telefono-cliente').css('display','none');
    $('.display-direccion-cliente').css('display','none');
    $('.display-referencia-cliente').css('display','none');
    $('.display-repartidor').css('display','none');
    $('.display-personas').css('display','none');
    $('.display-mozo').css('display','none');
    $('.btn-opc-nuevo-cliente').css('display','none');
    //DISABLED INPUT
    $("#hora_entrega").attr('disabled','true');
    $("#nomb_cliente").attr('disabled','true');
    $("#telefono_cliente").attr('disabled','true');
    $("#direccion_cliente").attr('disabled','true');
    $("#referencia_cliente").attr('disabled','true');
    $("#id_repartidor").attr('disabled','true');
    $("#id_mozo").attr('disabled','true');
}

$('.mostrador01').click( function() {
    mostrador_list_a();
    reset_default();
    $('.cont01').css('display','flex');
});

$('.mostrador02').click( function() {
    mostrador_list_b();
    reset_default();
    $('.cont01').css('display','flex');
});

$('.mostrador03').click( function() {
    mostrador_list_c();
    reset_default();
    $('.cont01').css('display','flex');
});

$('.delivery01').click( function() {
    delivery_list_a();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(1);
});

$('.delivery02').click( function() {
    delivery_list_b();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(0);

    // delive_repart
});

$('.delivery03').click( function() {
    delivery_list_c();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(0);
});

$('.delivery04').click( function() {
    delivery_list_d();
    reset_default();
    $('.cont01').css('display','flex');
    $('#codpestdelivery').val(0);
});

/****   *///

/* Link de pago whatsapp */
var enviar_whatsapp_pago = function(nro_pedido,total_pedido,cliente,telefono){
    var html_confirm = '<div>Enviar mensaje:</div>\
    <div class="font-18 font-bold">Pedido N? '+nro_pedido+'</div><br>\
    <div><form><textarea id="textarea" class="form-control" rows="8">Hola '+cliente+'!\
    \nYa aceptamos tu solicitud de tu pedido por un monto de '+$('#moneda').val()+' '+formatNumber(total_pedido)+'.\
    \nGracias por confirar en nosotros</textarea></div>\
            <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    Swal.fire({
        title: '',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            window.open('https://api.whatsapp.com/send?phone=51'+telefono+'&text='+$('#textarea').val() ,'_blank');
        }            
    });
}

var anular_pedido = function(id_pedido){

    var html_confirm = '<div>Se procederá a anular el siguiente pedido:</div>\
    <div class="font-18 font-bold">¿Está Usted de Acuerdo?</div><br>\
    <form>\
        <div class="text-center">\
            <label class="m-t-10">Ingrese código de seguridad</label>\
            <input class="form-control text-center" type="password" id="codigo_seguridad" autocomplete="off" style="font-size: 30px;height: 40px !important;"/><br>\
        </div>\
        <div class="text-left">\
            <label class="m-t-10">Motivo</label>\
            <textarea id="motivo" class="form-control" rows="2" required="required"></textarea>\
        </div>\
    </form><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    var disable = true;

    Swal.fire({
        customClass: {
            confirmButton: 'c-disabled',
        },
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Sí, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve, reject) {
                $.ajax({
                    url: $('#url').val()+'venta/anular_pedido',
                    type: 'POST',
                    data: {
                        id_pedido : id_pedido,
                        tipo_pedido : $("#codtipoped").val(),
                        motivo : $("#motivo").val(),
                        codigo_seguridad : $("#codigo_seguridad").val()
                    },
                    dataType: 'json'
                })
                .done(function(response){
                    if (response && response.success === true) {
                        if ($("#codtipoped").val() == 1) {
                            if ($("#anular_pedido_mesa_com").val() == 1) {impresion_comanda(id_pedido,'anularmesa'); }
                        }
                        if($("#codtipoped").val() == 2){
                            if ($("#anular_pedido_llevar_com").val() == 1) {impresion_comanda(id_pedido,'anularmesa');}
                        }
                        if($("#codtipoped").val() == 3){
                            if ($("#anular_pedido_delivery_com").val() == 1) {impresion_comanda(id_pedido,'anularmesa'); }
                        }
                        if (typeof contadorComensal === 'function') { contadorComensal(); }
                        window.open($("#url").val()+'venta','_self');
                    } else {
                        Swal.fire('Código incorrecto', response && response.message ? response.message : 'El código de seguridad no es correcto.', 'error');
                    }
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false,
        didOpen: function() {
            $('.c-disabled').attr('disabled', true);
            $('#codigo_seguridad').on('keyup input', function () {
                disableboton();
            });
        }
    });
}

var anular_venta = function(id_pedido,nro_pedido,id_venta){
    var html_confirm = '<div>Se procederá a anular el siguiente pedido:</div>\
    <div class="font-18 font-bold">Pedido Nº '+nro_pedido+'</div><br>\
    Ingrese código de seguridad</div><br>\
    <form><input class="form-control text-center w-50" type="password" id="codigo_anular_venta_" autocomplete="off"/></form><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Sí, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                if($('#codigo_anular_venta').val() == $('#codigo_anular_venta_').val()){
                    $.ajax({
                        url: $('#url').val()+'venta/anular_venta',
                        type: 'POST',
                        data: {
                            id_venta : id_venta,
                            id_pedido : id_pedido
                        },
                        dataType: 'json'
                    })
                    .done(function(response){
                        window.open($("#url").val()+'venta','_self');
                    })
                    .fail(function(){
                        Swal.fire('Oops...', 'Problemas con la conexi?n a internet!', 'error');
                    });
                } else {
                    Swal.fire({
                        title: 'Proceso No Culminado',
                        text: 'El c?digo ingresado es incorrecto',
                        icon: 'error',
                        confirmButtonColor: '#34d16e',
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }            
    });
}

var editar_pedido = function(id_pedido){
    $('#modal-editar-pedido').modal('show');
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_pedido: id_pedido
      },
      url: $('#url').val()+'venta/pedido_edit',
        success: function (item){
            $.each(item.data, function(i, campo) {
                $('#id_pedido').val(id_pedido);
                $('#id_repartidor_edit').selectpicker('val', campo.id_repartidor);
                $('#hora_entrega_edit').selectpicker('val', campo.hora_entrega);
                $('#amortizacion').val(campo.amortizacion);
                $('#id_tipo_pago').selectpicker('val', campo.tipo_pago);
                $('#paga_con').val(campo.paga_con);
                $('#comision_delivery').val(campo.comision_delivery);
                if(campo.tipo_pago == 1){
                    $('.display-paga-con').show();
                } else {
                    $('.display-paga-con').hide();
                }
            });
        }
    });
}

$("#id_tipo_pago").change(function() {
    if(this.value == 1){
        $('.display-paga-con').show();
    } else {
        $('.display-paga-con').hide();
    }
});

var editar_venta_pago = function(id_venta){
    $('#modal-editar-venta-pago').modal('show');
    $('[name="pago[]"]').val('');
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_venta: id_venta
      },
      url: $('#url').val()+'venta/venta_edit',
        success: function (item){
            $.each(item.data, function(i, campo) {
                $('.btn-pago').attr('disabled', true);
                $('#id_venta').val(campo.id_venta);
                $('#id_pedido').val(campo.id_pedido);                              
                $('#pago'+campo.id_pago).val(campo.monto);
                $('.totalPedido').text(formatNumber(parseFloat(campo.total) + parseFloat(campo.comision_delivery)));
                $('.totalPedido').val(parseFloat(campo.total) + parseFloat(campo.comision_delivery));
                $('.totalPedidoDelivery').text(formatNumber(campo.comision_delivery));



                // $('.btn-pago').attr('disabled', true); 
                // $('#id_venta').val(campo.id_venta);                             
                // $('#pago'+campo.id_pago).val(campo.monto);
                // $('.totalPedido').text(formatNumber(parseFloat(campo.total) + parseFloat(campo.comision_delivery)));
                // $('.totalPedido').val(parseFloat(campo.total) + parseFloat(campo.comision_delivery));
                // $('.totalPedidoDelivery').text(formatNumber(campo.comision_delivery));
                // console.log(parseFloat(campo.total, 2));





            });
            sumar_pagos();
        }
    });
}

 confirmar_pedido = function(id_pedido,estado_pedido){
    var html_confirm ='<div>Enviar los productos para su preparaci?n, a su ?rea de producci?n correspondiente *</div><br>\
    <div style="width: 100% !important; float: none !important;">\
        <table class="table m-b-0">\
            <tr><td class="text-left">Pedido: </td><td class="text-right">'+$('.pedido-numero').text()+'</td></tr>\
            <tr><td class="text-left">Cliente: </td><td class="text-right">'+$('.pedido-cliente').text()+'</td></tr>\
        </table>\
    </div><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                impresion_comanda(id_pedido,estado_pedido);
                
                delivery_list_a();
                reset_default();
                $('.cont01').css('display','flex');
                swal.close();
            });
        }       
    });
}

var alert_pedidos_programados = function(){
    $.ajax({
      type: "post",
      dataType: "json",
      url: $('#url').val()+'venta/alert_pedidos_programados',
        success: function (data){
            var fecha1 = moment($('#hora').val(), 'HH:mm:ss');
            var fecha2 = moment(data.hora_entrega, 'HH:mm:ss');
            var duration = moment.duration(fecha2 - fecha1).humanize();
            var minutos = fecha2.diff(fecha1, 'minutes');
            if(minutos < 30){
                html = '';
                var html_confirm = '<div class="font-16">Hay un pedido para las <strong>'+moment(fecha2).format('hh:mm A')+'</strong> esperando ser enviado a <strong>PREPARACI?N</strong></div>\
                <br><div style="width: 100% !important; float: none !important;">\
                    <table class="table m-b-0">\
                    <tr><td class="text-left">Pedido: </td><td class="text-right">'+data.nro_pedido+'</td></tr>\
                    <tr><td class="text-left">Cliente: </td><td class="text-right">'+data.nombre_cliente+'</td></tr>\
                    </table>\
                </div><br>\
                <div><span class="text-success" style="font-size: 17px;">?Continuar ahora?</span></div>';
                Swal.fire({
                    title: '',
                    html: html_confirm,
                    icon: 'info',
                    position: 'top-end',
                    showCancelButton: true,
                    confirmButtonColor: '#34d16e',
                    confirmButtonText: 'Si, Adelante!',
                    cancelButtonText: "No!",
                    showLoaderOnConfirm: true,
                    preConfirm: function() {
                        return new Promise(function(resolve) {
                            $('#codtipoped').val(3);
                            listarPedidosDetalle(3,data.id_pedido,0);
                            activaTab('tabp-3');
                            activaTab('delivery01');
                            delivery_list_a();
                            $('.display-estado-mesa').css('display','none');
                            $('.cont01-1').css('display','none');
                            $('.cont01-2').css('display','block');
                            Swal.close();
                        });
                    }             
                });
                var sound = new buzz.sound($('#url').val()+"public/sound/alert02", {
                    formats: [ "ogg", "mp3", "aac" ]
                });
                sound.play();
            }
            //alert(duration);
        }
    });
}

var validarApertura = function(){
    // if($('#cod_ape').val() == 0 && $('#rol_usr').val() != 1){ @braintechperu
    //if($('#cod_ape').val() == 0 && $('#rol_usr').val() != 2){
    if ($('#cod_ape').val() == 0 && $('#rol_usr').val() != 2 && $('#rol_usr').val() != 1) {
        var html_confirm = '<div>Para poder realizar esta operaci?n es necesario Aperturar Caja</div>\
            <br>\
            <div><span class="text-success" style="font-size: 18px;">¿Está Usted de Acuerdo?</span></div><br>\
            <a href="'+$("#url").val()+'caja/apercie" class="btn btn-success">Si, Adelante!</a>';

        Swal.fire({
            title: 'Advertencia',
            html: html_confirm,
            icon: 'warning',
            allowOutsideClick: false,
            allowEscapeKey : false,
            showCancelButton: false,
            showConfirmButton: false,
            closeOnConfirm: false,
            closeOnCancel: false
        });
    }
}

$('.pedido_programado').on('click', function(event){
    if( $(this).is(':checked') ) {
        $('#pedido_programado').val('1');
        $('.display-hora-entrega').css('display','block');
        $("#hora_entrega").removeAttr('disabled');
        $('#hora_entrega').selectpicker('refresh');
        $('#hora_entrega').selectpicker('val', '');
        $('#form-nuevo-pedido').formValidation('revalidateField', 'hora_entrega');
    } else {
        $('#pedido_programado').val('0');
        $("#hora_entrega").prop('disabled', true);
        $('.display-hora-entrega').css('display','none');
    }
});

$('#eliminar_pedido').on('click', function(event){
	var html_confirm = '<div>Para poder eliminar los pedidos, ingrese la contrase?a<br></div><br>\
		<form><input class="form-control text-center w-50" type="password" id="codigo_seguridad_" autocomplete="off"/></form><br>\
		<label id="password_respuesta" class=""></label>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
	disable = true; 
	Swal.fire({
		customClass: {
			confirmButton: 'c-disabled',
		},
	    title: '¿Desea eliminar todos sus pedidos?',
	    html: html_confirm,
	    icon: 'warning',
	    showCancelButton: true,
	    confirmButtonColor: '#34d16e',
	    confirmButtonText: 'Si, Adelante!',
	    cancelButtonText: "No!",
	    showLoaderOnConfirm: true,
	    preConfirm: function() {
	      return new Promise(function(resolve) {
	         $.ajax({
	            url: $("#url").val()+'ajuste/optimizar_pedidos_llevar',
	            type: 'POST',
	            dataType: 'json'
	         })
	         .done(function(response){
	         	if(response == 1){
	         		Swal.fire({
		                title: 'Proceso Terminado',
		                text: 'El sistema se ha optimizado correctamente',
		                icon: 'success',
		                confirmButtonColor: "#34d16e",   
		                confirmButtonText: "Aceptar"
		            });  
                    activaTab('mostrador01');
                    mostrador_list_a();
	         	}else{
		            Swal.fire({
		                title: 'Proceso No Culminado',
		                text: 'Asegurese de no tener un pedido abierto',
		                icon: 'error',
		                confirmButtonColor: "#34d16e",   
		                confirmButtonText: "Aceptar"
		            });
		        }               
	         })
	         .fail(function(){
	            Swal.fire('Oops...', 'Problemas con la conexi?n a internet!', 'error');
	         });
	      });
	    },
	    allowOutsideClick: false              
	}); 
	$('.c-disabled').attr('disabled', disable);
	$('#codigo_seguridad_').on( 'keyup click', function () {
	disableboton();
	});  
});

/*
var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = window.location.search.substring(1),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
        }
    }
};
*/
var disableboton = function(){
    if ($("#codigo_anular_venta").val() == $('#codigo_seguridad_').val() || $("#codigo_anular_venta").val() == $('#codigo_seguridad').val()) {
        $("#password_respuesta").text('Contrase?a Correcta');
        $("#password_respuesta").addClass('text-success');
        $("#password_respuesta").removeClass('text-danger');
        $('.c-disabled').attr('disabled', false);  
    }else{
        $("#password_respuesta").addClass('text-danger');
        $("#password_respuesta").removeClass('text-success');
        $("#password_respuesta").text('Contrase?a Incorrecta');
        $('.c-disabled').attr('disabled', true);
    }
}



// var disableboton = function(){
//     if ($("#codigo_anular_venta").val() == $('#codigo_seguridad').val()) {
//         $('.c-disabled').attr('disabled', false);  
//     }else{
//         $('.c-disabled').attr('disabled', true);
//     }
// }


function activaTab(tab){
    $('.nav-tabs a[href="#' + tab + '"]').tab('show');
};

