<?php
// index.php
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title></title>

  <!-- Bootstrap + jQuery -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/formvalidation@0.6.2-dev/dist/js/formValidation.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/formvalidation@0.6.2-dev/dist/js/framework/bootstrap.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="https://cdn.jsdelivr.net/npm/jquery-toast-plugin@1.3.2/dist/jquery.toast.min.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-toast-plugin@1.3.2/dist/jquery.toast.min.css">

 <style>
:root {
  --blue: #0472cf;    /* azul principal */
  --white: #f7fbfb;
  --accent: #7fbdb0;  /* color acento secundario */
}

body {
  margin: 0;
  font-family: Inter, system-ui, Arial, Helvetica, sans-serif;
  display: grid;
  place-items: center;
  min-height: 100vh;
  background: url('../public/images/fondo.svg') center/cover no-repeat; /* Imagen SVG de fondo */
  background-size: cover; /* Asegura que la imagen se ajuste al tamaño de la pantalla */
  background-attachment: fixed; /* Hace que la imagen permanezca fija durante el desplazamiento */
}

.card-login {
  width: 95vw;
  max-width: 900px;
  border-radius: 20px;
  overflow: hidden;
  display: flex;
  flex-direction: row;
  box-shadow: 0 18px 50px rgba(0, 0, 0, .45);
  transition: all 0.6s ease;
}

.left, .right {
  flex: 1;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  transition: background 0.6s ease, color 0.6s ease;
}

.left {
  background: var(--white);
  color: #000;
}

.right {
  background: var(--blue);
  color: var(--white);
}

/* Estado invertido */
.card-login.mozo-mode .left {
  background: var(--blue);
  color: #fff;
}

.card-login.mozo-mode .right {
  background: var(--white);
  color: var(--blue);
}

.art {
  width: 70%;
  height: 70%;
  min-height: 145px;
  border-radius: 14px;
  background: center/contain no-repeat;
  transition: background-image 0.6s ease;
}

/* Cuando el fondo es blanco */
.left .art {
  background-image: url('../public/images/nubeblanco1.png'); /* Imagen para fondo blanco */
}

/* Cuando el fondo es azul (mozo-mode) */
.card-login.mozo-mode .left .art {
  background-image: url('../public/images/nubeazul.png'); /* Imagen para fondo azul */
}

.brand h1 {
  margin: 0;
  font-size: 24px;
  transition: color 0.6s ease;
}

/* Contenedor */
/* Estilo general para el contenedor de los botones */
.switcher {
  display: flex;
  gap: 10px;
  margin-bottom: 20px;
  width: 100%;
}

/* Estilo general para los botones */
.switcher button {
  flex: 1;
  padding: 12px;
  border-radius: 10px;
  border: 2px solid transparent;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.3s ease;
}

/* Estilo para el botón activo */
.active-btn {
  background: #0472cf; /* Fondo azul */
  color: #fff; /* Texto blanco */
  border-color: #0472cf; /* Borde azul */
  box-shadow: 0 4px 10px rgba(4, 114, 207, 0.3); /* Sombra sutil */
}

/* Hover para el botón activo */
.active-btn:hover {
  background: #024f94; /* Fondo azul más oscuro al pasar el ratón */
  border-color: #024f94; /* Borde azul más oscuro */
}

/* Estilo para el botón inactivo (lo que cambia cuando es "Ingreso Administrativo") */
.inactive-btn {
  background: #f2f7ff; /* Fondo blanco o claro */
  color: #0472cf; /* Texto azul */
  border-color: #0472cf; /* Borde azul */
  opacity: 0.9; /* Opacidad un poco reducida */
  font-weight: 600;
}

/* Hover para el botón inactivo */
.inactive-btn:hover {
  opacity: 1; /* Opacidad total al pasar el ratón */
  background: #e5f1ff; /* Fondo azul claro al pasar el ratón */
  border-color: #0472cf; /* Borde azul al pasar el ratón */
  color: #0472cf; /* Texto azul al pasar el ratón */
}

.right .inactive-btn {
  background: rgba(255, 255, 255, 0.25);
  color: #fff;
}

.right .inactive-btn:hover {
  background: #fff;
  color: var(--blue);
  border-color: #fff;
}

.card-login.mozo-mode .right .inactive-btn {
  background: rgba(0, 0, 0, 0.08);
  color: var(--blue);
}

.card-login.mozo-mode .right .inactive-btn:hover {
  background: var(--blue);
  color: #fff;
  border-color: var(--blue);
}

form {
  width: 100%;
  max-width: 360px;
  display: flex;
  flex-direction: column;
  gap: 12px;
}

label {
  font-size: 13px;
  margin-bottom: 6px;
  opacity: .95;
  transition: color 0.6s ease;
}

input {
  padding: 12px 14px;
  border-radius: 999px;
  border: 1px solid rgba(0, 0, 0, 0.1);
  background: #fff;
  color: #000;
  font-size: 15px;
  transition: all 0.3s ease;
}

input:focus {
  border-color: var(--blue);
  box-shadow: 0 0 6px rgba(4, 114, 207, 0.5);
  outline: none;
}

/* Diseño del botón personalizado */
.btn-custom {
  background-color: #ef3f3f; /* Rojo pastel */
  border: 2px solid #ef3f3f; /* Borde del mismo color rojo pastel */
  color: white; /* Texto blanco */
  padding: 5px 10px; /* Espaciado del botón */
  border-radius: 25px; /* Bordes redondeados */
  font-size: 16px; /* Tamaño de texto */
  font-weight: bold; /* Texto en negrita */
  transition: all 0.3s ease; /* Transición suave para el cambio de color */
  cursor: pointer; /* Apunta a que es clickeable */
}

/* Efecto de resalte cuando se pasa el mouse (hover) */
.btn-custom:hover {
  background-color: #ef3f3f; /* Rojo más intenso al pasar el mouse */
  border: 2px solid #ef3f3f; /* Borde más intenso */
  transform: scale(1.05); /* Agrandar un poco el botón para el efecto */
}


.virtual-keyboard {
  margin-top: 12px;
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 10px;
  width: 100%;
}

.vk-btn {
  padding: 14px 0;
  font-size: 18px;
  border: 0;
  cursor: pointer;
  background: var(--blue);
  color: #fff;
  font-weight: 600;
  transition: background 0.3s;
}

.vk-btn:hover {
  background: #035aa0;
}

.vk-btn.del {
  background: #e74c3c;
}

.vk-btn.submit {
  background: var(--blue);
  color: #fff;
  font-weight: 700;
}

/* 📱 Responsive */
@media(max-width: 900px) {
  .card-login {
    flex-direction: column;
  }
  .left, .right {
    width: 100%;
    min-height: auto;
  }
  .switcher {
    flex-direction: column;
  }
  .switcher button {
    width: 100%;
  }
  .virtual-keyboard {
    grid-template-columns: repeat(3, 1fr);
  }
}

.mozo-input {
  width: 100%;
  text-align: center;
}

.mozo-input label {
  display: block;
  font-size: 14px;
  font-weight: 600;
  margin-bottom: 8px;
  color: inherit;
  text-align: center;
}

.mozo-input input {
  width: 100%;
  text-align: center;
  font-size: 20px;
  font-weight: 700;
  letter-spacing: 6px;
  padding: 14px;
  border-radius: 12px;
  border: 2px solid var(--blue);
  background: #fff;
  color: #000;
  box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
  transition: all 0.3s ease;
}

.mozo-input input:focus {
  border-color: var(--blue);
  box-shadow: 0 4px 14px rgba(4, 114, 207, 0.25);
}

.brand-title {
  font-size: 24px;
  font-weight: 700;
  margin: 0;
  transition: color 0.6s ease;
  color: #fff;
}

.card-login.mozo-mode .brand-title {
  color: var(--blue);
}

.form-group {
  position: relative;
}

/* Estilo para el contenedor de los inputs y los íconos */
.input-icon {
  position: relative; /* Para posicionar los íconos dentro del input */
  width: 100%;
  margin-bottom: 15px; /* Añadir espacio entre los campos de entrada */
}

/* Estilo para los inputs */
.input-icon input {
  width: 100%; /* Ancho completo */
  padding-left: 35px; /* Espacio para el ícono de usuario */
  padding-right: 35px; /* Espacio para el ícono de ojo */
  padding-top: 12px;
  padding-bottom: 12px;
  border-radius: 25px; /* Bordes redondeados */
  border: 2px solid #ccc; /* Borde gris claro */
  font-size: 16px; /* Tamaño de texto */
  margin-bottom: 10px; /* Espacio debajo de cada campo */
}

/* Estilo para los íconos */
.input-icon i {
  position: absolute;
  top: 40%;
  transform: translateY(-50%); /* Centra verticalmente el ícono */
  color: #6c757d; /* Color gris para los íconos */
  font-size: 18px;
  cursor: pointer;
}

/* Ícono de usuario en el lado izquierdo */
.input-icon .fa-user {
  left: 10px; /* Alineación a la izquierda */
}

/* Ícono de candado en el lado izquierdo */
.input-icon .fa-lock {
  left: 10px; /* Alineación a la izquierda */
}

/* Ícono de ojo en el lado derecho */
.input-icon .fa-eye, .input-icon .fa-eye-slash {
  right: 10px; /* Alineación a la derecha */
}

/* Estilo para el botón */
.btn-circle {
  border-radius: 50%;
  width: 50px;
  height: 50px;
  display: flex;
  justify-content: center;
  align-items: center;
  font-size: 24px;
  border: 3px solid white; /* Borde blanco siempre visible */
  box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.2); /* Sombra sutil para el efecto de relieve */
  transition: all 0.3s ease; /* Transición suave para el borde */
}


/* Borde de relieve blanco cuando está en "Ingreso Vendedor" */
.btn-vendedor-active {
  border: 3px solid white;
  box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.2); /* Sombra sutil para el efecto de relieve */
}
/* Estilo general para el span */
span {
  font-size: 16px; /* Tamaño del texto */
  margin-left: 10px; /* Espacio a la izquierda */
  font-weight: bold; /* Texto en negrita */
  color: #333; /* Color de texto por defecto */
  transition: color 0.3s ease; /* Transición suave en el color */
}

/* Cuando el fondo es azul grisáceo */
div.blue-background span {
  color: white; /* Texto blanco para fondo oscuro */
}

/* Efecto hover para resaltar el texto */
/* Estilo para el texto "Ingreso Vendedor" */
/* Estilo para el texto */
span {
  font-size: 16px;
  margin-left: 10px;
  font-weight: bold;
  color: #ffffff; /* Blanco para mayor contraste sobre el fondo azul */
  padding: 5px 10px; /* Espaciado alrededor del texto */
  border-radius: 5px; /* Bordes redondeados */
  text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3); /* Sombra para hacer el texto más legible */
  transition: all 0.3s ease; /* Transición suave para cambios */
}

/* Efecto hover para resaltar el texto */
span:hover {
  color: #4e73df; /* Azul al pasar el ratón para que resalte */
  background-color: white; /* Fondo blanco para resaltar más el texto */
  cursor: pointer; /* Cambiar a la mano cuando el ratón pasa por encima */
}

/* Si deseas mejorar la visibilidad general en el contenedor */
.container {
  background-color: #4e73df; /* Fondo azul */
  padding: 20px;
  border-radius: 10px;
  width: fit-content;
}

/* Estilo para el botón */
/* Estilo para los botones */
button {
  padding: 12px 20px; /* Ajustar espaciado del botón */
  border-radius: 25px; /* Bordes redondeados */
  font-size: 16px; /* Tamaño de texto */
  font-weight: bold; /* Texto en negrita */
  width: 100%; /* Asegura que el botón ocupe todo el ancho disponible */
  margin-bottom: 25px; /* Espaciado entre los botones */
  cursor: pointer;
  transition: all 0.3s ease; /* Transición suave para el cambio de color */
}

/* Estilo para el botón "Acceder" */
.btn-acceder {
  background-color: #ff9f9f; /* Rojo pastel */
  color: white; /* Texto blanco */
  border: none; /* Sin borde */
}

.btn-acceder:hover {
  background-color: #f76c6c; /* Rojo más intenso al pasar el ratón */
}

/* Estilo para el botón "Ingreso Vendedor" */
.btn-regular {
  background-color: #47b8e0; /* Azul claro */
  color: white;
  border: none;
}

.btn-regular:hover {
  background-color: #2497b7; /* Azul más intenso al pasar el ratón */
}

/* Ajustes para el contenedor de los botones */
.access-buttons {
  display: flex;
  flex-direction: column; /* Apilar los botones uno encima del otro */
  gap: 10px; /* Espacio entre los botones */
  width: 100%; /* Asegura que ocupe todo el ancho disponible */
  margin-top: 20px; /* Espacio superior */
}

/* 📱 Responsive */
@media(max-width: 900px) {
  .card-login {
    flex-direction: column;
  }
  .left, .right {
    width: 100%;
    min-height: auto;
  }
  .switcher {
    flex-direction: column;
  }
  .switcher button {
    width: 100%;
  }
  .virtual-keyboard {
    grid-template-columns: repeat(3, 1fr);
  }

  /* Ajustes para .art */
  .art {
    width: 80%;  /* Más pequeño para pantallas de tamaño medio */
    height: auto; /* Permitir que la altura se ajuste automáticamente para mantener la proporción */
    max-height: 140px;  /* Limitar la altura máxima de la imagen */
    margin: 0 auto;  /* Centra la imagen en la pantalla */
  }
}

@media (max-width: 480px) {
  .card-login {
    flex-direction: column;
  }
  .left, .right {
    width: 100%;
    min-height: auto;
  }
  .switcher {
    flex-direction: column;
  }
  .switcher button {
    width: 100%;
  }
  .virtual-keyboard {
    grid-template-columns: repeat(3, 1fr);
  }

  /* Ajustes para .art en pantallas pequeñas */
  .art {
    width: 90%;  /* Aumentamos el tamaño para pantallas muy pequeñas */
    max-height: 250px;  /* Reducir la altura máxima de la imagen */
    height: auto;  /* Ajustar la altura según la proporción de la imagen */
  }
}


.form-administrativo .form-group {
  margin-bottom: 0; /* Quita separación grande */
}

.form-administrativo .input-icon {
  position: relative;
  margin-bottom: 2px; /* Ajusta aquí la separación entre inputs */
}

.form-administrativo .input-icon input {
  width: 100%;
  padding: 10px 35px; /* espacio para íconos */
  border-radius: 20px;
  border: 1px solid #ccc;
  outline: none;
}

.form-mozo .form-group {
  margin-bottom: 2px; /* menos separación */
}

.form-mozo .form-group label {
  display: block;
  margin-bottom: 4px;
  font-weight: 600;
  font-size: 14px;
}

.form-mozo .input-icon {
  position: relative;
  margin-bottom: 6px;
}

.form-mozo .input-icon input {
  width: 100%;
  padding: 10px 35px;
  border-radius: 20px;
  border: 1px solid #ccc;
  outline: none;
  font-size: 14px;
}

/* Teclado virtual */
.virtual-keyboard {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 6px;
  margin-top: 10px;
}

/* Estilo base botones */
.virtual-keyboard .vk-btn {
  padding: 12px;
  font-size: 16px;
  border-radius: 12px;
  border: none;
  cursor: pointer;
  transition: transform 0.2s, background 0.2s;
  font-weight: bold;
}

/* Azul pastel para números */
.virtual-keyboard .vk-btn.num {
  background-color: #aecbfa;
  color: #1a237e;
}

.virtual-keyboard .vk-btn.num:hover {
  background-color: #90caf9;
  transform: scale(1.05);
}

/* Rojo pastel para SUPR */
.virtual-keyboard .vk-btn.del {
  background-color: #f8bbd0;
  color: #b71c1c;
}

.virtual-keyboard .vk-btn.del:hover {
  background-color: #f48fb1;
  transform: scale(1.05);
}

/* Amarillo pastel para OK */
.virtual-keyboard .vk-btn.submit {
  background-color: #fff59d;
  color: #5d4037;
}

.virtual-keyboard .vk-btn.submit:hover {
  background-color: #fff176;
  transform: scale(1.05);
}

.right .brand {
  margin-top: 15px;  /* separa hacia abajo */
}

.brand-title {
  font-size: 28px;   /* opcional, agranda el texto */
  font-weight: 700;
}


</style>

</head>
<body>

<div class="card-login">
  <div class="left">
    <div class="art"></div>
  </div>

  <div class="right">
    <div class="brand text-center mb-3">
  <h1 class="brand-title">Bienvenido!</h1>
</div>


  
   <!-- Formulario Administrativo -->
<div class="form-administrativo">
  <form id="frm-login-admin" method="post" autocomplete="off">
    <div class="form-group">
      <!-- Input para usuario -->
      <div class="input-icon">
        <i class="fas fa-user"></i> <!-- Ícono de usuario en el lado izquierdo -->
        <input type="text" id="f-user-admin" name="usuario" placeholder="Usuario">
      </div>

      <!-- Input para contraseña -->
      <div class="input-icon">
        <i class="fas fa-lock"></i> <!-- Ícono de candado en el lado izquierdo -->
        <input type="password" id="f-pass-admin" name="password" placeholder="Contraseña">
        <i class="fas fa-eye" id="togglePasswordAdmin"></i> <!-- Ícono de ojo en el lado derecho -->
      </div>
    </div>
    <button type="submit" class="btn-custom btn-primary-custom">Acceder</button>
  </form>
</div>


    <!-- Formulario Vendedor -->
    <div class="form-mozo" style="display:none">
      <form id="frm-login-mozo" method="post" autocomplete="off">
        <div class="form-group mozo-input">
  <label for="f-user-mozo">Código Vendedor</label>
  <div class="input-icon">
    <input type="password" id="f-user-mozo" name="usuario" placeholder="******" readonly>
    <i class="fa fa-eye" id="togglePasswordMozo"></i> <!-- Icono del ojo -->
  </div>
</div>

        <input type="hidden" id="f-pass-mozo" name="password">
        <div class="virtual-keyboard">
          <button type="button" class="vk-btn" data="1">1</button>
          <button type="button" class="vk-btn" data="2">2</button>
          <button type="button" class="vk-btn" data="3">3</button>
          <button type="button" class="vk-btn" data="4">4</button>
          <button type="button" class="vk-btn" data="5">5</button>
          <button type="button" class="vk-btn" data="6">6</button>
          <button type="button" class="vk-btn" data="7">7</button>
          <button type="button" class="vk-btn" data="8">8</button>
          <button type="button" class="vk-btn" data="9">9</button>
          <button type="button" class="vk-btn del" data="DEL">SUPR</button>
          <button type="button" class="vk-btn" data="0">0</button>
          <button type="submit" class="vk-btn submit" data="">OK</button>
        </div>
      </form>
    </div>

    <!-- Botón de alternancia -->
   <div class="access-button">
  <!-- Botón estilo rectangular -->
  <button type="button" id="btn-toggle" class="btn-regular">
    Ingreso Vendedor
  </button>
 
</div>
</div>

<script>
  $(function() {
    // === Cambiar de formulario entre Admin y Mozo ===
    $('#btn-toggle').on('click', function() {
      if ($('.form-administrativo').is(':visible')) {
        $('.form-administrativo').hide();
        $('.form-mozo').show();
        $(this).html('Ingreso Administrativo');
      } else {
        $('.form-administrativo').show();
        $('.form-mozo').hide();
        $(this).html('Ingreso Vendedor');
      }
      $('#btn-toggle').toggleClass('active-btn inactive-btn');
      $('.card-login').toggleClass('mozo-mode');
    });

    // === Cambio de foco al presionar Enter en el campo de usuario ===
    $('#f-user-admin').on('keypress', function(event) {
      if (event.key === 'Enter') {
        event.preventDefault();  // Prevenir el envío del formulario
        $('#f-pass-admin').focus();  // Mover al campo de contraseña
      }
    });

    // === Enviar formulario al presionar Enter en el campo de contraseña ===
    $('#f-pass-admin').on('keypress', function(event) {
      if (event.key === 'Enter') {
        $('#frm-login-admin').submit();  // Enviar el formulario
      }
    });

    // === Validación y Ajax para Admin ===
    $('#frm-login-admin').on('submit', function(e) {
      e.preventDefault();
      var parametros = new FormData(this);
      $.ajax({
        type: 'POST',
        dataType: 'JSON',
        data: parametros,
        url: 'login/run',
        contentType: false,
        processData: false,
      }).done(function(response) {
        if (response == 1) { window.open('tablero', '_self'); }
        else if (response == 2) { window.open('produccion', '_self'); }
        else if (response == 3) { window.open('venta', '_self'); }
        else if (response == 7) { window.open('contable', '_self'); }
        else {
          $.toast({heading: 'Acceso denegado!', text: 'Datos erróneos.', position: 'top-right', icon: 'error'});
        }
      }).fail(function() {
        Swal.fire('Oops...', 'Problemas con la conexión!', 'error');
      });
    });

    // === Validación y Ajax para Mozo ===
    $('#frm-login-mozo').on('submit', function(e) {
      e.preventDefault();
      var parametros = new FormData(this);
      $.ajax({
        type: 'POST',
        dataType: 'JSON',
        data: parametros,
        url: 'login/run',
        contentType: false,
        processData: false,
      }).done(function(response) {
        if (response == 3) { window.open('venta', '_self'); }
        else {
          $.toast({heading: 'Acceso denegado!', text: 'Código erróneo.', position: 'top-right', icon: 'error'});
        }
      }).fail(function() {
        Swal.fire('Oops...', 'Problemas con la conexión!', 'error');
      });
    });

    // === Teclado virtual ===
    $(".virtual-keyboard button").on('click', function() {
      let data = $(this).attr('data');
      let inputUser = $('#f-user-mozo');
      let inputPass = $('#f-pass-mozo');
      if (data == 'DEL') {
        let val = inputUser.val();
        val = val.substring(0, val.length - 1);
        inputUser.val(val);
        inputPass.val(val);
      } else if (data !== "") {
        inputUser.val(inputUser.val() + data);
        inputPass.val(inputPass.val() + data);
      }
    });

   $('#togglePasswordAdmin').on('click', function() {
  const input = $('#f-pass-admin')[0];
  input.type = input.type === 'password' ? 'text' : 'password';
  $(this).toggleClass('fa-eye fa-eye-slash');
});

$('#togglePasswordMozo').on('click', function() {
  const input = $('#f-user-mozo')[0];
  input.type = input.type === 'password' ? 'text' : 'password';
  $(this).toggleClass('fa-eye fa-eye-slash');
});


  });
</script>
</body>
</html>
