<?php
require_once ('public/lib/pdf/cellfit.php');

class FPDF_CellFiti extends FPDF_CellFit
{
	function AutoPrint($dialog=false)
	{
		//Open the print dialog or start printing immediately on the standard printer
		$param=($dialog ? 'true' : 'false');
		$script="print($param);";
		$this->IncludeJS($script);
	}

	function AutoPrintToPrinter($server, $printer, $dialog=false)
	{
		//Print on a shared printer (requires at least Acrobat 6)
		$script = "var pp = getPrintParams();";
		if($dialog)
			$script .= "pp.interactive = pp.constants.interactionLevel.full;";
		else
			$script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
		$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
		$script .= "print(pp);";
		$this->IncludeJS($script);
	}
}
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
// print_r($this->dato);
define('EURO',chr(128));
$pdf = new FPDF_CellFiti('P','mm',array(80,200));
$pdf->AddPage();
$pdf->SetMargins(0,0,0,0);
 
// CABECERA
$pdf->SetFont('Helvetica','',6);
$pdf->Cell(72,4,'',0,1,'C');
$pdf->SetFont('Helvetica','B',13);
$pdf->Cell(72,4,'STOCK DE INVENTARIO',0,1,'C');
$pdf->Ln(3);
$pdf->SetFont('Helvetica','',9);
$pdf->Cell(72,4,'USUARIO: '.utf8_decode(Session::get('nombres').' '.Session::get('apellidos')),0,1,'L');
$pdf->Cell(72,4,'FECHA: '.date('d-m-Y h:i A'),0,1,'L');

// COLUMNAS
$pdf->SetFont('Helvetica', 'B', 9);
$pdf->Cell(30, 10, 'CATEGORIA', 0);
$pdf->Cell(30, 10, 'PRODUCTO', 0);
$pdf->Cell(15, 10, 'STOCK.',0,0,'R');
$pdf->Ln(8);
$pdf->Cell(72,0,'','T');
$pdf->Ln(2);

foreach($this->dato as $d){
$pdf->SetFont('Helvetica', '', 8);
$pdf->MultiCell(55,4,utf8_decode($d->Producto->ins_cat).' - '.utf8_decode($d->Producto->ins_nom),0,'L'); 
// stock_real = data.ent-data.sal;
$pdf->Cell(72, -4, number_format(($d->ent-$d->sal),2),0,0,'R');
$pdf->Ln(1);
$pdf->Cell(72, 4, '-----------------------------------------------------------------------',0,0,'C');
$pdf->Ln(4);

}
// $pdf->SetFont('Helvetica', 'B', 10);
// $pdf->Cell(72,0,'','T');
// $pdf->Ln(1);
// $pdf->Cell(37, 10, 'TOTAL', 0);    
// $pdf->Cell(20, 10, '', 0);
// $pdf->Cell(15, 10, number_format(($total),2),0,0,'R');
 
// PIE DE PAGINA
$pdf->Ln(10);
$pdf->Output('ticket.pdf','i');
?>