$(function() {
    $('#informes').addClass("active");
    moment.locale('es');
    listar();

    $('#start').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#start, #end, #filtro_tipo_entrega, #filtro_repartidor, #estado').change( function() {
        listar();
    });

    $('.scroll_detalle').slimscroll({
        height: '100%'
    });
    var scroll_detalle = function () {
        var topOffset = 400;
        var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
        height = height - topOffset;
        $(".scroll_detalle").css("height", (height) + "px");
    };
    $(window).ready(scroll_detalle);
    $(window).on("resize", scroll_detalle);
    /* BOTON DATATABLES */
    var org_buildButton = $.fn.DataTable.Buttons.prototype._buildButton;
    $.fn.DataTable.Buttons.prototype._buildButton = function(config, collectionButton) {
    var button = org_buildButton.apply(this, arguments);
    $(document).one('init.dt', function(e, settings, json) {
        if (config.container && $(config.container).length) {
           $(button.inserter[0]).detach().appendTo(config.container)
        }
    })    
    return button;
    }

});
const StateType = {
    '11': 'danger',
    '13': 'warning',
    '01': 'secondary',
    '03': 'info',
    '05': 'success',
    '07': 'secondary',
    '09': 'dark'
};

var listar = function(){

    var moneda = $("#moneda").val();
    ifecha = $("#start").val();
    ffecha = $("#end").val();
    tipo_entrega = $('#filtro_tipo_entrega').selectpicker('val');
    id_repartidor = $('#filtro_repartidor').selectpicker('val');
    estado = $('#estado').selectpicker('val');
   

    var table = $('#table')
    .DataTable({
        buttons: [
            {
                extend: 'excel', sheetName: 'Fechas ' +  $('#start').val() + ' al ' + $('#end').val(), title: 'Reporte de ventas por delivery', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-excel"></i> Descargar en excel', titleAttr: 'Descargar Excel',
                container: '#excel', exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11] }
            },
            {
                extend: 'pdf', title: 'Reporte de ventas por delivery', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-pdf"></i> Descargar en pdf', titleAttr: 'Descargar Pdf',
                container: '#pdf', exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11] }, orientation: 'landscape'
            }
        ],
        "destroy": true,
        "responsive": true,
        "dom": "tip",
        "bSort": true,
        "order": [[0,"desc"]],
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"informe/venta_delivery_list",
            "data": {
                ifecha: ifecha,
                ffecha: ffecha,
                tipo_entrega: tipo_entrega,
                id_repartidor: id_repartidor,
                estado: estado
            }
        },
        "columns":[
            {"data":"fec_ven","render": function ( data, type, row ) {
                return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {"data":"Caja.desc_caja","render": function ( data, type, row ) {
                return '<div class="mayus">'+data+'</div>';
            }},
            {"data":"Cliente.nombre","render": function ( data, type, row ) {
                return '<div class="mayus">'+data+'</div>';
            }},
            {"data":"telefono_cliente","render": function ( data, type, row ) {
                return '<div class="mayus">'+data+'</div>';
            }},            
            {"data":null,"render": function ( data, type, row ) {
                return '<div class="mayus">'+data.desc_repartidor+'</div>';  
                /*
                if(data.id_repartidor == 2222){
                    return '<div class="mayus">RAPPI</div>';
                } else if(data.id_repartidor == 3333){
                    return '<div class="mayus">UBER</div>';
                } else if(data.id_repartidor == 4444){
                    return '<div class="mayus">GLOVO</div>';
                } else {
                    return '<div class="mayus">'+data.desc_repartidor+'</div>';                    
                }
                */
            }},
            {
                "data": null,
                "render": function ( data, type, row) {
                    return data.desc_td+'<br><span class="font-12">'+data.ser_doc+' - Nro.'+data.nro_doc+'</span>';
                }
            },
            {
                "data": null,
                "render": function ( data, type, row ) {
                    if(data.tipo_entrega == 1){
                        return '<div class="text-center"><span class="label label-primary">A DOMICILIO</span></div>';
                    } else if(data.tipo_entrega == 2){
                        return '<div class="text-center"><span class="label label-inverse">POR RECOGER</span></div>';
                    }
                }
            },
            {"data":"comis_del","render": function ( data, type, row) {
                return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
            }},
            {"data":"comis_tar","render": function ( data, type, row) {
                        return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
                    }},            
            {"data":"total","render": function ( data, type, row) {
                return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
            }},
            {"data":"monto_total","render": function ( data, type, row) {
                return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
            }},
            {"data": null,
                "render": function ( data, type, row ) {
                    bgArray = StateType[data.State.id];
                    return '<div class="text-center"><span class="p-10 badge badge-'+bgArray+'">'+data.State.descripcion+'</span></div>';
            }}, 
            {"data":null,"render": function ( data, type, row ) {
                return '<div class="text-right"><div class="btn-group">'
                    +'<a href="javascript::void(0)" class="text-dark" id="new" data-toggle="dropdown" aria-expanded="false"><i data-feather="more-vertical" class="feather-sm"></i></a>'
                        +'<div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -197px, 0px); top: 0px; left: 0px; will-change: transform;">'
                            +'<a class="dropdown-item" href="javascript:void(0)" onclick="detalle('+data.id_ven+',\''+data.desc_td+'\',\''+data.ser_doc+'-'+data.nro_doc+'\')"><i data-feather="eye" class="feather-sm fill-white"></i> Detalle</a>'
                            +'<a class="dropdown-item" href="'+$("#url").val()+'informe/venta_all_imp/'+data.id_ven+'" target="_blank"><i data-feather="printer" class="feather-sm fill-white"></i> Imprimir</a>'
                        +'</div>'
                    +'</div></div>';
            }}
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            total_comision = api
            .column( 7 /*, { search: 'applied', page: 'current'} */)
            .data()
            .reduce( function (a, b) {
                return intVal(a) + intVal(b);
            }, 0 );
            total_comision_tar = api
            .column( 8 /*, { search: 'applied', page: 'current'} */)
            .data()
            .reduce( function (a, b) {
                return intVal(a) + intVal(b);
            }, 0 );
            total = api
            .column( 9 /*, { search: 'applied', page: 'current'} */)
            .data()
            .reduce( function (a, b) {
                return intVal(a) + intVal(b);
            }, 0 );
            total_monto = api
            .column( 10 /*, { search: 'applied', page: 'current'} */)
            .data()
            .reduce( function (a, b) {
                return intVal(a) + intVal(b);
            }, 0 );

            operaciones = api
                .rows()
                .data()
                .count();

            $('.ventas-total').text(moneda+' '+formatNumber(total));
            $('.ventas-total2').text(moneda+' '+formatNumber(total_monto));
            $('.ventas-comision').text(moneda+' '+formatNumber(total_comision));
            $('.ventas-comision_tar').text(moneda+' '+formatNumber(total_comision_tar));
            $('.ventas-operaciones').text(operaciones);
        }
    });

    $('#table').DataTable().on("draw", function(){
        feather.replace();
    });
};

var detalle = function(id_venta,doc,num){
    var moneda = $("#moneda").val();
    var totalconsumido = 0,
        totalcomision = 0,
        totaldescuento = 0;
    $('#lista_pedidos').empty();
    $('#detalle').modal('show');
    $('.title-d').text(doc+' - '+num);
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_venta: id_venta
      },
      url: $('#url').val()+'informe/venta_all_det',
      success: function (data){
        $.each(data, function(i, item) {
            var calc = item.precio * item.cantidad;
            $('#lista_pedidos')
            .append(
              $('<tr/>')
                .append($('<td width="10%"/>').html(item.cantidad))
                .append($('<td width="60%"/>').html(item.Producto.pro_cat+' <span class="label label-warning">'+item.Producto.nom_pro_pre+'</span>'))
                .append($('<td width="15%"/>').html(moneda+' '+formatNumber(item.precio)))
                .append($('<td width="15%" class="text-right"/>').html(moneda+' '+formatNumber(calc)))
                );
            totalconsumido += calc;
            totalcomision = item.Comision.total;
            totaldescuento = item.Descuento.total;
            });
            
            $('.total-consumido').text(moneda+' '+formatNumber(totalconsumido));
            $('.total-descuento').text(moneda+' '+totaldescuento);
            $('.total-facturado').text(moneda+' '+formatNumber(totalconsumido-totaldescuento));
        }
    });
};