$(function() {
    $('#informes').addClass("active");
    moment.locale('es');
    listar();

    $('#start').bootstrapMaterialDatePicker({   
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#start, #end, #tipo_ped, #tipo_doc,#tipo_zona_mesas, #estado, #cliente').change( function() {
        $(".zonas_mesas").hide();
        if($('#tipo_ped').val() == 1){
            $(".zonas_mesas").show();
        }
        if (($('#tipo_ped').val() != 1 || $('#tipo_ped').val() == '%') && $('#tipo_ped').val() != '%') {
            $('#tipo_zona_mesas').selectpicker('val', '%');
        }
        listar();
    });

    $('.scroll_detalle').slimscroll({
        height: '100%'
    });
    var scroll_detalle = function () {
        var topOffset = 405;
        var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
        height = height - topOffset;
        $(".scroll_detalle").css("height", (height) + "px");
    };
    $(window).ready(scroll_detalle);
    $(window).on("resize", scroll_detalle);

    /* BOTON DATATABLES */
    var org_buildButton = $.fn.DataTable.Buttons.prototype._buildButton;
    $.fn.DataTable.Buttons.prototype._buildButton = function(config, collectionButton) {
    var button = org_buildButton.apply(this, arguments);
    $(document).one('init.dt', function(e, settings, json) {
        if (config.container && $(config.container).length) {
           $(button.inserter[0]).detach().appendTo(config.container)
        }
    })    
    return button;
    }

});
const StateType = {
    '11': 'danger',
    '13': 'warning',
    '01': 'secondary',
    '03': 'info',
    '05': 'success',
    '07': 'secondary',
    '09': 'dark'
};

var listar = function(){

    var moneda = $("#moneda").val();
    ifecha = $("#start").val();
    ffecha = $("#end").val();
    tped = $("#tipo_ped").selectpicker('val');
    tdoc = $("#tipo_doc").selectpicker('val');
    estado = $('#estado').selectpicker('val');
    cliente = $('#cliente').selectpicker('val');
    tipo_zona_mesas = $("#tipo_zona_mesas").selectpicker('val');


    var total_ope = 0,
    total_del = 0,
    total_rc = 0,
    total_tar = 0,
    total_total = 0,
    total_total2 = 0;

    $('.forma-de-pago').style

    $.ajax({
        type: "POST",
        url: $('#url').val()+"informe/venta_all_list",
        data: {
            ifecha: ifecha,
            ffecha: ffecha,
            tped: tped,
            tdoc: tdoc,
            estado: estado,
            cliente: cliente,
            id_salon:tipo_zona_mesas
        },
        dataType: "json",
        success: function(item){
            
            if (item.data.length != 0) {
                $.each(item.data, function(i, campo) {
                    total_ope++;
                    total_del  = total_del + parseFloat(campo.comis_del);
                    total_tar  = total_tar + parseFloat(campo.comis_tar);
                    total_total  = total_total + parseFloat(campo.total);
                    total_total2  = total_total2 + parseFloat(campo.monto_total);
                    total_rc  = total_rc + parseFloat(campo.comis_rc);
                   
                });
            }
            $('.ventas-operaciones').text(total_ope);
            $('.ventas-comis_del').text((total_del).toFixed(2));
            $('.ventas-rc').text((total_rc).toFixed(2));
            $('.ventas-comis_tar').text((total_tar).toFixed(2));
            $('.ventas-total').text((total_total).toFixed(2));
            $('.ventas-total2').text((total_total2).toFixed(2));
        }
    });



    var table = $('#table')
    .DataTable({
        buttons: [
            {
                extend: 'excel', sheetName: 'Fechas ' +  $('#start').val() + ' al ' + $('#end').val(), title: 'Reporte de ventas', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-excel"></i> Descargar en excel', titleAttr: 'Descargar Excel',
                container: '#excel', exportOptions: {  columns: ':visible' }
            },
            {
                extend: 'pdf', title: 'Reporte de ventas', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-pdf"></i> Descargar en pdf', titleAttr: 'Descargar Pdf',
                container: '#pdf', exportOptions: {  columns: ':visible' }, orientation: 'landscape'
            }
        ],
        "destroy": true,
        "responsive": true,
        "dom": "tip",
        "bSort": true,
        "order": [[0,"desc"]],
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"informe/venta_all_list",
            "data": {
                ifecha: ifecha,
                ffecha: ffecha,
                tped: tped,
                tdoc: tdoc,
                estado: estado,
                cliente: cliente,
                id_salon:tipo_zona_mesas
            }
        },
        "columns":[
            {"data":"fec_ven","render": function ( data, type, row ) {
                return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                var tooltip = ' <i class="ti-info-alt text-warning font-10" data-original-title="COD: 0'+data.id_apc+'" data-toggle="tooltip" data-placement="top"></i>';
                return (data.desc_caja).toUpperCase()+tooltip;
            }},
            {"data":null,"render": function ( data, type, row ) {
                if(data.Cliente.tipo_cliente == 1){
                    return (data.Cliente.nombre).toUpperCase()
                    +'<br><span class="font-12"> '+$('#diAcr').val()+': '+data.Cliente.dni+'</span>';
                } else if(data.Cliente.tipo_cliente == 2){
                    return (data.Cliente.nombre).toUpperCase()
                    +'<br><span class="font-12"> '+$('#tribAcr').val()+': '+data.Cliente.ruc+'</span>';
                }
            }},
            {"data":null,"render": function ( data, type, row ) {
                if(data.desc_tipo == 1){
                    var tooltip = ' <i class="ti-info-alt text-warning font-10" data-original-title="Cortesia" data-toggle="tooltip" data-placement="top"></i>';
                } else if(data.desc_tipo == 3){
                    var tooltip = ' <i class="ti-info-alt text-warning font-10" data-original-title="Credito Personal: '+data.Personal.nombres+'" data-toggle="tooltip" data-placement="top"></i>';
                } else {
                    var tooltip = '';
                }
                return data.desc_td
                +'<br><span class="font-12">'+data.ser_doc+'-'+data.nro_doc+'</span>'+tooltip;
            }},
            {"data":null,"render": function ( data, type, row ) {
                if(data.id_tped == 1){
                    return 'ZONA'
                    +'<br><span class="font-12">'+data.Pedido.desc_salon+' - Mesa: '+data.Pedido.nro_mesa+'</span>';
                } else if(data.id_tped == 2){
                   return 'MOSTRADOR';
                } else {
                    return 'DELIVERY';
                }
            }},
            {"data": null,
                "render": function(data, type, row){
                    if(data.desc_tipo == 1){
                        var tooltip = "<span class='label label-success' style='background: #ff951b'>Cortesia</span>";
                    } else if(data.desc_tipo == 3){
                        var tooltip = "<span class='label label-success' style='background: #a51bff'>Credito Personal</span>";
                    } else {
                        var tooltip = '';
                    }
                    var blkstr = []; 
                    $.each(data['Tipopago'], function(i,dato) { 
                        var str = "<span class='label label-success' style='background: "+dato.color+"'>" + dato.nombre + "</span>"; 
                        blkstr.push(str); 
                    });
                    return blkstr + tooltip;
                }
            },
            {"data":"comis_del","render": function ( data, type, row) {
                return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
            }},
            {"data":"comis_tar","render": function ( data, type, row) {
                return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
            }},
            {"data":"comis_rc","render": function ( data, type, row) {
                        return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
                    }},
            {"data":"total","render": function ( data, type, row) {
                return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
            }},
            {"data":"monto_total","render": function ( data, type, row) {
                        return '<div class="text-right bold m-b-0"> '+moneda+' '+formatNumber(data)+'</div>';
                    }},
            {"data": null,"render": function ( data, type, row ) {
                    bgArray = StateType[data.State.id];
                    return '<div class="text-center"><span class="p-10 badge badge-'+bgArray+'">'+data.State.descripcion+'</span></div>';
            }}, 
            {"data": null,
            "render": function ( data, type, row ) {
                return data.motivo_anulacion;
            }},             
            {"data":null,"render": function ( data, type, row ) {
                return '<div class="dropdown-action text-right"><div class="dropdown todo-action-dropdown">'
                    +'<a href="javascript::void(0)" class="btn btn-outline-primary dropdown-toggle text-decoration-none todo-action-dropdown custom-rounded" id="new" data-toggle="dropdown" aria-expanded="false"><i class="icon-options-vertical"></i></a>'
                        +'<div class="dropdown-menu dropdown-menu-right" aria-labelledby="more-action-3" style="">'
                            +'<a class="dropdown-item" href="javascript:void(0)" onclick="detalle('+data.id_ven+',\''+data.desc_td+'\',\''+data.ser_doc+'-'+data.nro_doc+'\')"><i data-feather="eye" class="feather-sm fill-white"></i> Detalle</a>'
                            +'<a class="dropdown-item" href="'+$("#url").val()+'informe/venta_all_imp/'+data.id_ven+'" target="_blank"><i data-feather="printer" class="feather-sm fill-white"></i> Imprimir</a>'
                        +'</div>'
                    +'</div></div>';
            }}
        ],
        "columnDefs": [
            {
                "targets": [ 6 ],
                "visible": false
            },
            {
                "targets": [ 7 ],
                "visible": false
            },
            {
                "targets": [ 8 ],
                "visible": false
            },
            {
                "targets": [ 9 ],
                "visible": false
            },
            {
                "targets": [ 12 ],
                "visible": false
            },
        ]        
    });
    $('body').tooltip({selector: '[data-toggle="tooltip"]'});    
    $('#table').DataTable().on("draw", function(){
        feather.replace();
    });
    $('a.toggle-vis').on( 'click', function (e) {
        e.preventDefault();
        var column = table.column( $(this).attr('data-column') );
        column.visible( ! column.visible() );
    });
};

var detalle = function(id_venta,doc,num){
    var moneda = $("#moneda").val();
    var totalconsumido = 0,
        totalcomision = 0,
        totaldescuento = 0;
    $('#lista_pedidos').empty();
    $('#detalle').modal('show');
    $('.title-detalle').text(doc+': '+num);
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_venta: id_venta
      },
      url: $('#url').val()+'informe/venta_all_det',
      success: function (data){
        $.each(data, function(i, item) {
            var calc = item.precio * item.cantidad;
            $('#lista_pedidos')
            .append(
              $('<tr/>')
                .append($('<td width="10%"/>').html(item.cantidad))
                .append($('<td width="60%"/>').html(item.Producto.pro_cat+' <span class="label label-warning">'+item.Producto.nom_pro_pre+'</span>'))
                .append($('<td width="15%"/>').html(moneda+' '+formatNumber(item.precio)))
                .append($('<td width="15%" class="text-right"/>').html(moneda+' '+formatNumber(calc)))
                );
            totalconsumido += calc;
            totalcomision = item.Comision.total;
            totaldescuento = item.Descuento.total;
            });
            
            $('.total-consumido').text(moneda+' '+formatNumber(totalconsumido));
            $('.total-comision').text(moneda+' '+totalcomision);
            $('.total-descuento').text(moneda+' '+totaldescuento);
            $('.total-facturado').text(moneda+' '+formatNumber(parseFloat(totalconsumido)+parseFloat(totalcomision)-parseFloat(totaldescuento)));
        }
    });
};