$(function() {
    $('#informes').addClass("active");
    moment.locale('es');
    listar();
    
    $('#start').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#start, #end, #filtro_cajero').change( function() {
        listar();
    });
});


//AQUI NUEVO AJUSTE PARA QUE MUESTRE EL LISTADO DE CAJAS EN BASE AL ROL Y EL ID DEL USUARIO:
var id_usu_actual = $('#id_usu_actual').val();
var id_rol_actual = $('#id_rol_actual').val();

if (id_rol_actual == 3) {
    console.log("hola soy cajero");
    var listar = function(){
    
        var moneda = $("#moneda").val();
        ifecha = $("#start").val();
        ffecha = $("#end").val();
        id_usu = $('#filtro_cajero').selectpicker('val');
    
        function filterGlobal () {
            $('#table').DataTable().search( 
                $('#global_filter').val()
            ).draw();
        }
    
        var table = $('#table')
        .DataTable({
            "destroy": true,
            "responsive": true,
            "dom": "tip",
            "bSort": true,
            "order": [[1,"desc"]],
            "ajax":{
                "method": "POST",
                "url": $('#url').val()+"informe/finanza_arq_list",
                "data": {
                    ifecha: ifecha,
                    ffecha: ffecha,
                    id_usu: id_usu_actual
                }
            },
            "columns":[
                {
                    "data": "id_apc",
                    "render": function ( data, type, row ) {
                        return 'COD0'+data;
                    }
                },
                {"data":"fecha_aper","render": function ( data, type, row ) {
                    return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                    +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
                }},
                {"data":null,"render": function ( data, type, row ) {
                    if(data.estado == 'a'){
                        return '-';
                    } else if(data.estado == 'c'){
                        return '<i class="ti-calendar"></i> '+moment(data.fecha_cierre).format('DD-MM-Y')
                    +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data.fecha_cierre).format('h:mm A')+'</span>';
                    }
                }},
                {"data": "desc_per"},
                {"data": "desc_caja"},
                {"data": "desc_turno"},
                {"data": "monto_aper"},
                {"data": "monto_sistema"},
                {
                    "data": null,
                    "render": function ( data, type, row ) {
                        if(data.estado == 'a'){
                            return '<div class="text-center"><span class="label label-success custom-rounded">APERTURADO</span></div>';
                        } else if(data.estado == 'c'){
                            return '<div class="text-center"><span class="label label-danger custom-rounded">CERRADO</span></div>';
                        }
                    }
                },
                {"data":null,"render": function ( data, type, row ) {
                    var botonimprimir = '<a class="important dropdown-item" href="'+$("#url").val()+'informe/finanza_arq_imp/'+data.id_apc+'" target="_blank"><i data-feather="printer" class="feather-sm fill-white"></i> Imprimir Caja</a>';
                    if($("#caja_prod_sep").val() == 1){
                        botonimprimir +='<a class="important dropdown-item" href="'+$("#url").val()+'informe/finanza_arq_imp/'+data.id_apc+'/productos" target="_blank"><i data-feather="archive" class="feather-sm fill-white"></i> Imp. Productos Vendidos</a>';
                    }
                    
                    //var botonimprimirGastos = '<a class="important dropdown-item" href="'+$("#url").val()+'informe/finanza_arq_imp/'+data.id_apc+'/gastos" target="_blank"><i data-feather="list" class="feather-sm fill-white"></i> Imprimir Gastos</a>';
    
                    return '<div class="dropdown-action text-right"><div class="dropdown todo-action-dropdown">'
                        +'<a href="javascript::void(0)" class="btn btn-outline-primary dropdown-toggle text-decoration-none todo-action-dropdown custom-rounded" id="new" data-toggle="dropdown" aria-expanded="false"><i class="icon-options-vertical"></i></a>'
                            +'<div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -197px, 0px); top: 0px; left: 0px; will-change: transform;">'
                                +'<a class="dropdown-item" href="'+$('#url').val()+'informe/finanza_arq_resumen/'+data.id_apc+'"><i data-feather="eye" class="feather-sm fill-white"></i> Detalle</a>'
                                +botonimprimir     
                                //+botonimprimirGastos
                                +'</div>'
                        +'</div></div>';
                }}
            ],
            "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;
    
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
     
                total = api
                    .column( 7 /*, { search: 'applied', page: 'current'} */)
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
    
                operaciones = api
                    .rows()
                    .data()
                    .count();
    
                $('.ingresos-total').text(moneda+' '+formatNumber(total));
                $('.ingresos-operaciones').text(operaciones);
            }
        });
    
        $('input.global_filter').on( 'keyup click', function () {
            filterGlobal();
        });
    
        $('#table').DataTable().on("draw", function(){
            feather.replace();
        });
    };
    
} else if (id_rol_actual == 1 || id_rol_actual == 2) {
    var listar = function(){
    
        var moneda = $("#moneda").val();
        ifecha = $("#start").val();
        ffecha = $("#end").val();
        id_usu = $('#filtro_cajero').selectpicker('val');
    
        function filterGlobal () {
            $('#table').DataTable().search( 
                $('#global_filter').val()
            ).draw();
        }
    
        var table = $('#table')
        .DataTable({
            "destroy": true,
            "responsive": true,
            "dom": "tip",
            "bSort": true,
            "order": [[1,"desc"]],
            "ajax":{
                "method": "POST",
                "url": $('#url').val()+"informe/finanza_arq_list",
                "data": {
                    ifecha: ifecha,
                    ffecha: ffecha,
                    id_usu: id_usu
                }
            },
            "columns":[
                {
                    "data": "id_apc",
                    "render": function ( data, type, row ) {
                        return 'COD0'+data;
                    }
                },
                {"data":"fecha_aper","render": function ( data, type, row ) {
                    return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                    +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
                }},
                {"data":null,"render": function ( data, type, row ) {
                    if(data.estado == 'a'){
                        return '-';
                    } else if(data.estado == 'c'){
                        return '<i class="ti-calendar"></i> '+moment(data.fecha_cierre).format('DD-MM-Y')
                    +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data.fecha_cierre).format('h:mm A')+'</span>';
                    }
                }},
                {"data": "desc_per"},
                {"data": "desc_caja"},
                {"data": "desc_turno"},
                {"data": "monto_aper"},
                {"data": "monto_sistema"},
                {
                    "data": null,
                    "render": function ( data, type, row ) {
                        if(data.estado == 'a'){
                            return '<div class="text-center"><span class="label label-success custom-rounded">APERTURADO</span></div>';
                        } else if(data.estado == 'c'){
                            return '<div class="text-center"><span class="label label-danger custom-rounded">CERRADO</span></div>';
                        }
                    }
                },
                {"data":null,"render": function ( data, type, row ) {
                    var botonimprimir = '<a class="important dropdown-item" href="'+$("#url").val()+'informe/finanza_arq_imp/'+data.id_apc+'" target="_blank"><i data-feather="printer" class="feather-sm fill-white"></i> Imprimir Caja</a>';
                    if($("#caja_prod_sep").val() == 1){
                        botonimprimir +='<a class="important dropdown-item" href="'+$("#url").val()+'informe/finanza_arq_imp/'+data.id_apc+'/productos" target="_blank"><i data-feather="archive" class="feather-sm fill-white"></i> Imp. Productos Vendidos</a>';
                    }
                    
                    //var botonimprimirGastos = '<a class="important dropdown-item" href="'+$("#url").val()+'informe/finanza_arq_imp/'+data.id_apc+'/gastos" target="_blank"><i data-feather="list" class="feather-sm fill-white"></i> Imprimir Gastos</a>';
    
                    return '<div class="dropdown-action text-right"><div class="dropdown todo-action-dropdown">'
                        +'<a href="javascript::void(0)" class="btn btn-outline-primary dropdown-toggle text-decoration-none todo-action-dropdown custom-rounded" id="new" data-toggle="dropdown" aria-expanded="false"><i class="icon-options-vertical"></i></a>'
                            +'<div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -197px, 0px); top: 0px; left: 0px; will-change: transform;">'
                                +'<a class="dropdown-item" href="'+$('#url').val()+'informe/finanza_arq_resumen/'+data.id_apc+'"><i data-feather="eye" class="feather-sm fill-white"></i> Detalle</a>'
                                +botonimprimir     
                                //+botonimprimirGastos
                                +'</div>'
                        +'</div></div>';
                }}
            ],
            "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;
    
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
     
                total = api
                    .column( 7 /*, { search: 'applied', page: 'current'} */)
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
    
                operaciones = api
                    .rows()
                    .data()
                    .count();
    
                $('.ingresos-total').text(moneda+' '+formatNumber(total));
                $('.ingresos-operaciones').text(operaciones);
            }
        });
    
        $('input.global_filter').on( 'keyup click', function () {
            filterGlobal();
        });
    
        $('#table').DataTable().on("draw", function(){
            feather.replace();
        });
    };
}