<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h4 class="m-b-0 m-t-0">Facturación Electrónica</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>" class="link">Inicio</a></li>
            <li class="breadcrumb-item active">Documentos Electrónicos</li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Documentos Electrónicos</h4>
                <h6 class="card-subtitle">Gestiona y envía tus documentos de facturación electrónica a facturafacil</h6>
                
                <!-- Envío automático: switch que guarda en BD -->
                <div class="row m-t-20 p-3 bg-light rounded">
                    <div class="col-12">
                        <label class="font-medium">Envío automático de documentos pendientes</label>
                        <p class="text-muted m-b-5 font-13">Si está activado, mientras tengas la web abierta se enviarán automáticamente cada pocos minutos los documentos con estado &quot;Pendiente&quot; a facturafacil (no hace falta configurar cron).</p>
                        <div class="d-flex align-items-center flex-wrap">
                            <label for="switch_envio_automatico" class="m-r-10 m-b-0 d-flex align-items-center" style="cursor: pointer;">
                                <input type="checkbox" id="switch_envio_automatico" autocomplete="off" style="width: 18px; height: 18px; cursor: pointer; margin-right: 8px;">
                                <span id="label_envio_automatico" class="badge badge-secondary px-3 py-2 font-14" style="min-width: 100px;">Desactivado</span>
                            </label>
                            <button type="button" class="btn btn-sm btn-success" id="btn_guardar_envio_automatico" style="display: none;">
                                <i class="fa fa-save"></i> Guardar
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="row m-t-20">
                    <div class="col-md-3">
                        <div class="form-group">
                            <input type="text" class="form-control" id="filtro_fecha_desde" placeholder="Fecha desde" autocomplete="off">
                            <label>Fecha desde</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <input type="text" class="form-control" id="filtro_fecha_hasta" placeholder="Fecha hasta" autocomplete="off">
                            <label>Fecha hasta</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <select class="form-control" id="filtro_status">
                                <option value="">Todos los estados</option>
                                <option value="pending">Pendiente</option>
                                <option value="sent">Enviado</option>
                                <option value="authorized">Autorizado</option>
                                <option value="rejected">Rechazado</option>
                            </select>
                            <label>Estado</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <select class="form-control" id="filtro_tipo_documento">
                                <option value="">Todos los tipos</option>
                                <option value="FAC">Factura (FAC)</option>
                                <option value="NTC">Nota de Crédito (NTC)</option>
                                <option value="NTD">Nota de Débito (NTD)</option>
                            </select>
                            <label>Tipo de documento</label>
                        </div>
                    </div>
                </div>
                
                <div class="table-responsive m-t-20">
                    <table id="table-documentos-fe" class="table table-bordered table-striped dt-responsive" style="width:100%">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Fecha</th>
                                <th>Tipo</th>
                                <th>Serie</th>
                                <th>Número</th>
                                <th>Cliente</th>
                                <th>Total</th>
                                <th>Estado</th>
                                <th>NTC emitida</th>
                                <th>CUFE</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                
                <!-- Panel de Debug -->
                <div class="m-t-20">
                    <button class="btn btn-info btn-sm" type="button" data-toggle="collapse" data-target="#debug-panel" aria-expanded="false" aria-controls="debug-panel">
                        <i class="fa fa-bug"></i> Ver Logs de Debug
                    </button>
                    <div class="collapse m-t-10" id="debug-panel">
                        <div class="card card-body" style="background-color: #f8f9fa; max-height: 400px; overflow-y: auto;">
                            <h6 class="text-info"><i class="fa fa-info-circle"></i> Logs de Debug</h6>
                            <div id="debug-logs" style="font-family: 'Courier New', monospace; font-size: 12px; color: #333;">
                                <div class="text-muted">Esperando eventos...</div>
                            </div>
                            <button class="btn btn-sm btn-secondary m-t-10" onclick="$('#debug-logs').html('<div class=\'text-muted\'>Logs limpiados</div>');">Limpiar Logs</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para ver detalles del documento -->
<div class="modal fade" id="modal-ver-documento" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Detalles del Documento</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body" id="contenido-documento">
                <!-- Contenido cargado dinámicamente -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para enviar documento -->
<div class="modal fade" id="modal-enviar-documento" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Enviar Documento</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <p>¿Está seguro de enviar este documento a facturafacil?</p>
                <div class="alert alert-info">
                    <strong>Información:</strong>
                    <ul class="m-b-0">
                        <li>El documento se enviará según el ambiente configurado en la serie</li>
                        <li>Una vez enviado, no podrá ser modificado</li>
                        <li>El estado se actualizará automáticamente según la respuesta</li>
                    </ul>
                </div>
                <input type="hidden" id="id_documento_enviar">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success" id="btn-confirmar-envio">Enviar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para convertir documento -->
<div class="modal fade" id="modal-convertir-documento" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Convertir Nota de Venta</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <p>Seleccione el tipo de documento al que desea convertir esta Nota de Venta:</p>
                <div class="alert alert-info">
                    <strong>Información:</strong>
                    <ul class="m-b-0">
                        <li>La conversión actualizará el tipo de documento en la venta</li>
                        <li>Se generará un nuevo documento electrónico con la serie correspondiente</li>
                        <li>El documento original (Nota de Venta) se mantendrá como referencia</li>
                    </ul>
                </div>
                <div class="form-group">
                    <label>Tipo de Documento:</label>
                    <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                        <label class="btn waves-effect waves-light btn-secondary btn-tipo-convertir-1 active">
                            <input type="radio" name="tipo_doc_convertir" value="1" autocomplete="off" checked>BOLETA
                        </label>
                        <label class="btn waves-effect waves-light btn-secondary btn-tipo-convertir-2">
                            <input type="radio" name="tipo_doc_convertir" value="2" autocomplete="off">FACTURA
                        </label>
                    </div>
                </div>
                
                <!-- Campo de búsqueda de cliente (similar al modal de pago) -->
                <div class="form-group mt-3" id="div-cliente-convertir">
                    <label class="font-13 text-inverse">BUSCAR CLIENTE</label>
                    <div class="input-group">
                        <div class="opcion-cliente-convertir input-group-prepend">
                            <a class="input-group-prepend" href="javascript:void(0)" onclick="nuevoClienteConvertir();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip" data-placement="top">
                                <span class="input-group-text bg-header">
                                    <small><i class="fas fa-user-plus"></i></small>
                                </span>
                            </a>
                        </div>
                        <input type="text" class="form-control" name="buscar_cliente_convertir" id="buscar_cliente_convertir" autocomplete="off" placeholder="Buscar cliente...">
                        <a class="input-group-append" href="javascript:void(0)" id="btnClienteLimpiarConvertir" data-original-title="Limpiar datos" data-toggle="tooltip" data-placement="top">
                            <span class="input-group-text bg-header">
                                <small><i class="fas fa-times link-danger"></i></small>
                            </span>
                        </a>
                    </div>
                    <input type="hidden" id="cliente_id_convertir" name="cliente_id_convertir" value="">
                    <input type="hidden" id="cliente_tipo_convertir" name="cliente_tipo_convertir" value="1">
                    <small class="text-muted" id="cliente-info-convertir">Cliente actual: <span id="cliente-nombre-actual-convertir">-</span></small>
                </div>
                
                <input type="hidden" id="id_documento_convertir">
                <input type="hidden" id="id_venta_convertir">
                <input type="hidden" id="cliente_id_original_convertir">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btn-confirmar-conversion">Convertir</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para emitir Nota de Crédito -->
<div class="modal fade" id="modal-emitir-nota-credito" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Emitir Nota de Crédito</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <strong>Información:</strong>
                    <ul class="m-b-0">
                        <li>Se creará una Nota de Crédito que anulará la factura seleccionada</li>
                        <li>La nota de crédito incluirá los mismos items y montos de la factura original</li>
                        <li>Se generará un nuevo número de documento según la serie configurada</li>
                    </ul>
                </div>
                
                <div class="row m-t-20">
                    <div class="col-md-12">
                        <h5>Detalles de la Factura Original</h5>
                        <table class="table table-bordered">
                            <tr>
                                <th width="30%">Serie:</th>
                                <td id="nc-serie-original">-</td>
                            </tr>
                            <tr>
                                <th>Número:</th>
                                <td id="nc-numero-original">-</td>
                            </tr>
                            <tr>
                                <th>Fecha:</th>
                                <td id="nc-fecha-original">-</td>
                            </tr>
                            <tr>
                                <th>Cliente:</th>
                                <td id="nc-cliente-original">-</td>
                            </tr>
                            <tr>
                                <th>Total:</th>
                                <td id="nc-total-original">-</td>
                            </tr>
                            <tr>
                                <th>CUFE:</th>
                                <td id="nc-cufe-original">-</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                <div class="row m-t-20">
                    <div class="col-md-12">
                        <h5>Detalles de la Nota de Crédito</h5>
                        <div class="form-group">
                            <label>Motivo de la Nota de Crédito:</label>
                            <textarea class="form-control" id="nc-motivo" rows="3" placeholder="Ingrese el motivo de la nota de crédito (opcional)"></textarea>
                        </div>
                    </div>
                </div>
                
                <input type="hidden" id="nc-id-documento-original">
                <input type="hidden" id="nc-fd-number-original">
                <input type="hidden" id="nc-fecha-creacion-original">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-warning" id="btn-confirmar-emitir-nc">Emitir Nota de Crédito</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Cliente (para crear/editar clientes) -->
<div class="modal inmodal" id="modal-cliente" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop">
            <form id="form-cliente" method="post" enctype="multipart/form-data">
            <input type="hidden" name="id_cliente" id="id_cliente">
            <input type="hidden" name="tipo_cliente" id="tipo_cliente">
            <div class="modal-header justify-center">
                <h4 class="modal-title-cliente">Nuevo Cliente</h4>
                <div class="ml-auto m-t-10">
                    <div class="box-new_client">
                        <div class="box-check_dni" style="display:inline-block">
                            <input name="tipo_cli" type="radio" value="1" id="td_dni" class="with-gap radio-col-light-green"/>
                            <label for="td_dni"><?php echo Session::get('diAcr'); ?></label>
                        </div>
                        <div class="box-check_ruc" style="display:inline-block">
                            <input name="tipo_cli" type="radio" value="2" id="td_ruc" class="with-gap radio-col-light-green"/>
                            <label for="td_ruc"><?php echo Session::get('tribAcr'); ?></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-body p-0 floating-labels">
                <div class="row" style="margin-left: 0px; margin-right: 0px;">
                    <!-- Column -->
                    <div class="col-lg-6 b-r">
                        <div class="row card-body p-0">
                            <div class="col-md-12 p-l-10 p-t-10 b-t b-b m-b-40 bg-light-info" style="display: flex;">
                                <h6 class="font-medium">Informaci&oacute;n personal</h6>
                            </div>
                            <div class="col-md-6 block01" style="display: block;">
                                <div class="form-group ent m-b-40">
                                    <input type="text" class="form-control dni" name="dni" id="dni" minlength="<?php echo Session::get('diCar'); ?>" maxlength="<?php echo Session::get('diCar'); ?>" value="" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="dni" class="c-dni"><?php echo Session::get('diAcr'); ?></label>
                                </div>
                            </div>
                            <div class="col-md-6 block02" style="display: none;">
                                <?php 
                                // Para Panamá (FacturaFacil) el RUC puede tener hasta 20 caracteres
                                $maxLengthRuc = Session::get('tribCar');
                                $rucFormClass = 'ent';
                                if (defined('API_SERVER_RUC') && API_SERVER_RUC == 'facturafacil.panama') {
                                    $maxLengthRuc = max($maxLengthRuc, 20);
                                    $rucFormClass = 'ruc-panama';
                                }
                                ?>
                                <div class="form-group <?php echo $rucFormClass; ?> m-b-40">
                                    <input type="text" class="form-control ruc" name="ruc" id="ruc" minlength="5" maxlength="<?php echo $maxLengthRuc; ?>" value="" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="ruc" class="c-ruc"><?php echo Session::get('tribAcr'); ?></label>
                                </div>
                            </div>
                            <div class="col-md-12 block07" style="display: none;">
                                <div class="form-group letNumMayMin m-b-40">
                                    <input type="text" class="form-control ruc input-mayus" name="razon_social" id="razon_social" value="" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="razon_social">Raz&oacute;n Social</label>
                                </div>
                            </div>
                            <div class="col-md-12 block03" style="display: block;">
                                <div class="form-group letMayMin m-b-40">
                                    <input type="text" class="form-control dni input-mayus" name="nombres" id="nombres" value="" autocomplete="off" required="required"/>
                                    <span class="bar"></span>
                                    <label for="nombres">Nombre completo</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    <div class="col-lg-6">
                        <div class="row card-body bg-header p-0">
                            <div class="col-md-12 p-l-10 p-t-10 b-t b-b m-b-40 bg-light-inverse" style="display: flex;">
                                <h6 class="font-medium">Contacto</h6>
                            </div>
                            <div class="col-md-6 block05" style="display: block;">
                                <div class="form-group m-b-40">
                                    <input type="date" class="form-control bg-transparent" name="fecha_nac" id="fecha_nac" value="" autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="fecha_nac">Fecha de Nacimiento</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group ent m-b-40">
                                    <input type="text" class="form-control bg-transparent input-espacio" name="telefono" id="telefono" value="" autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="telefono">Tel&eacute;fono</label>
                                </div>
                            </div>
                            <div class="col-md-12 block06" style="display: block;">
                                <div class="form-group m-b-40">
                                    <input type="text" class="form-control bg-transparent dni" name="correo" id="correo" value="" autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="correo">Correo electr&oacute;nico</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group m-b-40">
                                    <input type="text" class="form-control bg-transparent" name="direccion" id="direccion" value="" autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="direccion">Direcci&oacute;n</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group m-b-40">
                                    <input type="text" class="form-control bg-transparent input-mayus" name="referencia" id="referencia" value="" autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="referencia">Referencia</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Volver</button>
                <button type="submit" class="btn btn-success">Aceptar</button>
            </div>
            </form>
        </div>
    </div>
</div>

