$(function() {
    obtenerDatosFacturacion();
    
    // Botón para abrir modal de selección de coordenadas
    $(document).on('click', '#btn-seleccionar-coordenadas', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var modal = $('#modal-seleccionar-coordenadas');
        if (modal.length === 0) {
            Swal.fire('Error', 'El modal de selección de coordenadas no se encontró. Por favor recargue la página.', 'error');
            return;
        }
        modal.modal('show');
    });
    
    $('#form-facturacion').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
            ff_company_uuid: {
                validators: {
                    notEmpty: {
                        message: 'El UUID de empresa es requerido'
                    }
                }
            },
            ff_api_key: {
                validators: {
                    notEmpty: {
                        message: 'La API Key es requerida'
                    }
                }
            },
            ff_branch: {
                validators: {
                    notEmpty: {
                        message: 'El código de sucursal es requerido'
                    }
                }
            },
            branch_address: {
                validators: {
                    notEmpty: {
                        message: 'La dirección de la sucursal es requerida'
                    },
                    stringLength: {
                        min: 5,
                        max: 100,
                        message: 'La dirección debe tener entre 5 y 100 caracteres'
                    }
                }
            },
            branch_phone: {
                validators: {
                    notEmpty: {
                        message: 'El teléfono de la sucursal es requerido'
                    },
                    stringLength: {
                        min: 8,
                        max: 8,
                        message: 'El teléfono debe tener exactamente 8 dígitos'
                    },
                    regexp: {
                        regexp: /^[0-9]{8}$/,
                        message: 'El teléfono debe contener solo números (8 dígitos)'
                    }
                }
            },
            branch_location: {
                validators: {
                    notEmpty: {
                        message: 'La ubicación de la sucursal es requerida'
                    },
                    stringLength: {
                        min: 5,
                        max: 8,
                        message: 'La ubicación debe tener formato PP-DD-CC (ej: 08-01-01)'
                    },
                    regexp: {
                        regexp: /^\d{2}-\d{2}-\d{2}$/,
                        message: 'La ubicación debe tener formato PP-DD-CC (ej: 08-01-01)'
                    }
                }
            },
            branch_coordinates: {
                validators: {
                    notEmpty: {
                        message: 'Las coordenadas de la sucursal son requeridas'
                    },
                    stringLength: {
                        min: 14,
                        max: 20,
                        message: 'Las coordenadas deben tener formato latitud,longitud'
                    },
                    regexp: {
                        regexp: /^[+-]?\d+\.?\d*,[+-]?\d+\.?\d*$/,
                        message: 'Las coordenadas deben tener formato: latitud,longitud (ej: +08.9539,-79.5343)'
                    }
                }
            },
            branch_email: {
                validators: {
                    emailAddress: {
                        message: 'El email debe ser válido'
                    }
                }
            }
        }
    }).on('success.form.fv', function(e) {
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        var parametrosFacturacion = new FormData();
        parametrosFacturacion.append('ff_company_uuid', $('#ff_company_uuid').val());
        parametrosFacturacion.append('ff_api_key', $('#ff_api_key').val());
        parametrosFacturacion.append('ff_branch', $('#ff_branch').val());
        parametrosFacturacion.append('branch_address', $('#branch_address').val());
        parametrosFacturacion.append('branch_phone', $('#branch_phone').val());
        parametrosFacturacion.append('branch_location', $('#branch_location').val());
        parametrosFacturacion.append('branch_coordinates', $('#branch_coordinates').val());
        parametrosFacturacion.append('branch_email', $('#branch_email').val());
        parametrosFacturacion.append('facturacion_activa', $('#facturacion_activa_hidden').val());
        
        $.ajax({
            url: $('#url').val()+'ajuste/facturacion_electronica_crud',
            type: 'POST',
            data: parametrosFacturacion,
            dataType: 'json',
            contentType: false,
            processData: false,
        })
        .done(function(response){
            var html_terminado = '<div>Configuración guardada correctamente</div>\
                <br><a href="'+$('#url').val()+'ajuste/facturacion" class="btn btn-success">Aceptar</button>'
            Swal.fire({
                title: 'Proceso Terminado',
                html: html_terminado,
                icon: 'success',
                showConfirmButton: false
            });
            obtenerDatosFacturacion();
        })
        .fail(function(){
            swal('Oops...', 'Problemas con la conexión a internet!', 'error');
        });
    });
});

var obtenerDatosFacturacion = function(){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/facturacion_electronica_data",
        dataType: "json",
        success: function(item){
            $('#ff_company_uuid').val(item.ff_company_uuid || '');
            $('#ff_api_key').val(item.ff_api_key || '');
            // Mostrar el valor completo guardado, sin ocultar ni truncar
            $('#ff_branch').val(item.ff_branch || '');
            $('#branch_address').val(item.branch_address || '');
            $('#branch_phone').val(item.branch_phone || '');
            $('#branch_location').val(item.branch_location || '');
            $('#branch_coordinates').val(item.branch_coordinates || '');
            $('#branch_email').val(item.branch_email || '');
            $('#facturacion_activa_hidden').val(item.activo || '0');
            
            if(item.activo == '1' || item.activo == 1){
                $('#facturacion_activa').prop('checked', true);
            } else {
                $('#facturacion_activa').prop('checked', false);
            }
        }
    });
}

// Toggle para mostrar/ocultar API Key
const togglePasswordApiKey = document.querySelector('#togglePasswordApiKey');
const apiKey = document.querySelector('#ff_api_key');
if (togglePasswordApiKey && apiKey) {
    togglePasswordApiKey.addEventListener('click', function() {
        const type = apiKey.getAttribute('type') === 'password' ? 'text' : 'password';
        apiKey.setAttribute('type', type);
        if (type === 'password') {
            this.classList.remove('fa-eye');
            this.classList.add('fa-eye-slash');
        } else {
            this.classList.remove('fa-eye-slash');
            this.classList.add('fa-eye');
        }
    });
}

// Manejar checkbox de facturación activa
$('#facturacion_activa').on('change', function(event){
    if($(this).prop('checked')){
        $('#facturacion_activa_hidden').val('1');
    }else{
        $('#facturacion_activa_hidden').val('0');
    }
});

// Variables globales para el mapa
var mapCoordenadas = null;
var markerCoordenadas = null;

// Inicializar mapa cuando se abre el modal
$('#modal-seleccionar-coordenadas').on('shown.bs.modal', function() {
    // Coordenadas por defecto: Panamá (centro de la ciudad)
    var defaultLat = 8.9824;
    var defaultLng = -79.5199;
    var defaultZoom = 13;
    
    // Si ya hay coordenadas guardadas, usarlas
    var coordenadasActuales = $('#branch_coordinates').val();
    if (coordenadasActuales && coordenadasActuales.trim() !== '') {
        var coords = coordenadasActuales.split(',');
        if (coords.length === 2) {
            // Limpiar coordenadas (remover signos + y espacios)
            var latStr = coords[0].trim().replace(/^\+/, '');
            var lngStr = coords[1].trim().replace(/^\+/, '');
            defaultLat = parseFloat(latStr) || defaultLat;
            defaultLng = parseFloat(lngStr) || defaultLng;
        }
    }
    
    // Inicializar mapa solo si no existe
    if (!mapCoordenadas) {
        mapCoordenadas = L.map('map-coordenadas').setView([defaultLat, defaultLng], defaultZoom);
        
        // Agregar capa de OpenStreetMap
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
            maxZoom: 19
        }).addTo(mapCoordenadas);
        
        // Agregar marcador inicial
        markerCoordenadas = L.marker([defaultLat, defaultLng], {
            draggable: true
        }).addTo(mapCoordenadas);
        
        // Actualizar coordenadas cuando se mueve el marcador
        markerCoordenadas.on('dragend', function(e) {
            var position = markerCoordenadas.getLatLng();
            actualizarCoordenadasUI(position.lat, position.lng);
        });
        
        // Actualizar coordenadas cuando se hace clic en el mapa
        mapCoordenadas.on('click', function(e) {
            var lat = e.latlng.lat;
            var lng = e.latlng.lng;
            
            // Mover marcador a la nueva posición
            markerCoordenadas.setLatLng([lat, lng]);
            actualizarCoordenadasUI(lat, lng);
        });
        
        // Actualizar coordenadas iniciales en la UI
        actualizarCoordenadasUI(defaultLat, defaultLng);
    } else {
        // Si el mapa ya existe, centrarlo en las coordenadas actuales
        mapCoordenadas.setView([defaultLat, defaultLng], defaultZoom);
        markerCoordenadas.setLatLng([defaultLat, defaultLng]);
        actualizarCoordenadasUI(defaultLat, defaultLng);
    }
    
    // Ajustar tamaño del mapa después de que el modal se muestre
    setTimeout(function() {
        mapCoordenadas.invalidateSize();
    }, 100);
});

// Función para actualizar la UI con las coordenadas
function actualizarCoordenadasUI(lat, lng) {
    // Formatear coordenadas con signo + si es positivo
    var latFormatted = (lat >= 0 ? '+' : '') + lat.toFixed(4);
    var lngFormatted = (lng >= 0 ? '+' : '') + lng.toFixed(4);
    
    $('#map-latitud').val(latFormatted);
    $('#map-longitud').val(lngFormatted);
}

// Botón para confirmar coordenadas seleccionadas
$('#btn-confirmar-coordenadas').on('click', function() {
    var lat = $('#map-latitud').val();
    var lng = $('#map-longitud').val();
    
    if (lat && lng) {
        // Formatear como: latitud,longitud
        var coordenadas = lat + ',' + lng;
        $('#branch_coordinates').val(coordenadas);
        
        // Cerrar modal
        $('#modal-seleccionar-coordenadas').modal('hide');
        
        // Mostrar mensaje de éxito
        Swal.fire({
            title: 'Coordenadas seleccionadas',
            text: 'Las coordenadas han sido guardadas: ' + coordenadas,
            icon: 'success',
            timer: 2000,
            showConfirmButton: false
        });
    } else {
        Swal.fire({
            title: 'Error',
            text: 'Por favor seleccione una ubicación en el mapa',
            icon: 'error'
        });
    }
});

