<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h4 class="m-b-0 m-t-0">Configuración de Series y Documentos</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Inicio</a></li>
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Ajustes</a></li>
            <li class="breadcrumb-item active">Series y Documentos</li>
        </ol>
    </div>
    <div class="col-md-7 align-self-center text-right">
        <button type="button" class="btn btn-info" id="btn-nueva-serie"><i class="ti-plus"></i> Nueva Serie</button>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title"><i class="ti-receipt font-18"></i> Series y Documentos Fiscales</h4>
                <h6 class="card-subtitle">Configure las series y números de documentos según las normas de Panamá (DGI)</h6>
                <div class="alert alert-info m-t-20">
                    <h5><i class="ti-info-alt"></i> Información Importante</h5>
                    <ul class="mb-0">
                        <li><strong>POS (Punto de Venta):</strong> Debe ser exactamente 3 dígitos (000-999)</li>
                        <li><strong>Número Fiscal:</strong> 10 dígitos con ceros a la izquierda (0000000001 a 9999999999)</li>
                        <li><strong>Sin reinicio:</strong> Los números fiscales no pueden reiniciarse, deben ser secuenciales</li>
                        <li><strong>Ambiente:</strong> 1=Producción, 2=Pruebas (QA)</li>
                    </ul>
                </div>
                <div class="table-responsive m-t-20">
                    <table id="table-series" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Tipo Documento</th>
                                <th>Serie</th>
                                <th>POS</th>
                                <th>Número Inicial</th>
                                <th>Número Actual</th>
                                <th>Número Final</th>
                                <th>Ambiente</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Los datos se cargarán dinámicamente -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para crear/editar serie -->
<div class="modal fade" id="modal-serie" tabindex="-1" role="dialog" aria-labelledby="modal-serie-label" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form id="form-serie" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="modal-serie-label">Nueva Serie de Documento</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="id_serie" name="id_serie">
                    <div class="row floating-labels">
                        <div class="col-md-6">
                            <div class="form-group m-b-40">
                                <select id="tipo_documento" name="tipo_documento" class="form-control" required>
                                    <option value="">Seleccionar...</option>
                                    <option value="FAC">FAC - Factura Electrónica</option>
                                    <option value="NTC">NTC - Nota de Crédito</option>
                                    <option value="NTD">NTD - Nota de Débito</option>
                                </select>
                                <span class="bar"></span>
                                <label for="tipo_documento">Tipo de Documento</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group m-b-40">
                                <input type="text" id="serie" name="serie" class="form-control" maxlength="20" autocomplete="off">
                                <span class="bar"></span>
                                <label for="serie">Serie</label>
                                <small class="form-text text-muted">Ejemplo: A001, B001, C001</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group m-b-40">
                                <input type="text" id="pos" name="pos" class="form-control" maxlength="3" pattern="[0-9]{3}" placeholder="001" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="pos">POS (Punto de Venta)</label>
                                <small class="form-text text-muted">3 dígitos (000-999)</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group m-b-40">
                                <input type="number" id="numero_inicial" name="numero_inicial" class="form-control" min="1" max="9999999999" value="1" required>
                                <span class="bar"></span>
                                <label for="numero_inicial">Número Inicial</label>
                                <small class="form-text text-muted">Mínimo: 1</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group m-b-40">
                                <input type="number" id="numero_actual" name="numero_actual" class="form-control" min="1" max="9999999999" value="1" required>
                                <span class="bar"></span>
                                <label for="numero_actual">Número Actual</label>
                                <small class="form-text text-muted">Número actual en uso</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group m-b-40">
                                <input type="number" id="numero_final" name="numero_final" class="form-control" min="1" max="9999999999" value="9999999999" required>
                                <span class="bar"></span>
                                <label for="numero_final">Número Final</label>
                                <small class="form-text text-muted">Máximo permitido: 9999999999</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group m-b-40">
                                <select id="ambiente" name="ambiente" class="form-control" required>
                                    <option value="2">2 - Pruebas (QA)</option>
                                    <option value="1">1 - Producción</option>
                                </select>
                                <span class="bar"></span>
                                <label for="ambiente">Ambiente</label>
                                <small class="form-text text-muted">1=Producción, 2=Pruebas</small>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group m-b-40">
                                <span class="bar"></span>
                                <label for="activo">Estado</label>
                                <div class="row">
                                    <div class="col-8">
                                        <h6 class="text-muted mt-3">Activar esta serie</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <div class="switch">
                                            <label style="position: inherit;"><input type="checkbox" id="activo" checked><span class="lever switch-col-light-green"></span></label>
                                            <input type="hidden" name="activo" id="activo_hidden" value="1">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

