<?php

class Tablero_Model extends Model {

	public function __construct() {
		parent::__construct();
	}

    public function Caja()
    {
        try
        {      
            return $this->db->selectAll("SELECT id_apc,id_caja,id_turno,desc_caja,desc_turno FROM v_caja_aper WHERE estado = 'a'");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
	
	public function tablero_datos()
    {
        try
        {

            $id_apc = $_POST['id_apc'];

            $sql_ventas = $this->db->prepare("SELECT IFNULL(SUM(v.descuento_monto),0) AS descuento_monto, IFNULL(SUM(v.comision_tarjeta),0) AS comision_tarjeta, IFNULL(SUM(v.comision_delivery),0) AS comision_delivery, IFNULL(SUM(v.total+v.comision_delivery),0) AS total, IFNULL(SUM(v.comision_rc),0) AS comision_rc FROM tm_venta AS v WHERE v.id_apc = ? AND v.state_type_id != '11' AND v.descuento_tipo <> 1");
            $sql_ventas->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $ventas= $sql_ventas->fetch(PDO::FETCH_OBJ); 

            $sql_egresos = $this->db->prepare("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE /*(fecha_re >= ? AND fecha_re < ?) AND*/ id_apc = ? AND estado = 'a'");
            $sql_egresos->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $egresos = $sql_egresos->fetch(PDO::FETCH_OBJ);


            $sql_ventas_efe = $this->db->prepare("SELECT SUM(vp.monto) AS total FROM tm_venta_pago AS vp INNER JOIN tm_tipo_pago AS tp ON  vp.id_pago = tp.id_tipo_pago INNER JOIN tm_venta AS v ON vp.id_venta = v.id_venta WHERE vp.id_pago = 1 AND tp.id_tipo_pago = 1 AND v.id_apc = ? AND v.state_type_id != '11'");
            $sql_ventas_efe->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $ventas_efectivo = $sql_ventas_efe->fetch(PDO::FETCH_OBJ);   
            
            $sql_ventas_no_efe = $this->db->prepare("SELECT SUM(vp.monto) AS total FROM tm_venta_pago AS vp INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago INNER JOIN tm_venta AS v ON vp.id_venta = v.id_venta WHERE vp.id_pago <> 1 AND tp.id_tipo_pago <> 1 AND v.id_apc = ? AND v.state_type_id != '11'");
            $sql_ventas_no_efe->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $ventas_pagos_otros = $sql_ventas_no_efe->fetch(PDO::FETCH_OBJ);             


            $sql_ingresos = $this->db->prepare("SELECT IFNULL(SUM(importe),0) AS total FROM tm_ingresos_adm WHERE /*(fecha_reg >= ? AND fecha_reg < ?) AND */id_apc = ? AND estado = 'a'");
            $sql_ingresos->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $ingresos = $sql_ingresos->fetch(PDO::FETCH_OBJ);

            $sql_pollos_vendidos = $this->db->prepare("SELECT p.id_pres,p.pro_nom,p.pro_pre,dv.precio,SUM(dv.cantidad) AS cantidad, i.cant FROM tm_detalle_venta AS dv INNER JOIN tm_venta AS v ON dv.id_venta = v.id_venta INNER JOIN v_productos AS p ON dv.id_prod = p.id_pres INNER JOIN tm_producto_ingr AS i ON dv.id_prod = i.id_pres WHERE v.id_apc = ? AND i.id_ins = 1 AND p.pro_mar = 1 AND v.state_type_id != '11' GROUP BY dv.id_prod, dv.precio ORDER BY total DESC");
            $sql_pollos_vendidos->execute(array($id_apc));
            $pollos_vendidos = $sql_pollos_vendidos->fetchAll(PDO::FETCH_OBJ);
            //59 al 66

            $sql_pollos_stock = $this->db->prepare("SELECT (ent-sal) AS total FROM v_stock WHERE id_tipo_ins = 1 AND id_ins = 1");
            $sql_pollos_stock->execute();
            $pollos_stock = $sql_pollos_stock->fetch(PDO::FETCH_OBJ);

            $sql_platos = $this->db->prepare("SELECT vp.pro_nom,vp.pro_pre,dv.precio,SUM(dv.cantidad) AS cantidad,COUNT(dv.id_venta) AS total FROM tm_detalle_venta AS dv INNER JOIN tm_venta AS v ON dv.id_venta = v.id_venta INNER JOIN v_productos AS vp ON dv.id_prod = vp.id_pres WHERE vp.id_tipo = 1 AND v.state_type_id != '11' AND v.id_apc = ? GROUP BY dv.id_prod, dv.precio ORDER BY total DESC LIMIT 10");
            $sql_platos->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $platos = $sql_platos->fetchAll(PDO::FETCH_OBJ);

            $sql_productos = $this->db->prepare("SELECT vp.pro_nom,vp.pro_pre,dv.precio,SUM(dv.cantidad) AS cantidad,COUNT(dv.id_venta) AS total FROM tm_detalle_venta AS dv INNER JOIN tm_venta AS v ON dv.id_venta = v.id_venta INNER JOIN v_productos AS vp ON dv.id_prod = vp.id_pres WHERE v.state_type_id != '11' AND v.id_apc = ? GROUP BY dv.id_prod, dv.precio ORDER BY total DESC LIMIT 10");
            $sql_productos->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $productos = $sql_productos->fetchAll(PDO::FETCH_OBJ);

            $sql_canal_salon = $this->db->prepare("SELECT COUNT(*) AS cantidad_ventas, SUM(total) total_ventas FROM tm_venta WHERE id_tipo_pedido = 1 AND state_type_id != '11' AND id_apc = ?");
            $sql_canal_salon->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $canal_salon = $sql_canal_salon->fetch(PDO::FETCH_OBJ);

            $sql_canal_mostrador = $this->db->prepare("SELECT COUNT(*) AS cantidad_ventas, SUM(total) total_ventas FROM tm_venta WHERE id_tipo_pedido = 2 AND state_type_id != '11' AND id_apc = ?");
            $sql_canal_mostrador->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $canal_mostrador = $sql_canal_mostrador->fetch(PDO::FETCH_OBJ);

            $sql_canal_delivery = $this->db->prepare("SELECT COUNT(*) AS cantidad_ventas, SUM(total) total_ventas FROM tm_venta WHERE id_tipo_pedido = 3 AND state_type_id != '11' AND id_apc = ?");
            $sql_canal_delivery->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $canal_delivery = $sql_canal_delivery->fetch(PDO::FETCH_OBJ);

            $sql_canal_salon_i = $this->db->prepare("SELECT COUNT(*) AS cantidad_ventas, SUM(total) total_ventas FROM tm_venta WHERE id_tipo_pedido = 1 AND state_type_id = '11' AND id_apc = ?");
            $sql_canal_salon_i->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $canal_salon_i = $sql_canal_salon_i->fetch(PDO::FETCH_OBJ);

            $sql_canal_mostrador_i = $this->db->prepare("SELECT COUNT(*) AS cantidad_ventas, SUM(total) total_ventas FROM tm_venta WHERE id_tipo_pedido = 2 AND state_type_id = '11' AND id_apc = ?");
            $sql_canal_mostrador_i->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $canal_mostrador_i = $sql_canal_mostrador_i->fetch(PDO::FETCH_OBJ);

            $sql_canal_delivery_i = $this->db->prepare("SELECT COUNT(*) AS cantidad_ventas, SUM(total) total_ventas FROM tm_venta WHERE id_tipo_pedido = 3 AND state_type_id = '11' AND id_apc = ?");
            $sql_canal_delivery_i->execute(array(/*$ifecha,$ffecha,*/$id_apc));
            $canal_delivery_i = $sql_canal_delivery_i->fetch(PDO::FETCH_OBJ);

            $data = array("Ventas" => $ventas,"VentasEfectivo" => $ventas_efectivo, "VentasOMP" => $ventas_pagos_otros, "Egresos" => $egresos,"Ingresos" => $ingresos,"Platos" => $platos,"Productos" => $productos, "Pollostock" => $pollos_stock, "Pollosvendidos" => $pollos_vendidos, "CanalSalon" => $canal_salon, "CanalMostrador" => $canal_mostrador, "CanalDelivery" => $canal_delivery, "CanalSalonAnulados" => $canal_salon_i, "CanalMostradorAnulados" => $canal_mostrador_i,"CanalDeliveryAnulados" => $canal_delivery_i/*"data3" => $m,"data4" => $tp,"data5" => $me,"data6" => $vm,"data7" => $vmo,"data8" => $mo,*//*,"data11" => $ma,"data12" => $moa*/);
            $json = json_encode($data);
            echo $json;  

        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function tablero_datos2()
    {
        try
        {

            $id_apc = $_POST['id_apc'];
            $documents = $this->db->query("SELECT 
            SUM(CASE WHEN v.id_tipo_doc  = 1 THEN v.total ELSE 0 END) AS ventas_bol,
            SUM(CASE WHEN v.id_tipo_doc  = 2 THEN v.total ELSE 0 END) AS ventas_fac,
            SUM(CASE WHEN v.id_tipo_doc  = 3 THEN v.total ELSE 0 END) AS ventas_nv,
            SUM(v.total) AS total
            FROM tm_venta AS v WHERE v.id_apc = '{$id_apc}' AND v.state_type_id != '11' ORDER BY v.fecha_venta DESC, SUM(v.total) DESC;")->fetch(PDO::FETCH_OBJ);

            $pagos = $this->db->query("SELECT  tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto, tp.color AS color FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_apc = '{$id_apc}' AND vp.monto > 0 AND v.state_type_id != '11' GROUP BY tp.descripcion;")->fetchAll(PDO::FETCH_OBJ);  

            
            $pagos_array = $this->getPagos($pagos);
            $sumars = round($documents->ventas_bol+$documents->ventas_fac+$documents->ventas_nv);
            $data = [
               'ventas' => [
                    'labels' =>  array('Ventas'),
                    'datasets' => array(
                        array(
                            'label' => 'Boleta de Venta',
                            'data' => [($documents->ventas_bol)? round(($documents->ventas_bol /$sumars)*100) : '0'],
                            'backgroundColor' => '#00afe9',
                            'borderRadius' => '20',
                        ),
                        array(
                            'label' => 'Factura de Venta',
                            'data' => [($documents->ventas_fac)? round(($documents->ventas_fac/$sumars)*100) : '0'],
                            'backgroundColor' => '#ffb22b',
                            'borderRadius' => '20',
                        ),
                        array(
                            'label' => 'Nota de Venta',
                            'data' => [($documents->ventas_nv)? round(($documents->ventas_nv/$sumars)*100): '0'],
                            'backgroundColor' => '#7460ee ',
                            'borderRadius' => '20',
                        ),
                    ),
                  
                ],
                'ventasmonto' =>[
                    'bv' => ($documents->ventas_bol)? $documents->ventas_bol : '0',
                    'fv' => ($documents->ventas_fac)? $documents->ventas_fac : '0',
                    'nv' => ($documents->ventas_nv)? $documents->ventas_nv : '0',
                ],
                'fp' => [
                    'labels' =>  array_values($pagos_array['formaspago']),
                    'data' => array_values($pagos_array['monto']),
                    'backgroundColor' =>  array_values($pagos_array['color'])
                ],
            ];
           
            $json = json_encode($data);
            echo $json;

        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }    
    private function getPagos($pagos)
    {
            $color= array();    
            $monto = array(); 
            $formaspago = array();  
            $sumar = 0;   
            foreach ($pagos as $sum) {
                $sumar = $sumar + $sum->monto;
            }
            foreach ($pagos as $clave) {
                $formaspago[] =  $clave->nombre." (".round(($clave->monto / $sumar)*100) ."%)";
                $color[] = $clave->color;
                $monto[] = ($clave->monto);
            }

        return compact('formaspago','color', 'monto', 'sumar');
    }

}