<?php
/**
 * Created by PhpStorm.
 * User: elporfirio
 * Date: 2019-02-26
 * Time: 23:04
 */

require_once ('public/lib/phpqrcode/qrlib.php');
require_once ('public/lib/pdf/cellfit.php');
// require('fpdf/fpdf.php');
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'Exception.php';
require 'PHPMailer.php';
require 'SMTP.php';

class FPDF_CellFiti extends FPDF_CellFit
{
	function AutoPrint($dialog=false)
	{
		//Open the print dialog or start printing immediately on the standard printer
		$param=($dialog ? 'true' : 'false');
		$script="print($param);";
		$this->IncludeJS($script);
	}

	function AutoPrintToPrinter($server, $printer, $dialog=false)
	{
		//Print on a shared printer (requires at least Acrobat 6)
		$script = "var pp = getPrintParams();";
		if($dialog)
			$script .= "pp.interactive = pp.constants.interactionLevel.full;";
		else
			$script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
		$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
		$script .= "print(pp);";
		$this->IncludeJS($script);
	}
}
class Email
{
    public function __construct() {
        //$this->db = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
    }

    public function sendEmail($correo_cliente,$documento_cliente,$datos_factura,$negocio) {

        try {
            //AQUI CAMBIAR SI SE DESEA QUE EL SE ENVIE EN FORMATO "a4"
            $formato = 'ticket';
            if($formato == 'a4'){ 
                $pdf = new FPDF();
                $pdf->AddPage('PORTRAIT', 'letter');
                $data = json_decode($datos_factura,true);
                
                //DATOS DE EMPRESA
                $pdf->Ln(5);
                $pdf->SetFont('Arial','B',11);
                $pdf->Cell( 100, 5, utf8_decode($data['Empresa']['nombre_comercial']) , 0, 1, '');
                $pdf->SetFont('Arial','',10);
                $pdf->MultiCell( 100, 5, utf8_decode($data['Empresa']['direccion_comercial']) , 0, 'L');
                $pdf->Cell( 100, 5, 'TELF: '.utf8_decode($data['Empresa']['celular']) , 0, 1, '');
                
                //DATOS DE CLIENTE
                $textypos = 5;
                $pdf->SetFont('Arial','B',10);    
                $pdf->setY(50);$pdf->setX(10);
                $pdf->Cell(5,$textypos,"Cliente: ");
                $pdf->SetFont('Arial','',10);    
                $pdf->setY(50);$pdf->setX(30);
                $pdf->Cell(5,$textypos,utf8_decode($data['Cliente']['nombre']));
                
                if ($data['Cliente']['tipo_cliente'] == 1){
                    $tipodoc = 'DNI';
                    $nrodoc = $data['Cliente']['dni'];
                }else if ($data['Cliente']['tipo_cliente'] == 2){
                    $tipodoc = 'RUC';
                    $nrodoc = $data['Cliente']['ruc'];
                }
                $pdf->SetFont('Arial','B',10);    
                $pdf->setY(55);$pdf->setX(10);
                $pdf->Cell(5,$textypos, $tipodoc);
                $pdf->SetFont('Arial','',10);    
                $pdf->setY(55);$pdf->setX(30);
                $pdf->Cell(5,$textypos, $nrodoc);
                
                $pdf->SetFont('Arial','B',10);
                $pdf->setY(60);$pdf->setX(10);
                $pdf->Cell(5,$textypos,"Direccion: ");
                $pdf->SetFont('Arial','',10);    
                $pdf->setY(60);$pdf->setX(30);
                $pdf->MultiCell( 100, 5, utf8_decode($data['Cliente']['direccion']), 0, 'L');
                
                // NRO DE FACTURA
                $elec = (($data['id_tdoc'] == 1 || $data['id_tdoc'] == 2) && $data['Empresa']['sunat'] == 1) ? 'ELECTRONICA' : '';
                $pdf->SetLineWidth(0.1); $pdf->SetFillColor(500); 
                $pdf->Rect(120, 10, 85, 30);
                $pdf->SetXY( 120, 15 ); 
                $pdf->SetFont( "Arial", "B", 12 ); 
                $pdf->Cell( 85, 4, 'R.U.C. Nro. '.utf8_decode($data['Empresa']['ruc']), 0, 0, 'C');
                $pdf->SetXY( 120, 15 ); 
                $pdf->Cell( 85, 20, $data['desc_td'].' '.$elec, 0, 0, 'C');
                $pdf->SetXY( 120, 15 ); 
                $pdf->Cell( 85, 36, $data['ser_doc'].'-'.$data['nro_doc'] , 0, 0, 'C');
                
                $pdf->SetFont('Arial','B',10);    
                $pdf->setY(55);$pdf->setX(135);
                $pdf->Cell(5,$textypos,"F. Emision: ");
                $pdf->SetFont('Arial','',10);    
                $pdf->setY(55);$pdf->setX(168);
                $pdf->Cell(5,$textypos, date('d-m-Y h:i A',strtotime($data['fec_ven'])));
                
                $pdf->SetFont('Arial','B',10); 
                $pdf->setY(60);$pdf->setX(135);
                $pdf->Cell(5,$textypos,"Moneda: ");
                $pdf->SetFont('Arial','',10);    
                $pdf->setY(60);$pdf->setX(168);
                $pdf->Cell(5,$textypos,"SOLES");
                
                /// Apartir de aqui empezamos con la tabla de productos
                $pdf->setY(70);$pdf->setX(135);
                $pdf->Ln();
                /////////////////////////////
                //// Array de Cabecera
                
                $header = array("Descripcion","Cant.","P. Unitario","Importe");
                //// Arreglo de Productos
                
                    // Column widths
                    $w = array(126, 20, 25, 25);
                    // Header, el numero 7 define el alto de la cabecera
                    $pdf->SetFont('Arial','B',10); 
                    for($i=0;$i<count($header);$i++)
                        
                    $pdf->Cell($w[$i],7,$header[$i],1,0,'C');
                    $pdf->Ln();
                    // Data
                    $pdf->SetFont('Arial','',10);
                    
                    $total = 0;
                    $total_ope_gravadas = 0;
                    $total_igv_gravadas = 0;
                    $total_ope_exoneradas = 0;
                    $total_igv_exoneradas = 0;
                    foreach($data['Detalle'] as $row)
                    {
                        if($row['codigo_afectacion'] == '10'){
                            $total_ope_gravadas = $total_ope_gravadas + $row['valor_venta'];
                            $total_igv_gravadas = $total_igv_gravadas + $row['total_igv'];
                            $total_ope_exoneradas = $total_ope_exoneradas + 0;
                            $total_igv_exoneradas = $total_igv_exoneradas + 0;
                        } else{
                            $total_ope_gravadas = $total_ope_gravadas + 0;
                            $total_igv_gravadas = $total_igv_gravadas + 0;
                            $total_ope_exoneradas = $total_ope_exoneradas + $row['valor_venta'];
                            $total_igv_exoneradas = $total_igv_exoneradas + $row['total_igv'];
                        }

                        $pdf->Cell($w[0],6,utf8_decode($row['nombre_producto']),1);
                        $pdf->Cell($w[1],6,number_format($row['cantidad']),'1',0,'C');
                        $pdf->Cell($w[2],6,"S/  ".number_format($row['precio_unitario'],2,".",","),'1',0,'R');
                        $pdf->Cell($w[3],6,"S/  ".number_format($row['cantidad']*$row['precio_unitario'],2,".",","),'1',0,'R');
                
                        $pdf->Ln();
                        //// aqui multiplica la cantidad por elprecio unitario
                        $total = ($row['cantidad'] * $row['precio_unitario']) + $total;
                    }
                /////////////////////////////
                //// Apartir de aqui esta la tabla con los subtotales y totales
                //$yposdinamic = 70 + (count($products)*10);
                
                $pdf->setX(215);
                $pdf->Ln();
                /////////////////////////////
                
                /*
                $operacion_gravada = (($data['total'] + $data['comis_tar'] + $data['comis_del'] - $data['desc_monto']) / (1 + $data['igv']));
                $igv = ($operacion_gravada * $data['igv']);
                */
                //$header = array("", "");
                $data2 = array(
                    array("Subtotal",number_format(($data['total']),2)),
                    array("Costo delivery", number_format(($data['comis_del']),2)),
                    array("Descuento", number_format(($data['desc_monto']),2)),
                    array("Operacion Gravada", number_format(($total_ope_gravadas),2)),
                    array("Operacion Exonerada", number_format(($total_ope_exoneradas),2)),
                    array("IGV", number_format(($total_igv_gravadas + $total_igv_exoneradas),2)),
                    array("Importe Total", number_format(($data['total'] + $data['comis_del'] - $data['desc_monto']),2)),
                );
                    // Column widths
                    $w2 = array(40, 36);
                    // Header
                
                    $pdf->Ln();
                    // Data
                    foreach($data2 as $row)
                    {
                        $pdf->setX(130);
                        $pdf->Cell($w2[0],6,$row[0],1);
                        $pdf->Cell($w2[1],6,"S/ ".number_format($row[1], 2, ".",","),'1',0,'R');
                        $pdf->Ln();
                    }
                /////////////////////////////
                
                //$yposdinamic += (count($data2)*10);
                $pdf->SetFont('Arial','B',10);    
                $pdf->setX(10);
                $pdf->Ln();
                $pdf->Cell(5,$textypos,'SON: '.numtoletras($data['total'] + $data['comis_del'] - $data['desc_monto']));
                $pdf->SetFont('Arial','',8);
                $pdf->Ln(5);
                $pdf->setX(10);
                $pdf->Cell(5,$textypos,utf8_decode('Designado Emisor Electrónico según Resolución de Superintendecia Nro.155-2017/SUNAT.'),'C');
                $pdf->Ln(5);
                $pdf->setX(10);
                $pdf->Cell(5,$textypos,utf8_decode('Representación impresa de '.$data['desc_td'].' '.$elec));
                $pdfdoc = $pdf->Output('', 'S');
            }
            if($formato == 'ticket'){
                $data = json_decode($datos_factura,true);

                $new_igvrc = ($data['Configuracion']['com_rc_val'] > '0')? ((1 + $data['igv'])+ ($data['Configuracion']['com_rc_val'] / 100) ) : (1 + $data['igv']);
                $new_igv = (1 + $data['igv']);
                //PARA TICKETERAS XPRINTER, 3NSTAR
                define('EURO',chr(128));
                $pdf = new FPDF_CellFiti('P','mm',array(72,350));
                $pdf->AddPage();
                $pdf->SetMargins(0,0,0,0);
                
                if($data['Empresa']['logo']){
                    $url_logo = URL."public/images/".$data['Empresa']['logo'];
                    $pdf->Image($url_logo,L_CENTER,2,L_DIMENSION,0);
                    $pdf->Cell(72,L_ESPACIO,'',0,1,'C');
                }
                $pdf->SetFont('Helvetica','',7);
                $pdf->Cell(72,4,'',0,1,'C');
                $pdf->SetFont('Helvetica','B',10);
                $pdf->MultiCell(72,4,utf8_decode($data['Empresa']['razon_social']),0,'C');
                $pdf->SetFont('Helvetica','',10);
                $pdf->MultiCell(72,4,utf8_decode($data['Empresa']['nombre_comercial']),0,'C');
                $pdf->SetFont('Helvetica','',9);
                $pdf->Cell(72,4,utf8_decode('RUC').': '.utf8_decode($data['Empresa']['ruc']),0,1,'C');
                $pdf->MultiCell(72,4,utf8_decode($data['Empresa']['direccion_comercial']),0,'C');
                $pdf->Cell(72,4,'TELF: '.utf8_decode($data['Empresa']['celular']),0,1,'C');
                 
                // DATOS FACTURA
                $elec = (($data['id_tdoc'] == 1 || $data['id_tdoc'] == 2) && $data['Empresa']['sunat'] == 1) ? 'ELECTRONICA' : '';     
                $pdf->Ln(3);
                $pdf->SetFont('Helvetica', 'B', 10);
                $pdf->Cell(72,4,utf8_decode($data['desc_td']).' '.$elec,0,1,'C');
                $pdf->Cell(72,4,utf8_decode($data['ser_doc']).'-'.utf8_decode($data['nro_doc']),0,1,'C');
                $pdf->Ln(2);
                $pdf->SetFont('Helvetica', '', 7);
                $pdf->Cell(72,4,'FECHA DE EMISION: '.date('d-m-Y h:i A',strtotime($data['fec_ven'])),0,1,'');
                
                if($data['id_tped'] == 1){
                    $pdf->Cell(72,4,utf8_decode('TIPO DE ATENCION').': '.utf8_decode($data['Pedido']['desc_salon']).' - MESA: '.utf8_decode($data['Pedido']['nro_mesa']),0,1,'');
                }else if ($data['id_tped'] == 2){
                    $pdf->Cell(72,4,'TIPO DE ATENCION: MOSTRADOR',0,1,'');
                }else if ($data['id_tped'] == 3){
                    $pdf->Cell(72,4,'TIPO DE ATENCION: DELIVERY',0,1,'');
                }

                $pdf->MultiCell(72,4,'CLIENTE: '.utf8_decode($data['Cliente']['nombre']),0,1,'');
                if($data['Cliente']['tipo_cliente'] == 1){
                $pdf->Cell(72,4,utf8_decode('DNI').': '.utf8_decode($data['Cliente']['dni']),0,1,'');
                }else{
                $pdf->Cell(72,4,utf8_decode('RUC').': '.utf8_decode($data['Cliente']['ruc']),0,1,'');
                }
                $pdf->MultiCell(72,4,'TELEFONO: '.utf8_decode($data['Cliente']['telefono']),0,1,'');
                $pdf->MultiCell(72,4,'DIRECCION: '.utf8_decode($data['Cliente']['direccion']),0,1,'');
                $pdf->MultiCell(72,4,'REFERENCIA: '.utf8_decode($data['Cliente']['referencia']),0,1,'');
                 
                // COLUMNAS
                $pdf->SetFont('Helvetica', 'B', 7);
                $pdf->Cell(5, 10, 'CANT.',0,0);
                $pdf->Cell(42, 10, 'PRODUCTO', 0,0,'C');
                $pdf->Cell(10, 10, 'P.U.',0,0,'R');
                $pdf->Cell(15, 10, 'IMP.',0,0,'R');
                $pdf->Ln(8);
                $pdf->Cell(72,0,'','T');
                $pdf->Ln(1);
                 
                // PRODUCTOS
                $total = 0;
                $total_ope_gravadas = 0;
                $total_igv_gravadas = 0;
                $total_ope_exoneradas = 0;
                $total_igv_exoneradas = 0;
                
                foreach($data['Detalle'] as $d){
                
                    if($d['codigo_afectacion'] == '10'){
                        $total_ope_gravadas = $total_ope_gravadas + $d['valor_venta'];
                        $total_igv_gravadas = $total_igv_gravadas + $d['total_igv'];
                        $total_ope_exoneradas = $total_ope_exoneradas + 0;
                        $total_igv_exoneradas = $total_igv_exoneradas + 0;
                    } else{
                        $total_ope_gravadas = $total_ope_gravadas + 0;
                        $total_igv_gravadas = $total_igv_gravadas + 0;
                        $total_ope_exoneradas = $total_ope_exoneradas + $d['valor_venta'];
                        $total_igv_exoneradas = $total_igv_exoneradas + $d['total_igv'];
                    }
                    if ($data['consumo'] == '0') {
                        $pdf->SetFont('Helvetica', '', 7);
                        $pdf->Cell(10, 4, $d['cantidad'],0,0,'L');
                        $pdf->MultiCell(42,4,utf8_decode($d['nombre_producto']),0,'L'); 
                        $pdf->Cell(57, -4, $d['precio_unitario'],0,0,'R');
                        $pdf->Cell(15, -4, number_format(($d['cantidad'] * $d['precio_unitario']),2),0,0,'R');
                        $pdf->Ln(1);
                    }
                
                    if($d['cantidad'] > 0){
                        $total = ($d['cantidad'] * $d['precio_unitario']) + $total;
                    }
                }
                if ($data['consumo'] == '1') {
                    $pdf->SetFont('Helvetica', '', 7);
                    $pdf->Cell(10, 4, '1',0,0,'L');
                    $pdf->MultiCell(42,4,utf8_decode($data['consumo_desc']),0,'L'); 
                    $pdf->Cell(57, -4, $data['total'],0,0,'R');
                    $pdf->Cell(15, -4, number_format(($data['total']),2),0,0,'R');
                    $pdf->Ln(1);
                }
                
                $sbt = (($data['total'] + $data['comis_tar'] + $data['comis_del'] - $data['desc_monto']) / $new_igv);
                $igv = ($sbt * $data['igv']);
                $pdf->SetFont('Helvetica', '', 7);
                $pdf->Cell(72,0,'','T');
                $pdf->Ln(0);    
                $pdf->Cell(37, 10, 'SUB TOTAL', 0);    
                $pdf->Cell(20, 10, '', 0);
                $igvv = ($total_ope_gravadas > 0)? $new_igvrc : '1';
                $new_subtotal = number_format(((($data['total']) +$data['comis_del']) / $igvv),2, '.', '');
                $pdf->Cell(15, 10, $new_subtotal,0,0,'R');
                
                $pdf->Ln(4); 
                if ($total_ope_gravadas > 0 ) {
                $pdf->Cell(37, 10,'IGV ('.(($new_igv-1)*100).'%)', 0);   
                $pdf->Cell(20, 10, '', 0);
                $pdf->Cell(15, 10, number_format((($new_subtotal * ($new_igv - 1))),2),0,0,'R'); 
                }
                
                if($data['desc_monto'] > 0){
                $pdf->Ln(4); 
                $pdf->Cell(37, 10, 'DESCUENTO', 0);    
                $pdf->Cell(20, 10, '', 0);
                $pdf->Cell(15, 10, '-'.number_format(($data['desc_monto']),2),0,0,'R');
                }
                if($data['comis_del'] > 0){
                $pdf->Ln(4); 
                $pdf->Cell(37, 10, 'DELIVERY', 0);    
                $pdf->Cell(20, 10, '', 0);
                $pdf->Cell(15, 10, '('.number_format(($data['comis_del']),2).')',0,0,'R');
                }
                if($data['comis_rc'] > 0){
                $pdf->Ln(4); 
                $datorc = ($data['rc'] > 0) ? ($data['rc']*100) : $data['Configuracion']['com_rc_val'];
                $pdf->Cell(37, 10, 'REC. CONS. '.$datorc.'%', 0);   
                $pdf->Cell(20, 10, '', 0);
                $pdf->Cell(15, 10, '('.number_format(($data['comis_rc']),2).')',0,0,'R');
                }	
                $pdf->Ln(4); 
                $pdf->SetFont('Helvetica', 'B', 7);
                $pdf->Cell(37, 10, 'TOTAL', 0);    
                $pdf->Cell(20, 10, '', 0);

                $pdf->Cell(15, 10, number_format(($data['total'] + $data['comis_del']),2),0,0,'R');	
 
                $pdf->Ln(8);
                
                $pdf->Ln(2);
                $pdf->SetFont('Helvetica', '', 7);
                $pdf->MultiCell(72,4,'SON: '.numtoletras($data['total'] + $data['comis_del']),0,'L');
                $pdf->Ln(2);
                
                foreach($data['Pagos'] as $d){ 
                    $pdf->Cell(37, 4, $d['nombre'], 0);   
                    $pdf->Cell(20, 4, '',0,0,'R');
                    $pdf->Cell(15, 4, number_format(($d['monto']),2),0,0,'R');
                    $pdf->Ln(4);
                }
                if($data['pago_efe_none'] > 0){
                    $pdf->Cell(72,0,'','T');  
                    $pdf->Ln(2);
                    $pdf->Cell(37, 4, 'PAGO CON', 0);   
                    $pdf->Cell(20, 4, '',0,0,'R');
                    $pdf->Cell(15, 4, number_format(($data['pago_efe_none']),2),0,0,'R');
                    $pdf->Ln(4);
                    $pdf->Cell(37, 4, 'VUELTO', 0);   
                    $pdf->Cell(20, 4, '',0,0,'R');
                    $pdf->Cell(15, 4, number_format(($data['pago_efe_vuelto']),2),0,0,'R');
                    $pdf->Ln(4);
                }
                
                if($data['desc_tipo'] == 1){
                $pdf->Ln(2);
                $pdf->Cell(37, 4, 'CORTESIA', 0);   
                $pdf->Cell(20, 4, '',0,0,'R');
                $pdf->Cell(15, 4, number_format(($data['desc_monto']),2),0,0,'R');
                }
                if($data['desc_tipo'] == 3){
                $pdf->Ln(2);
                $pdf->Cell(37, 4, 'CREDITO PERSONAL', 0);   
                $pdf->Cell(20, 4, '',0,0,'R');
                $pdf->Cell(15, 4, number_format(($data['desc_monto']),2),0,0,'R');
                }
                $pdf->Ln(10);
                
                
                $pdf->SetFont('Helvetica', 'B', 8);
                $pdf->Cell(72,0,utf8_decode('CONDICIÓN DE PAGO: CONTADO'),0,1,'L');
                $pdf->Ln(4);
                $pdf->Cell(72,0,'','T');
                
                
                $pdf->Ln(2);
                // CODIGO QR
                if(($data['id_tdoc'] == 1 || $data['id_tdoc'] == 2) && $data['Empresa']['sunat'] == 1){
                    $td="";
                    $tc="";
                    $tdc="";
                    if($data['id_tdoc']==1){
                        $tc="03";
                        $tdd="1";
                        $tdc=$data['Cliente']['dni'];
                    }
                    if($data['id_tdoc']==2){
                        $tc="01";
                        $tdd="6";
                        $tdc=$data['Cliente']['ruc'];
                    }
                    $nombreqr = $tc."-".$td.$data['ser_doc']."-".$data['nro_doc'];
                        $text_qr = $data['Empresa']['ruc'] . '|' . $tc . '|' . $data['ser_doc'] . '|' . $data['nro_doc'] .'|'.number_format(($total_igv_gravadas + $total_igv_exoneradas),2).'|'.number_format(($data['total']),2).'|'.date('Y-m-d',strtotime($data['fec_ven'])).'|'. $tdd . '|' . $tdc . '|'.$data['hash_cdr'];
                    $ruta_qr    = 'api_fact/UBL21/archivos_xml_sunat/imgqr/QR_' . $nombreqr . '.png';
                    $qr         = 'api_fact/UBL21/archivos_xml_sunat/imgqr/QR_' . $nombreqr . '.png';
                
                    if (!file_exists($ruta_qr)) {
                        QRcode::png($text_qr, $qr, 'Q', 15, 0);
                    }
                    $pdf->Cell(25, 10,$pdf->Image($ruta_qr,2,$pdf->GetY(),20), 0); 

                    $pdf->MultiCell(47,4,utf8_decode('Representación impresa de la '.$data['desc_td']).' '.$elec.' consulte en',0,'C');
                    $pdf->Cell(25, 10,' ',0);
                    $pdf->MultiCell(47,4,URL.'consulta',0,'C');
                }
                
                $pdf->Ln(8);
                $pdf->Cell(72,0,'GRACIAS POR SU PREFERENCIA',0,1,'C');
                $pdf->Ln(8);
                $pdfdoc = $pdf->Output('', 'S');                
            }

            $mail = new PHPMailer(true);
            $mail->SMTPDebug = 0;
            $mail->isSMTP();
            
            $mail->CharSet = 'UTF-8';
            
            $mail->Host = 'mail.alpharest.org.pe';
            $mail->SMTPAuth = true;

            $mail->Username = 'no-responder@alpharest.org.pe';
            $mail->Password = 'W45115-lpM8-';

            $mail->SMTPSecure = 'ssl';
            $mail->Port = 465;
            
            $xml = $documento_cliente;
            $fxml = file_get_contents($xml);
            $mail->addStringAttachment($fxml, utf8_decode($data['Empresa']['ruc']).'-'.$data['ser_doc'].'-'.$data['nro_doc'].'.XML');
            
            //$mail->addStringAttachment($pdfdoc, 'my-doc.pdf');
            $mail->AddStringAttachment($pdfdoc, utf8_decode($data['Empresa']['ruc']).'-'.$data['ser_doc'].'-'.$data['nro_doc'].'.pdf', 'base64', 'application/pdf');
                
            ## MENSAJE A ENVIAR
            $mail->setFrom('no-responder@alpharest.org.pe', $negocio);
            $mail->addAddress($correo_cliente);

            $mail->isHTML(true);
            $mail->Subject = 'Estimado cliente adjuntamos los documentos electrónicos';
            $mail->Body = 'Gracias por su compra.';

            $mail->send();
            echo json_encode(1);

        } catch (Exception $exception) {
            echo 'Error:', $exception->getMessage();
            echo json_encode(2);
        }
    }
}
