<?php

class SendPseModel
{
    private $company;
    private $token;
    
    public function __construct($company)
    {
        $this->company = $company; 
    }
 
    /**
     * 
     * Autenticar con servicio PSE, asignar token
     *
     * @return void
     */
    public function login()
    {
        $params = [
            'usuario' => $this->company['user_pse'],
            'contraseña' => $this->company['password_pse']
        ];

        $response = $this->sendRequest($this->company['url_login_pse'], $params);

        $this->token = isset($response['token']) ? $response['token'] : null;

        if(!$this->token)
        {
            $this->throwException("Error al autenticar con PSE: ".$response['mensaje'] ?? '');
        }
    }

    
    /**
     * 
     * Enviar cdr al PSE
     *
     * @param  $cdr_zip
     * @param  $document
     * @return void
     */
    public function sendCdr($cdr_zip, $document)
    {
        
        if(!$this->token) $this->login();

        $archivo = base64_encode(file_get_contents($cdr_zip.'.XML'));
        $params = [
            'nombre_archivo_xml' => $document['filename'],
            'nombre_archivo_cdr' => 'R-'.$document['filename'],
            'archivo' => $archivo,
        ];

        $response = $this->sendRequest($this->company['url_send_cdr_pse'], $params);
        
        if(!$response['correcto']) $this->throwException("Documento: {$document['filename']} - {$response['mensaje']}");
        
        $resp['respuesta'] = 'ok';
        $resp['mensaje_pse_cdr'] = $response['mensaje'];

        return $resp;
        
    }

    
    /**
     * 
     * Enviar xml a PSE para agregar firma digital
     *
     * @param  string $xmlUnsigned
     * @param  $document
     * @return string
     */
    public function signXml($xmlUnsigned, $document)
    {
        if(!$this->token) $this->login();

        $archivo = base64_encode(file_get_contents($xmlUnsigned.'.XML'));
        $params = [
            'ruc_emisor' => $this->company['ruc'],
            'tipo_doc_procesar' => $document['tipo_doc_procesar'],
            'nombre_archivo_xml' => $document['filename'],
            'archivo' => $archivo,
        ];

        $response = $this->sendRequest($this->company['url_signature_pse'], $params);

        if(!$response) $this->throwException('Error al firmar xml (error desconocido).');

        if(!$response['correcto']) $this->throwException("Documento: {$document['filename']} - {$response['mensaje']}");

        $xmlSigned = base64_decode($response['archivo']);
        
        $doc = new DOMDocument();
        $doc->loadXML($xmlSigned);

        $hash_cpe = $doc->getElementsByTagName('DigestValue')->item(0)->nodeValue;

        $doc->save($xmlUnsigned . '.XML');

        $resp['respuesta'] = 'ok';
        $resp['mensaje_pse'] = $response['mensaje'];
        $resp['hash_cpe'] = $hash_cpe;
        return $resp;
    }

    /**
     * 
     * Realizar petición a api PSE
     *
     * @param  string $url
     * @param  array $params
     * @return array
     */
    private function sendRequest($url, $params)
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($params),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer '.$this->token
            )
        ));
        
        $response = curl_exec($curl);

        if($response === false) $this->throwException('Error desconocido: '.curl_error($curl));
         
        curl_close($curl);

        return json_decode($response, true);

    }


    public function throwException($message)
    {
        throw new Exception($message);
    }
 
}