<?php
require_once ('public/lib/print/num_letras.php');
require_once ('public/lib/pdf/cellfit.php');

class FPDF_CellFiti extends FPDF_CellFit
{
	function AutoPrint($dialog=false)
	{
		//Open the print dialog or start printing immediately on the standard printer
		$param=($dialog ? 'true' : 'false');
		$script="print($param);";
		$this->IncludeJS($script);
	}

	function AutoPrintToPrinter($server, $printer, $dialog=false)
	{
		//Print on a shared printer (requires at least Acrobat 6)
		$script = "var pp = getPrintParams();";
		if($dialog)
			$script .= "pp.interactive = pp.constants.interactionLevel.full;";
		else
			$script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
		$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
		$script .= "print(pp);";
		$this->IncludeJS($script);
	}
}
define('EURO',chr(128));
$pdf = new FPDF_CellFiti('P','mm',array(80,200));
$pdf->AddPage();
$pdf->SetMargins(0,0,0,0);
 
// CABECERA
$pdf->SetFont('Helvetica','',6);
$pdf->Cell(72,4,'',0,1,'C');
$pdf->SetFont('Helvetica','',13);
$pdf->Cell(72,4,'DELIVERY',0,1,'C');
$pdf->Ln(3);
$pdf->SetFont('Helvetica','',9);
$pdf->Cell(72,4,'ENTREGA: '.date('d-m-Y h:i A',strtotime($this->dato->fec_ven)),0,1,'L');
$pdf->MultiCell(72,4,'REPARTIDOR: '.utf8_decode($this->dato->Repartidor->desc_repartidor),0,1,'');
// id_repartidor
//list_repartidor
//NombreRepartidor

$pdf->MultiCell(72,4,'CLIENTE: '.utf8_decode($this->dato->Cliente->nombre),0,1,'');
if($this->dato->Cliente->tipo_cliente == 1){
$pdf->Cell(72,4,utf8_decode(Session::get('diAcr')).': '.utf8_decode($this->dato->Cliente->dni),0,1,'');
}else{
$pdf->Cell(72,4,utf8_decode(Session::get('tribAcr')).': '.utf8_decode($this->dato->Cliente->ruc),0,1,'');
}
$pdf->MultiCell(72,4,'TELEFONO: '.utf8_decode($this->dato->Cliente->telefono),0,1,'');
$pdf->MultiCell(72,4,'DIRECCION: '.utf8_decode($this->dato->Cliente->direccion),0,1,'');
$pdf->MultiCell(72,4,'REFERENCIA: '.utf8_decode($this->dato->Cliente->referencia),0,1,'');
// $pdf->Cell(72,4,'REPARTIDOR: '.utf8_decode($this->dato->repartidor->nombres),0,1,'');
//$pdf->MultiCell(72,4,'REPARTIDOR: '.utf8_decode($this->dato->desc_repartidor),0,1,''); '.$this->dato->mozo->nombres,0,1,'L');

// COLUMNAS
$pdf->SetFont('Helvetica', 'B', 9);
$pdf->Cell(42, 10, 'PRODUCTO', 0);
$pdf->Cell(5, 10, 'CANT.',0,0,'R');
$pdf->Cell(10, 10, 'P.U.',0,0,'R');
$pdf->Cell(15, 10, 'IMP.',0,0,'R');
$pdf->Ln(8);
$pdf->Cell(72,0,'','T');
$pdf->Ln(1);

$total = 0;
foreach($this->dato->Detalle as $d){
$pdf->SetFont('Helvetica', '', 9);

if ($this->dato->activated_pres == '1'){
    $descripcion = $d->Producto->pro_pre;
}else {
    $descripcion = $d->Producto->pro_nom.' '.$d->Producto->pro_pre;
}
$toppings_str = '';
$alto = -4;

if($d->toppings){
	$dsd = str_replace("'", '"', $d->toppings);
	$itemArray = json_decode($dsd, true);
	if (is_array($itemArray)) {
		foreach ($itemArray as $topping => $price) {
			$alto = $alto -8;
			$toppings_str .= "\n * ".$topping . "";
		}
	}
}
$pdf->MultiCell(42,4,utf8_decode($descripcion."".$toppings_str),0,'L'); 

$pdf->Cell(47, -4, $d->cantidad,0,0,'R');
$pdf->Cell(10, -4, $d->precio,0,0,'R');
$pdf->Cell(15, -4, number_format(($d->cantidad * $d->precio),2),0,0,'R');
$pdf->Ln(1);
$total = ($d->cantidad * $d->precio) + $total;
}

if($this->dato->comis_del > 0){
	// $pdf->Ln(4); 
	$pdf->Cell(37, 4, 'DELIVERY', 0);    
	$pdf->Cell(20, 4, '', 0);
	$pdf->Cell(15, 4, '('.number_format(($this->dato->comis_del),2).')',0,0,'R');
	$pdf->Ln(4); 
}
$pdf->Cell(72,0,'','T');
$pdf->Ln(2);
foreach($this->dato->Pagos as $d){ 
	$pdf->Cell(37, 4, $d->nombre, 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, number_format(($d->monto),2),0,0,'R');
	$pdf->Ln(4);
}
if($this->dato->pago_efe_none > 0){
	// $pdf->Cell(72,0,'','T');  
	$pdf->Ln(2);
	$pdf->Cell(37, 4, 'PAGO CON', 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, number_format(($this->dato->pago_efe_none),2),0,0,'R');
	$pdf->Ln(4);
	$pdf->Cell(37, 4, 'VUELTO', 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, number_format(($this->dato->pago_efe_vuelto),2),0,0,'R');
	$pdf->Ln(4);
}

	


	$pdf->Ln(10);

	$pdf->Output('ticket.pdf','i');
?>