<?php
require_once ('public/lib/print/num_letras.php');
require_once ('public/lib/pdf/cellfit.php');
require_once ('public/lib/phpqrcode/qrlib.php');

class FPDF_CellFiti extends FPDF_CellFit
{
	function AutoPrint($dialog=false)
	{
		//Open the print dialog or start printing immediately on the standard printer
		$param=($dialog ? 'true' : 'false');
		$script="print($param);";
		$this->IncludeJS($script);
	}

	function AutoPrintToPrinter($server, $printer, $dialog=false)
	{
		//Print on a shared printer (requires at least Acrobat 6)
		$script = "var pp = getPrintParams();";
		if($dialog)
			$script .= "pp.interactive = pp.constants.interactionLevel.full;";
		else
			$script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
		$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
		$script .= "print(pp);";
		$this->IncludeJS($script);
	}
}

$new_igvrc = ($this->configuracion->com_rc_val > '0')? ((1 + $this->dato->igv)+ ($this->configuracion->com_rc_val / 100) ) : (1 + $this->dato->igv);

$new_igv = (1 + $this->dato->igv);

define('EURO',chr(128));
if($this->configuracion->printer_select == '0'){
	$pdf = new FPDF_CellFiti('P','mm',array(72,350));
	$pdf->AddPage();
	$pdf->SetMargins(0,0,0,0);
}else{
	$pdf = new FPDF_CellFiti('P','mm',array(80,350));
	$pdf->AddPage();
	$pdf->SetMargins(4,0,0,0);
}
// ========== MODELO DE AUTORIZACIÓN POSTERIOR (DGI) - 13 SECCIONES ==========
// 1. Logo del emisor centrado; debajo logo DGI centrado y muy pequeño
$dir_images = __DIR__ . '/../../../../public/images/';
$path_dgi = $dir_images . 'dgi.png';
$path_logo = !empty($this->empresa['logo']) ? ($dir_images . $this->empresa['logo']) : '';
$mostrar_dgi = file_exists($path_dgi);
$mostrar_logo = ($path_logo !== '' && file_exists($path_logo)) && ($this->empresa['pdf_logo'] == '1' || empty($this->empresa['pdf_logo']));
$d_1 = isset($this->configuracion->pdf_logo_alt) ? $this->configuracion->pdf_logo_alt : 25;
$d_2 = isset($this->configuracion->pdf_logo_dim) ? $this->configuracion->pdf_logo_dim : 50;
$ancho_pag = 72;
$y_logo = 2;
$w_dgi_peq = 6; // DGI muy pequeño
if ($mostrar_logo || $mostrar_dgi) {
	if ($mostrar_logo) {
		$x_logo = ($ancho_pag - $d_2) / 2;
		$pdf->Image($path_logo, $x_logo, $y_logo, $d_2, 0);
	}
	$y_despues_logo = $y_logo + 11; // espacio aprox. bajo logo restaurante
	if ($mostrar_dgi) {
		$x_dgi = ($ancho_pag - $w_dgi_peq) / 2;
		$pdf->Image($path_dgi, $x_dgi, $y_despues_logo, $w_dgi_peq, 0);
	}
	$pdf->Cell($ancho_pag, $d_1, '', 0, 1, 'C');
}
$pdf->SetFont('Helvetica','',7);
$pdf->Cell(72,4,'',0,1,'C');

// 2. Información del emisor: RUC, nombre o Razón Social, Dirección
if ($this->empresa['pdf_rz'] == '1' && !empty($this->empresa['razon_social'])) {
	$pdf->SetFont('Helvetica','B',10);
	$pdf->MultiCell(72,4,utf8_decode($this->empresa['razon_social']),0,'C');
}
if ($this->empresa['pdf_nc'] == '1' && !empty($this->empresa['nombre_comercial'])) {
	$pdf->SetFont('Helvetica','B',9);
	$pdf->MultiCell(72,4,utf8_decode($this->empresa['nombre_comercial']),0,'C');
}
if ($this->empresa['pdf_ruc'] == '1' && !empty($this->empresa['ruc'])) {
	$pdf->SetFont('Helvetica','',9);
	$pdf->Cell(72,4,utf8_decode(Session::get('tribAcr')).': '.utf8_decode($this->empresa['ruc']),0,1,'C');
}
if ($this->empresa['pdf_dc'] == '1' && !empty($this->empresa['direccion_comercial'])) {
	$pdf->MultiCell(72,4,utf8_decode($this->empresa['direccion_comercial']),0,'C');
	$pdf->Ln(2);
}else{
	$pdf->Ln(1);
}
if ($this->empresa['pdf_tel'] == '1' && !empty($this->empresa['celular'])) {
	$pdf->Cell(72,4,'TELF: '.utf8_decode($this->empresa['celular']),0,1,'C');
}
$elec = (($this->dato->id_tdoc == 1 || $this->dato->id_tdoc == 2) && $this->empresa['sunat'] == 1) ? 'ELECTRONICA' : '';
if ($elec && (!isset($this->empresa['modo']) || $this->empresa['modo'] != 1)) {
	$pdf->SetFont('Helvetica','',6);
	$pdf->MultiCell(72,4,utf8_decode('FE generada en ambiente de pruebas - sin valor comercial ni fiscal'),0,'C');
	$pdf->SetFont('Helvetica','',7);
}

// 3. Nombre del documento - Si está autorizado: "FACTURA ELECTRÓNICA" o "BOLETA DE VENTA ELECTRÓNICA", sino "COMPROBANTE AUXILIAR"
$w_doc = (isset($this->configuracion->printer_select) && $this->configuracion->printer_select != '0') ? 72 : 68;
$pdf->Ln(2);

// Verificar si el documento FE está autorizado
$doc_fe_autorizado = isset($this->dato->DocumentoFE) && !empty($this->dato->DocumentoFE->cufe) && !empty($this->dato->DocumentoFE->status) && $this->dato->DocumentoFE->status == 'authorized';

if ($this->dato->id_tdoc == 3) {
	$pdf->SetFont('Helvetica','B',8);
	$pdf->MultiCell($w_doc, 3.5, 'FACTURA DE OPERACION INTERNA', 0, 'C');
	$pdf->SetFont('Helvetica','',7);
	$pdf->Cell($w_doc, 4, 'DOCUMENTO NO FISCAL', 0, 1, 'C');
} elseif ($this->dato->id_tdoc == 2) {
	if ($doc_fe_autorizado) {
		// Documento autorizado: solo "FACTURA ELECTRÓNICA"
		$pdf->SetFont('Helvetica','B',7);
		$pdf->MultiCell($w_doc, 3, utf8_decode('FACTURA ELECTRÓNICA'), 0, 'C');
	} else {
		// Documento no autorizado: "COMPROBANTE AUXILIAR DE FACTURA ELECTRÓNICA"
		$pdf->SetFont('Helvetica','B',6);
		$pdf->MultiCell($w_doc, 3, utf8_decode('COMPROBANTE AUXILIAR DE FACTURA ELECTRÓNICA'), 0, 'C');
		$pdf->SetFont('Helvetica','',7);
		$pdf->MultiCell($w_doc, 3, utf8_decode($this->dato->desc_td) . ' ' . $elec, 0, 'C');
	}
} elseif ($this->dato->id_tdoc == 1) {
	if ($doc_fe_autorizado) {
		// Documento autorizado: solo "BOLETA DE VENTA ELECTRÓNICA"
		$pdf->SetFont('Helvetica','B',7);
		$pdf->MultiCell($w_doc, 3, utf8_decode('BOLETA DE VENTA ELECTRÓNICA'), 0, 'C');
	} else {
		// Documento no autorizado: "COMPROBANTE AUXILIAR DE FACTURA ELECTRÓNICA"
		$pdf->SetFont('Helvetica','B',6);
		$pdf->MultiCell($w_doc, 3, utf8_decode('COMPROBANTE AUXILIAR DE FACTURA ELECTRÓNICA'), 0, 'C');
		$pdf->SetFont('Helvetica','',7);
		$pdf->MultiCell($w_doc, 3, utf8_decode('BOLETA DE VENTA ELECTRÓNICA'), 0, 'C');
	}
} else {
	$title = trim($nombre_tdoc !== '' ? $nombre_tdoc : 'DOCUMENTO');
	$pdf->SetFont('Helvetica','B',8);
	$pdf->MultiCell($w_doc, 3.5, strtoupper($title), 0, 'C');
}

// 4. Fecha de emisión, número de factura electrónica, sucursal, punto de facturación (CAJA/PTO FACT)
$pdf->SetFont('Helvetica', 'B', 10);
$pdf->Cell(72,4,'# '.utf8_decode($this->dato->ser_doc).'-'.utf8_decode(str_pad($this->dato->nro_doc, 10, '0', STR_PAD_LEFT)),0,1,'C');
$pdf->SetFont('Helvetica', '', 7);
$pdf->Cell(72,4,'FECHA: '.date('d-m-Y h:i A',strtotime($this->dato->fec_ven)),0,1,'');
$pdf->Cell(72,4,'SUCURSAL: 0000',0,1,'');
$pdf->Cell(72,4,'CAJA/PTO FACT: 001',0,1,'');
$pdf->Ln(1);
if($this->dato->id_tped == 1){
	$pdf->Cell(72,4,utf8_decode('TIPO DE ATENCION').': '.utf8_decode($this->dato->Pedido->desc_salon).' - MESA: '.utf8_decode($this->dato->Pedido->nro_mesa),0,1,'');
}else if ($this->dato->id_tped == 2){
	$pdf->Cell(72,4,'TIPO DE ATENCION: PARA LLEVAR',0,1,'');
}else if ($this->dato->id_tped == 3){
	$pdf->Cell(72,4,'TIPO DE ATENCION: DELIVERY',0,1,'');
}

// 5. Información de quien recibe la factura: RECEPTOR, CLIENTE
$pdf->Cell(72,4,'RECEPTOR: '.($this->dato->Cliente->tipo_cliente == 2 ? utf8_decode($this->dato->Cliente->ruc) : 'Consumidor final'),0,1,'');
$pdf->MultiCell(72,4,'CLIENTE: '.utf8_decode($this->dato->Cliente->nombre),0,1,'');
if($this->dato->Cliente->tipo_cliente == 1){
$pdf->Cell(72,4,utf8_decode('RUC').': '.utf8_decode($this->dato->Cliente->dni),0,1,'');
}else{
$pdf->Cell(72,4,utf8_decode('RUC').': '.utf8_decode($this->dato->Cliente->ruc),0,1,'');
}
$pdf->MultiCell(72,4,'TELEFONO: '.utf8_decode($this->dato->Cliente->telefono),0,1,'');
$pdf->MultiCell(72,4,'DIRECCION: '.utf8_decode($this->dato->Cliente->direccion),0,1,'');
$pdf->MultiCell(72,4,'REFERENCIA: '.utf8_decode($this->dato->Cliente->referencia),0,1,'');
if ($this->dato->id_tped == 2){
	if($this->dato->Llevar->nombre_cliente != 'CLIENTE VARIOS'){
		$pdf->MultiCell(72,4,'NOMBRE PARA LLEVAR: '.utf8_decode($this->dato->Llevar->nombre_cliente),0,1,'');
	}
}
$pdf->MultiCell(72,4,'ID PEDIDO: '.utf8_decode($this->dato->id_ped),0,1,'');

// 6. Código, descripción, cantidad, P.U., descuento por ítem, monto (DESC antes de MONTO)
$pdf->SetFont('Helvetica', 'B', 7);
$pdf->Cell(5, 10, 'CANT.',0,0);
$pdf->Cell(32, 10, ($elec ? utf8_decode('DESCRIPCIÓN') : 'PRODUCTO'), 0,0,'C');
$pdf->Cell(10, 10, 'P.U.',0,0,'R');
$pdf->Cell(10, 10, utf8_decode('DESC.'),0,0,'C');
$pdf->Cell(15, 10, ($elec ? 'MONTO' : 'IMP.'),0,0,'R');
$pdf->Ln(8);
$linea_de_guiones = str_repeat('-', 84); // Cambia el número 5 por la cantidad de guiones que desees
$pdf->Cell(72, 0, $linea_de_guiones, 0, 1, 'L');
// $pdf->Cell(72,0,'','T');
$pdf->Ln(1);
 

// PRODUCTOS
$total = 0;
$total_ope_gravadas = 0;
$total_igv_gravadas = 0;
$total_ope_exoneradas = 0;
$total_igv_exoneradas = 0;

foreach($this->dato->Detalle as $d){

	if($d->codigo_afectacion == '10'){
        $total_ope_gravadas = $total_ope_gravadas + $d->valor_venta;
        $total_igv_gravadas = $total_igv_gravadas + $d->total_igv;
        $total_ope_exoneradas = $total_ope_exoneradas + 0;
        $total_igv_exoneradas = $total_igv_exoneradas + 0;
    } else{
        $total_ope_gravadas = $total_ope_gravadas + 0;
        $total_igv_gravadas = $total_igv_gravadas + 0;
        $total_ope_exoneradas = $total_ope_exoneradas + $d->valor_venta;
        $total_igv_exoneradas = $total_igv_exoneradas + $d->total_igv;
    }

	$descripcion = $d->nombre_producto;
	$toppings_str = '';
	$alto = -4;

	if($d->toppings){
		$dsd = str_replace("'", '"', $d->toppings);
		$itemArray = json_decode($dsd, true);
		if (is_array($itemArray)) {
			foreach ($itemArray as $topping => $price) {
				$alto = $alto -8;
				$toppings_str .= "\n * ".$topping . "";
			}
		}
	}

	if ($this->dato->consumo == '0') {
	$descuento_item = isset($d->descuento_item) ? floatval($d->descuento_item) : 0;
	$subtotal_linea = $d->cantidad * $d->precio_unitario;
	$monto_linea = $subtotal_linea - $descuento_item;
	if ($monto_linea < 0) $monto_linea = 0;
	$pdf->SetFont('Helvetica', '', 7);
	$pdf->Cell(10, 4, $d->cantidad,0,0,'L');
	$pdf->MultiCell(32,4,utf8_decode($descripcion."".$toppings_str),0,'L'); 
	$pdf->Cell(47, $alto, $d->precio_unitario,0,0,'R');
	$pdf->Cell(10, $alto, ($descuento_item > 0 ? number_format($descuento_item, 2) : '-'),0,0,'C');
	$pdf->Cell(15, $alto, ($elec ? 'B/. ' : '').number_format($monto_linea, 2),0,0,'R');
	$pdf->Ln(1);
	}

	if($d->cantidad > 0){
		$total = ($d->cantidad * $d->precio_unitario) + $total;
	}
}
if ($this->dato->consumo == '1') {
	$pdf->SetFont('Helvetica', '', 7);
	$pdf->Cell(10, 4, '1',0,0,'L');
	$pdf->MultiCell(32,4,utf8_decode($this->dato->consumo_desc),0,'L'); 
	$pdf->Cell(47, -4, $this->dato->total,0,0,'R');
	$pdf->Cell(10, -4, '-',0,0,'C');
	$pdf->Cell(15, -4, ($elec ? 'B/. ' : '').number_format(($this->dato->total),2),0,0,'R');
	$pdf->Ln(1);
}
// 7. Valores y cantidades totales, forma de pago y vuelto (SUBTOTAL, ITBMS, TOTAL)
$sbt = (($this->dato->total + $this->dato->comis_tar + $this->dato->comis_del - $this->dato->desc_monto) / $new_igv);
$igv = ($sbt * $this->dato->igv);
$pdf->SetFont('Helvetica', '', 7);
$pdf->Cell(72,0,'-----------------------------------------------------------------------------------',0,1,'C');
if($this->dato->id_tdoc == 1 || $this->dato->id_tdoc == 2){
    $pdf->Ln(0);
    $pdf->Cell(37, 10, 'SUBTOTAL', 0);    
    $pdf->Cell(20, 10, '', 0);
    $tasa_igv = floatval($this->dato->igv);
    $total_mas_del = ($this->dato->total) + $this->dato->comis_del;
    if ($total_ope_gravadas > 0) {
        $igvv = $new_igvrc;
        $new_subtotal_val = $total_mas_del / $igvv;
    } else {
        $new_subtotal_val = ($tasa_igv > 0) ? ($total_mas_del / (1 + $tasa_igv)) : $total_mas_del;
    }
    $new_subtotal = number_format($new_subtotal_val, 2, '.', '');
    $pdf->Cell(15, 10, 'B/. '.$new_subtotal,0,0,'R');
    
    $pdf->Ln(4);
    if ($tasa_igv > 0) {
    $itbms_monto = $total_mas_del - $new_subtotal_val;
    if ($itbms_monto < 0) $itbms_monto = 0;
    $pdf->Cell(37, 10, 'ITBMS '.round($tasa_igv * 100).'%', 0);   
    $pdf->Cell(20, 10, '', 0);
    $pdf->Cell(15, 10, 'B/. '.number_format($itbms_monto, 2),0,0,'R'); 
    } 
}

if($this->dato->desc_monto > 0){
$pdf->Ln(4); 
$pdf->Cell(37, 10, 'DESCUENTO', 0);    
$pdf->Cell(20, 10, '', 0);
$pdf->Cell(15, 10, '-'.number_format(($this->dato->desc_monto),2),0,0,'R');

}
if($this->dato->comis_del > 0){
$pdf->Ln(4); 
$pdf->Cell(37, 10, 'DELIVERY', 0);    
$pdf->Cell(20, 10, '', 0);
$pdf->Cell(15, 10, '('.number_format(($this->dato->comis_del),2).')',0,0,'R');

}

if($this->dato->comis_rc > 0){
$pdf->Ln(4); 
$datorc = ($this->dato->rc > 0) ? ($this->dato->rc*100) : $this->configuracion->com_rc_val;
$pdf->Cell(37, 10, 'REC. CONS. '.$datorc.'%', 0);   
$pdf->Cell(20, 10, '', 0);
$pdf->Cell(15, 10, '('.number_format(($this->dato->comis_rc),2).')',0,0,'R');

}	
$pdf->Ln(4); 
$pdf->SetFont('Helvetica', 'B', 7);
$pdf->Cell(37, 10, 'TOTAL', 0);    
$pdf->Cell(20, 10, '', 0);
$pdf->Cell(15, 10, 'B/. '.number_format(($this->dato->total + $this->dato->comis_del),2),0,0,'R');	
$pdf->Ln(8);

$pdf->Ln(2);
$pdf->SetFont('Helvetica', '', 7);
$pdf->MultiCell(72,4,'SON: '.numtoletras($this->dato->total + $this->dato->comis_del),0,'L');
$pdf->Ln(2);

foreach($this->dato->Pagos as $d){ 
	$pdf->Cell(37, 4, utf8_decode($d->nombre), 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, 'B/. '.number_format(($d->monto),2),0,0,'R');
	$pdf->Ln(4);
}

if($this->dato->propina > 0){
	// $pdf->Ln(2);
	$pdf->SetFont('Helvetica', 'B', 7);
	$pdf->Ln(2);
	$pdf->Cell(37, 4, 'PROPINA', 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, number_format(($this->dato->propina),2),0,0,'R');
	$pdf->Ln(5);
}

if($this->dato->pago_efe_none > 0){
	// $pdf->Cell(72,0,'','T');  
	$linea_de_guiones = str_repeat('-', 84); // Cambia el número 5 por la cantidad de guiones que desees
	$pdf->Cell(72, 0, $linea_de_guiones, 0, 1, 'L');
	$pdf->Ln(2);
	$pdf->Cell(37, 4, 'PAGO CON', 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, 'B/. '.number_format(($this->dato->pago_efe_none),2),0,0,'R');
	$pdf->Ln(4);
	$pdf->Cell(37, 4, 'VUELTO', 0);   
	$pdf->Cell(20, 4, '',0,0,'R');
	$pdf->Cell(15, 4, 'B/. '.number_format(($this->dato->pago_efe_vuelto),2),0,0,'R');
	$pdf->Ln(4);
}

if($this->dato->desc_tipo == 1){
$pdf->Ln(2);
$pdf->Cell(37, 4, 'CORTESIA', 0);   
$pdf->Cell(20, 4, '',0,0,'R');
$pdf->Cell(15, 4, number_format(($this->dato->desc_monto),2),0,0,'R');
}
if($this->dato->desc_tipo == 3){
$pdf->Ln(2);
$pdf->Cell(37, 4, 'CREDITO PERSONAL', 0);   
$pdf->Cell(20, 4, '',0,0,'R');
$pdf->Cell(15, 4, number_format(($this->dato->desc_monto),2),0,0,'R');
}

if($this->dato->comis_tar > 0){
	$pdf->Ln(4);   
	$pdf->Cell(37, 10, 'COM.TARJETA ('.number_format(($this->dato->comis_tar),2).')', 0);    
	$pdf->Cell(20, 10, '', 0);
	$pdf->Cell(15, 10, number_format(($this->dato->total + $this->dato->comis_del - $this->dato->desc_monto+$this->dato->comis_tar ),2),0,0,'R');
	}

$pdf->Ln(10);

$pdf->SetFont('Helvetica', '', 8);
$pdf->Cell(72,0,utf8_decode('CONDICIÓN DE PAGO: CONTADO'),0,1,'L');
$pdf->Ln(4);
$pdf->Cell(72, 0, utf8_decode('Vendedor: ' .$this->dato->desc_usu), 0, 1, 'L');
$pdf->Ln(4);

$observaciones = $this->dato->observacion;
if ($observaciones) {
    $pdf->Cell(72, 0, utf8_decode('Observaciones: ' .$this->dato->observacion), 0, 1, 'L');  
    $pdf->Ln(4);    
}

// $pdf->Cell(72,0,'','T');

$linea_de_guiones = str_repeat('-', 74);
$pdf->Cell(72, 0, $linea_de_guiones, 0, 1, 'L');

// 8-11. CAFE (si aplica), consulta, CUFE, código QR - Documentos electrónicos (Boleta/Factura)
if(($this->dato->id_tdoc == 1 || $this->dato->id_tdoc == 2) && $this->empresa['sunat'] == 1){
	// Variables para tipo de documento
	$td="";
	$tc="";
	$tdc="";
	if($this->dato->id_tdoc==1){
		$tc="03";
		$tdd="1";
		$tdc=$this->dato->Cliente->dni;
	}
	if($this->dato->id_tdoc==2){
		$tc="01";
		$tdd="6";
		$tdc=$this->dato->Cliente->ruc;
	}
	
	// Verificar si el documento FE está autorizado (tiene CUFE)
	$doc_fe_autorizado = isset($this->dato->DocumentoFE) && !empty($this->dato->DocumentoFE->cufe) && !empty($this->dato->DocumentoFE->status) && $this->dato->DocumentoFE->status == 'authorized';
	$cufe = $doc_fe_autorizado ? $this->dato->DocumentoFE->cufe : '';
	$process_date = $doc_fe_autorizado && !empty($this->dato->DocumentoFE->process_date) ? $this->dato->DocumentoFE->process_date : '';
	$document_uuid = $doc_fe_autorizado && !empty($this->dato->DocumentoFE->document_uuid) ? $this->dato->DocumentoFE->document_uuid : '';
	$pos_fe = $doc_fe_autorizado && !empty($this->dato->DocumentoFE->pos) ? $this->dato->DocumentoFE->pos : '001';
	
	if ($doc_fe_autorizado && $cufe) {
		// 8. CAFE de emisión previa, transmisión para la DGI hasta... (con fecha de process_date)
		if ($process_date) {
			$pdf->SetFont('Helvetica','',6);
			$fecha_proceso = date('d/m/Y H:i:s', strtotime($process_date));
			$pdf->MultiCell(72,4,utf8_decode('CAFE de emisión previa, transmisión para la DIRECCIÓN GENERAL DE INGRESOS hasta ' . $fecha_proceso),0,'L');
			$pdf->SetFont('Helvetica','',7);
			$pdf->Ln(2);
		}
		
		// 9. Dirección web para consulta digital del documento (usando el CUFE)
		$url_consulta_base = 'https://dgi-fep.mef.gob.pa/consultas';
		$pdf->SetFont('Helvetica','',6);
		$pdf->MultiCell(72,3,utf8_decode('Consulte en: ' . $url_consulta_base),0,'L');
		$pdf->Ln(1);
		
		// 10. Código Único de Facturación Electrónica (CUFE). O escaneando el código QR
		$pdf->SetFont('Helvetica','B',7);
		$pdf->MultiCell(72,4,utf8_decode('usando el CUFE:'),0,'L');
		$pdf->SetFont('Helvetica','',6);
		$pdf->MultiCell(72,3,utf8_decode($cufe),0,'L');
		$pdf->SetFont('Helvetica','',7);
		$pdf->MultiCell(72,4,utf8_decode('O escaneando el código QR'),0,'C');
		$pdf->Ln(2);
		
		// 11. Código QR (apuntar a la URL de descarga del PDF de FacturaFacil)
		$id_documento_fe = isset($this->dato->DocumentoFE->id_documento_fe) ? $this->dato->DocumentoFE->id_documento_fe : 0;
		if ($id_documento_fe > 0) {
			$url_pdf_qr = URL . 'facturacion/documentos_descargar_pdf?id=' . $id_documento_fe;
			// Nombre único del QR incluyendo id_documento_fe para evitar conflictos
			$nombreqr = 'FE_' . $id_documento_fe . '_' . $tc . "-" . $td . $this->dato->ser_doc . "-" . $this->dato->nro_doc;
			$ruta_qr = 'api_fact/UBL21/archivos_xml_sunat/imgqr/QR_' . $nombreqr . '.png';
			// Regenerar QR siempre para asegurar que apunte a la URL correcta
			QRcode::png($url_pdf_qr, $ruta_qr, 'Q', 15, 0);
		} else {
			// Fallback si no hay id_documento_fe
			$nombreqr = $tc . "-" . $td . $this->dato->ser_doc . "-" . $this->dato->nro_doc;
			$ruta_qr = 'api_fact/UBL21/archivos_xml_sunat/imgqr/QR_' . $nombreqr . '.png';
			if (!file_exists($ruta_qr)) {
				$text_qr = $this->empresa['ruc'] . '|' . $tc . '|' . $this->dato->ser_doc . '|' . $this->dato->nro_doc .'|'.number_format(($total_igv_gravadas + $total_igv_exoneradas),2).'|'.number_format(($this->dato->total),2).'|'.date('Y-m-d',strtotime($this->dato->fec_ven)).'|'. $tdd . '|' . $tdc . '|'.(isset($cufe) ? $cufe : '');
				QRcode::png($text_qr, $ruta_qr, 'Q', 15, 0);
			}
		}
		if (file_exists($ruta_qr)) {
			$x_qr = ($ancho_pag - 25) / 2;
			$pdf->Image($ruta_qr, $x_qr, $pdf->GetY(), 25, 0);
			$pdf->Ln(28);
		}
		
		// 12. Información adicional (SystemRef, ConfirmationNbr, DocBarcode)
		$pdf->SetFont('Helvetica','',6);
		$pdf->Cell(72,4,'SystemRef: '.utf8_decode($this->dato->ser_doc).'-'.utf8_decode($pos_fe).'-'.utf8_decode(str_pad($this->dato->nro_doc, 10, '0', STR_PAD_LEFT)),0,1,'L');
		if ($document_uuid) {
			$pdf->Cell(72,4,'ConfirmationNbr: '.utf8_decode($document_uuid),0,1,'L');
		}
		$pdf->Cell(72,4,'DocBarcode: '.utf8_decode(substr($cufe, 0, 50)),0,1,'L');
		$pdf->SetFont('Helvetica','',7);
		$pdf->Ln(2);
		
		// 13. Información del PAC: Razón Social, RUC, Proveedor Autorizado Calificado, Resolución y Fecha
		$pdf->SetFont('Helvetica','',6);
		$pdf->MultiCell(72,4,utf8_decode('Documento validado por FACTURA FÁCIL, S.A. con RUC 155723374-2-2022, es Proveedor Autorizado Calificado, Resolución No. 201-2167 de 21/03/2023.'),0,'C');
		$pdf->SetFont('Helvetica','',7);
	} else {
		// Si no está autorizado, mostrar mensaje genérico
		$pdf->SetFont('Helvetica','',6);
		$pdf->MultiCell(72,4,utf8_decode('CAFE de emisión previa, transmisión para la DIRECCIÓN GENERAL DE INGRESOS hasta la fecha indicada en consulta.'),0,'L');
		$pdf->SetFont('Helvetica','',7);
		$pdf->Ln(2);
		$pdf->MultiCell(72,4,'Consulte en '.URL.'consulta '.utf8_decode('usando el CUFE'),0,'C');
		$pdf->Ln(1);
		$pdf->SetFont('Helvetica','B',7);
		$pdf->MultiCell(72,4,utf8_decode('Código Único de Facturación Electrónica (CUFE)'),0,'C');
		$pdf->SetFont('Helvetica','',7);
		$pdf->MultiCell(72,4,utf8_decode('O escaneando el código QR'),0,'C');
		$pdf->Ln(2);
		
		// QR básico sin CUFE
		$nombreqr=$tc."-".$td.$this->dato->ser_doc."-".$this->dato->nro_doc;
		$text_qr = $this->empresa['ruc'] . '|' . $tc . '|' . $this->dato->ser_doc . '|' . $this->dato->nro_doc .'|'.number_format(($total_igv_gravadas + $total_igv_exoneradas),2).'|'.number_format(($this->dato->total),2).'|'.date('Y-m-d',strtotime($this->dato->fec_ven)).'|'. $tdd . '|' . $tdc . '|'.(isset($this->dato->hash_cdr) ? $this->dato->hash_cdr : '');
		$ruta_qr = 'api_fact/UBL21/archivos_xml_sunat/imgqr/QR_' . $nombreqr . '.png';
		$qr = 'api_fact/UBL21/archivos_xml_sunat/imgqr/QR_' . $nombreqr . '.png';
		if (!file_exists($ruta_qr)) {
			QRcode::png($text_qr, $qr, 'Q', 15, 0);
		}
		$pdf->Cell(25, 10, $pdf->Image($ruta_qr, 2, $pdf->GetY(), 20), 0); 
		$pdf->MultiCell(47,4,utf8_decode('Autorizado mediante la resolución Nro. 0180050001388/DGI'),0,'C');	
		$pdf->Cell(25, 10,' ',0);
		$pdf->MultiCell(47,4,utf8_decode('Representación impresa de la '.$this->dato->desc_td).' '.$elec.' consulte en',0,'C');
		$pdf->Ln(2);
		$pdf->SetFont('Helvetica','',6);
		$pdf->Cell(72,4,'SystemRef: '.utf8_decode($this->dato->ser_doc).'-001-'.utf8_decode(str_pad($this->dato->nro_doc, 10, '0', STR_PAD_LEFT)),0,1,'L');
		if (!empty($this->dato->hash_cdr)) {
			$pdf->Cell(72,4,'ConfirmationNbr: '.utf8_decode($this->dato->hash_cdr),0,1,'L');
		}
		$pdf->Cell(72,4,'DocBarcode: ',0,1,'L');
		$pdf->SetFont('Helvetica','',7);
		$pdf->Ln(2);
		$pdf->SetFont('Helvetica','',6);
		$pdf->MultiCell(72,4,utf8_decode('Documento validado por Factura Fácil S.A con RUC 155723374-2-2022, es Proveedor Autorizado Calificado, Resolución No. 201-2157 de 14/03/2023.'),0,'C');
		$pdf->SetFont('Helvetica','',7);
	}
}

$pdf->Ln(4);

if(($this->dato->id_tped == 1 && $this->configuracion->mesa_ticket_desp == '1') || ($this->dato->id_tped == 2 &&$this->configuracion->llevar_ticket_desp == '1') | ($this->dato->id_tped == 3 && $this->configuracion->delivery_ticket_desp == '1')){
	// ticket DESPACHO VENTA RAPIDO
	$pdf->AddPage();
	if($this->configuracion->printer_select == '0'){
		$pdf->SetMargins(0,0,0,0);
	}else{
		$pdf->SetMargins(4,0,0,0);
	}	
	// $pdf->Ln(3);
	$pdf->SetFont('Courier','',7);
	$pdf->Cell(72,4,'',0,1,'C');
	// $pdf->Cell(60,4,'-----------------------------------------',0,1,'C');
	$pdf->SetFont('Helvetica','',10);
	$pdf->Cell(60,4,'TICKET DESPACHO',0,1,'C');
	$pdf->Ln(2);
	$pdf->SetFont('Helvetica','',9);

	if($this->dato->id_tped == 1){
		$pdf->Cell(72,4,utf8_decode('PEDIDO NRO:').': '.utf8_decode($this->dato->Pedido->desc_salon).' - MESA: '.utf8_decode($this->dato->Pedido->nro_mesa),0,1,'');
	}else if ($this->dato->id_tped == 2){
		$pdf->Cell(60,4,'PEDIDO NRO:    LL- '.utf8_decode($this->dato->Llevar->nro_pedido),0,1,'C');
	}else if ($this->dato->id_tped == 3){
		$pdf->Cell(60,4,'PEDIDO NRO:    DEL- '.utf8_decode($this->dato->Delivery->nro_pedido),0,1,'C');
		// $pdf->Cell(72,4,'TIPO DE ATENCION: DELIVERY',0,1,'');
	}

	// $pdf->Cell(60,4,'PEDIDO NRO:    PD-'.utf8_decode($this->dato->TicketDespacho->nro_pedido),0,1,'C');
	$pdf->SetFont('Courier','',7);
	$pdf->Cell(60,4,'-----------------------------------------',0,1,'C');
	$pdf->SetFont('Helvetica','',8);
	$pdf->Cell(60,4,'CLIENTE',0,1,'C');
	$pdf->MultiCell(60,4,'NOMBRE: '.utf8_decode($this->dato->Cliente->nombre),0,1,'');
	$pdf->MultiCell(60,4,'DIRECCION: '.utf8_decode($this->dato->Cliente->direccion),0,1,'');
	$pdf->MultiCell(60,4,'REFERENCIA: '.utf8_decode($this->dato->Cliente->referencia),0,1,'');
	$pdf->SetFont('Courier','',7);
	$pdf->Cell(60,4,'-----------------------------------------',0,1,'C');
	// COLUMNAS
	$pdf->SetFont('Helvetica', 'B', 7);
	$pdf->Cell(10, 4, 'CANT.',0,0,'L');
	$pdf->Cell(60, 4, 'PRODUCTO', 0,0,'L');
	$pdf->Ln(3);
	$pdf->SetFont('Courier','',7);
	$pdf->Cell(60,4,'-----------------------------------------',0,1,'C');
	$pdf->Ln(1);

	$total = 0;
	foreach($this->dato->Detalle as $d){

		$pdf->SetFont('Helvetica', '', 6);
		$pdf->Cell(10, 4, $d->cantidad,0,0,'L');
		$pdf->MultiCell(50,4,utf8_decode($d->nombre_producto),0,'L'); 
		$pdf->Ln(1);
	}
	$pdf->SetFont('Courier','',7);
	$pdf->Cell(60,4,'-----------------------------------------',0,1,'C');
	$pdf->SetFont('Helvetica', '', 7);

	$pdf->SetFont('Courier','',7);
	$pdf->Cell(60,4,'-----------------------------------------',0,1,'C');
	$pdf->SetFont('Helvetica', '', 8);
}


//$pdf->Output('ticket.pdf','F');
// $pdf->Cell(72,4,,0,1,'C');
$pdf->Output(utf8_decode($this->dato->ser_doc).'-'.utf8_decode($this->dato->nro_doc).'.pdf','I');
?>