$(function() {
    $('#informes').addClass("active");
    moment.locale('es');

	listar();

    $('#start').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#start, #end').change( function() {
        listar();

    });

    $('#filtro_zonas').change( function() {
        zonas();
        listar();
    });   
    $('#filtro_mesas').change( function() {
        // zonas();
        listar();
    });         

    /* BOTON DATATABLES */
    var org_buildButton = $.fn.DataTable.Buttons.prototype._buildButton;
    $.fn.DataTable.Buttons.prototype._buildButton = function(config, collectionButton) {
    var button = org_buildButton.apply(this, arguments);
    $(document).one('init.dt', function(e, settings, json) {
        if (config.container && $(config.container).length) {
           $(button.inserter[0]).detach().appendTo(config.container)
        }
    })    
    return button;
    }
});

var listar = function(){
    
    var moneda = $("#moneda").val();
    var ifecha = $("#start").val();
    var ffecha = $("#end").val();
    filtro_zona = $("#filtro_zonas").selectpicker('val');
    filtro_mesas = $("#filtro_mesas").selectpicker('val');

	var	table =	$('#table')
	.DataTable({
        buttons: [
            {
                extend: 'excel', sheetName: 'Mes: ' +  $('#start').val() + ' al ' + $('#end').val(), title: 'Reporte de mesas y salones', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-excel"></i> Descargar en excel', titleAttr: 'Descargar Excel',
                container: '#excel', exportOptions: { columns: [0,1,2,3] }
            },
            {
                extend: 'pdf', title: 'Reporte de mesas y salones', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-pdf"></i> Descargar en pdf', titleAttr: 'Descargar Pdf',
                container: '#pdf', exportOptions: { columns: [0,1,2,3] }, orientation: 'landscape', 
                customize : function(doc){ 
                    doc.styles.tableHeader.alignment = 'left'; 
                    doc.content[1].table.widths = [60,'*','*','*','*'];
                }
            }
        ],        

		"destroy": true,
		"dom": "tip",
		"bSort": true,
		"ajax":{
			"method": "POST",
			"url": $('#url').val()+"informe/reporte_mesas_salones_list",
			"data": {
                ifecha: ifecha,
                ffecha: ffecha,
                filtro_zona :  filtro_zona,
                filtro_mesas :  filtro_mesas
            }
		},
		"columns":[
            {"data":"desc_salon"},
            {"data":"nro_mesa"},
            // {"data":"fecha_nac"},
            {"data":"cantidad_ventas"},            
            {"data":"total_ventas"},
            // {"data":"direccion"},
		], 
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            total_atendidos = api
            .column(2 /*, { search: 'applied', page: 'current'} */)
            .data()
            .reduce( function (a, b) {
                return intVal(a) + intVal(b);
            }, 0 );

            total = api
                .column(3 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            $('.operaciones').text(formatNumber(total_atendidos));
            $('.venta').text(moneda+' '+formatNumber(total));
        }        
        
	});
}

var zonas = function(){
    $('#filtro_mesas').find('option').remove();
    $('#filtro_mesas').append("<option value='%' active>Mostrar todo</option>").selectpicker('refresh');
    $.ajax({
        type: "POST",
        url: $('#url').val()+"informe/zonas_mesas2",
        data: {
            cod: $("#filtro_zonas").selectpicker('val')
        },
        dataType: "json",
        success: function(data){
            $('#filtro_mesas').append('<optgroup>');
            $.each(data, function (index, value) {
                $('#filtro_mesas').append("<option value='" + value.id_mesa + "'>" + value.nro_mesa + "</option>").selectpicker('refresh');            
            });
            $('#filtro_mesas').append('</optgroup>');
            $('#filtro_mesas').prop('disabled', false);
            $('#filtro_mesas').selectpicker('refresh');
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        } 
    });
}