<?php
/**
 * Comprobante auxiliar de factura electrónica - Formato reglamentario Panamá (DGI)
 * Modelo de Autorización Posterior - 13 secciones según DGI:
 *  1. Logos de DGI y del emisor (DGI pequeño, alineado a la izquierda)
 *  2. Información del emisor: RUC, nombre o Razón Social, Dirección
 *  3. Nombre del documento "Comprobante Auxiliar de Factura Electrónica" y tipo de documento
 *  4. Fecha de emisión, número de factura electrónica y punto de facturación (Sucursal, Caja/PTO FACT)
 *  5. Información de quien recibe la factura: RUC, Nombre o Razón Social, Dirección / Consumidor final
 *  6. Código, descripción, cantidad, valor unitario, ITBMS, valor del ítem
 *  7. Valores y cantidades totales, forma de pago y vuelto
 *  8. CAFE de emisión previa, transmisión para la DGI hasta dd/mm/aaaa hh:mm:ss
 *  9. Dirección web para consulta digital del documento (usando el CUFE)
 * 10. Código Único de Facturación Electrónica (CUFE). O escaneando el código QR
 * 11. Código QR
 * 12. Información adicional (SystemRef, ConfirmationNbr, DocBarcode)
 * 13. Información del PAC: Razón Social, RUC, Proveedor Autorizado Calificado, Resolución y Fecha
 */
$doc = isset($this->doc) ? $this->doc : array();
$empresa = isset($this->empresa) ? $this->empresa : array();
$url_pdf = isset($this->url_pdf) ? $this->url_pdf : '';
$qr_base64 = isset($this->qr_base64) ? $this->qr_base64 : '';
$url_base = isset($this->url_base) ? $this->url_base : '';

$serie = isset($doc['serie_electronica']) ? $doc['serie_electronica'] : '';
$numero = isset($doc['fd_number']) ? str_pad($doc['fd_number'], 10, '0', STR_PAD_LEFT) : '';
$fecha_emi = isset($doc['fecha_creacion']) ? date('d/m/Y h:i A', strtotime($doc['fecha_creacion'])) : '';
$ambiente = (isset($doc['environment']) && $doc['environment'] == 1) ? 'producción' : 'pruebas';
$tipo_doc = isset($doc['document_type']) ? $doc['document_type'] : 'FAC';
$nomb_tipo = array('FAC' => 'Factura de Operación Interna', 'NTC' => 'Nota de Crédito', 'NTD' => 'Nota de Débito');
$tipo_label = isset($nomb_tipo[$tipo_doc]) ? $nomb_tipo[$tipo_doc] : $tipo_doc;
$receptor = isset($doc['receptor_name']) ? htmlspecialchars($doc['receptor_name']) : 'Consumidor final';
$receptor_tipo = (isset($doc['receptor_type']) && $doc['receptor_type'] == '02') ? 'Consumidor final' : (isset($doc['receptor_ruc']) ? $doc['receptor_ruc'] : 'Consumidor final');
$total = isset($doc['total']) ? number_format(floatval($doc['total']), 2) : '0.00';
$cufe = isset($doc['cufe']) ? $doc['cufe'] : '';
$process_date = isset($doc['process_date']) ? $doc['process_date'] : '';
$pos = isset($doc['pos']) ? $doc['pos'] : '001';
$sucursal = '0000';

$ruc_empresa = isset($empresa['ruc']) ? $empresa['ruc'] : '';
$dv_empresa = '';
if (preg_match('/\s*DV\s*(\d+)/i', $ruc_empresa, $m)) { $dv_empresa = ' DV ' . $m[1]; $ruc_empresa = trim(preg_replace('/\s*DV\s*\d+/i', '', $ruc_empresa)); }
$nombre_comercial = isset($empresa['nombre_comercial']) ? htmlspecialchars($empresa['nombre_comercial']) : (defined('NAME_NEGOCIO') ? NAME_NEGOCIO : '');
$razon_social = isset($empresa['razon_social']) ? htmlspecialchars($empresa['razon_social']) : $nombre_comercial;
$direccion_empresa = isset($empresa['direccion_comercial']) ? htmlspecialchars($empresa['direccion_comercial']) : (isset($empresa['direccion_fiscal']) ? $empresa['direccion_fiscal'] : '');
$telefono_empresa = isset($empresa['celular']) ? $empresa['celular'] : '';

$items = isset($doc['items']) ? $doc['items'] : array();
$payments = isset($doc['payments']) ? $doc['payments'] : array();

// ITBMS % desde el documento: tax_code 01=7%, 02=10%, 03=15% (alineado con imp_venta_all / configuración)
$itbms_pct = 10;
foreach ($items as $it) {
    $code = isset($it['tax_code']) ? trim($it['tax_code']) : '';
    if ($code === '01') { $itbms_pct = 7; break; }
    if ($code === '02') { $itbms_pct = 10; break; }
    if ($code === '03') { $itbms_pct = 15; break; }
}

$subtotal = 0;
foreach ($items as $it) { $subtotal += floatval(isset($it['subtotal']) ? $it['subtotal'] : 0); }
$total_imp = 0;
foreach ($items as $it) { $total_imp += floatval(isset($it['total_taxes']) ? $it['total_taxes'] : 0); }
$forma_pago = 'Efectivo';
if (!empty($payments)) {
    $p = $payments[0];
    $tipos = array('01'=>'Crédito','02'=>'Efectivo','03'=>'Tarjeta crédito','04'=>'Tarjeta débito','08'=>'Transferencia','09'=>'Cheque','10'=>'POS','99'=>'Otro');
    $forma_pago = isset($tipos[$p['type']]) ? $tipos[$p['type']] : 'Efectivo';
}

$consulta_dgi = 'https://dg1-fep-test.mef.gob.pa/Consultas';
if ($ambiente === 'producción') $consulta_dgi = 'https://dg1-fep.mef.gob.pa/Consultas';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobante Auxiliar FE - <?php echo $serie; ?>-<?php echo $numero; ?></title>
    <style>
        * { box-sizing: border-box; }
        body { font-family: Arial, sans-serif; font-size: 12px; max-width: 320px; margin: 0 auto; padding: 12px; color: #000; }
        .seccion { margin-bottom: 10px; }
        .center { text-align: center; }
        .bold { font-weight: bold; }
        .small { font-size: 10px; }
        table.items { width: 100%; border-collapse: collapse; font-size: 11px; }
        table.items th { text-align: left; border-bottom: 1px solid #000; padding: 4px 2px; }
        table.items td { padding: 3px 2px; border-bottom: 1px dotted #666; }
        .linea-item { border-bottom: 1px dotted #ccc; padding: 4px 0; }
        .totales { margin-top: 8px; text-align: right; }
        .cufe { word-break: break-all; font-size: 9px; }
        .qr { margin: 8px auto; display: block; }
        .logos-wrap { display: flex; align-items: center; justify-content: flex-start; gap: 12px; flex-wrap: wrap; }
        .logo-dgi { height: 36px; width: auto; }
        .logo-emisor { max-height: 50px; width: auto; margin-left: auto; }
        @media print { body { padding: 0; } .no-print { display: none; } }
    </style>
</head>
<body>
    <!-- 1. Logos de DGI y del emisor (DGI pequeño, alineado a la izquierda) -->
    <div class="seccion logos-wrap">
        <img src="<?php echo $url_base; ?>/public/images/dgi.png" alt="DGI" class="logo-dgi" onerror="this.style.display='none'">
        <?php 
        $logo_path = !empty($empresa['logo']) ? (__DIR__ . '/../../public/images/' . $empresa['logo']) : '';
        if ($logo_path && file_exists($logo_path)) { 
            echo '<img src="' . $url_base . '/public/images/' . htmlspecialchars($empresa['logo']) . '" alt="Logo emisor" class="logo-emisor">';
        } 
        ?>
    </div>

    <!-- 2. Información del emisor -->
    <div class="seccion center">
        <div class="bold"><?php echo $nombre_comercial; ?></div>
        <div><?php echo $razon_social; ?></div>
        <div>RUC: <?php echo $ruc_empresa . $dv_empresa; ?></div>
        <?php if ($ambiente === 'pruebas') { ?>
            <div class="small" style="margin-top:4px;">FE generada en ambiente de pruebas - sin valor comercial ni fiscal</div>
        <?php } ?>
        <?php if ($direccion_empresa) { ?><div><?php echo $direccion_empresa; ?></div><?php } ?>
        <?php if ($telefono_empresa) { ?><div><?php echo $telefono_empresa; ?></div><?php } ?>
    </div>

    <!-- 3. Nombre y tipo de documento -->
    <div class="seccion center">
        <div class="bold">COMPROBANTE AUXILIAR DE FACTURA ELECTRÓNICA</div>
        <div><?php echo $tipo_label; ?></div>
    </div>

    <!-- 4. Fecha de emisión, número, sucursal, punto de facturación -->
    <div class="seccion">
        <div><strong>#<?php echo $serie . '-' . $numero; ?></strong></div>
        <div>FECHA: <?php echo $fecha_emi; ?></div>
        <div>SUCURSAL: <?php echo $sucursal; ?></div>
        <div>CAJA/PTO FACT: <?php echo $pos; ?></div>
    </div>

    <!-- 5. Receptor -->
    <div class="seccion">
        <div>RECEPTOR: <?php echo $receptor_tipo; ?></div>
        <div class="bold">CLIENTE: <?php echo $receptor; ?></div>
        <?php if (!empty($doc['receptor_ruc'])) { ?><div>RUC: <?php echo htmlspecialchars($doc['receptor_ruc']); ?></div><?php } ?>
    </div>

    <!-- 6. Detalle de productos/servicios (con columna DESC para descuento por ítem) -->
    <div class="seccion">
        <table class="items">
            <thead>
                <tr><th>DESCRIPCIÓN</th><th class="center">CANT</th><th class="center">P.U</th><th class="center">DESC.</th><th class="center">MONTO</th></tr>
            </thead>
            <tbody>
                <?php foreach ($items as $it) {
                    $desc = isset($it['description']) ? htmlspecialchars($it['description']) : '';
                    $cant = isset($it['quantity']) ? $it['quantity'] : 1;
                    $pu = isset($it['price']) ? number_format(floatval($it['price']), 2) : '0.00';
                    $desc_item = isset($it['discount']) ? floatval($it['discount']) : 0;
                    $total_item = isset($it['total_item']) ? floatval($it['total_item']) : 0;
                    $monto = number_format($total_item, 2);
                    $tasa = '';
                    if (isset($it['total_taxes']) && floatval($it['total_taxes']) > 0 && isset($it['subtotal']) && floatval($it['subtotal']) > 0) {
                        $tasa = ' (' . $itbms_pct . '%)';
                    }
                ?>
                <tr>
                    <td><?php echo $desc . $tasa; ?></td>
                    <td class="center"><?php echo $cant; ?></td>
                    <td class="center"><?php echo $pu; ?></td>
                    <td class="center"><?php echo $desc_item > 0 ? number_format($desc_item, 2) : '-'; ?></td>
                    <td class="center">B/. <?php echo $monto; ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

    <!-- 7. Totales y forma de pago -->
    <div class="seccion totales">
        <div>SUBTOTAL B/. <?php echo number_format($subtotal, 2); ?></div>
        <?php if ($total_imp > 0) { ?><div>ITBMS <?php echo $itbms_pct; ?>% B/. <?php echo number_format($total_imp, 2); ?></div><?php } ?>
        <div class="bold">TOTAL B/. <?php echo $total; ?></div>
        <div><?php echo $forma_pago; ?> B/. <?php echo $total; ?></div>
    </div>

    <!-- 8. CAFE (modelo autorización posterior) -->
    <?php if ($cufe && $process_date) { ?>
    <div class="seccion small">
        CAFE de emisión previa, transmisión para la DIRECCIÓN GENERAL DE INGRESOS hasta <?php echo date('d/m/Y H:i:s', strtotime($process_date)); ?>
    </div>
    <?php } ?>

    <!-- 9. Dirección web para consulta digital del documento -->
    <?php if ($cufe) { ?>
    <div class="seccion small">
        Consulte en <?php echo $consulta_dgi; ?><br>
        usando el CUFE: <span class="cufe"><?php echo htmlspecialchars($cufe); ?></span>
    </div>
    <?php } ?>

    <!-- 10. CUFE y texto QR -->
    <?php if ($cufe) { ?>
    <div class="seccion center">
        <div class="bold">Código Único de Facturación Electrónica (CUFE)</div>
        <div class="cufe"><?php echo htmlspecialchars($cufe); ?></div>
        <div>O escaneando el código QR</div>
    </div>
    <?php } ?>

    <!-- 11. Código QR (redirige al PDF del documento) -->
    <?php if ($qr_base64) { ?>
    <div class="seccion center">
        <img src="<?php echo $qr_base64; ?>" alt="QR" class="qr" width="120" height="120">
        <div class="small">Escanea para ver el PDF del documento</div>
    </div>
    <?php } ?>

    <!-- 12. Información adicional (SystemRef, ConfirmationNbr, DocBarcode) -->
    <div class="seccion small">
        <div>SystemRef: <?php echo $serie; ?>-<?php echo $pos; ?>-<?php echo $numero; ?></div>
        <?php if (!empty($doc['document_uuid'])) { ?><div>ConfirmationNbr: <?php echo $doc['document_uuid']; ?></div><?php } ?>
        <div>DocBarcode: <?php echo $cufe ? htmlspecialchars(substr($cufe, 0, 50)) : ''; ?></div>
    </div>

    <!-- 13. Información del PAC: Razón Social, RUC, Proveedor Autorizado Calificado, Resolución y Fecha -->
    <div class="seccion small center">
        Documento validado por Factura Fácil S.A con RUC 155723374-2-2022, es Proveedor Autorizado Calificado, Resolución No. 201-2157 de 14/03/2023.
    </div>

    <script>
    (function() {
        window.onload = function() {
            window.print();
        };
        window.onafterprint = function() {
            window.close();
        };
    })();
    </script>
</body>
</html>
