$(function() {
	$('#form-proveedor').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
            dni: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-dni").text()+' debe tener '+$("#dni").attr("maxlength")+' digitos'
                    }
                }
            },
            ruc: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-ruc").text()+' debe tener '+$("#ruc").attr("maxlength")+' digitos'
                    }
                }
            }
        }
    }).on('success.form.fv', function(e) {

        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
        var parametros = {
            "tipo_prov" : $("input[name='tipo_prov']").val(),
            "dni" : $("input[name='dni']").val(),
            "ruc" : $("input[name='ruc']").val(),
            "nombres" : $("input[name='nombres']").val(),
            "razon_social" : $("input[name='razon_social']").val(),
            "direccion" : $("input[name='direccion']").val(),
            "telefono" : $("input[name='telefono']").val(),
            "contacto" : $("input[name='contacto']").val(),
            "email" : $("input[name='email']").val()            
        };
		$.ajax({
			type: 'POST',
			dataType: 'json',
            data: parametros,
			url: $('#url').val()+'compra/compra_proveedor_nuevo',
			success: function(data){
				if(data.cod == 1){
					Swal.fire({   
                        title:'Proceso No Culminado',   
                        text: 'Datos duplicados',
                        icon: "error", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
				}else {
					$('#id_prov').val(data.id_prov);
                    $('#datos_proveedor').val(data.razon_social);
                    $('#modal-proveedor').modal('hide');
				}
			}
		});
        return false;
    });
});

/* Nuevo Proveedor */
var nuevoProveedor = function(){
    $('#id_prov').val('');
    $('#tipo_prov').val(2);
    $('.modal-title').text('Nuevo Proveedor');
    $("#td_ruc").attr('checked', true);
    $("#td_dni").attr('checked', false);
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","none");
    $(".block04").css("display","none");
    $(".block05").css("display","none");
    $(".block06").css("display","none");
    $(".block07").css("display","block");
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);

    $('#modal-proveedor').modal('show');
}

$('input:radio[id=td_dni]').on('click', function(event){
    $('#id_prov').val('');
    $('#tipo_prov').val(1);
    $("#td_dni").attr('checked', true);
    $("#td_ruc").attr('checked', false);
    $(".block01").css("display","block");
    $(".block02").css("display","none");
    $(".block03").css("display","block");
    $(".block04").css("display","block");
    $(".block05").css("display","block");
    $(".block06").css("display","block");
    $(".block07").css("display","none");
    $(".dni").prop('disabled', false);
    $(".ruc").prop('disabled', true);
    $('#form-proveedor').formValidation('resetForm', true);
});

$('input:radio[id=td_ruc]').on('click', function(event){
    $('#id_prov').val('');
    $('#tipo_prov').val(2);
    $("#td_ruc").attr('checked', true);
    $("#td_dni").attr('checked', false);
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","none");
    $(".block04").css("display","none");
    $(".block05").css("display","none");
    $(".block06").css("display","none");
    $(".block07").css("display","block");
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    $('#form-proveedor').formValidation('resetForm', true);  


});




/* Consultar ruc del nuevo cliente */
/* Compatible con Perú (11 dígitos fijos) y Panamá (formato variable) */
var buscarRucTimerCompraProv = null;
$("#ruc").keyup(function(event) {
    var that = this,
    value = $(this).val();
    var maxLength = parseInt($("#ruc").attr("maxlength")) || 20;
    
    if (buscarRucTimerCompraProv) {
        clearTimeout(buscarRucTimerCompraProv);
    }
    
    if(value == "") {
        $('#ruc').val("");
        $('#razon_social').val("");
        $('#direccion').val("");
        $('#telefono').val("");
        $('#email').val("");
        $('#contacto').val("");
        $('#form-proveedor').formValidation('resetForm', true);
        return;
    }
    
    if (event.keyCode == 13) {
        event.preventDefault();
        buscarRucCompraProvForm(value);
        return;
    }
    
    if (maxLength == 11 && value.length == 11) {
        buscarRucCompraProvForm(value);
        return;
    }
    
    if (value.length >= 5) {
        buscarRucTimerCompraProv = setTimeout(function() {
            buscarRucCompraProvForm(value);
        }, 1500);
    }
});

function buscarRucCompraProvForm(ruc) {
    $.getJSON($('#url').val()+"api/ruc/"+encodeURIComponent(ruc), {
        format: "json"
    })
    .done(function(data) {
        if(data && data.success !== false) {
            // Para Panamá, incluir el DV junto al RUC si existe
            if(data.ruc) {
                var rucCompleto = data.ruc;
                if(data.dv) {
                    rucCompleto = data.ruc + ' DV:' + data.dv;
                }
                $("#ruc").val(rucCompleto);
            }
            if(data.razonSocial) $("#razon_social").val(data.razonSocial);
            if(data.direccion) $("#direccion").val(data.direccion);
            $('#form-proveedor').formValidation('revalidateField', 'razon_social');
            $('#form-proveedor').formValidation('revalidateField', 'direccion');
        }
    });
}

$("#dni").keyup(function(event) {
    var that = this,
    value = $(this).val();
    if (value.length == $("#dni").attr("maxlength")) {
        $.getJSON($('#url').val()+"api/dni/"+$("#dni").val(), {
            format: "json"
        })
        .done(function(data) {
            $("#dni").val(data.dni);
            $("#nombres").val(data.nombres+' '+data.apellidoPaterno+' '+data.apellidoMaterno);
            $("#fecha_nac").val(data.fechaNacimiento);
            $("#direccion").val(data.direccion);
            $('#form').formValidation('revalidateField', 'nombres');
            $('#form').formValidation('revalidateField', 'ape_paterno');
            $('#form').formValidation('revalidateField', 'ape_materno');
        });
    } else if($("#dni").val() == "") {
        $('#dni').val("");
        $('#ruc').val("");
        $('#nombres').val("");
        $('#fecha_nac').val("");
        $('#telefono').val("");
        $('#correo').val("");
        $('#razon_social').val("");
        $('#direccion').val("");
        $('#referencia').val("");
        $('#form-proveedor').formValidation('resetForm', true);
    }
});





$('#modal-proveedor').on('hidden.bs.modal', function() {
	//$('#ruc_numero').val('');
    $(this).find('form')[0].reset();
    $('#form-proveedor').formValidation('resetForm', true);
});