$(function() {
    var id_catg = '%';
    listarCategorias();
    listarProductos(id_catg);
    $('.scroll_categoria').slimscroll({
        height: '100%'
    });
    var scroll_categoria = function () {
            var topOffset = 340;
            var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
            height = height - topOffset;
            $(".scroll_categoria").css("height", (height) + "px");
    };
    $(window).ready(scroll_categoria);
    $(window).on("resize", scroll_categoria);

    $('.scroll_receta').slimscroll({
        height: '100%'
    });
    var scroll_receta = function () {
            var topOffset = 260;
            var height = ((window.innerHeight > 0) ? window.innerHeight : this.screen.height) - 1;
            height = height - topOffset;
            $(".scroll_receta").css("height", (height) + "px");
    };
    $(window).ready(scroll_receta);
    $(window).on("resize", scroll_receta);

    $(".touchspin1").TouchSpin({
        verticalbuttons: true,
        buttondown_class: 'btn btn-warning',
        buttonup_class: 'btn btn-warning',
        min: 0,
        max: 99,
        step: 1,
        booster: false,
        stepintervaldelay: 600000
    });

});

/* Mostrar datos en la lista categorias */
var listarCategorias = function(){
    $('#ul-cat').empty();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_cat_list",
        dataType: "json",
        success: function(item){
            if(item.data.length > 0){
                $.each(item.data, function(i, campo) {
                    $('#ul-cat')
                        .append(
                        $('<li/>')
                            .html('<a href="javascript:void(0)" class="link" onclick="listarProductos('+campo.id_catg+')">'+campo.descripcion+''
                            +'<span><i data-feather="edit" class="feather-sm fill-white" onclick="editarCategoria('+campo.id_catg+',\''+campo.descripcion+'\','+campo.delivery+','+campo.orden+',\''+campo.estado+'\',\''+campo.imagen+'\')"></i>'
                            +'&nbsp;<i data-feather="trash-2" class="feather-sm fill-white" onclick="eliminarCategoria('+campo.id_catg+')"></i>&nbsp;</span></a>')
                        )
                });
                feather.replace();
            }else{
                $('#ul-cat').html("<center><br><br><br><i class='mdi mdi-alert-circle display-3' style='color: #d3d3d3;'></i><br><br><span class='font-18' style='color: #d3d3d3;'>No hay datos disponibles</span><br></center>");
            }
        }
    });
}

/* Mostrar datos en la tabla productos */
var listarProductos = function(id_catg){
    $('#categoria').val(id_catg);
    $('#head-p').empty();
    $('#body-c').empty();
    $('#body-p').html('<div class="row text-center"><div class="col-sm-10 offset-sm-1"><h4><i class="ti ti-arrow-circle-left"></i><br>Agregue o seleccione un producto</h4><h6>Debes agregar o seleccionar un producto para poder agregar o modificar sus presentaciones</h6></div></div>');
    var table = $('#table-productos')
    .DataTable({
        "destroy": true,
        "responsive": true,
        "dom": "tp",
        "bSort": false,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"ajuste/producto_list",
            "data": {
                id_prod : '%',
                id_catg : id_catg
            }
        },
        "columns":[
            {"data":null,"render": function ( data, type, row) {
                return '<a href="javascript:void(0)" class="link" onclick="listarPresentaciones('+data.id_prod+',\''+data.nombre+'\')">'+data.nombre+'</a>';
            }},
            {"data":null,"render": function ( data, type, row) {
                if(data.id_tipo == 1){
                    return '<div class="text-center"><span class="text-navy"><i class="ti-check"></i> Si </span></div>';
                } else if (data.id_tipo == 2){
                    return '<div class="text-center"><span class="text-danger"><i class="ti-close"></i> No </span></div>'
                }
            }},
            {"data":null,"render": function ( data, type, row) {
                if(data.estado == 'a'){
                    return '<div class="text-center"><span class="text-navy"><i class="ti-check"></i> Si </span></div>';
                } else if (data.estado == 'i'){
                    return '<div class="text-center"><span class="text-danger"><i class="ti-close"></i> No </span></div>'
                }
            }},
            {"data":null,"render": function ( data, type, row ) {
                return '<div class="text-right"><a href="javascript:void(0)" class="text-info edit" onclick="editarProducto('+data.id_prod+')"><i data-feather="edit" class="feather-sm fill-white"></i></a><a href="javascript:void(0)" class="text-danger edit" onclick="eliminarProducto('+data.id_prod+')"><i data-feather="trash-2" class="feather-sm fill-white"></i></a></div>';
            }}
        ]
    });

    $('#table-productos').DataTable().on("draw", function(){
        feather.replace();
    });
}

/* Listar presentaciones de cada producto seleccionado */
var listarPresentaciones = function(id_prod,nombre){
    var moneda = $("#moneda").val();
    var id_pres = '%';
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_pres_list",
        data: {
            id_prod: id_prod,
            id_pres: id_pres
        },
        dataType: "json",
        success: function(item){
        $('#head-p').html('<button class="btn btn-success btn-block btn-nuevo-presentacion" onclick="nuevaPresentacion('+id_prod+',\''+nombre+'\')"><i class="fas fa-plus-circle"></i> Agregar presentaci&oacute;n </button>');
        $('#body-c').html('<br><strong class="text-warning">Presentaciones de <span id="nomb_pres">'+nombre+'</span></strong><br><br>');
            if (item.data.length != 0) {
                $('#body-p').empty();
                $.each(item.data, function(i, campo) {
                    if(campo.estado == 'a'){
                        var boxpres = '';
                    }else{
                        var boxpres = 'boxpres';
                    }
                    $('#body-p')
                    .append(
                        $('<div>')
                        .html('<div class="card col-sm-12 menupress '+boxpres+' font-14" style="margin-bottom: 10px;"> <div class="card-body d-flex curso" style="padding: 10px 0px 10px 0px;"> <div class="read"> <a href="javascript:void(0)" class="link" onclick="editarPresentacion('+campo.id_pres+',\''+nombre+'\')">'+campo.presentacion+'</a></div> <div class="ml-auto"> <a href="javascript:void(0)" class="link" onclick="editarPresentacion('+campo.id_pres+',\''+nombre+'\')">'+moneda+' '+campo.precio+'</a> </div> <div class="read ml-4  "> <a href="javascript:void(0)" class="text-danger edit" onclick="eliminarPres('+campo.id_pres+')"><i data-feather="trash-2" class="feather-sm fill-white"></i></a> </div> </div></div>')
                    )
                });
                feather.replace();
            } else {
                $('#body-p').html('<div class="row text-center"><div class="col-sm-10 offset-sm-1"><h4><i class="ti ti-arrow-circle-up"></i><br>Agregue una presentación</h4><h6>Debes agregar una presentación para poder guardar y usar el producto, asi mismo poder agregar una receta a tu presentación</h6></div></div>');
            }
        }
    });
}

/* Editar datos de un producto */
var editarProducto = function(id_prod){
    $('.bootstrap-tagsinput').css({
        'display': 'block',
        'box-shadow': 'none'
    });
    
    $('#id_catg_producto').find('option').remove();
    ComboCatg();
    var id_catg = '%';
    $('#modal-producto').modal('show');
    $("#id_prod_producto").val(id_prod);
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_list",
        data: {
            id_prod: id_prod,
            id_catg: id_catg
        },
        dataType: "json",
        success: function(item){
            $.each(item.data, function(i, campo) {                
                $('#notas_producto').tagsinput('removeAll');
                $('#nombre_producto').val(campo.nombre);
                if(campo.id_tipo == 1){
                    $('#transf').addClass('active');
                    $('#ntransf').removeClass('active');
                    $("input[name=id_tipo][value='1']").attr("checked",true);
                    $("input[name=id_tipo][value='2']").attr("checked",false);
                } else if (campo.id_tipo == 2){
                    $('#ntransf').addClass('active');
                    $('#transf').removeClass('active');
                    $("input[name=id_tipo][value='1']").attr("checked",false);
                    $("input[name=id_tipo][value='2']").attr("checked",true);
                }
                if(campo.delivery == 1){
                    $('#delivery_producto').prop('checked', true);
                    $('#hidden_delivery_producto').val(1);
                } else {
                    $('#delivery_producto').prop('checked', false);
                    $('#hidden_delivery_producto').val(0);
                }
                if(campo.estado == 'a'){
                    $('#estado_producto').prop('checked', true);
                    $('#hidden_estado_producto').val('a');
                } else {
                    $('#estado_producto').prop('checked', false);
                    $('#hidden_estado_producto').val('i');
                }
                $('#id_areap_producto').selectpicker('val', campo.id_areap);
                $('#id_catg_producto').selectpicker('val', campo.id_catg);
                $('#id_catg_producto').selectpicker();
                $('#id_catg_producto').selectpicker('refresh');
                $('#notas_fields').empty();
                countDivs();
                var room = 1;
                var notasObj;

                if (typeof campo.notas === 'string') {
                  try {
                    notasObj = JSON.parse(campo.notas);
                  } catch (error) {
                    notasObj = campo.notas;
                  }
                } else {
                  notasObj = campo.notas;
                }
              
                if (typeof notasObj === 'object') {
                    countDivs();
                    for (var key in notasObj) {
                        if (notasObj.hasOwnProperty(key)) {
                            room++;
                            var objTo = document.getElementById('notas_fields')
                            var divtest = document.createElement("div");
                            divtest.setAttribute("class", "form-group mb-0 pb-2 border-bottom removeclass" + room);
                            var rdiv = 'removeclass' + room;
                            divtest.innerHTML = '<div class="row"> <div class="col-12 py-2"> <input class="form-control input-mayus border rounded px-2" type="text" autocomplete="off" name="grupo_nota[]" id="grupo_nota" value="'+key+'" required="required"/> </div> <div class="col"> <input name="notas_producto[]" id="notas_producto" class="form-control notas_producto" data-role="tagsinput" value="'+notasObj[key]+'"> </div> <div class="col-auto text-right"> <button class="btn btn-sm btn btn-link" type="button" onclick="remove_notas_fields(' + room + ');"> <i class="fa fa-minus"></i> </button> </div> </div>';
                        
                            objTo.appendChild(divtest)
                            $('.notas_producto').tagsinput('refresh');
                            $('.bootstrap-tagsinput').css({
                            'display': 'block',
                            'box-shadow': 'none'
                            });

                        console.log(key + ": " + notasObj[key]);
                        }
                    }
                    countDivs();
                } else {
                    countDivs();
                    $('#notas_producto').tagsinput('add',campo.notas);
                //   console.log('campo.notas no es un objeto JSON válido.');
                }
            });
        }
    });
}

/* Editar categoria */
var editarCategoria = function(id_catg,descripcion,delivery,orden,estado,imagen){
    $(".f").addClass("focused");
    $("#id_catg_categoria").val(id_catg);
    $("#descripcion_categoria").val(descripcion);
    $("#orden_categoria").val(orden);
    $('#wizardPicturePreview-2').attr('src',$("#url").val()+'public/images/productos/'+imagen+'');
    $('#imagen').val(imagen);
    $('#wizard-picture-2').val('');
    $('.display-categoria-list').hide();
    $('#display-categoria-nuevo').show();
    $('#form-categoria').formValidation('revalidateField', 'descripcion_categoria');
    if(delivery == 1){
        $('#delivery_categoria').prop('checked', true);
        $('#hidden_delivery_categoria').val(1);
    } else {
        $('#delivery_categoria').prop('checked', false);
        $('#hidden_delivery_categoria').val(0);
    }
    if(estado == 'a'){
        $('#estado_categoria').prop('checked', true);
        $('#hidden_estado_categoria').val('a');
    } else {
        $('#estado_categoria').prop('checked', false);
        $('#hidden_estado_categoria').val('i');
    }
}

/* Eliminar categoria */
var eliminarCategoria = function(id_catg){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_cat_delete",
        data: {
            id_catg: id_catg
        },
        dataType: "json",
        success: function(data){
            if(data == 1){
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos eliminados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                listarCategorias();
            }else if(data == 0){
                Swal.fire({   
                    title:'Proceso No Culminado',   
                    text: 'Datos protegidos',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }
    });
}

/* Eliminar Producto */
var eliminarProducto = function(id_producto){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_prod_delete",
        data: {
            id_prod: id_producto
        },
        dataType: "json",
        success: function(data){
            if(data == 1){
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos eliminados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                var id_catg = '%';
                listarCategorias();
                listarProductos(id_catg);
            }else if(data == 0){
                Swal.fire({   
                    title:'Proceso No Culminado',   
                    text: 'Datos protegidos',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }
    });
}
/* Eliminar Presentacion */
var eliminarPres = function(id_pres){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_pres_delete",
        data: {
            id_pres: id_pres
        },
        dataType: "json",
        success: function(data){
            if(data == 1){
                Swal.fire({   
                    title:'Proceso Terminado',   
                    text: 'Datos eliminados correctamente',
                    icon: "success", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
                var id_catg = '%';
                listarCategorias();
                listarProductos(id_catg);
            }else if(data == 0){
                Swal.fire({   
                    title:'Proceso No Culminado',   
                    text: 'Datos protegidos',
                    icon: "error", 
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    allowOutsideClick: false,
                    showCancelButton: false,
                    showConfirmButton: true
                }, function() {
                    return false
                });
            }
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }
    });
}
/* Nueva presentacion de un producto */
var nuevaPresentacion = function(id_prod,nombre){
    $('.bootstrap-tagsinput').css({
    'display': 'block',
    'box-shadow': 'none'
    });
    $(".f").removeClass("focused");
    $('#form-presentacion').formValidation('resetForm', true);
    $('#wizardPicturePreview').attr('src',$("#url").val()+'public/images/productos/default.png');
    $('#imagen2').val('default.png');
    $('#wizard-picture').val('');
    
    // Resetear configuración de impuesto a valores por defecto
    $('#usar_sistema_radio').prop('checked', true);
    $('#usar_impuesto_sistema_hidden').val('1');
    $('#opciones_personalizacion_impuesto').hide();
    $('#impuesto_excluido_pres_radio').prop('checked', true);
    $('#impuesto_incluido_personalizado_hidden').val('0');
    $('.card-radio-impuesto-pres').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    $('#id_prod_presentacion').val(id_prod);
    $('#nombre_producto_presentacion').val(nombre);
    $('#cod_prod_presentacion').val('');
    $('#descripcion_presentacion').val('');
    $('#stock_min_presentacion').val('');
    
    // Resetear configuración de impuesto a valores por defecto
    $('#usar_sistema_radio').prop('checked', true);
    $('#usar_impuesto_sistema_hidden').val('1');
    $('#opciones_personalizacion_impuesto').hide();
    $('#impuesto_excluido_pres_radio').prop('checked', true);
    $('#impuesto_incluido_personalizado_hidden').val('0');
    $('.card-radio-impuesto-pres').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    $('#ordenins').val('1');
    $('#precio_delivery').val('');
    $('#precio_delivery_app').val('');
    $('#grupo_limit_max').val(0);
    var id_catg = '%';
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_list",
        data: {
            id_prod: id_prod,
            id_catg: id_catg
        },
        dataType: "json",
        success: function(item){
            $.each(item.data, function(i, campo) {
                $('#notas_presentacion').tagsinput('removeAll');
                $('#notas_fieldspre').empty();
                countDivss();
            //id_tipo = 1 (Producto Transformado)
                if(campo.id_tipo == 1){
                    // Ocultar check receta (tp-1), stock/stock_minimo (tp-2)
                    $('#tp-1').css('display','none');
                    $('#tp-2').css('display','none');
                    $('#mensaje-ins').css('display','block');
                    $('#mensaje-ins').html('<div class="alert alert-warning">'
                        +'Guarde los datos de la presentaci&oacute;n, para que pueda ingresar una receta o toppings'
                        +'</div>');
                }else{
                //id_tipo = 2 (Producto NO Transformado)

                    $('#mensaje-ins').css('display','none');
                    $('#tp-1').css('display','none');
                    $('#tp-2').css('display','block');
                }
                
                //IMPUESTO
                $('#hidden_impuesto_presentacion').val(1);
                $('#impuesto_presentacion').prop('checked', true);
                //ESTADO
                $('#hidden_estado_presentacion').val('a');
                $('#estado_presentacion').prop('checked', true);
                
                //OPCION RECETA
                $('#hidden_receta_presentacion').val(0);
                $('#receta_presentacion').prop('checked', false);
                
                //CONTROL DE STOCK
                $('#stock_presentacion').prop('checked', false);
                $('#stock_limit').prop('checked', false);
                $('#hidden_stock_limit').val(0);
                $('#tp-4').css('display','none');
                $('#tp-4-1').css('display','none');
                
                //DELIVERY
                $('#hidden_delivery_presentacion').val(0);
                $('#delivery_presentacion').prop('checked', false);
                $('#tp-3').css('display','none');
                $('#tp-3-1').css('display','none');
                
                // OPCION PARA LLEVAR
                $('#llevar_presentacion').prop('checked', false);
                $('#hidden_llevar_presentacion').val(0);
                
                // OPCION NOTAS
                $('#hidden_nota_presentacion').val(0);
                $('#nota_presentacion').prop('checked', false);
                $('#nota_presentacion_').css('display','none');
                
                // OPCION TOPPINGS
                $('#toppings_presentacion').prop('checked', false);
                $('#hidden_toppings_presentacion').val(0);
                $('#mensaje-toppings').css('display','none');
                $('#tp-toppings').css('display','none');
                
                $('#hidden_insumo_principal_presentacion').val(0);
                $('#insumo_principal_presentacion').prop('checked', false);
            });
        }
    });
    $('#id_pres_presentacion').val('');
    $('#modal-presentacion').modal('show');
}
/* Editar datos de una presentacion de un producto */
var editarPresentacion = function(id_pres,nombre){
    $(".f").addClass("focused");
    $('.bootstrap-tagsinput').css({
        'display': 'block',
        'box-shadow': 'none'
        });    
    var id_prod = '%';

    $('#form-presentacion').formValidation('resetForm', true);
    
    // Resetear configuración de impuesto antes de cargar datos
    $('#usar_sistema_radio').prop('checked', false);
    $('#personalizar_impuesto_radio').prop('checked', false);
    $('#usar_impuesto_sistema_hidden').val('');
    $('#opciones_personalizacion_impuesto').hide();
    $('#impuesto_porcentaje_personalizado').val('');
    $('#impuesto_incluido_personalizado_hidden').val('');
    $('.card-tipo-impuesto-pres').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    $('.card-radio-impuesto-pres').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    
    $("#nombre_producto_presentacion").val(nombre);
    $('#id_pres_receta').val(id_pres);
     $('#id_pres_receta2').val(id_pres);
    $('#modal-presentacion').modal('show');

    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_pres_list",
        data: {
            id_prod: id_prod,
            id_pres: id_pres
        },
        dataType: "json",
        success: function(item){
            $.each(item.data, function(i, campo) {
                $('#id_pres_presentacion').val(campo.id_pres);
                $('#id_prod_presentacion').val(campo.id_prod);
                $('#cod_prod_presentacion').val(campo.cod_prod);
                $('#presentacion_presentacion').val(campo.presentacion);
                $('#descripcion_presentacion').val(campo.descripcion);
                $('#precio_presentacion').val(campo.precio);
                $('#ordenins').val(campo.ordenins);
                $('#precio_delivery').val(campo.precio_delivery);
                $('#precio_delivery_app').val(campo.precio_delivery_app);
                $('#precio_llevar').val(campo.precio_llevar);
                $('#costounitario_presentacion').val(campo.costo_unitario);
                $('#wizardPicturePreview').attr('src',$("#url").val()+'public/images/productos/'+campo.imagen+'');
                $('#imagen2').val(campo.imagen);
                $('#wizard-picture').val('');
                $('#stock_min_presentacion').val(campo.stock_min);
                $('#tp-grupo-maximo').css('display','none');
                
                // Cargar configuración de impuesto personalizado
                // Debug: mostrar valores recibidos
                console.log('Datos de impuesto recibidos:', {
                    usar_impuesto_sistema: campo.usar_impuesto_sistema,
                    tipo_usar_impuesto: typeof campo.usar_impuesto_sistema,
                    impuesto_incluido_personalizado: campo.impuesto_incluido_personalizado,
                    impuesto_porcentaje_personalizado: campo.impuesto_porcentaje_personalizado
                });
                
                // VERIFICACIÓN IMPORTANTE: Si hay porcentaje personalizado, forzar modo personalizado
                // aunque usar_impuesto_sistema sea 1 (puede ser un error de guardado)
                var tienePorcentajePersonalizado = campo.impuesto_porcentaje_personalizado !== null && 
                                                   campo.impuesto_porcentaje_personalizado !== undefined && 
                                                   campo.impuesto_porcentaje_personalizado !== '';
                
                var usarImpuestoSistemaVal = campo.usar_impuesto_sistema;
                if(usarImpuestoSistemaVal === null || usarImpuestoSistemaVal === undefined || usarImpuestoSistemaVal === ''){
                    // Si hay porcentaje personalizado, asumir personalizado
                    usarImpuestoSistemaVal = tienePorcentajePersonalizado ? '0' : '1';
                }
                
                var usarImpuestoSistema = parseInt(usarImpuestoSistemaVal);
                
                // Si es NaN, verificar si hay porcentaje personalizado para decidir
                if(isNaN(usarImpuestoSistema)){
                    usarImpuestoSistema = tienePorcentajePersonalizado ? 0 : 1;
                }
                
                // FORZAR personalizado si hay porcentaje personalizado guardado
                if(tienePorcentajePersonalizado && usarImpuestoSistema === 1){
                    console.warn('ADVERTENCIA: Hay porcentaje personalizado pero usar_impuesto_sistema es 1. Forzando a personalizado.');
                    usarImpuestoSistema = 0;
                }
                
                console.log('Valor procesado usar_impuesto_sistema:', usarImpuestoSistema, '| Porcentaje:', campo.impuesto_porcentaje_personalizado, '| Tiene porcentaje:', tienePorcentajePersonalizado);
                
                // Si es 1, usar sistema; si es 0, personalizar
                if (usarImpuestoSistema === 1) {
                    // Usar configuración del sistema
                    $('#usar_sistema_radio').prop('checked', true);
                    $('#personalizar_impuesto_radio').prop('checked', false);
                    $('#usar_impuesto_sistema_hidden').val('1');
                    $('#opciones_personalizacion_impuesto').hide();
                    $('.card-tipo-impuesto-pres[data-value="1"]').css({'border-color': '#2196F3', 'background-color': '#E3F2FD'});
                    $('.card-tipo-impuesto-pres[data-value="0"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
                } else {
                    // Personalizar impuesto
                    $('#personalizar_impuesto_radio').prop('checked', true);
                    $('#usar_sistema_radio').prop('checked', false);
                    $('#usar_impuesto_sistema_hidden').val('0');
                    $('#opciones_personalizacion_impuesto').show();
                    $('.card-tipo-impuesto-pres[data-value="0"]').css({'border-color': '#FF9800', 'background-color': '#FFF3E0'});
                    $('.card-tipo-impuesto-pres[data-value="1"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
                    
                    // Cargar porcentaje personalizado
                    if(campo.impuesto_porcentaje_personalizado !== null && campo.impuesto_porcentaje_personalizado !== undefined && campo.impuesto_porcentaje_personalizado !== ''){
                        $('#impuesto_porcentaje_personalizado').val(campo.impuesto_porcentaje_personalizado);
                        console.log('Porcentaje personalizado cargado:', campo.impuesto_porcentaje_personalizado);
                    } else {
                        // Si no hay porcentaje personalizado, usar el del sistema como placeholder
                        var porcentajeSistema = $('#impuesto_valor_sistema').val() || '0';
                        $('#impuesto_porcentaje_personalizado').val(porcentajeSistema);
                        console.log('No hay porcentaje personalizado, usando sistema:', porcentajeSistema);
                    }
                    
                    // Cargar si está incluido o excluido
                    var impuestoIncluidoVal = campo.impuesto_incluido_personalizado;
                    if(impuestoIncluidoVal === null || impuestoIncluidoVal === undefined || impuestoIncluidoVal === ''){
                        impuestoIncluidoVal = 0; // Por defecto excluido
                    }
                    var impuestoIncluido = parseInt(impuestoIncluidoVal);
                    if(isNaN(impuestoIncluido)){
                        impuestoIncluido = 0;
                    }
                    if (impuestoIncluido === 1) {
                        $('#impuesto_incluido_pres_radio').prop('checked', true);
                        $('#impuesto_excluido_pres_radio').prop('checked', false);
                        $('#impuesto_incluido_personalizado_hidden').val('1');
                        $('.card-radio-impuesto-pres[data-value="1"]').css({'border-color': '#4caf50', 'background-color': '#f1f8f4'});
                        $('.card-radio-impuesto-pres[data-value="0"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
                    } else {
                        $('#impuesto_excluido_pres_radio').prop('checked', true);
                        $('#impuesto_incluido_pres_radio').prop('checked', false);
                        $('#impuesto_incluido_personalizado_hidden').val('0');
                        $('.card-radio-impuesto-pres[data-value="0"]').css({'border-color': '#f44336', 'background-color': '#fff5f5'});
                        $('.card-radio-impuesto-pres[data-value="1"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
                    }
                }
                
                // Calcular precio inicial
                setTimeout(function(){
                    calcularPrecioConImpuesto();
                }, 100);
                
                if(campo.crt_stock == 1){
                    $('#stock_limit').prop('checked', true);
                    $('#stock_presentacion').prop('checked', true);
                    $('#hidden_stock_limit').val(1);
                    $('#tp-4').css('display','block');
                    $('#tp-4-1').css('display','block');
                } else {
                    $('#stock_presentacion').prop('checked', false);
                    $('#stock_limit').prop('checked', false);
                    $('#hidden_stock_limit').val(0);
                    $('#tp-4').css('display','none');
                    $('#tp-4-1').css('display','none');
                }

                if(campo.margen == 1){
                    $('#insumo_principal_presentacion').prop('checked', true);
                    $('#hidden_insumo_principal_presentacion').val(1);
                } else {
                    $('#insumo_principal_presentacion').prop('checked', false);
                    $('#hidden_insumo_principal_presentacion').val(0);
                }

                if(campo.impuesto == 1){
                    $('#impuesto_presentacion').prop('checked', true);
                    $('#hidden_impuesto_presentacion').val(1);
                } else {
                    $('#impuesto_presentacion').prop('checked', false);
                    $('#hidden_impuesto_presentacion').val(0);
                }

                if(campo.delivery == 1){
                    $('#delivery_presentacion').prop('checked', true);
                    $('#hidden_delivery_presentacion').val(1);
                    $('#tp-3').css('display','block');
                    $('#tp-3-1').css('display','block');
                } else {
                    $('#delivery_presentacion').prop('checked', false);
                    $('#hidden_delivery_presentacion').val(0);
                    $('#tp-3').css('display','none');
                    $('#tp-3-1').css('display','none');
                }

                if(campo.llevar == 1){
                    $('#llevar_presentacion').prop('checked', true);
                    $('#hidden_llevar_presentacion').val(1);
                    $('#tp-5').css('display','block');
                } else {
                    $('#llevar_presentacion').prop('checked', false);
                    $('#hidden_llevar_presentacion').val(0);
                    $('#tp-5').css('display','none');
                }                

                if(campo.estado == 'a'){
                    $('#estado_presentacion').prop('checked', true);
                    $('#hidden_estado_presentacion').val('a');
                } else {
                    $('#estado_presentacion').prop('checked', false);
                    $('#hidden_estado_presentacion').val('i');
                }
                
                if(campo.nota == 1){
                    $('#nota_presentacion').prop('checked', true);
                    $('#hidden_nota_presentacion').val(1);
                    $('#nota_presentacion_').css('display','block');
                }

                //id_tipo = 1 (Producto Transformado)
                if(campo.TipoProd.id_tipo == 1){
                    if(campo.receta == 1){
                        $('#receta_presentacion').prop('checked', true);
                        $('#hidden_receta_presentacion').val(1);
                        $('#mensaje-ins').css('display','block');
                        $('#mensaje-ins').html('<div class="alert alert-info">'
                            +'Modificar los ingredientes <a style="color: #fff !important; cursor:pointer;" class="label label-danger" onclick="receta()">AQUI</a>'
                            +'</div>');
                    } else {
                        $('#receta_presentacion').prop('checked', false);
                        $('#hidden_receta_presentacion').val(0);
                        $('#mensaje-ins').css('display','none');
                        $('#mensaje-ins').html('<div class="alert alert-warning">'
                            +'Ingresar los ingredientes <a style="color: #fff !important; cursor:pointer;" class="label label-danger" onclick="receta()">AQUI</a> y luego click en Guardar'
                            +'</div>');
                    }

                    if(campo.toppings == 1){
                        $('#toppings_presentacion').prop('checked', true);
                        $('#hidden_toppings_presentacion').val(1);
                        $('#mensaje-toppings').css('display','block');
                        $('#mensaje-toppings').html('<div class="alert alert-info">'
                            +'Modificar los toppings <a style="color: #fff !important; cursor:pointer;" class="label label-danger" onclick="toppings()">AQUI</a>'
                            +'</div>');
                    } else {
                        $('#toppings_presentacion').prop('checked', false);
                        $('#hidden_toppings_presentacion').val(0);
                        $('#mensaje-toppings').css('display','none');
                        $('#mensaje-toppings').html('<div class="alert alert-warning">'
                            +'Ingresar los toppings <a style="color: #fff !important; cursor:pointer;" class="label label-danger" onclick="toppings()">AQUI</a> y luego click en Guardar'
                            +'</div>');
                    }                    
                    // Mostrar check receta (tp-1)
                    $('#tp-1').css('display','block');
                    
                    // CONTROL STOCK
                    $('#stock_presentacion').prop('checked', false);
                    $('#stock_limit').prop('checked', false);
                    $('#hidden_stock_limit').val(0);
                    $('#tp-2').css('display','none');
                    $('#tp-4').css('display','none');
                    $('#tp-4-1').css('display','none');
                    
                    $('#tp-toppings').css('display','block');
                }
                //id_tipo = 2 (Producto NO Transformado)
                else{
                    // RECETA
                    $('#receta_presentacion').prop('checked', false);
                    $('#mensaje-ins').css('display','none');
                    $('#tp-1').css('display','none');

                    if(campo.receta == 1){
                        //$('#stock_presentacion').prop('checked', false);
                        $('#hidden_receta_presentacion').val(1);
                        //$('#tp-4').css('display','none');
                        //$('#tp-4-1').css('display','none');
                    } else {
                        //$('#stock_presentacion').prop('checked', true);
                        $('#hidden_receta_presentacion').val(0);
                        //$('#tp-4').css('display','block');
                        //$('#tp-4-1').css('display','block');
                    }
                    
                    // TOPPINGS
                    $('#toppings_presentacion').prop('checked', false);
                    $('#hidden_toppings_presentacion').val(0);
                    $('#mensaje-toppings').css('display','none');
                    $('#tp-toppings').css('display','none');
                    
                    // CONTROL DE STOCK
                    $('#tp-2').css('display','block');
                }

                $('#notas_fieldspre').empty();
                countDivss();
                var room = 0;
                var notasObj;

                if (typeof campo.notas === 'string') {
                  try {
                    notasObj = JSON.parse(campo.notas);
                  } catch (error) {
                    notasObj = campo.notas;
                  }
                } else {
                  notasObj = campo.notas;
                }
              
                if (typeof notasObj === 'object') {
                    countDivss();
                    $('#tp-grupo-maximo').css('display','block');
                    $('#grupo_limit_max').val(notasObj.grupo_limit);

                    for (var i = 0; i < notasObj.grupo.length; i++) {
                        var grupo = notasObj.grupo[i].grupo;
                        var notas = notasObj.grupo[i].notas;
                        var cantNota = notasObj.grupo[i].cant_nota;
                        room++;
                        var objTo = document.getElementById('notas_fieldspre')
                        var divtest = document.createElement("div");
                        divtest.setAttribute("class", "form-group mb-0 pb-2 border-bottom removeclass" + room);
                        divtest.innerHTML =  ' <div class="row"> <div class="col-12"> <div class="row"> <div class="col py-2"> <input class="form-control input-mayus border rounded px-2" type="text" autocomplete="off" placeholder="nota agrupacion" name="grupo_nota_pre[]" id="grupo_nota_pre" value="'+grupo+'" required="required"/> </div> <div class="col-auto py-2"> <input class="touchspin1 input text-left border rounded pl-2" style="max-width:100px" value="'+cantNota+'" type="text" name="cantidad_nota[]"/> </div> </div> </div> <div class="col"> <input name="notas_presentacion[]" id="notas_presentacion" class="form-control notas_presentacion" value="'+notas+'" data-role="tagsinput" placeholder="add"> </div> <div class="col-auto text-right"> <button class="btn btn-sm btn btn-link" type="button" onclick="remove_notas_fieldss(' + room + ');"> <i class="fa fa-minus"></i> </button> </div> </div> ';

                        objTo.appendChild(divtest)
                        $('.notas_presentacion').tagsinput('refresh');
                        $('.bootstrap-tagsinput').css({
                        'display': 'block',
                        'box-shadow': 'none'
                        });
                        $(".touchspin1").TouchSpin({
                            verticalbuttons: true,
                            buttondown_class: 'btn btn-warning',
                            buttonup_class: 'btn btn-warning',
                            min: 0,
                            max: 99,
                            step: 1,
                            booster: false,
                            stepintervaldelay: 600000
                        });

                        // Hacer algo con los datos del grupo
                        console.log("Grupo:", grupo);
                        console.log("Notas:", notas);
                        console.log("Cantidad de notas:", cantNota);
                    }                    

                      
                    countDivss();
                } else {
                    countDivss();
                    $('#notas_presentacion').tagsinput('add',campo.notas);
                //   console.log('campo.notas no es un objeto JSON válido.');
                }                
            });
        }
    });
}
/* Producto */
$(function() {
    $('#form-producto')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
            }
    })
    .on('success.form.fv', function(e) {

            e.preventDefault();
            var $form = $(e.target),
            fv = $form.data('formValidation');
            
            var form = $(this);

            var producto = {
                id_prod: 0,
                id_tipo: 0,
                id_catg: 0,
                id_areap: 0,
                nombre: 0,
                grupo_notas: 0,
                notas: 0,
                descripcion: 0,
                delivery: 0,
                estado: 0
            }

            producto.id_prod = $('#id_prod_producto').val();
            producto.id_tipo = $('input:radio[name=id_tipo]:checked').val();
            producto.id_catg = $('#id_catg_producto').val();
            producto.id_areap = $('#id_areap_producto').val();
            producto.nombre = $('#nombre_producto').val();
            // producto.notas = $('#notas_producto').val().toUpperCase();
            if ($("input[name='grupo_nota[]']").length > 0) {
                producto.grupo_notas = $("input[name='grupo_nota[]']").map(function() {
                  return $(this).val();
                }).get();
              } else {
                producto.grupo_notas = 0; // Asignar un array vacío si no existen los inputs
              }
              

            // producto.grupo_notas = $("input[name='grupo_nota[]']").map(function(){return $(this).val();}).get();
            producto.notas = $("input[name='notas_producto[]']").map(function(){return $(this).val();}).get();

            //producto.descripcion = $('#descripcion_producto').val();
            producto.delivery = $('#hidden_delivery_producto').val();
            producto.estado = $('#hidden_estado_producto').val();

            $.ajax({
                dataType: 'JSON',
                type: 'POST',
                url: $('#url').val()+'ajuste/producto_crud',
                data: producto,
                success: function (cod) {
                    if(cod == 0){
                        Swal.fire({   
                            title:'Proceso No Culminado',   
                            text: 'Datos duplicados',
                            icon: "error", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                    } else if(cod == 1){
                        $('#modal-producto').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos registrados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarProductos(producto.id_catg);                        
                    } else if(cod == 2) {
                        $('#modal-producto').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos actualizados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarProductos(producto.id_catg);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(errorThrown + ' ' + textStatus);
                }   
            });

            return false;
    });
});

$(function() {
    $('#form-presentacion')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
            }
        })
    .on('success.form.fv', function(e) {

        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
        var form = $(this);


        // Asegurar que los campos hidden estén actualizados antes de enviar
        var radioSeleccionado = $('input[name="tipo_impuesto_presentacion"]:checked');
        var usarSistema = false;
        
        if(radioSeleccionado.length > 0){
            usarSistema = radioSeleccionado.val() == '1';
        } else {
            // Si no hay radio seleccionado, verificar por el estado de las cards
            var cardSistema = $('.card-tipo-impuesto-pres[data-value="1"]');
            if(cardSistema.css('border-color') == 'rgb(33, 150, 243)' || cardSistema.css('border-color') == '#2196F3'){
                usarSistema = true;
            }
        }
        
        $('#usar_impuesto_sistema_hidden').val(usarSistema ? '1' : '0');
        
        // Si está personalizado, asegurar que el porcentaje esté presente
        if(!usarSistema){
            var porcentajePersonalizado = $('#impuesto_porcentaje_personalizado').val();
            if(!porcentajePersonalizado || porcentajePersonalizado === ''){
                // Si no hay porcentaje, usar el del sistema
                porcentajePersonalizado = $('#impuesto_valor_sistema').val() || '0';
                $('#impuesto_porcentaje_personalizado').val(porcentajePersonalizado);
            }
        } else {
            // Si está usando sistema, limpiar el porcentaje personalizado
            $('#impuesto_porcentaje_personalizado').val('');
        }
        
        // Asegurar que impuesto_incluido_personalizado tenga un valor por defecto si está vacío
        if(!usarSistema && (!$('#impuesto_incluido_personalizado_hidden').val() || $('#impuesto_incluido_personalizado_hidden').val() === '')){
            $('#impuesto_incluido_personalizado_hidden').val('0'); // Por defecto excluido
        }
        
        // Asegurar que usar_impuesto_sistema siempre tenga un valor
        if(!$('#usar_impuesto_sistema_hidden').val() || $('#usar_impuesto_sistema_hidden').val() === ''){
            $('#usar_impuesto_sistema_hidden').val(usarSistema ? '1' : '0');
        }
        
        // Forzar actualización del FormData después de actualizar los hidden
        var presentacion = new FormData();
        var formDataArray = $('#form-presentacion').serializeArray();
        $.each(formDataArray, function(i, field){
            presentacion.append(field.name, field.value);
        });
        
        // Asegurar que los campos de impuesto siempre estén presentes en FormData
        // Verificar si ya están incluidos, si no, añadirlos explícitamente
        var camposIncluidos = {};
        $.each(formDataArray, function(i, field){
            camposIncluidos[field.name] = true;
        });
        
        if(!camposIncluidos['usar_impuesto_sistema']){
            presentacion.append('usar_impuesto_sistema', $('#usar_impuesto_sistema_hidden').val() || '1');
        }
        if(!usarSistema && !camposIncluidos['impuesto_incluido_personalizado']){
            presentacion.append('impuesto_incluido_personalizado', $('#impuesto_incluido_personalizado_hidden').val() || '0');
        }
        if(!usarSistema && !camposIncluidos['impuesto_porcentaje_personalizado']){
            var porcentaje = $('#impuesto_porcentaje_personalizado').val();
            if(porcentaje && porcentaje !== ''){
                presentacion.append('impuesto_porcentaje_personalizado', porcentaje);
            }
        }
        
        // Añadir archivos si hay
        var fileInput = $('#wizard-picture')[0];
        if(fileInput && fileInput.files.length > 0){
            presentacion.append('imagen', fileInput.files[0]);
        } else if($('#imagen2').val()){
            presentacion.append('imagen', $('#imagen2').val());
        }
        
        // Debug: mostrar valores que se van a enviar
        console.log('Valores a enviar:', {
            usar_impuesto_sistema: $('#usar_impuesto_sistema_hidden').val(),
            impuesto_incluido_personalizado: $('#impuesto_incluido_personalizado_hidden').val(),
            impuesto_porcentaje_personalizado: $('#impuesto_porcentaje_personalizado').val(),
            id_pres_presentacion: $('#id_pres_presentacion').val(),
            radio_seleccionado: radioSeleccionado.val(),
            usarSistema_detectado: usarSistema
        });

        enviarPresentacionAJAX();

        return false;
        function enviarPresentacionAJAX() {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                data: presentacion,
                url: $('#url').val()+'ajuste/producto_pres_crud',
                contentType: false,
                processData: false,
                success: function (cod) {
                    // Log del retorno del servidor
                    console.log('RETORNO DEL SERVIDOR - Código recibido:', cod);
                    console.log('RETORNO DEL SERVIDOR - Tipo:', typeof cod);
                    console.log('RETORNO DEL SERVIDOR - Valores enviados anteriormente:', {
                        usar_impuesto_sistema: $('#usar_impuesto_sistema_hidden').val(),
                        impuesto_incluido_personalizado: $('#impuesto_incluido_personalizado_hidden').val(),
                        impuesto_porcentaje_personalizado: $('#impuesto_porcentaje_personalizado').val(),
                        id_pres_presentacion: $('#id_pres_presentacion').val()
                    });
                    
                    if(cod == 0){
                        Swal.fire({   
                            title:'Proceso No Culminado',   
                            text: 'Datos duplicados',
                            icon: "error", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                    } else if(cod == 1){
                        $('#modal-presentacion').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos registrados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarPresentaciones($('#id_prod_presentacion').val(),$('#nombre_producto_presentacion').val());
                    } else if(cod == 2) {
                        $('#modal-presentacion').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos actualizados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarPresentaciones($('#id_prod_presentacion').val(),$('#nombre_producto_presentacion').val());
                    } else {
                        console.log('RETORNO DEL SERVIDOR - Código no reconocido:', cod);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(errorThrown + ' ' + textStatus);
                }   
            });
        }

        return false;

      });
});


$(function() {

    $('#form-categoria')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
        }
    })
    .on('success.form.fv', function(e) {

        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
        var form = $(this);

        var categoria = new FormData($('#form-categoria')[0]);
        console.log(categoria);
        /*
        var categoria = {
            id_catg: 0,
            descripcion: 0,
            delivery: 0,
            estado: 0
        }

        categoria.id_catg = $('#id_catg_categoria').val();
        categoria.descripcion = $('#descripcion_categoria').val();
        categoria.delivery = $('#hidden_delivery_categoria').val();
        categoria.estado = $('#hidden_estado_categoria').val();
        */

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            url: $('#url').val()+'ajuste/producto_cat_crud',
            data: categoria,
            contentType: false,
            processData: false,
            success: function (cod) {
                if(cod == 0){
                    Swal.fire({   
                        title:'Proceso No Culminado',   
                        text: 'Datos duplicados',
                        icon: "error", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                } else if(cod == 1){
                    var cat = '%';
                    listarCategorias();
                    listarProductos(cat);
                    $('#descripcion_categoria').val('');
                    $("#id_catg_categoria").val('');
                    //$('#boton-catg').css("display","block");
                    $('.display-categoria-list').show();
                    $('#display-categoria-nuevo').hide();
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos registrados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                } else if(cod == 2) {
                    var cat = '%';
                    listarCategorias();
                    listarProductos(cat);
                    $('#descripcion_categoria').val('');
                    $("#id_catg_categoria").val('');
                    //$('#boton-catg').css("display","block");
                    $('.display-categoria-list').show();
                    $('#display-categoria-nuevo').hide();
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos actualizados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                }
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(errorThrown + ' ' + textStatus);
            }   
        });

    return false;

    });
});


/* import */
$(function() {
    $('#form-import')
        .formValidation({
            framework: 'bootstrap',
            excluded: ':disabled',
            fields: {
            }
    })
    .on('success.form.fv', function(e) {

        if (e.type == "submit") {
            e.preventDefault();
            var $form = $(e.target),
            fv = $form.data('formValidation');
            
            var form = $(this);
        }
            var id_catg = '%';

            var formData = new FormData();
            formData.append('file', $('#upfile')[0].files[0])

            $.ajax({
                type: 'POST',
                url: $('#url').val()+'ajuste/importarexcel',
                data: formData,
                processData: false,  // tell jQuery not to process the data
                contentType: false,   // tell jQuery not to set contentType
                success: function (cod) {
                    if(cod == 0){
                        $('#modal-import').modal('hide');
                        Swal.fire({   
                            title:'Proceso No Culminado',   
                            text: 'Datos duplicados',
                            icon: "error", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarCategorias();
                        listarProductos(id_catg);
                    } else if(cod == 1){
                  
                        $('#modal-import').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos registrados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        listarCategorias();
                        listarProductos(id_catg);
                        // listarProductos(producto.id_catg);                        
                    } else if(cod == 2) {
                        $('#modal-import').modal('hide');
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos actualizados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        // listarProductos(producto.id_catg);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(errorThrown + ' ' + textStatus);
                }   
            });

            return false;
    });
});

var listarReceta = function(){
    $('#table-receta').empty();
    $.ajax({
        type: "post",
        dataType: "json",
        data: {
            id_pres: $("#id_pres_receta").val()
        },
        url: $('#url').val()+'ajuste/producto_pres_ing',
        success: function (data){
            if(data.length > 0){
            $.each(data, function(i, item) {
                var opc_m=item.id_med;if(1==opc_m)var valor_cant=(1*item.cant).toFixed(6);else if(2==opc_m)var valor_cant=(1*item.cant).toFixed(6);else if(3==opc_m)var valor_cant=(1e3*item.cant).toFixed(6);else if(4==opc_m)var valor_cant=(1e6*item.cant).toFixed(6);else if(5==opc_m)var valor_cant=(1*item.cant).toFixed(6);else if(6==opc_m)var valor_cant=(1e3*item.cant).toFixed(6);else if(7==opc_m)var valor_cant=(2.20462*item.cant).toFixed(6);else if(8==opc_m)var valor_cant=(35.274*item.cant).toFixed(6);
                if(item.id_tipo_ins == 1){
                    var tipo = '<span class="label label-warning">INSUMO</span>';
                } else if (item.id_tipo_ins == 2){
                    var tipo = '<span class="label label-info">PRODUCTO</span>';
                } else{
                    var tipo = '<span class="label label-success">COMBO</span>';
                }
                $('#table-receta')
                .append(
                  $('<tr class="active"/>')
                    .append($('<td/>').html(tipo))
                    .append($('<td/>').html(item.Insumo.ins_cat))
                    .append($('<td/>').html(item.Insumo.ins_nom))
                    .append($('<td/>').html(valor_cant))
                    .append($('<td/>').html(item.Medida.descripcion))
                    .append($('<td class="text-right"/>').html('<div class="text-right"><a href="javascript:void(0)" class="text-danger delete ms-2" onclick="eliminarInsumo('+item.id_pi+');"><i data-feather="trash-2" class="feather-sm fill-white"></i></a></div>'))
                    )
                });
                feather.replace();
            } else {
                $('#table-receta').html("<tr style='border-left: 1px solid #fff;'><td colspan='6'><center><br><br><i class='fas fa-lemon display-5' style='color: #d3d3d3;'></i><br><span class='font-18' style='color: #d3d3d3;'>Agregue ingredientes</span><br><span style='color: #d3d3d3;'>No se encontraton ingredientes en esta receta</span><br></center></td></tr>");
            }
        }
    });
}

var listarToppings = function(){
    var moneda = $("#moneda").val();
    $('#table-toppings').empty();
    $.ajax({
        type: "post",
        dataType: "json",
        data: {
            id_pres: $("#id_pres_receta2").val()
        },
        url: $('#url').val()+'ajuste/toppings_producto_pres_ing',
        success: function (data){
            if(data.length > 0){
            $.each(data, function(i, item) {
                var opc_m=item.id_med;if(1==opc_m)var valor_cant=(1*item.cant).toFixed(6);else if(2==opc_m)var valor_cant=(1*item.cant).toFixed(6);else if(3==opc_m)var valor_cant=(1e3*item.cant).toFixed(6);else if(4==opc_m)var valor_cant=(1e6*item.cant).toFixed(6);else if(5==opc_m)var valor_cant=(1*item.cant).toFixed(6);else if(6==opc_m)var valor_cant=(1e3*item.cant).toFixed(6);else if(7==opc_m)var valor_cant=(2.20462*item.cant).toFixed(6);else if(8==opc_m)var valor_cant=(35.274*item.cant).toFixed(6);
                if(item.id_tipo_ins == 1){
                    var tipo = '<span class="p-1 badge badge-warning">INSUMO</span>';
                } else if (item.id_tipo_ins == 2){
                    var tipo = '<span class="p-1 badge badge-info">PRODUCTO</span>';
                } else{
                    var tipo = '<span class="p-1 badge badge-success">COMBO</span>';
                }
                $('#table-toppings')
                .append(
                  $('<tr class="active"/>')
                    .append($('<td/>').html(tipo))
                    .append($('<td/>').html(item.Insumo.ins_cat))
                    .append($('<td/>').html(item.Insumo.ins_nom))
                    .append($('<td/>').html(valor_cant))
                    .append($('<td/>').html(item.Medida.descripcion))
                    .append($('<td/>').html(moneda+' '+item.precio))
                    .append($('<td class="text-right"/>').html('<div class="text-right"><a href="javascript:void(0)" class="text-danger delete ms-2" onclick="eliminarToppings('+item.id_pi+');"><i data-feather="trash-2" class="feather-sm fill-white"></i></a></div>'))
                    )
                });
                feather.replace();
            } else {
                $('#table-toppings').html("<tr style='border-left: 1px solid #fff;'><td colspan='6'><center><br><br><i class='fas fa-lemon display-5' style='color: #d3d3d3;'></i><br><span class='font-18' style='color: #d3d3d3;'>Agregue ingredientes</span><br><span style='color: #d3d3d3;'>No se encontraton ingredientes en esta receta</span><br></center></td></tr>");
            }
        }
    });
}

var ComboCatg = function(){
    $('#id_catg_producto').find('option').remove();
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_combo_cat",
        dataType: "json",
        success: function(data){
            $.each(data, function (index, value) {
                $('#id_catg_producto').append("<option value='" + value.id_catg + "'>" + value.descripcion + "</option>");            
                $('#id_catg_producto').selectpicker();
                $('#id_catg_producto').selectpicker('refresh');
                $('#id_catg_producto').selectpicker('val', $('#categoria').val());
                $('#id_catg_producto').selectpicker('refresh');    
            });
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        } 
    });
    
}

/* Abrir modal para ingresar insumos/ingredientes a la receta */
var receta = function(){
    $('#modal-presentacion').modal('hide');
    $('#modal-receta').modal('show');
    $('.list-ingredientes').css('display','none');
    listarReceta();
}

/* Eliminar insumo/ingrediente de receta */
var eliminarInsumo = function(id_pi){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/producto_ingrediente_delete",
        data: {
            id_pi: id_pi
        },
        dataType: "json",
        success: function(datos){
            $.toast({
                heading: 'Proceso Terminado',
                text: 'Ingrediente eliminado',
                position: 'bottom-left',
                loaderBg:'#696969',
                icon: 'success',
                hideAfter: 3000, 
                stack: 20
            });
            listarReceta();
        }
    });
}

var eliminarToppings = function(id_pi){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/toppings_producto_ingrediente_delete",
        data: {
            id_pi: id_pi
        },
        dataType: "json",
        success: function(datos){
            $.toast({
                heading: 'Proceso Terminado',
                text: 'Toppings eliminado',
                position: 'bottom-left',
                loaderBg:'#696969',
                icon: 'success',
                hideAfter: 3000, 
                stack: 20
            });
            listarToppings();
        }
    });
}

var toppings = function(){
    $('#modal-presentacion').modal('hide');
    $('#modal-toppings').modal('show');
    $('.list-ingredientes').css('display','none');
    listarToppings();
}

$('.btn-eliminar').on('click', function(){
    $('.list-ingredientes').css('display','none');
    $("#buscar_ingrediente").val('');
    $("#buscar_ingrediente2").val('');
    $('#cant_receta').val('');
    $('#valor_ing').text('0');
});

/* Boton cerrar modal ingredientes */
$('.btn-cerrar-receta').click( function() {
    $('#modal-receta').modal('hide');
    $('#modal-toppings').modal('hide');
    $('#modal-presentacion').modal('show');
});
/* PRESENTACION */
$('#toppings_presentacion').on('click', function(event){
    if($('#toppings_presentacion').is(':checked')){
        $('#mensaje-toppings').css('display','block');
        $('#hidden_toppings_presentacion').val(1); 
    }else{
        $('#mensaje-toppings').css('display','none');
        $('#hidden_toppings_presentacion').val(0); 
    }
});

$('#receta_presentacion').on('click', function(event){
    if($('#receta_presentacion').is(':checked')){
        $('#mensaje-ins').css('display','block');
        $('#hidden_receta_presentacion').val(1);
    }else{
        $('#mensaje-ins').css('display','none');
        $('#hidden_receta_presentacion').val(0);
    }
});

$('#stock_presentacion').on('click', function(event){
    if($('#stock_presentacion').is(':checked')){
        $('#hidden_receta_presentacion').val(1);
        $('#tp-4').css('display','block');
        $('#tp-4-1').css('display','block');
    }else{
        $('#hidden_receta_presentacion').val(0);
        $('#tp-4').css('display','none');
        $('#tp-4-1').css('display','none');
    }
});

$('#impuesto_presentacion').on('click', function(event){
    if($('#impuesto_presentacion').is(':checked')){
        $('#hidden_impuesto_presentacion').val(1);
    }else{
        $('#hidden_impuesto_presentacion').val(0);
    }
});

$('#delivery_presentacion').on('click', function(event){
    if($('#delivery_presentacion').is(':checked')){
        $('#hidden_delivery_presentacion').val(1);
        $('#tp-3').css('display','block');
        $('#tp-3-1').css('display','block');
    }else{
        $('#hidden_delivery_presentacion').val(0);
        $('#tp-3').css('display','none');
        $('#tp-3-1').css('display','none');
    }
});

$('#llevar_presentacion').on('click', function(event){
    if($('#llevar_presentacion').is(':checked')){
        $('#hidden_llevar_presentacion').val(1);
        $('#tp-5').css('display','block');
    }else{
        $('#hidden_llevar_presentacion').val(0);
        $('#tp-5').css('display','none');
    }
});

$('#estado_presentacion').on('click', function(event){
    if($('#estado_presentacion').is(':checked')){
        $('#hidden_estado_presentacion').val('a');
    }else{
        $('#hidden_estado_presentacion').val('i');
    }
});

$('#nota_presentacion').on('click', function(event){
    if($('#nota_presentacion').is(':checked')){
        $('#nota_presentacion_').css('display','block');
        $('#hidden_nota_presentacion').val(1); 
    }else{
        $('#nota_presentacion_').css('display','none');
        $('#hidden_nota_presentacion').val(0); 
    }
});

/* PRESENTACION */

/* CATEGORIA */
$('#delivery_categoria').on('click', function(event){
    if($('#delivery_categoria').is(':checked')){
        $('#hidden_delivery_categoria').val(1);
    }else{
        $('#hidden_delivery_categoria').val(0);
    }
});

$('#estado_categoria').on('click', function(event){
    if($('#estado_categoria').is(':checked')){
        $('#hidden_estado_categoria').val('a');
    }else{
        $('#hidden_estado_categoria').val('i');
    }
});

$('.btn-categoria-nuevo').click( function() {
    $(".f").removeClass("focused");
    $('.display-categoria-list').hide();
    $('#display-categoria-nuevo').show();
    $('#descripcion_categoria').val('');
    $('#orden_categoria').val('');
    $("#descripcion_categoria").focus();
    $('#id_catg_categoria').val('');
    $('#form-categoria').formValidation('revalidateField', 'descripcion_categoria');
    $('#hidden_delivery_categoria').val(0);
    $('#delivery_categoria').prop('checked', false);
    $('#hidden_estado_categoria').val('a');
    $('#estado_categoria').prop('checked', true);
    $('#wizardPicturePreview-2').attr('src',$("#url").val()+'public/images/productos/default.png');
    $('#imagen').val('default.png');
    $('#wizard-picture-2').val('');
});

$('.btn-categoria-cancelar').click( function() {
    $(".f").removeClass("focused");
    $('.display-categoria-list').show();
    $('#display-categoria-nuevo').hide();
    $('#descripcion_categoria').val('');
    $('#orden_categoria').val('');
    $("#descripcion_categoria").focus();
    $('#id_catg_categoria').val('');
});

/* CATEGORIA */

/* PRODUCTO */
$('#delivery_producto').on('click', function(event){
    if($('#delivery_producto').is(':checked')){
        $('#hidden_delivery_producto').val(1);
    }else{
        $('#hidden_delivery_producto').val(0);
    }
});

$('#stock_limit').on('click', function(event){
    if($('#stock_limit').is(':checked')){
        $('#hidden_stock_limit').val(1);
    }else{
        $('#hidden_stock_limit').val(0);
    }
});

$('#insumo_principal_presentacion').on('click', function(event){
    if($('#insumo_principal_presentacion').is(':checked')){
        $('#hidden_insumo_principal_presentacion').val(1);
    }else{
        $('#hidden_insumo_principal_presentacion').val(0);
    }
});

$('#estado_producto').on('click', function(event){
    if($('#estado_producto').is(':checked')){
        $('#hidden_estado_producto').val('a');
    }else{
        $('#hidden_estado_producto').val('i');
    }
});

$('.btn-nuevo-producto').click( function() {
    $('#id_prod_producto').val('');
    $('#transf').addClass('active');
    $('#ntransf').removeClass('active');
    $("input[name=id_tipo][value='1']").attr("checked",true);
    $("input[name=id_tipo][value='2']").attr("checked",false);
    ComboCatg();
    $('#notas_producto').tagsinput('removeAll');
    $('.bootstrap-tagsinput').css({
        'display': 'block',
        'box-shadow': 'none'
    });
    
    $('#hidden_delivery_producto').val(0);
    $('#delivery_producto').prop('checked', false);
    $('#hidden_estado_producto').val('a');
    $('#estado_producto').prop('checked', true);
    $('#modal-producto').modal('show');
});

$('#modal-producto').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#form-producto').formValidation('resetForm', true);
    $("#notas_producto").val('');
    $("#id_areap_producto").val('').selectpicker('refresh');
    $('#receta_presentacion').removeAttr('checked');
    $('#stock_presentacion').removeAttr('checked');
    $('#notas_fields').empty();
    countDivs();
});


var room = 1;
function notas_fields() {

    room++;
    // console.log(room);
    var objTo = document.getElementById('notas_fields')
    var divtest = document.createElement("div");
    divtest.setAttribute("class", "form-group mb-0 pb-2 border-bottom removeclass" + room);
    var rdiv = 'removeclass' + room;
    divtest.innerHTML = '<div class="row"> <div class="col-12 py-2"> <input class="form-control input-mayus border rounded px-2" type="text" autocomplete="off" placeholder="nota agrupacion" name="grupo_nota[]" id="grupo_nota" required="required"/> </div> <div class="col"> <input name="notas_producto[]" id="notas_producto" class="form-control notas_producto" data-role="tagsinput" placeholder="add"> </div> <div class="col-auto text-right"> <button class="btn btn-sm btn btn-link" type="button" onclick="remove_notas_fields(' + room + ');"> <i class="fa fa-minus"></i> </button> </div> </div>';

    objTo.appendChild(divtest)

    $('.notas_producto').tagsinput('refresh');
    $('.bootstrap-tagsinput').css({
    'display': 'block',
    'box-shadow': 'none'
    });

    countDivs();

}

function countDivs() {
  var divCount = $('.form-group.border-bottom').length;
  if (divCount > 0) {
    $('.remove-nota').remove();
  } else {
    notas_fields2()
  }
}

function notas_fields2() {
    var objTo = document.getElementById('retornar-nota')
    var divtest = document.createElement("div");
    objTo.innerHTML = '<div class="form-group mb-1 remove-nota"> <input name="notas_producto[]" id="notas_producto" class="form-control notas_producto" data-role="tagsinput" placeholder="add"> <span class="bar"></span> <label for="notas_producto">Notas <i class="ti-info-alt text-warning font-10" data-original-title="Escribe una o varias notas, Ejm: SIN SAL, POCA SAL" data-toggle="tooltip" data-placement="top"></i></label> </div>';
    
    objTo.appendChild(divtest);
    $('.notas_producto').tagsinput('refresh');
    $('.bootstrap-tagsinput').css({
    'display': 'block',
    'box-shadow': 'none'
    });
}

function remove_notas_fields(rid) {
    $('.removeclass' + rid).remove();
    countDivs();
}
// presentacion 
function notas_fieldspre() {
    var divCount = $('.form-group.border-bottom').length;
    var count = 0;
    var rooms = (divCount > 0) ? divCount : count;
    var room = ++rooms;
    // console.log(roomIncremented);


    var objTo = document.getElementById('notas_fieldspre')
    var divtest = document.createElement("div");
    divtest.setAttribute("class", "form-group mb-0 pb-2 border-bottom removeclass" + room);
    var rdiv = 'removeclass' + room;
    divtest.innerHTML = ' <div class="row"> <div class="col-12"> <div class="row"> <div class="col py-2"> <input class="form-control input-mayus border rounded px-2" type="text" autocomplete="off" placeholder="nota agrupacion" name="grupo_nota_pre[]" id="grupo_nota_pre" required="required"/> </div> <div class="col-auto py-2"> <input class="touchspin1 input text-left border rounded pl-2" style="max-width:100px" value="0" type="text" name="cantidad_nota[]"/> </div> </div> </div> <div class="col"> <input name="notas_presentacion[]" id="notas_presentacion" class="form-control notas_presentacion" data-role="tagsinput" placeholder="add"> </div> <div class="col-auto text-right"> <button class="btn btn-sm btn btn-link" type="button" onclick="remove_notas_fieldss(' + room + ');"> <i class="fa fa-minus"></i> </button> </div> </div> ';

    objTo.appendChild(divtest)

    $('#tp-grupo-maximo').css('display','block');
    $('.notas_presentacion').tagsinput('refresh');
    $('.bootstrap-tagsinput').css({
    'display': 'block',
    'box-shadow': 'none'
    });
    $(".touchspin1").TouchSpin({
        verticalbuttons: true,
        buttondown_class: 'btn btn-warning',
        buttonup_class: 'btn btn-warning',
        min: 0,
        max: 99,
        step: 1,
        booster: false,
        stepintervaldelay: 600000
    });


    countDivss();

}

function countDivss() {
    var divCount = $('.form-group.border-bottom').length;
    if (divCount > 0) {
      $('.remove-nota-pre').remove();
    } else {
      notas_fields22()
      $('#tp-grupo-maximo').css('display','none');
    }
  }
  
function notas_fields22() {
    var objTo = document.getElementById('retornar-nota-pre')
    var divtest = document.createElement("div");
    objTo.innerHTML = '<div class="form-group mb-1 remove-nota-pre"> <input name="notas_presentacion[]" id="notas_presentacion" class="form-control notas_presentacion" data-role="tagsinput" placeholder="add"> <span class="bar"></span> <label for="notas_presentacion">Notas <i class="ti-info-alt text-warning font-10" data-original-title="Escribe una o varias notas, Ejm: SIN SAL, POCA SAL" data-toggle="tooltip" data-placement="top"></i></label> </div>';
    
    objTo.appendChild(divtest);
    $('.notas_presentacion').tagsinput('refresh');
    $('.bootstrap-tagsinput').css({
    'display': 'block',
    'box-shadow': 'none'
    });
}

function remove_notas_fieldss(rid) {
    $('.removeclass' + rid).remove();
    countDivss();
}

$('.btn-importar-producto').click( function() {
    $('#id_prod_producto').val('');
    $('#transf').addClass('active');
    $('#ntransf').removeClass('active');
    $("input[name=id_tipo][value='1']").attr("checked",true);
    $("input[name=id_tipo][value='2']").attr("checked",false);
    ComboCatg();
    $('#notas_producto').tagsinput('removeAll');
    $('.bootstrap-tagsinput').css({
        'display': 'block',
        'box-shadow': 'none'
    });
    $('#hidden_delivery_producto').val(0);
    $('#delivery_producto').prop('checked', false);
    $('#hidden_estado_producto').val('a');
    $('#estado_producto').prop('checked', true);
    $('#modal-import').modal('show');
});

$('#modal-import').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#upfile').formValidation('resetForm', true);
});

/* PRODUCTO */

$(document).on('click', '#ul-cat li .link', function(){
    $(this).parent().parent().find('li').removeClass('cat_active');
    $(this).parent().addClass('cat_active');
});

$(document).on('click', '#table-productos_wrapper .dataTable tbody tr .link', function(){
    $(this).parent().parent().parent().find('tr').removeClass('pro_active');
    $(this).parent().parent().addClass('pro_active');
});

$(document).on('click', '#body-p a.link', function(){
    $(this).parent().find('a').find('div').removeClass('pre_active');
    $(this).find('div').addClass('pre_active');
});


$('#presentacion_presentacion').keyup(function(){
    var abrev_pres = ($(this).val().charAt(0)+''+$(this).val().charAt(1)+''+$(this).val().charAt(2)).toUpperCase();
    var abrev_prod = ($('#nomb_pres').text().charAt(0)+''+$('#nomb_pres').text().charAt(1)).toUpperCase();
    var abrev_prec = Math.floor($('#precio_presentacion').val());
    $("#cod_prod_presentacion").val(abrev_prod+''+abrev_pres+''+abrev_prec);
});

$('#precio_presentacion').keyup(function(){
    var abrev_pres = ($('#presentacion_presentacion').val().charAt(0)+''+$('#presentacion_presentacion').val().charAt(1)+''+$('#nombre_pres').val().charAt(2)).toUpperCase();
    var abrev_prod = ($('#nomb_pres').text().charAt(0)+''+$('#nomb_pres').text().charAt(1)).toUpperCase();
    var abrev_prec = Math.floor($(this).val());
    $("#cod_prod_presentacion").val(abrev_prod+''+abrev_pres+''+abrev_prec);
    calcularPrecioConImpuesto();
});

// Función para calcular el precio con impuesto
function calcularPrecioConImpuesto() {
    var precioBase = parseFloat($('#precio_presentacion').val()) || 0;
    var usarSistema = $('input[name="tipo_impuesto_presentacion"]:checked').val() == '1';
    var impuestoIncluido = false;
    var porcentajeImpuesto = 0;
    
    if (usarSistema) {
        // Obtener configuración del sistema desde la variable oculta
        var impuestoIncluidoSistema = $('#impuesto_incluido_sistema').val() || '0';
        impuestoIncluido = (impuestoIncluidoSistema == '1' || impuestoIncluidoSistema == 1);
        porcentajeImpuesto = parseFloat($('#igv_impuesto').val()) || 0;
    } else {
        // Usar configuración personalizada
        impuestoIncluido = $('input[name="impuesto_incluido_pres"]:checked').val() == '1';
        var porcentajePersonalizado = parseFloat($('#impuesto_porcentaje_personalizado').val()) || parseFloat($('#igv_impuesto').val()) || 0;
        porcentajeImpuesto = porcentajePersonalizado / 100; // Convertir porcentaje a decimal
    }
    
    var impuestoMonto = 0;
    var precioFinal = 0;
    var precioBaseMostrar = precioBase; // Precio base a mostrar en la UI
    
    if (impuestoIncluido) {
        // Si el impuesto está incluido, el precio ingresado ya lo contiene
        // Calculamos el precio sin impuesto: precioSinImpuesto = precioBase / (1 + porcentajeImpuesto)
        var precioSinImpuesto = precioBase / (1 + porcentajeImpuesto);
        impuestoMonto = precioBase - precioSinImpuesto;
        precioFinal = precioBase; // El precio final es el mismo que el ingresado (ya incluye impuesto)
        precioBaseMostrar = precioSinImpuesto; // Mostrar el precio sin impuesto como "precio base"
    } else {
        // Si el impuesto está excluido, el precio ingresado es el precio base
        impuestoMonto = precioBase * porcentajeImpuesto;
        precioFinal = precioBase + impuestoMonto;
        precioBaseMostrar = precioBase; // El precio base es el ingresado
    }
    
    // Actualizar la UI
    $('#precio_base_calc').text(precioBaseMostrar.toFixed(2));
    $('#impuesto_calc').text(impuestoMonto.toFixed(2));
    $('#precio_final_calc').text(precioFinal.toFixed(2));
    
    // Actualizar porcentaje mostrado
    var porcentajeMostrar = usarSistema ? 
        $('#impuesto_valor_sistema').val() || (parseFloat($('#igv_impuesto').val()) * 100).toFixed(2) : 
        parseFloat($('#impuesto_porcentaje_personalizado').val()) || $('#impuesto_valor_sistema').val() || (parseFloat($('#igv_impuesto').val()) * 100).toFixed(2);
    $('#impuesto_porcentaje_calc').text(porcentajeMostrar);
    
    // Actualizar nombre del impuesto
    var nombreImpuesto = $('#impuesto_nombre_sistema').val() || 'Impuesto';
    $('#impuesto_nombre_calc').text(nombreImpuesto);
}

// Manejar cambio entre usar sistema y personalizar (click en cards)
$(document).on('click', '.card-tipo-impuesto-pres', function(event){
    // Evitar doble trigger si se hace click directamente en el radio
    if($(event.target).is('input[type="radio"]') || $(event.target).closest('.form-check-input').length > 0){
        return;
    }
    var valor = $(this).data('value');
    var radioId = valor == '1' ? '#usar_sistema_radio' : '#personalizar_impuesto_radio';
    $(radioId).prop('checked', true).trigger('change');
});

// Manejar cambio entre usar sistema y personalizar (change en radio)
$(document).on('change', 'input[name="tipo_impuesto_presentacion"]', function(){
    var valorRadio = $(this).val();
    var usarSistema = (valorRadio == '1' || valorRadio === '1');
    var valorHidden = usarSistema ? '1' : '0';
    $('#usar_impuesto_sistema_hidden').val(valorHidden);
    console.log('Radio cambiado - valor:', valorRadio, '| usarSistema:', usarSistema, '| hidden actualizado a:', valorHidden);
    
    // Actualizar estilos de las cards
    if(usarSistema){
        $('.card-tipo-impuesto-pres[data-value="1"]').css({'border-color': '#2196F3', 'background-color': '#E3F2FD'});
        $('.card-tipo-impuesto-pres[data-value="0"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
        $('#opciones_personalizacion_impuesto').slideUp();
    } else {
        $('.card-tipo-impuesto-pres[data-value="0"]').css({'border-color': '#FF9800', 'background-color': '#FFF3E0'});
        $('.card-tipo-impuesto-pres[data-value="1"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
        $('#opciones_personalizacion_impuesto').slideDown();
    }
    
    calcularPrecioConImpuesto();
});

// Manejar cambio en impuesto incluido/excluido personalizado
$(document).on('change', 'input[name="impuesto_incluido_pres"]', function(){
    var valor = $(this).val();
    $('#impuesto_incluido_personalizado_hidden').val(valor);
    
    // Actualizar estilos de las cards
    if(valor == '1'){
        $('.card-radio-impuesto-pres[data-value="1"]').css({'border-color': '#4caf50', 'background-color': '#f1f8f4'});
        $('.card-radio-impuesto-pres[data-value="0"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    } else {
        $('.card-radio-impuesto-pres[data-value="0"]').css({'border-color': '#f44336', 'background-color': '#fff5f5'});
        $('.card-radio-impuesto-pres[data-value="1"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    }
    
    calcularPrecioConImpuesto();
});

// Permitir hacer click en toda la card para seleccionar
$(document).on('click', '.card-radio-impuesto-pres', function(event){
    var valor = $(this).data('value');
    var radioId = valor == '1' ? '#impuesto_incluido_pres_radio' : '#impuesto_excluido_pres_radio';
    $(radioId).prop('checked', true).trigger('change');
});

// Calcular cuando cambia el precio
$('#precio_presentacion').on('input change', function(){
    calcularPrecioConImpuesto();
});

// Calcular cuando cambia el porcentaje personalizado
$(document).on('input change', '#impuesto_porcentaje_personalizado', function(){
    calcularPrecioConImpuesto();
});