$(function() {
    moment.locale('es');
    obtenerDatos();
    $('#created_at').bootstrapMaterialDatePicker({
        time: false,
        format: 'DD-MM-YYYY',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });
    $('#form-plataforma').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    }).on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        // Asegurar valores antes de enviar
        var mostrarImp = $('#mostrar_opcion_impresion').prop('checked') ? '1' : '0';
        var noImprimir = $('#no_imprimir_ni_mostrar').prop('checked') ? '1' : '0';
        var modEstadisticas = $('#modulo_estadisticas').prop('checked') ? '1' : '0';
        $('#mostrar_opcion_impresion_hidden').val(mostrarImp);
        $('#no_imprimir_ni_mostrar_opcion_hidden').val(noImprimir);
        $('#modulo_estadisticas_hidden').val(modEstadisticas);
        var parametros = new FormData($('#form-plataforma')[0]);
        parametros.set('mostrar_opcion_impresion', mostrarImp);
        parametros.set('no_imprimir_ni_mostrar_opcion', noImprimir);
        parametros.set('modulo_estadisticas', modEstadisticas);
        
        if ($('#api_wsp_hidden').val()=='1' && $('#wsp_token').val()=='') {
            Swal.fire({
                title: 'Falta token API Whatsapp',
                text: 'Si activa el envio por api debe colocar un token válido',
                icon: 'warning',
                showConfirmButton: true,
            });
            return false;
        }

        if ($('#api_wsp_hidden').val()=='1' && $('#wsp_number').val().length != 11) {
            Swal.fire({
                title: 'Falta token API Whadddtsapp',
                text: 'Si activa el envio por api debe colocar un token válido',
                icon: 'warning',
                showConfirmButton: true,
            });
            return false;
        }        

        $.ajax({
            url: $('#url').val()+'ajuste/datosplataforma_crud',
            type: 'POST',
            data: parametros,
            dataType: 'json',
            contentType: false,
            processData: false,
         })
         .done(function(response){
            var html_terminado = '<div>Datos actualizados correctamente</div>\
                <br><a href="'+$('#url').val()+'ajuste" class="btn btn-success">Aceptar</button>'
            Swal.fire({
                title: 'Proceso Terminado',
                html: html_terminado,
                icon: 'success',
                showConfirmButton: false
            });
            obtenerDatos();
        })
        .fail(function(){
            swal('Oops...', 'Problemas con la conexión a internet!', 'error');
        });
    });

    
});

$('.btn-plataforma').click( function() {
    obtenerDatos(function() {
        $('#modal-plataforma').modal('show');
    });
});


var bloc_desbloc = function(){
    if($('#bloqueo_id').val() == '0'){
        var html_confirm = '<div>Se procederá a desbloquear la plataforma</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
        var bloqueo_id = 1;
    }else{
        var html_confirm = '<div>Se procederá a bloquear la plataforma</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
        var bloqueo_id = 0;
    }
    // console.log(bloqueo_id);
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
        return new Promise(function(resolve) {
            console.log(bloqueo_id);
            $.ajax({
                url: $('#url').val()+'ajuste/bloqueo',
                type: 'POST',
                data: {
                    // $ver = (Session::get('rol') == 1) ? '' :  header('location: ' . URL . 'err/danger'); 

                    tipo_bloqueo  : bloqueo_id,
                    },
                dataType: 'json'
            })
            .done(function(response){
                if(response == 1){
                Swal.fire({
                    title: 'Proceso Terminado',
                    text: 'Datos eliminados correctamente',
                    icon: 'success',
                    showConfirmButton: false,
                });
                location.reload();
                }else{
                    Swal.fire({
                        title: 'Proceso No Culminado',
                        text: 'no se pueden eliminar',
                        icon: 'error',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                }
            })
            .fail(function(){
                Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
            });
        });
        },
        allowOutsideClick: false              
    });
}

var obtenerDatos = function(callback){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/datosplataforma_data",
        dataType: "json",
        success: function(item){
            console.log(item.created_at);
            $('#created_at').val(item.created_at);
            $('#limit_users').val(item.limit_users);
            $('#limit_documents').val(item.limit_documents);
            $('#locked_users_hidden').val(item.locked_users);   
            $('#locked_documents_hidden').val(item.locked_documents);
            $('#activated_mesa_hidden').val(item.activated_mesa);
            $('#activated_llevar_hidden').val(item.activated_llevar);
            $('#activated_delivery_hidden').val(item.activated_delivery);
            $('#activated_pdv_pos_hidden').val(item.activated_pdv_pos);
            $('#activated_mod_compras_hidden').val(item.activated_mod_compras);
            $('#activated_mod_inv_hidden').val(item.activated_mod_inv);
            $('#activated_mod_ins_recet_topp_hidden').val(item.activated_mod_ins_recet_topp);
            $('#api_wsp_hidden').val(item.api_wsp);   
            $('#wsp_token').val(item.wsp_token);
            $('#wsp_number').val(item.wsp_number);
            var mostrarImp = (item.mostrar_opcion_impresion === '1' || item.mostrar_opcion_impresion === 1);
            var noImprimirNiMostrar = (item.no_imprimir_ni_mostrar_opcion === '1' || item.no_imprimir_ni_mostrar_opcion === 1);
            $('#mostrar_opcion_impresion_hidden').val(mostrarImp ? '1' : '0');
            $('#mostrar_opcion_impresion').prop('checked', mostrarImp);
            $('#no_imprimir_ni_mostrar_opcion_hidden').val(noImprimirNiMostrar ? '1' : '0');
            $('#no_imprimir_ni_mostrar').prop('checked', noImprimirNiMostrar);
            var modEstadisticas = (item.modulo_estadisticas === '1' || item.modulo_estadisticas === 1);
            $('#modulo_estadisticas_hidden').val(modEstadisticas ? '1' : '0');
            $('#modulo_estadisticas').prop('checked', modEstadisticas);

            if(item.locked_users == '1'){$('#locked_users').prop('checked', true)}else{$('#locked_users').prop('checked', false)};
            if(item.locked_documents == '1'){$('#locked_documents').prop('checked', true)}else{$('#locked_documents').prop('checked', false)};
            if(item.activated_mesa == '1'){$('#activated_mesa').prop('checked', true)}else{$('#activated_mesa').prop('checked', false)};
            if(item.activated_llevar == '1'){$('#activated_llevar').prop('checked', true)}else{$('#activated_llevar').prop('checked', false)};
            if(item.activated_delivery == '1'){$('#activated_delivery').prop('checked', true)}else{$('#activated_delivery').prop('checked', false)};
            if(item.activated_pdv_pos == '1'){$('#activated_pdv_pos').prop('checked', true)}else{$('#activated_pdv_pos').prop('checked', false)};
            if(item.activated_mod_compras == '1'){$('#activated_mod_compras').prop('checked', true)}else{$('#activated_mod_compras').prop('checked', false)};
            if(item.activated_mod_inv == '1'){$('#activated_mod_inv').prop('checked', true)}else{$('#activated_mod_inv').prop('checked', false)}; 
            if(item.activated_mod_ins_recet_topp == '1'){$('#activated_mod_ins_recet_topp').prop('checked', true)}else{$('#activated_mod_ins_recet_topp').prop('checked', false)};
            if(item.api_wsp == '1'){$('#api_wsp').prop('checked', true); $('.div_token_wsp').show();}else{$('#api_wsp').prop('checked', false); $('.div_token_wsp').hide();}
            if (typeof callback === 'function') { callback(); }
        }
    });
}
$('#locked_users').on('change', function(event){
    if($(this).prop('checked')){
        $('#locked_users_hidden').val('1');
    }else{
        $('#locked_users_hidden').val('0');
    }
});

$('#locked_documents').on('change', function(event){
    if($(this).prop('checked')){
        $('#locked_documents_hidden').val('1');
    }else{
        $('#locked_documents_hidden').val('0');
    }
});
$('#activated_mesa').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_mesa_hidden').val('1');
    }else{
        $('#activated_mesa_hidden').val('0');
    }
});
$('#activated_llevar').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_llevar_hidden').val('1');
    }else{
        $('#activated_llevar_hidden').val('0');
    }
});
$('#activated_delivery').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_delivery_hidden').val('1');
    }else{
        $('#activated_delivery_hidden').val('0');
    }
});
$('#activated_pdv_pos').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_pdv_pos_hidden').val('1');
    }else{
        $('#activated_pdv_pos_hidden').val('0');
    }
});
$('#activated_mod_compras').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_mod_compras_hidden').val('1');
    }else{
        $('#activated_mod_compras_hidden').val('0');
    }
});
$('#activated_mod_inv').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_mod_inv_hidden').val('1');
    }else{
        $('#activated_mod_inv_hidden').val('0');
    }
});
$('#activated_mod_ins_recet_topp').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_mod_ins_recet_topp_hidden').val('1');
    }else{
        $('#activated_mod_ins_recet_topp_hidden').val('0');
    }
});
$('#api_wsp').on('change', function(event){
    if($(this).prop('checked')){
        $('#api_wsp_hidden').val('1');
        $('.div_token_wsp').show();

    }else{
        $('#api_wsp_hidden').val('0');
        $('.div_token_wsp').hide();
    }
});
$('#mostrar_opcion_impresion').on('change', function(event){
    if($(this).prop('checked')){
        $('#mostrar_opcion_impresion_hidden').val('1');
    }else{
        $('#mostrar_opcion_impresion_hidden').val('0');
    }
});
$('#no_imprimir_ni_mostrar').on('change', function(event){
    if($(this).prop('checked')){
        $('#no_imprimir_ni_mostrar_opcion_hidden').val('1');
        $('#mostrar_opcion_impresion').prop('checked', false);
        $('#mostrar_opcion_impresion_hidden').val('0');
    }else{
        $('#no_imprimir_ni_mostrar_opcion_hidden').val('0');
    }
});
$('#modulo_estadisticas').on('change', function(event){
    if($(this).prop('checked')){
        $('#modulo_estadisticas_hidden').val('1');
    }else{
        $('#modulo_estadisticas_hidden').val('0');
    }
});