$(function() {

    const rangeInputs = document.querySelectorAll('input[type="range"]');

    rangeInputs.forEach(function(rangeInput) {
      const tooltip = rangeInput.nextElementSibling;
    
      rangeInput.addEventListener("input", function() {
        const selectedValue = rangeInput.value;
        tooltip.innerText = selectedValue;
        tooltip.style.display = "block";
      });
    
      rangeInput.addEventListener("mouseout", function() {
        tooltip.style.display = "none";
      });
    });
    
    var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
    $('.js-switch').each(function() {
        new Switchery($(this)[0], $(this).data());
    });
    obtenerDatos();
    $('#config').addClass("active");
    $('#form').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    }).on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        var parametros = new FormData($('#form')[0]);

        // Guardar configuración del sistema
        $.ajax({
            url: $('#url').val()+'ajuste/datosistema_crud',
            type: 'POST',
            data: parametros,
            dataType: 'json',
            contentType: false,
            processData: false,
         })
         .done(function(response){
            // Guardar configuración de facturación electrónica
            var parametrosFacturacion = new FormData();
            parametrosFacturacion.append('ff_company_uuid', $('#ff_company_uuid').val());
            parametrosFacturacion.append('ff_api_key', $('#ff_api_key').val());
            parametrosFacturacion.append('ff_branch', $('#ff_branch').val());
            parametrosFacturacion.append('facturacion_activa', $('#facturacion_activa_hidden').val());
            
            $.ajax({
                url: $('#url').val()+'ajuste/facturacion_electronica_crud',
                type: 'POST',
                data: parametrosFacturacion,
                dataType: 'json',
                contentType: false,
                processData: false,
            })
            .done(function(responseFacturacion){
                var html_terminado = '<div>Datos actualizados correctamente</div>\
                    <br><a href="'+$('#url').val()+'ajuste/sistema" class="btn btn-success">Aceptar</button>'
                Swal.fire({
                    title: 'Proceso Terminado',
                    html: html_terminado,
                    icon: 'success',
                    showConfirmButton: false
                });
                obtenerDatos();
                obtenerDatosFacturacion();
            })
            .fail(function(){
                var html_terminado = '<div>Datos del sistema actualizados, pero hubo un problema al guardar la configuración de facturación</div>\
                    <br><a href="'+$('#url').val()+'ajuste/sistema" class="btn btn-success">Aceptar</button>'
                Swal.fire({
                    title: 'Proceso Parcialmente Terminado',
                    html: html_terminado,
                    icon: 'warning',
                    showConfirmButton: false
                });
                obtenerDatos();
            });
        })
        .fail(function(){
            swal('Oops...', 'Problemas con la conexión a internet!', 'error');
        });
    });
});

var obtenerDatos = function(){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/datosistema_data",
        dataType: "json",
        success: function(item){
            $('#zona_hora').val(item.zona_hora);
            $('#trib_acr').val(item.trib_acr);
            $('#trib_car').val(item.trib_car);
            $('#di_acr').val(item.di_acr);
            $('#di_car').val(item.di_car);            
            $('#imp_acr').val(item.imp_acr);
            $('#imp_val').val(item.imp_val);
            $('#mon_acr').val(item.mon_acr);
            $('#mon_val').val(item.mon_val);
            
            // Cargar configuración de impuesto incluido/excluido
            var impuestoIncluido = item.impuesto_incluido || 0;
            if(impuestoIncluido == '1' || impuestoIncluido == 1){
                $('#impuesto_incluido_radio').prop('checked', true);
                $('#impuesto_incluido_hidden').val('1');
                $('.card-radio-impuesto[data-value="1"]').css({'border-color': '#4caf50', 'background-color': '#f1f8f4'});
                $('.card-radio-impuesto[data-value="0"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
            } else {
                $('#impuesto_excluido_radio').prop('checked', true);
                $('#impuesto_incluido_hidden').val('0');
                $('.card-radio-impuesto[data-value="0"]').css({'border-color': '#f44336', 'background-color': '#fff5f5'});
                $('.card-radio-impuesto[data-value="1"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
            }           
            $('#pc_name').val(item.pc_name);           
            $('#pc_ip').val(item.pc_ip);   
            $('#print_com_hidden').val(item.print_com);   
            $('#print_pre_hidden').val(item.print_pre);
            $('#print_cpe_hidden').val(item.print_cpe);
            $('#cod_seg').val(item.cod_seg); 
            $('#opc_01_hidden').val(item.opc_01);
            $('#editprice_hidden').val(item.editprice);
            $('#multimozo_hidden').val(item.multimozo);
            $('#print_com_combo_hidden').val(item.print_com_combo);
            $('#com_delivery_hidden').val(item.com_delivery);
            $('#print_com_re_hidden').val(item.print_com_re);  
            $('#com_rc_hidden').val(item.com_rc);
            $('#com_rc_val').val(item.com_rc_val);
            $('#com_tar_hidden').val(item.com_tar);
            $('#com_tar_val').val(item.com_tar_val);
            $('#nota_ind_hidden').val(item.nota_ind);
            $('#anular_pedido_mesa_hidden').val(item.anular_pedido_mesa);
            $('#anular_pedido_mesa_com_hidden').val(item.anular_pedido_mesa_com);
            $('#anular_pedido_llevar_hidden').val(item.anular_pedido_llevar);
            $('#anular_pedido_llevar_com_hidden').val(item.anular_pedido_llevar_com);
            $('#anular_pedido_delivery_hidden').val(item.anular_pedido_delivery);
            $('#anular_pedido_delivery_com_hidden').val(item.anular_pedido_delivery_com);
            $('#prod_caja_sep_hidden').val(item.prod_caja_sep);
            $('#mesa_ticket_desp_hidden').val(item.mesa_ticket_desp);
            $('#llevar_ticket_desp_hidden').val(item.llevar_ticket_desp);
            $('#delivery_ticket_desp_hidden').val(item.delivery_ticket_desp);
            $('#pdf_logo_dim').val(item.pdf_logo_dim);
            $('#pdf_logo_alt').val(item.pdf_logo_alt);
            $('#pdf_logo_mg').val(item.pdf_logo_mg);
            $('#printer_select').val(item.printer_select);
            $('#report_date_hidden').val(item.report_date);
            $('#activated_pres_hidden').val(item.activated_pres);
            $('#activated_price_com_hidden').val(item.activated_price_com);
            $('#activated_open_gaveta_hidden').val(item.activated_open_gaveta);
            $('#activated_vista_pos_2_hidden').val(item.activated_vista_pos_2);
            $('#sep_items_hidden').val(item.sep_items);
            $('#desactivar_precuenta_hidden').val(item.desactivar_precuenta);
            $('#actu_automatica_mesa_hidden').val(item.actu_automatica_mesa);
            $('#decimal_stock_hidden').val(item.decimal_stock);
            
            
            
            if(item.print_com == '1')
            {$('#print_com').prop('checked', true)}else{$('#print_com_combo').prop('disabled', true);$('#print_com_re').prop('disabled', true)}
            if(item.print_pre == '1'){$('#print_pre').prop('checked', true)}
            if(item.print_cpe == '1'){$('#print_cpe').prop('checked', true)}
            if(item.opc_01 == '1'){$('#opc_01').prop('checked', true)}
            if(item.editprice == '1'){$('#editprice').prop('checked', true)}
            if(item.multimozo == '1'){$('#multimozo').prop('checked', true)}
            if(item.print_com_combo == '1'){$('#print_com_combo').prop('checked', true)}
            if(item.print_com_re == '1'){$('#print_com_re').prop('checked', true)}
            if(item.com_delivery == '1'){$('#com_delivery').prop('checked', true)}
            if(item.nota_ind == '1'){$('#nota_ind').prop('checked', true)}
            if(item.com_rc == '1'){$('#com_rc').prop('checked', true); $('.rc_val').css('display','block');}
            if(item.com_tar == '1'){$('#com_tar').prop('checked', true); $('.tar_val').css('display','block');}
            if(item.anular_pedido_mesa == '1')
            {$('#anular_pedido_mesa').prop('checked', true)}else{ $('#anular_pedido_mesa_com').prop('disabled', true)}
            if(item.anular_pedido_mesa_com == '1'){$('#anular_pedido_mesa_com').prop('checked', true)}
            if(item.anular_pedido_llevar == '1')
            {$('#anular_pedido_llevar').prop('checked', true)}else{ $('#anular_pedido_llevar_com').prop('disabled', true)} 
            if(item.anular_pedido_llevar_com == '1'){$('#anular_pedido_llevar_com').prop('checked', true)}
            if(item.anular_pedido_delivery == '1')
            {$('#anular_pedido_delivery').prop('checked', true)}else{ $('#anular_pedido_delivery_com').prop('disabled', true)}
            if(item.anular_pedido_delivery_com == '1'){$('#anular_pedido_delivery_com').prop('checked', true)}
            if(item.prod_caja_sep == '1'){$('#prod_caja_sep').prop('checked', true)}
            if(item.mesa_ticket_desp == '1'){$('#mesa_ticket_desp').prop('checked', true)}
            if(item.llevar_ticket_desp == '1'){$('#llevar_ticket_desp').prop('checked', true)}
            if(item.delivery_ticket_desp == '1'){$('#delivery_ticket_desp').prop('checked', true)}
            if(item.printer_select == '1'){$('#printer_select').prop('checked', true)}
            if(item.report_date == '1'){$('#report_date').prop('checked', true)}
            if(item.activated_pres == '1'){$('#activated_pres').prop('checked', true)}
            if(item.activated_price_com == '1'){$('#activated_price_com').prop('checked', true)}
            if(item.activated_open_gaveta == '1'){$('#activated_open_gaveta').prop('checked', true)}
            if(item.activated_vista_pos_2 == '1'){$('#activated_vista_pos_2').prop('checked', true)}
            if(item.sep_items == '1'){$('#sep_items').prop('checked', true)}
            if(item.desactivar_precuenta == '1'){$('#desactivar_precuenta').prop('checked', true)}
            if(item.actu_automatica_mesa == '1'){$('#actu_automatica_mesa').prop('checked', true)}
            if(item.decimal_stock == '1'){$('#decimal_stock').prop('checked', true)}
            
            if (item.cat_menu == '1') {
                $('#customRadio1').prop('checked', true);
              }else {
                $('#customRadio0').prop('checked', true);
              }
            
            // Cargar datos de facturación electrónica
            obtenerDatosFacturacion();

        }
    });
}

var obtenerDatosFacturacion = function(){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/facturacion_electronica_data",
        dataType: "json",
        success: function(item){
            $('#ff_company_uuid').val(item.ff_company_uuid || '');
            $('#ff_api_key').val(item.ff_api_key || '');
            $('#ff_branch').val(item.ff_branch || '');
            $('#facturacion_activa_hidden').val(item.activo || '0');
            
            // Cargar campos de sucursal si existen en el formulario
            if ($('#branch_address').length) $('#branch_address').val(item.branch_address || '');
            if ($('#branch_phone').length) $('#branch_phone').val(item.branch_phone || '');
            if ($('#branch_location').length) $('#branch_location').val(item.branch_location || '');
            if ($('#branch_coordinates').length) $('#branch_coordinates').val(item.branch_coordinates || '');
            if ($('#branch_email').length) $('#branch_email').val(item.branch_email || '');
            
            if(item.activo == '1' || item.activo == 1){
                $('#facturacion_activa').prop('checked', true);
            } else {
                $('#facturacion_activa').prop('checked', false);
            }
        }
    });
}

$('#anular_pedido_mesa').on('change', function(event){
    if($(this).prop('checked')){
        $('#anular_pedido_mesa_hidden').val('1');
        $('#anular_pedido_mesa_com').prop('disabled', false);
    }else{
        $('#anular_pedido_mesa_hidden').val('0');
        $('#anular_pedido_mesa_com').prop('disabled', true);
        $('#anular_pedido_mesa_com').prop('checked', false);
        $('#anular_pedido_mesa_com_hidden').val('0');
    }
});

$('#anular_pedido_mesa_com').on('change', function(event){
    if($(this).prop('checked')){
        $('#anular_pedido_mesa_com_hidden').val('1');
    }else{
        $('#anular_pedido_mesa_com_hidden').val('0');
    }
});

$('#printer_select').on('change', function(event){
    if($(this).prop('checked')){
        $('#printer_select_hidden').val('1');
    }else{
        $('#printer_select_hidden').val('0');
    }
});

$('#anular_pedido_llevar').on('change', function(event){
    if($(this).prop('checked')){
        $('#anular_pedido_llevar_hidden').val('1');
        $('#anular_pedido_llevar_com').prop('disabled', false);
    }else{
        $('#anular_pedido_llevar_hidden').val('0');
        $('#anular_pedido_llevar_com').prop('disabled', true);
        $('#anular_pedido_llevar_com').prop('checked', false);
        $('#anular_pedido_llevar_com_hidden').val('0');
    }
});

$('#anular_pedido_llevar_com').on('change', function(event){
    if($(this).prop('checked')){
        $('#anular_pedido_llevar_com_hidden').val('1');
    }else{
        $('#anular_pedido_llevar_com_hidden').val('0');
    }
});


$('#anular_pedido_delivery').on('change', function(event){
    if($(this).prop('checked')){
        $('#anular_pedido_delivery_hidden').val('1');
        $('#anular_pedido_delivery_com').prop('disabled', false);
    }else{
        $('#anular_pedido_delivery_hidden').val('0');
        $('#anular_pedido_delivery_com').prop('disabled', true);
        $('#anular_pedido_delivery_com').prop('checked', false);
        $('#anular_pedido_delivery_com_hidden').val('0');
    }
});

$('#anular_pedido_delivery_com').on('change', function(event){
    if($(this).prop('checked')){
        $('#anular_pedido_delivery_com_hidden').val('1');
    }else{
        $('#anular_pedido_delivery_com_hidden').val('0');
    }
});

$('#print_com').on('change', function(event){
    if($(this).prop('checked')){
        $('#print_com_hidden').val('1');
        $('#print_com_combo').prop('disabled', false);
        $('#print_com_re').prop('disabled', false);
    }else{
        $('#print_com_hidden').val('0');
        $('#print_com_combo').prop('disabled', true);
        $('#print_com_combo').prop('checked', false);
        $('#print_com_combo_hidden').val('0');

        $('#print_com_re').prop('disabled', true);
        $('#print_com_re').prop('checked', false);
        $('#print_com_re_hidden').val('0');
    }
});

$('#com_rc').on('change', function(event){
    if($(this).prop('checked')){
        $('#com_rc_hidden').val('1');
        $('.rc_val').css('display','block');
    }else{
        $('#com_rc_hidden').val('0');
        $('#com_rc_val').val('0');
        $('.rc_val').css('display','none');
    }
});

$('#com_tar').on('change', function(event){
    if($(this).prop('checked')){
        $('#com_tar_hidden').val('1');
        $('.tar_val').css('display','block');
    }else{
        $('#com_tar_hidden').val('0');
        $('#com_tar_val').val('0');
        $('.tar_val').css('display','none');
    }
});

$('#print_com_combo').on('change', function(event){
    if($(this).prop('checked')){
        $('#print_com_combo_hidden').val('1');
    }else{
        $('#print_com_combo_hidden').val('0');
    }
});

$('#print_com_re').on('change', function(event){
    if($(this).prop('checked')){
        $('#print_com_re_hidden').val('1');
    }else{
        $('#print_com_re_hidden').val('0');
    }
});

$('#print_pre').on('change', function(event){
    if($(this).prop('checked')){
        $('#print_pre_hidden').val('1');
    }else{
        $('#print_pre_hidden').val('0');
    }
});

$('#print_cpe').on('change', function(event){
    if($(this).prop('checked')){
        $('#print_cpe_hidden').val('1');
    }else{
        $('#print_cpe_hidden').val('0');
    }
});
$('#opc_01').on('change', function(event){
    if($(this).prop('checked')){
        $('#opc_01_hidden').val('1');
    }else{
        $('#opc_01_hidden').val('0');
    }
});

$('#editprice').on('change', function(event){
    if($(this).prop('checked')){
        $('#editprice_hidden').val('1');
    }else{
        $('#editprice_hidden').val('0');
    }
});

$('#multimozo').on('change', function(event){
    if($(this).prop('checked')){
        $('#multimozo_hidden').val('1');
    }else{
        $('#multimozo_hidden').val('0');
    }
});
$('#com_delivery').on('change', function(event){
    if($(this).prop('checked')){
        $('#com_delivery_hidden').val('1');
    }else{
        $('#com_delivery_hidden').val('0');
    }
});

$('#nota_ind').on('change', function(event){
    if($(this).prop('checked')){
        $('#nota_ind_hidden').val('1');
    }else{
        $('#nota_ind_hidden').val('0');
    }
});

$('#prod_caja_sep').on('change', function(event){
    if($(this).prop('checked')){
        $('#prod_caja_sep_hidden').val('1');
    }else{
        $('#prod_caja_sep_hidden').val('0');
    }
});

$('#mesa_ticket_desp').on('change', function(event){
    if($(this).prop('checked')){
        $('#mesa_ticket_desp_hidden').val('1');
    }else{
        $('#mesa_ticket_desp_hidden').val('0');
    }
});

$('#llevar_ticket_desp').on('change', function(event){
    if($(this).prop('checked')){
        $('#llevar_ticket_desp_hidden').val('1');
    }else{
        $('#llevar_ticket_desp_hidden').val('0');
    }
});

$('#delivery_ticket_desp').on('change', function(event){
    if($(this).prop('checked')){
        $('#delivery_ticket_desp_hidden').val('1');
    }else{
        $('#delivery_ticket_desp_hidden').val('0');
    }
});
$('#report_date').on('change', function(event){
    if($(this).prop('checked')){
        $('#report_date_hidden').val('1');
    }else{
        $('#report_date_hidden').val('0');
    }
});
$('#activated_pres').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_pres_hidden').val('1');
    }else{
        $('#activated_pres_hidden').val('0');
    }
});
$('#activated_price_com').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_price_com_hidden').val('1');
    }else{
        $('#activated_price_com_hidden').val('0');
    }
});
$('#activated_open_gaveta').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_open_gaveta_hidden').val('1');
    }else{
        $('#activated_open_gaveta_hidden').val('0');
    }
});
$('#activated_vista_pos_2').on('change', function(event){
    if($(this).prop('checked')){
        $('#activated_vista_pos_2_hidden').val('1');
    }else{
        $('#activated_vista_pos_2_hidden').val('0');
    }
});

$('#sep_items').on('change', function(event){
    if($(this).prop('checked')){
        $('#sep_items_hidden').val('1');
    }else{
        $('#sep_items_hidden').val('0');
    }
});


$('#desactivar_precuenta').on('change', function(event){
    if($(this).prop('checked')){
        $('#desactivar_precuenta_hidden').val('1');
    }else{
        $('#desactivar_precuenta_hidden').val('0');
    }
});

$('#actu_automatica_mesa').on('change', function(event){
    if($(this).prop('checked')){
        $('#actu_automatica_mesa_hidden').val('1');
    }else{
        $('#actu_automatica_mesa_hidden').val('0');
    }
});

$('#decimal_stock').on('change', function(event){
    if($(this).prop('checked')){
        $('#decimal_stock_hidden').val('1');
    }else{
        $('#decimal_stock_hidden').val('0');
    }
});

const togglePasswordUser = document.querySelector('#togglePasswordUser');
const contrasena = document.querySelector('#cod_seg');
if (togglePasswordUser && contrasena) {
    togglePasswordUser.addEventListener('click', function() {
        const type = contrasena.getAttribute('type') === 'password' ? 'text' : 'password';
        contrasena.setAttribute('type', type);
        if (type === 'password') {
            this.classList.remove('fa-eye');
            this.classList.add('fa-eye-slash');
        } else {
            this.classList.remove('fa-eye-slash');
            this.classList.add('fa-eye');
        }
    });
}

// Toggle para mostrar/ocultar API Key
const togglePasswordApiKey = document.querySelector('#togglePasswordApiKey');
const apiKey = document.querySelector('#ff_api_key');
if (togglePasswordApiKey && apiKey) {
    togglePasswordApiKey.addEventListener('click', function() {
        const type = apiKey.getAttribute('type') === 'password' ? 'text' : 'password';
        apiKey.setAttribute('type', type);
        if (type === 'password') {
            this.classList.remove('fa-eye');
            this.classList.add('fa-eye-slash');
        } else {
            this.classList.remove('fa-eye-slash');
            this.classList.add('fa-eye');
        }
    });
}

// Manejar checkbox de facturación activa
$('#facturacion_activa').on('change', function(event){
    if($(this).prop('checked')){
        $('#facturacion_activa_hidden').val('1');
    }else{
        $('#facturacion_activa_hidden').val('0');
    }
});

// Manejar selección de tipo de impuesto (radio buttons)
$(document).on('change', 'input[name="tipo_impuesto"]', function(event){
    var valor = $(this).val();
    $('#impuesto_incluido_hidden').val(valor);
    
    // Actualizar estilos de las cards
    if(valor == '1'){
        $('.card-radio-impuesto[data-value="1"]').css({'border-color': '#4caf50', 'background-color': '#f1f8f4'});
        $('.card-radio-impuesto[data-value="0"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    } else {
        $('.card-radio-impuesto[data-value="0"]').css({'border-color': '#f44336', 'background-color': '#fff5f5'});
        $('.card-radio-impuesto[data-value="1"]').css({'border-color': '#e0e0e0', 'background-color': '#fff'});
    }
});

// Permitir hacer click en toda la card para seleccionar
$(document).on('click', '.card-radio-impuesto', function(event){
    var valor = $(this).data('value');
    var radioId = valor == '1' ? '#impuesto_incluido_radio' : '#impuesto_excluido_radio';
    $(radioId).prop('checked', true).trigger('change');
});
