$(function() {
    obtenerDatos();
    $('#config').addClass("active");

    // Cascada Ubicación Panamá (Provincia -> Distrito -> Corregimiento -> branch_location)
    if ($('#ubicacion_provincia').length) {
        $('#ubicacion_provincia').on('change', function() {
            var id = $(this).val();
            $('#ubicacion_distrito').html('<option value="">Distrito</option>').prop('disabled', true);
            $('#ubicacion_corregimiento').html('<option value="">Corregimiento</option>').prop('disabled', true);
            $('#branch_location').val('');
            if (id) cargarDistritosPanama(id);
        });
        $('#ubicacion_distrito').on('change', function() {
            var id = $(this).val();
            $('#ubicacion_corregimiento').html('<option value="">Corregimiento</option>').prop('disabled', true);
            $('#branch_location').val('');
            if (id) cargarCorregimientosPanama(id);
        });
        $('#ubicacion_corregimiento').on('change', function() {
            actualizarBranchLocation();
        });
    }

    function cargarDistritosPanama(idProvincia) {
        $.getJSON($('#url').val() + 'ajuste/getDistritosPanama', { id_provincia: idProvincia }, function(data) {
            var $sel = $('#ubicacion_distrito');
            $sel.find('option:not(:first)').remove();
            if (data && data.length) {
                $.each(data, function(i, d) {
                    $sel.append($('<option></option>').val(d.id).attr('data-codigo', d.codigo).text(d.nombre));
                });
                $sel.prop('disabled', false);
            }
        });
    }
    function cargarCorregimientosPanama(idDistrito) {
        $.getJSON($('#url').val() + 'ajuste/getCorregimientosPanama', { id_distrito: idDistrito }, function(data) {
            var $sel = $('#ubicacion_corregimiento');
            $sel.find('option:not(:first)').remove();
            if (data && data.length) {
                $.each(data, function(i, d) {
                    $sel.append($('<option></option>').val(d.id).attr('data-codigo', d.codigo).text(d.nombre));
                });
                $sel.prop('disabled', false);
            }
        });
    }
    function actualizarBranchLocation() {
        var pp = $('#ubicacion_provincia option:selected').attr('data-codigo');
        var dd = $('#ubicacion_distrito option:selected').attr('data-codigo');
        var cc = $('#ubicacion_corregimiento option:selected').attr('data-codigo');
        if (pp && dd && cc) $('#branch_location').val(pp + '-' + dd + '-' + cc);
    }

    function aplicarBranchLocationACascada(ppddcc) {
        var parts = ppddcc.split('-');
        if (parts.length !== 3) return;
        var pp = parts[0], dd = parts[1], cc = parts[2];
        var $prov = $('#ubicacion_provincia');
        var optProv = $prov.find('option[data-codigo="' + pp + '"]');
        if (!optProv.length) return;
        $prov.val(optProv.val());
        $('#ubicacion_distrito').html('<option value="">Distrito</option>').prop('disabled', true);
        $('#ubicacion_corregimiento').html('<option value="">Corregimiento</option>').prop('disabled', true);
        $.getJSON($('#url').val() + 'ajuste/getDistritosPanama', { id_provincia: optProv.val() }, function(data) {
            var $dist = $('#ubicacion_distrito');
            $dist.find('option:not(:first)').remove();
            if (data && data.length) {
                $.each(data, function(i, d) {
                    $dist.append($('<option></option>').val(d.id).attr('data-codigo', d.codigo).text(d.nombre));
                });
                $dist.prop('disabled', false);
                var optDist = $dist.find('option[data-codigo="' + dd + '"]');
                if (optDist.length) {
                    $dist.val(optDist.val());
                    $.getJSON($('#url').val() + 'ajuste/getCorregimientosPanama', { id_distrito: optDist.val() }, function(data2) {
                        var $corr = $('#ubicacion_corregimiento');
                        $corr.find('option:not(:first)').remove();
                        if (data2 && data2.length) {
                            $.each(data2, function(i, d) {
                                $corr.append($('<option></option>').val(d.id).attr('data-codigo', d.codigo).text(d.nombre));
                            });
                            $corr.prop('disabled', false);
                            var optCorr = $corr.find('option[data-codigo="' + cc + '"]');
                            if (optCorr.length) $corr.val(optCorr.val());
                        }
                    });
                }
            }
        });
    }

    // Cargar datos de facturación después de que el DOM esté completamente cargado
    // Verificar que los campos existan antes de cargar
    if($('#ff_company_uuid').length > 0){
        obtenerDatosFacturacion();
    } else {
        // Si no existen, esperar un poco más
        setTimeout(function(){
            if($('#ff_company_uuid').length > 0){
                obtenerDatosFacturacion();
            } else {
                console.error('Los campos de facturación electrónica no se encontraron en el DOM');
            }
        }, 1000);
    }
    
    // Botón para abrir modal de selección de coordenadas
    $(document).on('click', '#btn-seleccionar-coordenadas', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var modal = $('#modal-seleccionar-coordenadas');
        if (modal.length === 0) {
            Swal.fire('Error', 'El modal de selección de coordenadas no se encontró. Por favor recargue la página.', 'error');
            return;
        }
        modal.modal('show');
    });
    
    $('#form').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    }).on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        var parametros = new FormData($('#form')[0]);
        
        // Agregar datos de facturación electrónica
        parametros.append('ff_company_uuid', $('#ff_company_uuid').val());
        parametros.append('ff_api_key', $('#ff_api_key').val());
        parametros.append('ff_branch', $('#ff_branch').val());
        parametros.append('branch_address', $('#branch_address').val());
        parametros.append('branch_phone', $('#branch_phone').val());
        parametros.append('branch_location', $('#branch_location').val());
        parametros.append('branch_coordinates', $('#branch_coordinates').val());
        parametros.append('branch_email', $('#branch_email').val());
        parametros.append('facturacion_activa', $('#facturacion_activa_hidden').val());

        $.ajax({
            url: $('#url').val()+'ajuste/datosempresa_crud',
            type: 'POST',
            data: parametros,
            dataType: 'json',
            contentType: false,
            processData: false,
         })
         .done(function(response){
            var html_terminado = '<div>Datos actualizados correctamente</div>\
                <br><a href="'+$('#url').val()+'ajuste/datosempresa" class="btn btn-success">Aceptar</button>'
            Swal.fire({
                title: 'Proceso Terminado',
                html: html_terminado,
                icon: 'success',
                showConfirmButton: false
            });
            obtenerDatos();
            obtenerDatosFacturacion();
        })
        .fail(function(){
            swal('Oops...', 'Problemas con la conexión a internet!', 'error');
        });
    });
});

var obtenerDatos = function(){
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/datosempresa_data",
        dataType: "json",
        success: function(item){
            if($('#usuid').val() == 1){
                $('.sunat').show();
                $(".sunat").prop('disabled', false);
            } else {
                $('.sunat').hide();
                $(".sunat").prop('disabled', true);
            }
            $('#tribAcr').val(item.trib_acr);
            $('#ruc').val(item.ruc);
            $('#razon_social').val(item.razon_social);
            if(item.logo == null || item.logo == ''){
                $('#wizardPicturePreview-2').attr('src',$("#url").val()+'public/images/productos/default.png');
            }else{
                $('#wizardPicturePreview-2').attr('src',$("#url").val()+'public/images/'+item.logo+'');  
            }
            $('#imagen').val(item.logo);
            $('#nombre_comercial').val(item.nombre_comercial);
            $('#direccion_comercial').val(item.direccion_comercial);
            $('#direccion_fiscal').val(item.direccion_fiscal);
            $('#celular').val(item.celular);        
            $('#ubigeo').val(item.ubigeo);        
            $('#departamento').val(item.departamento);        
            $('#provincia').val(item.provincia);        
            $('#distrito').val(item.distrito);       
            $('#usuariosol').val(item.usuariosol);       
            $('#clavesol').val(item.clavesol);       
            $('#clavecertificado').val(item.clavecertificado);
            $('#client_id').val(item.client_id);       
            $('#client_secret').val(item.client_secret);
            $('#sunat_hidden').val(item.sunat);   
            $('#hidden_ose').val(item.ose);
            $('#ose_url').val(item.ose_url);
            $('#modo_hidden').val(item.modo);

            $('#hidden_pse').val(item.send_document_to_pse);
            $('#url_pse').val(item.url_login_pse);
            $('#cdr_pse').val(item.url_send_cdr_pse);
            $('#xml_pse').val(item.url_signature_pse);
            $('#usuario_pse').val(item.user_pse);
            $('#contra_pse').val(item.password_pse);

            // $('#hidden_pdf_rz').val(item.pdf_rz);

            $('#hidden_pdf_logo').val(item.pdf_logo);
            $('#hidden_pdf_rz').val(item.pdf_rz);
            $('#hidden_pdf_nc').val(item.pdf_nc);
            $('#hidden_pdf_dc').val(item.pdf_dc);
            $('#hidden_pdf_ruc').val(item.pdf_ruc);
            $('#hidden_pdf_tel').val(item.pdf_tel);

            if(item.sunat == '1'){$('#sunat').prop('checked', true)}
            if(item.modo == '1'){$('#modo').prop('checked', true)}
            if(item.ose == '1'){$('#ose').prop('checked', true); $('.ose_url').css('display','block');}  
            // if(item.pdf_rz == '1'){$('#pdf_rz').prop('checked', true)};   
            if(item.send_document_to_pse == '1'){$('#pse').prop('checked', true); $('.pse_activo').css('display','block');}

            if(item.pdf_logo == '1'){ $('#pdf_logo').prop('checked', true); }
            if(item.pdf_rz == '1'){ $('#pdf_rz').prop('checked', true); }
            if(item.pdf_nc == '1'){ $('#pdf_nc').prop('checked', true); }
            if(item.pdf_dc == '1'){ $('#pdf_dc').prop('checked', true); }
            if(item.pdf_ruc == '1'){ $('#pdf_ruc').prop('checked', true); }
            if(item.pdf_tel == '1'){ $('#pdf_tel').prop('checked', true); }
        }
    });
}

$('#sunat').on('change', function(event){
    if($(this).prop('checked')){
        $('#sunat_hidden').val('1');
        // Activar automáticamente el switch de facturación electrónica cuando se activa DGI
        if($('#facturacion_activa').length){
            $('#facturacion_activa').prop('checked', true);
            $('#facturacion_activa_hidden').val('1');
        }
    }else{
        $('#sunat_hidden').val('0');
        // Desactivar automáticamente el switch de facturación electrónica cuando se desactiva DGI
        if($('#facturacion_activa').length){
            $('#facturacion_activa').prop('checked', false);
            $('#facturacion_activa_hidden').val('0');
        }
    }
});

$('#modo').on('change', function(event){
    if($(this).prop('checked')){
        $('#modo_hidden').val('1');
    }else{
        $('#modo_hidden').val('3');
    }
});

$('#ose').on('click', function(event){
    if($('#ose').is(':checked')){
        $('#hidden_ose').val('1');
        $('.ose_url').css('display','block');
    }else{
        $('#hidden_ose').val('0');
        $('.ose_url').css('display','none');
    }
});

$('#pdf_logo').on('click', function(event){
    if($('#pdf_logo').is(':checked')){
        $('#hidden_pdf_logo').val('1');
    }else{
        $('#hidden_pdf_logo').val('0');
    }
});

$('#pdf_rz').on('click', function(event){
    if($('#pdf_rz').is(':checked')){
        $('#hidden_pdf_rz').val('1');
    }else{
        $('#hidden_pdf_rz').val('0');
    }
});

$('#pdf_nc').on('click', function(event){
    if($('#pdf_nc').is(':checked')){
        $('#hidden_pdf_nc').val('1');
    }else{
        $('#hidden_pdf_nc').val('0');
    }
});

$('#pdf_dc').on('click', function(event){
    if($('#pdf_dc').is(':checked')){
        $('#hidden_pdf_dc').val('1');
    }else{
        $('#hidden_pdf_dc').val('0');
    }
});

$('#pdf_ruc').on('click', function(event){
    if($('#pdf_ruc').is(':checked')){
        $('#hidden_pdf_ruc').val('1');
    }else{
        $('#hidden_pdf_ruc').val('0');
    }
});

$('#pdf_tel').on('click', function(event){
    if($('#pdf_tel').is(':checked')){
        $('#hidden_pdf_tel').val('1');
    }else{
        $('#hidden_pdf_tel').val('0');
    }
});

$('#pse').on('click', function(event){
    if($('#pse').is(':checked')){
        $('#hidden_pse').val('1');
        $('.pse_activo').css('display','block');
    }else{
        $('#hidden_pse').val('0');
        $('.pse_activo').css('display','none');
    }
});

/* Compatible con Perú (11 dígitos fijos) y Panamá (formato variable) */
var buscarRucTimerEmpresa = null;
$("#ruc").keyup(function(event) {
    var that = this,
    value = $(this).val();
    var maxLength = parseInt($("#ruc").attr("maxlength")) || 20;
    
    if (buscarRucTimerEmpresa) {
        clearTimeout(buscarRucTimerEmpresa);
    }
    
    if (event.keyCode == 13) {
        event.preventDefault();
        buscarRucEmpresaForm(value);
        return;
    }
    
    if (maxLength == 11 && value.length == 11) {
        buscarRucEmpresaForm(value);
        return;
    }
    
    if (value.length >= 5) {
        buscarRucTimerEmpresa = setTimeout(function() {
            buscarRucEmpresaForm(value);
        }, 1500);
    }
});

function buscarRucEmpresaForm(ruc) {
    $.getJSON($('#url').val()+"api/ruc/"+encodeURIComponent(ruc), {
        format: "json"
    })
    .done(function(data) {
        if(data && data.success !== false) {
            // Para Panamá, incluir el DV junto al RUC si existe
            if(data.ruc) {
                var rucCompleto = data.ruc;
                if(data.dv) {
                    rucCompleto = data.ruc + ' DV:' + data.dv;
                }
                $("#ruc").val(rucCompleto);
            }
            if(data.razonSocial) $("#razon_social").val(data.razonSocial);
            if(data.direccion) $("#direccion_fiscal").val(data.direccion);
            if(data.departamento) $("#departamento").val(data.departamento);
            if(data.provincia) $("#provincia").val(data.provincia);
            if(data.distrito) $("#distrito").val(data.distrito);
            $('#form').formValidation('revalidateField', 'razon_social');
            $('#form').formValidation('revalidateField', 'nombreComercial');
            $('#form').formValidation('revalidateField', 'direccion');
            $('#form').formValidation('revalidateField', 'telefonos');
            $('#form').formValidation('revalidateField', 'departamento');
            $('#form').formValidation('revalidateField', 'provincia');
            $('#form').formValidation('revalidateField', 'distrito');
        }
    });
}


var anularlogo = function(){

    var html_confirm = '<div>Se procederá a eliminar el logo</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
          return new Promise(function(resolve) {
             $.ajax({
                url: $('#url').val()+'ajuste/anularlogo',
                dataType: 'json'
             })
             .done(function(response){
                if(response == 1){
                Swal.fire({
                    title: 'Proceso Terminado',
                    text: 'Datos eliminados correctamente',
                    icon: 'success',
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar"
                });
                obtenerDatos();
                }else{
                    Swal.fire({
                        title: 'Proceso No Culminado',
                        text: 'no se pueden eliminar',
                        icon: 'error',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                }
             })
             .fail(function(){
                Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
             });
          });
        },
        allowOutsideClick: false              
    });
}

// Función para cargar datos de facturación electrónica
var obtenerDatosFacturacion = function(){
    console.log('Cargando datos de facturación electrónica...');
    $.ajax({
        type: "POST",
        url: $('#url').val()+"ajuste/facturacion_electronica_data",
        dataType: "json",
        success: function(item){
            console.log('Datos de facturación recibidos:', item);
            if(item){
                if($('#ff_company_uuid').length) {
                    $('#ff_company_uuid').val(item.ff_company_uuid || '');
                    console.log('UUID cargado:', item.ff_company_uuid || '');
                } else {
                    console.warn('Campo ff_company_uuid no encontrado en el DOM');
                }
                if($('#ff_api_key').length) $('#ff_api_key').val(item.ff_api_key || '');
                if($('#ff_branch').length) $('#ff_branch').val(item.ff_branch || '');
                if($('#branch_address').length) $('#branch_address').val(item.branch_address || '');
                if($('#branch_phone').length) $('#branch_phone').val(item.branch_phone || '');
                if($('#branch_location').length) $('#branch_location').val(item.branch_location || '');
                if ($('#ubicacion_provincia').length && item.branch_location && /^\d{2}-\d{2}-\d{2}$/.test(String(item.branch_location).trim())) {
                    aplicarBranchLocationACascada(String(item.branch_location).trim());
                }
                if($('#branch_coordinates').length) $('#branch_coordinates').val(item.branch_coordinates || '');
                if($('#branch_email').length) $('#branch_email').val(item.branch_email || '');
                if($('#facturacion_activa_hidden').length) $('#facturacion_activa_hidden').val(item.activo || '0');
                
                if($('#facturacion_activa').length){
                    if(item.activo == '1' || item.activo == 1){
                        $('#facturacion_activa').prop('checked', true);
                        console.log('Facturación activada');
                    } else {
                        $('#facturacion_activa').prop('checked', false);
                        console.log('Facturación desactivada');
                    }
                } else {
                    console.warn('Checkbox facturacion_activa no encontrado en el DOM');
                }
            } else {
                console.warn('No se recibieron datos de facturación');
            }
        },
        error: function(xhr, status, error){
            console.error('Error al cargar datos de facturación electrónica:', error);
            console.error('Status:', status);
            console.error('Response:', xhr.responseText);
        }
    });
}

// Toggle para mostrar/ocultar API Key
const togglePasswordApiKey = document.querySelector('#togglePasswordApiKey');
const apiKey = document.querySelector('#ff_api_key');
if (togglePasswordApiKey && apiKey) {
    togglePasswordApiKey.addEventListener('click', function() {
        const type = apiKey.getAttribute('type') === 'password' ? 'text' : 'password';
        apiKey.setAttribute('type', type);
        if (type === 'password') {
            this.classList.remove('fa-eye');
            this.classList.add('fa-eye-slash');
        } else {
            this.classList.remove('fa-eye-slash');
            this.classList.add('fa-eye');
        }
    });
}

// Manejar checkbox de facturación activa
$('#facturacion_activa').on('change', function(event){
    if($(this).prop('checked')){
        $('#facturacion_activa_hidden').val('1');
    }else{
        $('#facturacion_activa_hidden').val('0');
    }
});

// Variables globales para el mapa
var mapCoordenadas = null;
var markerCoordenadas = null;

// Inicializar mapa cuando se abre el modal
$('#modal-seleccionar-coordenadas').on('shown.bs.modal', function() {
    var defaultLat = 8.9824;
    var defaultLng = -79.5199;
    var defaultZoom = 13;
    
    var coordenadasActuales = $('#branch_coordinates').val();
    if (coordenadasActuales && coordenadasActuales.trim() !== '') {
        var coords = coordenadasActuales.split(',');
        if (coords.length === 2) {
            var latStr = coords[0].trim().replace(/^\+/, '');
            var lngStr = coords[1].trim().replace(/^\+/, '');
            defaultLat = parseFloat(latStr) || defaultLat;
            defaultLng = parseFloat(lngStr) || defaultLng;
        }
    }
    
    if (!mapCoordenadas) {
        mapCoordenadas = L.map('map-coordenadas').setView([defaultLat, defaultLng], defaultZoom);
        
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
            maxZoom: 19
        }).addTo(mapCoordenadas);
        
        markerCoordenadas = L.marker([defaultLat, defaultLng], {
            draggable: true
        }).addTo(mapCoordenadas);
        
        markerCoordenadas.on('dragend', function(e) {
            var position = markerCoordenadas.getLatLng();
            actualizarCoordenadasUI(position.lat, position.lng);
        });
        
        mapCoordenadas.on('click', function(e) {
            var lat = e.latlng.lat;
            var lng = e.latlng.lng;
            markerCoordenadas.setLatLng([lat, lng]);
            actualizarCoordenadasUI(lat, lng);
        });
        
        actualizarCoordenadasUI(defaultLat, defaultLng);
    } else {
        mapCoordenadas.setView([defaultLat, defaultLng], defaultZoom);
        markerCoordenadas.setLatLng([defaultLat, defaultLng]);
        actualizarCoordenadasUI(defaultLat, defaultLng);
    }
    
    setTimeout(function() {
        mapCoordenadas.invalidateSize();
    }, 100);
});

function actualizarCoordenadasUI(lat, lng) {
    var latFormatted = (lat >= 0 ? '+' : '') + lat.toFixed(4);
    var lngFormatted = (lng >= 0 ? '+' : '') + lng.toFixed(4);
    
    $('#map-latitud').val(latFormatted);
    $('#map-longitud').val(lngFormatted);
}

$('#btn-confirmar-coordenadas').on('click', function() {
    var lat = $('#map-latitud').val();
    var lng = $('#map-longitud').val();
    
    if (lat && lng) {
        var coordenadas = lat + ',' + lng;
        $('#branch_coordinates').val(coordenadas);
        $('#modal-seleccionar-coordenadas').modal('hide');
        
        Swal.fire({
            title: 'Coordenadas seleccionadas',
            text: 'Las coordenadas han sido guardadas: ' + coordenadas,
            icon: 'success',
            timer: 2000,
            showConfirmButton: false
        });
    } else {
        Swal.fire({
            title: 'Error',
            text: 'Por favor seleccione una ubicación en el mapa',
            icon: 'error'
        });
    }
});