<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h4 class="m-b-0 m-t-0">Facturación Electrónica</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Inicio</a></li>
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Ajustes</a></li>
            <li class="breadcrumb-item active">Facturación Electrónica</li>
        </ol>
    </div>
</div>

<form id="form-facturacion" method="post" enctype="multipart/form-data">
<div class="row">
	<div class="col-md-9">
	    <div class="card p-20">
            <div class="row floating-labels">
                <div class="col-md-12">
                    <h4 class="card-title"><i class="ti-receipt font-18"></i> Configuración de Facturación Electrónica</h4>
                    <h6 class="card-subtitle">Configuración para integración con facturafacil de Panamá</h6><br>
                    <div class="row pt-4">
                        <!-- Activar Facturación -->
                        <div class="col-md-12">
                            <div class="form-group m-b-40">
                                <span class="bar"></span>
                                <label for="facturacion_activa">Activar Facturación Electrónica</label>
                                <div class="row">
                                    <div class="col-8">
                                        <h6 class="text-muted mt-3">Habilita la emisión de facturas electrónicas a través de facturafacil</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <div class="switch">
                                            <label style="position: inherit;"><input type="checkbox" id="facturacion_activa"><span class="lever switch-col-light-green"></span></label>
                                            <input type="hidden" name="facturacion_activa" id="facturacion_activa_hidden">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Columna 1: Credenciales de API -->
                        <div class="col-md-6">
                            <h5 class="m-t-20 m-b-20"><i class="ti-key"></i> Credenciales de API</h5>
                            <hr>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="ff_company_uuid" id="ff_company_uuid" class="form-control" autocomplete="off">
                                <span class="bar"></span>
                                <label for="ff_company_uuid">UUID de Empresa (X-FF-Company)</label>
                                <small class="form-text text-muted">Ingrese el UUID de su empresa proporcionado por facturafacil</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="password" name="ff_api_key" id="ff_api_key" class="form-control" autocomplete="off">
                                <i class="fas fa-eye-slash" id="togglePasswordApiKey" style="position:absolute;margin-top:-27px;right:0;font-size: 18px;cursor:pointer"></i>
                                <span class="bar"></span>
                                <label for="ff_api_key">API Key (X-FF-API-Key)</label>
                                <small class="form-text text-muted">Ingrese su API Key de facturafacil</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="ff_branch" id="ff_branch" class="form-control" autocomplete="off" placeholder="0001 o UUID">
                                <span class="bar"></span>
                                <label for="ff_branch">Branch (X-FF-Branch)</label>
                                <small class="form-text text-muted">Código o UUID de sucursal según facturafacil</small>
                            </div>
                        </div>
                        
                        <!-- Columna 2: Datos de la Sucursal -->
                        <div class="col-md-6">
                            <h5 class="m-t-20 m-b-20"><i class="ti-location-pin"></i> Datos de la Sucursal</h5>
                            <hr>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="branch_address" id="branch_address" class="form-control input-mayus" autocomplete="off" maxlength="100">
                                <span class="bar"></span>
                                <label for="branch_address">Dirección de la Sucursal</label>
                                <small class="form-text text-muted">Dirección completa de la sucursal que emite la factura</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="branch_phone" id="branch_phone" class="form-control" autocomplete="off" maxlength="8" placeholder="99999999">
                                <span class="bar"></span>
                                <label for="branch_phone">Teléfono de la Sucursal</label>
                                <small class="form-text text-muted">8 dígitos sin guiones (ej: 99999999)</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="branch_location" id="branch_location" class="form-control" autocomplete="off" maxlength="8" placeholder="08-01-01">
                                <span class="bar"></span>
                                <label for="branch_location">Ubicación (PP-DD-CC)</label>
                                <small class="form-text text-muted">Código de ubicación: Provincia-Distrito-Corregimiento (ej: 08-01-01)</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <div class="input-group">
                                    <input type="text" name="branch_coordinates" id="branch_coordinates" class="form-control" autocomplete="off" maxlength="20" placeholder="+08.9539,-79.5343">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-info" id="btn-seleccionar-coordenadas" title="Seleccionar en mapa" onclick="abrirModalCoordenadas()">
                                            <i class="ti-location-pin"></i> Mapa
                                        </button>
                                    </div>
                                </div>
                                <span class="bar"></span>
                                <label for="branch_coordinates">Coordenadas (Latitud,Longitud)</label>
                                <small class="form-text text-muted">Formato: +08.9539,-79.5343. Use el botón "Mapa" para seleccionar.</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="email" name="branch_email" id="branch_email" class="form-control" autocomplete="off" maxlength="100">
                                <span class="bar"></span>
                                <label for="branch_email">Email de la Sucursal (Opcional)</label>
                                <small class="form-text text-muted">Correo electrónico de contacto de la sucursal</small>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <h5><i class="ti-info-alt"></i> Información de Headers</h5>
                                <p>Los siguientes headers se configurarán automáticamente al realizar las peticiones a la API:</p>
                                <ul class="mb-0">
                                    <li><strong>X-FF-Company:</strong> UUID de la empresa</li>
                                    <li><strong>X-FF-API-Key:</strong> API Key de autenticación</li>
                                    <li><strong>X-FF-Branch:</strong> Código de sucursal</li>
                                    <li><strong>Content-Type:</strong> application/json</li>
                                    <li><strong>Accept:</strong> application/json</li>
                                </ul>
                                <hr>
                                <p class="mb-0"><strong>Nota:</strong> Si la sucursal no existe en facturafacil, se enviarán automáticamente los datos de dirección, teléfono, ubicación y coordenadas configurados arriba.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 text-right">
                    <a href="<?php echo URL; ?>ajuste" class="btn btn-secondary">Cancelar</a>
                    <button class="btn btn-success text-right" type="submit">Guardar</button>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="alert alert-info font-15">
            <h3 class="text-info"><i class="fa fa-exclamation-circle"></i> Información</h3>
            <dl>
                <dt>Facturación Electrónica</dt>
                <dd>Configure las credenciales de facturafacil para habilitar la emisión de facturas electrónicas en Panamá.</dd>
            </dl>
        </div>
    </div>
</div>
</form>

<!-- Modal para seleccionar coordenadas en mapa -->
<div class="modal fade" id="modal-seleccionar-coordenadas" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ti-location-pin"></i> Seleccionar Ubicación en el Mapa</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="ti-info-alt"></i> <strong>Instrucciones:</strong> Haga clic en el mapa para seleccionar la ubicación de la sucursal. Puede arrastrar el marcador para ajustar la posición.
                </div>
                <div id="map-coordenadas" style="height: 500px; width: 100%; border: 1px solid #ddd; border-radius: 4px;"></div>
                <div class="m-t-20">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Latitud:</label>
                                <input type="text" id="map-latitud" class="form-control" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Longitud:</label>
                                <input type="text" id="map-longitud" class="form-control" readonly>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success" id="btn-confirmar-coordenadas">Confirmar Coordenadas</button>
            </div>
        </div>
    </div>
</div>

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>

<script>
// Función global para abrir el modal de coordenadas
function abrirModalCoordenadas() {
    console.log('Función abrirModalCoordenadas llamada');
    var modal = $('#modal-seleccionar-coordenadas');
    if (modal.length === 0) {
        console.error('Modal no encontrado en el DOM');
        Swal.fire('Error', 'El modal de selección de coordenadas no se encontró. Por favor recargue la página.', 'error');
        return;
    }
    console.log('Abriendo modal...');
    modal.modal('show');
}
</script>

