<?php
/**
 * Script de prueba para generar PDFs de facturación dividida
 * Uso: 
 *   - Por venta: http://localhost/test_pdf_dividida.php?id_venta=8369
 *   - Por pedido: http://localhost/test_pdf_dividida.php?id_pedido=8802
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/libs/Database.php';
require_once __DIR__ . '/libs/Session.php';
require_once __DIR__ . '/libs/Model.php';

function autoload_test($class) {
    $paths = array('libs/', 'models/');
    foreach ($paths as $p) {
        $f = __DIR__ . '/' . $p . $class . '.php';
        if (file_exists($f)) { require_once $f; return; }
    }
}
spl_autoload_register('autoload_test');

session_start();
Session::init();

$id_venta = isset($_GET['id_venta']) ? intval($_GET['id_venta']) : 0;
$id_pedido = isset($_GET['id_pedido']) ? intval($_GET['id_pedido']) : 0;
// Si solo se proporciona un número sin especificar si es venta o pedido, intentar detectar
$numero = isset($_GET['numero']) ? intval($_GET['numero']) : 0;

if ($id_venta <= 0 && $id_pedido <= 0 && $numero <= 0) {
    die("Error: Proporcione id_venta, id_pedido o numero. Ejemplos:<br>
         - test_pdf_dividida.php?id_venta=8369<br>
         - test_pdf_dividida.php?id_pedido=8802<br>
         - test_pdf_dividida.php?numero=8802 (detecta automáticamente)");
}

try {
    require_once __DIR__ . '/models/informe_model.php';
    $informe_model = new Informe_Model();
    $db_check = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
    
    // Si se proporciona solo "numero", intentar detectar si es pedido o venta
    if ($numero > 0 && $id_venta <= 0 && $id_pedido <= 0) {
        // Verificar si existe como venta
        $stm_check_venta = $db_check->prepare("SELECT COUNT(*) as cnt FROM tm_venta WHERE id_venta = ?");
        $stm_check_venta->execute(array($numero));
        $check_venta = $stm_check_venta->fetch(PDO::FETCH_OBJ);
        
        // Verificar si existe como pedido
        $stm_check_pedido = $db_check->prepare("SELECT COUNT(*) as cnt FROM tm_pedido WHERE id_pedido = ?");
        $stm_check_pedido->execute(array($numero));
        $check_pedido = $stm_check_pedido->fetch(PDO::FETCH_OBJ);
        
        if ($check_venta && $check_venta->cnt > 0) {
            $id_venta = $numero;
            echo "<p style='color:blue;'><strong>Detectado como ID Venta</strong></p>";
        } elseif ($check_pedido && $check_pedido->cnt > 0) {
            $id_pedido = $numero;
            echo "<p style='color:blue;'><strong>Detectado como ID Pedido</strong></p>";
        } else {
            die("Error: El número $numero no existe ni como venta ni como pedido.");
        }
    }
    
    // Si se proporciona id_pedido, mostrar información del pedido
    if ($id_pedido > 0) {
        echo "<h2>Test Pedido Dividido - ID Pedido: $id_pedido</h2>";
        
        // Verificar precuentas configuradas
        $stm_prec = $db_check->prepare("SELECT * FROM tm_pedido_precuenta_facturacion WHERE id_pedido = ? ORDER BY nombre_precuenta");
        $stm_prec->execute(array($id_pedido));
        $precuentas = $stm_prec->fetchAll(PDO::FETCH_OBJ);
        
        echo "<p><strong>Precuentas configuradas:</strong> " . count($precuentas) . "</p>";
        
            if (count($precuentas) > 0) {
            echo "<h3>Precuentas:</h3>";
            foreach ($precuentas as $prec) {
                echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px 0;'>";
                echo "<h4>Precuenta: " . htmlspecialchars($prec->nombre_precuenta) . "</h4>";
                
                // Obtener información del cliente desde v_clientes (vista estándar del sistema)
                // Si v_clientes no tiene ubicacion, obtenerla directamente de tm_cliente
                $cliente_nombre = 'N/A';
                $cliente_ruc = 'N/A';
                $cliente_data_full = null;
                if (!empty($prec->id_cliente)) {
                    // Primero obtener datos de v_clientes
                    $stm_cliente = $db_check->prepare("SELECT * FROM v_clientes WHERE id_cliente = ?");
                    $stm_cliente->execute(array($prec->id_cliente));
                    $cliente = $stm_cliente->fetch(PDO::FETCH_OBJ);
                    if ($cliente) {
                        $cliente_nombre = htmlspecialchars($cliente->nombre ?? 'N/A');
                        $cliente_ruc = htmlspecialchars($cliente->ruc ?? ($cliente->dni ?? 'N/A'));
                        $cliente_data_full = $cliente;
                        
                        // Si no tiene ubicacion en v_clientes, obtenerla de tm_cliente
                        if (empty($cliente_data_full->ubicacion) && empty($cliente_data_full->location)) {
                            $stm_ubicacion = $db_check->prepare("SELECT ubicacion FROM tm_cliente WHERE id_cliente = ?");
                            $stm_ubicacion->execute(array($prec->id_cliente));
                            $ubicacion_row = $stm_ubicacion->fetch(PDO::FETCH_OBJ);
                            if ($ubicacion_row && !empty($ubicacion_row->ubicacion)) {
                                $cliente_data_full->ubicacion = $ubicacion_row->ubicacion;
                            }
                        }
                    }
                }
                
                echo "<p><strong>Cliente ID:</strong> " . ($prec->id_cliente ?? 'N/A') . "</p>";
                echo "<p><strong>Cliente Nombre:</strong> " . $cliente_nombre . "</p>";
                echo "<p><strong>Cliente RUC:</strong> " . $cliente_ruc . "</p>";
                
                // Mostrar datos completos del cliente para verificar ubicación
                if ($cliente_data_full) {
                    echo "<details style='margin: 10px 0;'>";
                    echo "<summary style='cursor: pointer; color: #007bff;'><strong>Ver datos completos del cliente</strong></summary>";
                    echo "<div style='margin-top: 10px; padding: 10px; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px;'>";
                    echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%; font-size: 12px;'>";
                    foreach ($cliente_data_full as $key => $value) {
                        $value_display = ($value === null || $value === '') ? '<span style="color: red;">VACÍO</span>' : htmlspecialchars($value);
                        $row_color = (in_array($key, ['ubicacion', 'location', 'direccion', 'address']) && ($value === null || $value === '')) ? 'background-color: #ffebee;' : '';
                        echo "<tr style='$row_color'>";
                        echo "<td><strong>" . htmlspecialchars($key) . "</strong></td>";
                        echo "<td>" . $value_display . "</td>";
                        echo "</tr>";
                    }
                    echo "</table>";
                    echo "</div>";
                    echo "</details>";
                    
                    // Verificar específicamente ubicación
                    $ubicacion = $cliente_data_full->ubicacion ?? $cliente_data_full->location ?? null;
                    if (empty($ubicacion)) {
                        echo "<p style='color: red;'><strong>⚠️ PROBLEMA DETECTADO:</strong> El cliente NO tiene ubicación registrada.</p>";
                        echo "<p>Campos verificados: 'ubicacion', 'location'</p>";
                        echo "<p>Para facturación electrónica en Panamá, se requiere formato PP-DD-CC (ej: 08-01-01)</p>";
                    } else {
                        echo "<p style='color: green;'><strong>✅ Ubicación encontrada:</strong> " . htmlspecialchars($ubicacion) . "</p>";
                        if (!preg_match('/^\d{2}-\d{2}-\d{2}$/', $ubicacion)) {
                            echo "<p style='color: orange;'><strong>⚠️ ADVERTENCIA:</strong> El formato de ubicación no coincide con PP-DD-CC. Formato actual: " . htmlspecialchars($ubicacion) . "</p>";
                        }
                    }
                }
                
                echo "<p><strong>ID Venta:</strong> " . ($prec->id_venta ?? 'NO REGISTRADA') . "</p>";
                echo "<p><strong>Correlativo:</strong> " . ($prec->correlativo ?? 'N/A') . "</p>";
                
                // Items de esta precuenta con nombres de productos
                $stm_items = $db_check->prepare("SELECT dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, dp.toppings,
                    vp.pro_nom, vp.pro_pre
                    FROM tm_detalle_pedido dp
                    LEFT JOIN v_productos vp ON dp.id_pres = vp.id_pres
                    WHERE dp.id_pedido = ? AND dp.nombre_precuenta = ? AND dp.estado <> 'z' 
                    GROUP BY dp.id_pres, dp.precio, CASE WHEN dp.toppings IS NOT NULL THEN dp.toppings ELSE '' END");
                $stm_items->execute(array($id_pedido, $prec->nombre_precuenta));
                $items = $stm_items->fetchAll(PDO::FETCH_OBJ);
                
                echo "<p><strong>Items:</strong> " . count($items) . "</p>";
                if (count($items) > 0) {
                    echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
                    echo "<tr><th>Cantidad</th><th>Producto</th><th>Precio</th><th>Toppings</th></tr>";
                    foreach ($items as $item) {
                        $nombre_producto = !empty($item->pro_nom) ? htmlspecialchars($item->pro_nom . ' ' . $item->pro_pre) : 'ID: ' . $item->id_pres;
                        echo "<tr>";
                        echo "<td>" . $item->cantidad . "</td>";
                        echo "<td>" . $nombre_producto . "</td>";
                        echo "<td>$" . number_format($item->precio, 2) . "</td>";
                        echo "<td>" . (!empty($item->toppings) ? htmlspecialchars($item->toppings) : '-') . "</td>";
                        echo "</tr>";
                    }
                    echo "</table>";
                } else {
                    echo "<p style='color:orange;'>No hay items en esta precuenta.</p>";
                }
                
                if ($prec->id_venta) {
                    echo "<p><a href='test_pdf_dividida.php?id_venta=" . $prec->id_venta . "'>Ver PDF de esta venta</a></p>";
                    
                    // Obtener documentos FE generados para esta venta
                    $stm_docs_fe = $db_check->prepare("SELECT d.*, 
                        COALESCE(s.serie, td.serie) as serie_electronica,
                        td.descripcion as tipo_doc_nombre
                        FROM tm_facturacion_electronica_documentos d
                        LEFT JOIN tm_series_documentos s ON d.id_serie_documento = s.id_serie
                        LEFT JOIN tm_venta v ON d.id_venta = v.id_venta
                        LEFT JOIN tm_tipo_doc td ON v.id_tipo_doc = td.id_tipo_doc AND d.id_serie_documento IS NULL
                        WHERE d.id_venta = ? ORDER BY d.id_documento_fe DESC");
                    $stm_docs_fe->execute(array($prec->id_venta));
                    $docs_fe = $stm_docs_fe->fetchAll(PDO::FETCH_OBJ);
                    
                    if (count($docs_fe) > 0) {
                        echo "<p><strong>Documentos FE generados:</strong> " . count($docs_fe) . "</p>";
                        echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%; margin-top: 10px;'>";
                        echo "<tr><th>ID Doc FE</th><th>Tipo</th><th>Serie</th><th>Número</th><th>Estado</th><th>Total</th><th>Fecha</th></tr>";
                        foreach ($docs_fe as $doc_fe) {
                            $numero_formateado = str_pad($doc_fe->fd_number, 10, '0', STR_PAD_LEFT);
                            $serie_display = $doc_fe->serie_electronica ?? 'N/A';
                            $tipo_display = $doc_fe->document_type ?? ($doc_fe->tipo_doc_nombre ?? 'N/A');
                            $estado_color = ($doc_fe->status == 'sent' || $doc_fe->status == 'accepted') ? 'green' : (($doc_fe->status == 'pending') ? 'orange' : 'red');
                            echo "<tr>";
                            echo "<td>" . $doc_fe->id_documento_fe . "</td>";
                            echo "<td>" . htmlspecialchars($tipo_display) . "</td>";
                            echo "<td>" . htmlspecialchars($serie_display) . "</td>";
                            echo "<td>" . $numero_formateado . "</td>";
                            echo "<td style='color:" . $estado_color . ";'><strong>" . htmlspecialchars($doc_fe->status ?? 'N/A') . "</strong></td>";
                            echo "<td>$" . number_format($doc_fe->total ?? 0, 2) . "</td>";
                            echo "<td>" . ($doc_fe->issue_date ?? 'N/A') . "</td>";
                            echo "</tr>";
                        }
                        echo "</table>";
                        echo "<p><a href='" . URL . "facturacion/documentos_fe?id_venta=" . $prec->id_venta . "' target='_blank'>Ver documentos en sistema</a></p>";
                    } else {
                        echo "<p style='color:orange;'><strong>⚠️ No se encontraron documentos FE para esta venta</strong></p>";
                    }
                }
                echo "</div>";
            }
        } else {
            echo "<p>Este pedido no tiene precuentas configuradas.</p>";
        }
        
        // Resumen de documentos FE para todas las ventas del pedido
        echo "<h3>Resumen de Documentos FE del Pedido:</h3>";
        $stm_docs_pedido = $db_check->prepare("SELECT d.*, 
            COALESCE(s.serie, td.serie) as serie_electronica,
            td.descripcion as tipo_doc_nombre,
            v.id_venta,
            ppf.nombre_precuenta
            FROM tm_facturacion_electronica_documentos d
            INNER JOIN tm_venta v ON d.id_venta = v.id_venta
            LEFT JOIN tm_pedido_precuenta_facturacion ppf ON v.id_venta = ppf.id_venta
            LEFT JOIN tm_series_documentos s ON d.id_serie_documento = s.id_serie
            LEFT JOIN tm_tipo_doc td ON v.id_tipo_doc = td.id_tipo_doc AND d.id_serie_documento IS NULL
            WHERE v.id_pedido = ? ORDER BY d.id_documento_fe DESC");
        $stm_docs_pedido->execute(array($id_pedido));
        $docs_pedido = $stm_docs_pedido->fetchAll(PDO::FETCH_OBJ);
        
        if (count($docs_pedido) > 0) {
            echo "<p><strong>Total documentos FE encontrados:</strong> " . count($docs_pedido) . "</p>";
            echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th>Precuenta</th><th>ID Venta</th><th>ID Doc FE</th><th>Tipo</th><th>Serie</th><th>Número</th><th>Estado</th><th>Total</th><th>Fecha</th></tr>";
            foreach ($docs_pedido as $doc_ped) {
                $numero_formateado = str_pad($doc_ped->fd_number, 10, '0', STR_PAD_LEFT);
                $serie_display = $doc_ped->serie_electronica ?? 'N/A';
                $tipo_display = $doc_ped->document_type ?? ($doc_ped->tipo_doc_nombre ?? 'N/A');
                $estado_color = ($doc_ped->status == 'sent' || $doc_ped->status == 'accepted') ? 'green' : (($doc_ped->status == 'pending') ? 'orange' : 'red');
                echo "<tr>";
                echo "<td>" . htmlspecialchars($doc_ped->nombre_precuenta ?? 'N/A') . "</td>";
                echo "<td>" . $doc_ped->id_venta . "</td>";
                echo "<td>" . $doc_ped->id_documento_fe . "</td>";
                echo "<td>" . htmlspecialchars($tipo_display) . "</td>";
                echo "<td>" . htmlspecialchars($serie_display) . "</td>";
                echo "<td>" . $numero_formateado . "</td>";
                echo "<td style='color:" . $estado_color . ";'><strong>" . htmlspecialchars($doc_ped->status ?? 'N/A') . "</strong></td>";
                echo "<td>$" . number_format($doc_ped->total ?? 0, 2) . "</td>";
                echo "<td>" . ($doc_ped->issue_date ?? 'N/A') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            echo "<p><a href='" . URL . "facturacion/documentos_fe?id_pedido=" . $id_pedido . "' target='_blank'>Ver todos los documentos en sistema</a></p>";
        } else {
            echo "<p style='color:orange;'><strong>⚠️ No se encontraron documentos FE para este pedido</strong></p>";
            echo "<p>Posibles razones:</p>";
            echo "<ul>";
            echo "<li>Las ventas aún no se han registrado</li>";
            echo "<li>La facturación electrónica no está activada</li>";
            echo "<li>Los documentos aún no se han generado</li>";
            echo "<li>Hubo un error al generar los documentos</li>";
            echo "</ul>";
        }
        
        echo "<p><a href='" . URL . "venta/orden/$id_pedido'>Ver pedido en sistema</a></p>";
        exit;
    }
    
    // Si se proporciona id_venta, verificar si es facturación dividida
    echo "<h2>Test PDF Facturación Dividida - ID Venta: $id_venta</h2>";
    
    $stm_check = $db_check->prepare("SELECT COUNT(*) as cnt FROM tm_pedido_precuenta_facturacion WHERE id_venta = ?");
    $stm_check->execute(array($id_venta));
    $check = $stm_check->fetch(PDO::FETCH_OBJ);
    $es_dividida = ($check && $check->cnt > 0);
    
    echo "<p><strong>Es facturación dividida:</strong> " . ($es_dividida ? 'SÍ' : 'NO') . "</p>";
    
    if ($es_dividida) {
        // Obtener datos de precuenta
        $stm_prec = $db_check->prepare("SELECT * FROM tm_pedido_precuenta_facturacion WHERE id_venta = ? LIMIT 1");
        $stm_prec->execute(array($id_venta));
        $prec_data = $stm_prec->fetch(PDO::FETCH_OBJ);
        
        echo "<h3>Datos de Precuenta:</h3>";
        echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px 0;'>";
        echo "<p><strong>Nombre Precuenta:</strong> " . htmlspecialchars($prec_data->nombre_precuenta) . "</p>";
        echo "<p><strong>ID Pedido:</strong> " . $prec_data->id_pedido . "</p>";
        
        // Obtener información del cliente desde v_clientes (vista estándar del sistema)
        if (!empty($prec_data->id_cliente)) {
            $stm_cliente = $db_check->prepare("SELECT * FROM v_clientes WHERE id_cliente = ?");
            $stm_cliente->execute(array($prec_data->id_cliente));
            $cliente = $stm_cliente->fetch(PDO::FETCH_OBJ);
            if ($cliente) {
                echo "<p><strong>Cliente ID:</strong> " . $prec_data->id_cliente . "</p>";
                echo "<p><strong>Cliente Nombre:</strong> " . htmlspecialchars($cliente->nombre ?? 'N/A') . "</p>";
                echo "<p><strong>Cliente RUC:</strong> " . htmlspecialchars($cliente->ruc ?? ($cliente->dni ?? 'N/A')) . "</p>";
                
                // Mostrar datos completos del cliente para verificar ubicación
                echo "<details style='margin: 10px 0;'>";
                echo "<summary style='cursor: pointer; color: #007bff;'><strong>Ver datos completos del cliente</strong></summary>";
                echo "<div style='margin-top: 10px; padding: 10px; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px;'>";
                echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%; font-size: 12px;'>";
                foreach ($cliente as $key => $value) {
                    $value_display = ($value === null || $value === '') ? '<span style="color: red;">VACÍO</span>' : htmlspecialchars($value);
                    $row_color = (in_array($key, ['ubicacion', 'location', 'direccion', 'address']) && ($value === null || $value === '')) ? 'background-color: #ffebee;' : '';
                    echo "<tr style='$row_color'>";
                    echo "<td><strong>" . htmlspecialchars($key) . "</strong></td>";
                    echo "<td>" . $value_display . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
                echo "</div>";
                echo "</details>";
                
                // Verificar específicamente ubicación
                $ubicacion = $cliente->ubicacion ?? $cliente->location ?? null;
                if (empty($ubicacion)) {
                    echo "<p style='color: red;'><strong>⚠️ PROBLEMA DETECTADO:</strong> El cliente NO tiene ubicación registrada.</p>";
                    echo "<p>Campos verificados: 'ubicacion', 'location'</p>";
                    echo "<p>Para facturación electrónica en Panamá, se requiere formato PP-DD-CC (ej: 08-01-01)</p>";
                } else {
                    echo "<p style='color: green;'><strong>✅ Ubicación encontrada:</strong> " . htmlspecialchars($ubicacion) . "</p>";
                    if (!preg_match('/^\d{2}-\d{2}-\d{2}$/', $ubicacion)) {
                        echo "<p style='color: orange;'><strong>⚠️ ADVERTENCIA:</strong> El formato de ubicación no coincide con PP-DD-CC. Formato actual: " . htmlspecialchars($ubicacion) . "</p>";
                    }
                }
            } else {
                echo "<p style='color:orange;'><strong>Cliente ID:</strong> " . $prec_data->id_cliente . " (no encontrado en v_clientes)</p>";
            }
        }
        
        echo "<p><strong>ID Venta:</strong> " . ($prec_data->id_venta ?? 'N/A') . "</p>";
        echo "<p><strong>Correlativo:</strong> " . ($prec_data->correlativo ?? 'N/A') . "</p>";
        echo "</div>";
        
        // Obtener documentos FE generados para esta venta
        if (!empty($prec_data->id_venta)) {
            $stm_docs_fe = $db_check->prepare("SELECT d.*, 
                COALESCE(s.serie, td.serie) as serie_electronica,
                td.descripcion as tipo_doc_nombre
                FROM tm_facturacion_electronica_documentos d
                LEFT JOIN tm_series_documentos s ON d.id_serie_documento = s.id_serie
                LEFT JOIN tm_venta v ON d.id_venta = v.id_venta
                LEFT JOIN tm_tipo_doc td ON v.id_tipo_doc = td.id_tipo_doc AND d.id_serie_documento IS NULL
                WHERE d.id_venta = ? ORDER BY d.id_documento_fe DESC");
            $stm_docs_fe->execute(array($prec_data->id_venta));
            $docs_fe = $stm_docs_fe->fetchAll(PDO::FETCH_OBJ);
            
            echo "<h3>Documentos FE Generados:</h3>";
            if (count($docs_fe) > 0) {
                echo "<p><strong>Total documentos:</strong> " . count($docs_fe) . "</p>";
                echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
                echo "<tr><th>ID Doc FE</th><th>Tipo</th><th>Serie</th><th>Número</th><th>Estado</th><th>Total</th><th>Fecha Emisión</th><th>CUFE</th></tr>";
                foreach ($docs_fe as $doc_fe) {
                    $numero_formateado = str_pad($doc_fe->fd_number, 10, '0', STR_PAD_LEFT);
                    $serie_display = $doc_fe->serie_electronica ?? 'N/A';
                    $tipo_display = $doc_fe->document_type ?? ($doc_fe->tipo_doc_nombre ?? 'N/A');
                    $estado_color = ($doc_fe->status == 'sent' || $doc_fe->status == 'accepted') ? 'green' : (($doc_fe->status == 'pending') ? 'orange' : 'red');
                    echo "<tr>";
                    echo "<td>" . $doc_fe->id_documento_fe . "</td>";
                    echo "<td>" . htmlspecialchars($tipo_display) . "</td>";
                    echo "<td>" . htmlspecialchars($serie_display) . "</td>";
                    echo "<td>" . $numero_formateado . "</td>";
                    echo "<td style='color:" . $estado_color . ";'><strong>" . htmlspecialchars($doc_fe->status ?? 'N/A') . "</strong></td>";
                    echo "<td>$" . number_format($doc_fe->total ?? 0, 2) . "</td>";
                    echo "<td>" . ($doc_fe->issue_date ?? 'N/A') . "</td>";
                    echo "<td>" . (!empty($doc_fe->cufe) ? htmlspecialchars(substr($doc_fe->cufe, 0, 20) . '...') : 'N/A') . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
                echo "<p><a href='" . URL . "facturacion/documentos_fe?id_venta=" . $prec_data->id_venta . "' target='_blank'>Ver documentos completos en sistema</a></p>";
            } else {
                echo "<p style='color:orange;'><strong>⚠️ No se encontraron documentos FE para esta venta</strong></p>";
                echo "<p>Posibles razones:</p>";
                echo "<ul>";
                echo "<li>La facturación electrónica no está activada</li>";
                echo "<li>El documento aún no se ha generado</li>";
                echo "<li>Hubo un error al generar el documento</li>";
                echo "</ul>";
            }
        }
        
        // Obtener items desde tm_detalle_pedido
        $stm_items_pedido = $db_check->prepare("SELECT id_pres, SUM(cantidad) AS cantidad, precio, toppings 
            FROM tm_detalle_pedido 
            WHERE id_pedido = ? AND nombre_precuenta = ? AND estado <> 'z' 
            GROUP BY id_pres, precio, CASE WHEN toppings IS NOT NULL THEN toppings ELSE '' END");
        $stm_items_pedido->execute(array($prec_data->id_pedido, $prec_data->nombre_precuenta));
        $items_pedido = $stm_items_pedido->fetchAll(PDO::FETCH_OBJ);
        
        echo "<h3>Items desde tm_detalle_pedido:</h3>";
        echo "<pre>" . print_r($items_pedido, true) . "</pre>";
        
        // Obtener items desde tm_detalle_venta
        $stm_items_venta = $db_check->prepare("SELECT id_prod, precio, cantidad, toppings FROM tm_detalle_venta WHERE id_venta = ?");
        $stm_items_venta->execute(array($id_venta));
        $items_venta = $stm_items_venta->fetchAll(PDO::FETCH_OBJ);
        
        echo "<h3>Items desde tm_detalle_venta:</h3>";
        echo "<pre>" . print_r($items_venta, true) . "</pre>";
        
        // Generar PDF
        echo "<h3>Generando PDF...</h3>";
        $dato = $informe_model->venta_dividida_imp_pdf($id_venta);
        
        echo "<h3>Datos obtenidos para PDF:</h3>";
        echo "<p><strong>Cliente ID:</strong> " . ($dato->id_cli ?? 'N/A') . "</p>";
        echo "<p><strong>Correlativo:</strong> " . ($dato->nro_doc ?? 'N/A') . "</p>";
        echo "<p><strong>Items en Detalle:</strong> " . (isset($dato->Detalle) ? count($dato->Detalle) : 0) . "</p>";
        
        if (isset($dato->Detalle) && count($dato->Detalle) > 0) {
            echo "<h4>Primeros 3 items:</h4>";
            echo "<pre>" . print_r(array_slice($dato->Detalle, 0, 3), true) . "</pre>";
        } else {
            echo "<p style='color:red;'><strong>ERROR: No hay items en el detalle!</strong></p>";
        }
        
        echo "<p><a href='" . URL . "informe/venta_all_imp/$id_venta' target='_blank'>Abrir PDF</a></p>";
        
    } else {
        echo "<p>Esta venta no es facturación dividida. Usando método normal.</p>";
        try {
            $dato = $informe_model->venta_all_imp_pdf($id_venta);
            echo "<p><strong>Cliente ID:</strong> " . ($dato->id_cli ?? 'N/A') . "</p>";
            echo "<p><strong>Correlativo:</strong> " . ($dato->nro_doc ?? 'N/A') . "</p>";
            echo "<p><strong>Items en Detalle:</strong> " . (isset($dato->Detalle) ? count($dato->Detalle) : 0) . "</p>";
            echo "<p><a href='" . URL . "informe/venta_all_imp/$id_venta' target='_blank'>Abrir PDF</a></p>";
        } catch (Exception $e) {
            echo "<p style='color:red;'><strong>ERROR al generar PDF:</strong> " . $e->getMessage() . "</p>";
            echo "<p>Verifique que la venta existe y tiene datos válidos.</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color:red;'><strong>ERROR:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
