<?php
/**
 * Script para obtener la clave descifrada del usuario "soporte"
 * 
 * Este script descifra la contraseña almacenada en base64 en la base de datos.
 * En el sistema, las contraseñas se codifican con base64_encode() antes de guardarlas.
 */

require_once 'config.php';
require_once 'libs/Database.php';

try {
    // Conectar a la base de datos usando las constantes de config.php
    $db = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
    
    // Buscar el usuario "soporte"
    $usuario = 'soporte';
    $sql = "SELECT id_usu, usuario, contrasena, nombres, estado FROM tm_usuario WHERE usuario = :usuario";
    $stmt = $db->prepare($sql);
    $stmt->execute(array(':usuario' => $usuario));
    $usuario_data = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($usuario_data) {
        // Obtener la contraseña codificada en base64
        $contrasena_codificada = $usuario_data['contrasena'];
        
        // Descifrar la contraseña usando base64_decode()
        $contrasena_descifrada = base64_decode($contrasena_codificada);
        
        // Mostrar los resultados
        echo "===========================================\n";
        echo "INFORMACIÓN DEL USUARIO: " . strtoupper($usuario) . "\n";
        echo "===========================================\n";
        echo "ID Usuario: " . $usuario_data['id_usu'] . "\n";
        echo "Usuario: " . $usuario_data['usuario'] . "\n";
        echo "Nombres: " . $usuario_data['nombres'] . "\n";
        echo "Estado: " . $usuario_data['estado'] . "\n";
        echo "-------------------------------------------\n";
        echo "Contraseña codificada (base64): " . $contrasena_codificada . "\n";
        echo "-------------------------------------------\n";
        echo "CONTRASEÑA DESCIFRADA: " . $contrasena_descifrada . "\n";
        echo "===========================================\n";
        
    } else {
        echo "ERROR: No se encontró el usuario '$usuario' en la base de datos.\n";
    }
    
} catch (Exception $e) {
    echo "ERROR al conectar a la base de datos: " . $e->getMessage() . "\n";
    echo "\nDetalles:\n";
    echo "- Tipo DB: " . DB_TYPE . "\n";
    echo "- Host: " . DB_HOST . "\n";
    echo "- Base de datos: " . DB_NAME . "\n";
    echo "- Usuario: " . DB_USER . "\n";
}



