<?php
/**
 * Cron: envío automático de documentos de facturación electrónica (status = pending).
 * Ejecutar por cron cada X minutos, por ejemplo (cada 5 min):
 *   0,5,10,15,20,25,30,35,40,45,50,55 * * * * php /ruta/htdocs/cron_envio_automatico_fe.php
 *
 * Requiere que en Ajustes > Facturación electrónica esté activado "Envío automático".
 */

if (php_sapi_name() !== 'cli') {
    die('Este script debe ejecutarse desde la línea de comandos (CLI).');
}

$log_file = __DIR__ . '/cron_envio_automatico_fe.log';

function log_cron($message, $log_file) {
    $line = date('Y-m-d H:i:s') . ' ' . $message . "\n";
    file_put_contents($log_file, $line, FILE_APPEND);
}

log_cron('=== Inicio cron envío automático FE ===', $log_file);

try {
    require __DIR__ . '/config.php';
    require __DIR__ . '/libs/Database.php';
    require __DIR__ . '/libs/Model.php';
    require __DIR__ . '/models/facturacion_electronica_model.php';

    $model = new Facturacion_Electronica_Model();

    if (!$model->envio_automatico_activo()) {
        log_cron('Envío automático desactivado. No se procesan documentos.', $log_file);
        exit(0);
    }

    $ids = $model->get_documentos_pendientes_envio(50);
    if (empty($ids)) {
        log_cron('No hay documentos pendientes de envío.', $log_file);
        exit(0);
    }

    log_cron('Documentos pendientes: ' . count($ids) . ' (IDs: ' . implode(', ', $ids) . ')', $log_file);

    $ok = 0;
    $fail = 0;
    foreach ($ids as $id_documento_fe) {
        $result = $model->enviar_documento_fe(array('id_documento_fe' => $id_documento_fe));
        if (!empty($result['success'])) {
            $ok++;
            log_cron("ID $id_documento_fe: OK - " . (isset($result['message']) ? $result['message'] : 'Enviado'), $log_file);
        } else {
            $fail++;
            log_cron("ID $id_documento_fe: ERROR - " . (isset($result['message']) ? $result['message'] : 'Error desconocido'), $log_file);
        }
    }

    log_cron("Fin: enviados OK=$ok, errores=$fail", $log_file);
    exit(0);

} catch (Exception $e) {
    log_cron('Excepción: ' . $e->getMessage(), $log_file);
    error_log('cron_envio_automatico_fe: ' . $e->getMessage());
    exit(1);
}
